/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.tagcloud;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.annotation.Synchronized;
import com.treemap.tagcloud.TextShape;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Font;
import org.mkui.font.MkFontKt;
import org.mkui.geom.AffineTransform;
import org.mkui.geom.PathIterator;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;
import org.mkui.graphics.IHeadless;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 *2\u00020\u0001:\u0001*B%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB%\b\u0016\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\t\u0010\rJ\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\fH\u0016J\u0011\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0096\u0002J\u0012\u0010!\u001a\u00020 2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0010\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020'H\u0016J\u0012\u0010(\u001a\u00020)2\b\u0010#\u001a\u0004\u0018\u00010$H\u0017R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/treemap/tagcloud/RectangularTextShape;", "Lcom/treemap/tagcloud/TextShape;", "headless", "Lorg/mkui/graphics/IHeadless;", "font", "Lorg/jetbrains/skia/Font;", "Lorg/mkui/font/MkFont;", "text", "", "<init>", "(Lorg/mkui/graphics/IHeadless;Lorg/jetbrains/skia/Font;Ljava/lang/String;)V", "shape", "Lorg/mkui/geom/Rectangle2D;", "(Lorg/jetbrains/skia/Font;Ljava/lang/String;Lorg/mkui/geom/Rectangle2D;)V", "getText", "()Ljava/lang/String;", "getFont", "()Lorg/jetbrains/skia/Font;", "setFont", "(Lorg/jetbrains/skia/Font;)V", "isTextOutline", "", "()Z", "bounds2D", "getBounds2D", "()Lorg/mkui/geom/Rectangle2D;", "intersects", "r", "contains", "point", "Lorg/mkui/geom/Point2D;", "pathIterator", "Lorg/mkui/geom/PathIterator;", "getPathIterator", "()Lorg/mkui/geom/PathIterator;", "at", "Lorg/mkui/geom/AffineTransform;", "getFlattenPathIterator", "flatness", "", "createTransformedShape", "Lorg/mkui/geom/Shape;", "Companion", "treemap"})
@StabilityInferred(parameters=0)
public final class RectangularTextShape
implements TextShape {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String text;
    @NotNull
    private Font font;
    @NotNull
    private final Rectangle2D shape;
    public static final int $stable = 8;

    @Override
    @NotNull
    public String getText() {
        return this.text;
    }

    @Override
    @NotNull
    public Font getFont() {
        return this.font;
    }

    public void setFont(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"<set-?>");
        this.font = font;
    }

    public RectangularTextShape(@NotNull IHeadless headless, @NotNull Font font, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)headless, (String)"headless");
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Rectangle2D r = headless.getStringBounds(null, font, text);
        this.shape = (Rectangle2D)new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        this.setFont(font);
        this.text = text;
    }

    public RectangularTextShape(@NotNull Font font, @NotNull String text, @NotNull Rectangle2D shape) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        this.setFont(font);
        this.text = text;
        this.shape = shape;
    }

    @Override
    public boolean isTextOutline() {
        return false;
    }

    @NotNull
    public Rectangle2D getBounds2D() {
        return this.shape.getBounds2D();
    }

    public boolean intersects(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.shape.intersects(r);
    }

    public boolean contains(@NotNull Point2D point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        double x = point.getX();
        double y = point.getY();
        double x0 = this.shape.getX();
        double y0 = this.shape.getY();
        return x >= x0 && y >= y0 && x < x0 + this.shape.getWidth() && y < y0 + this.shape.getHeight();
    }

    @NotNull
    public PathIterator getPathIterator() {
        return this.shape.getPathIterator();
    }

    @NotNull
    public PathIterator getPathIterator(@Nullable AffineTransform at) {
        return this.shape.getPathIterator(at);
    }

    @NotNull
    public PathIterator getFlattenPathIterator(double flatness) {
        return this.shape.getFlattenPathIterator(flatness);
    }

    @Override
    @Synchronized
    @NotNull
    public Shape createTransformedShape(@Nullable AffineTransform at) {
        Font font = this.getFont();
        AffineTransform affineTransform = at;
        Intrinsics.checkNotNull((Object)affineTransform);
        this.setFont(MkFontKt.deriveFontSize((Font)font, (double)(affineTransform.getScaleY() * MkFontKt.getFontSize((Font)this.getFont()))));
        return new RectangularTextShape(this.getFont(), this.getText(), Companion.transformBounds(this.shape, at));
    }

    @NotNull
    public Rectangle getBounds() {
        return TextShape.super.getBounds();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000b"}, d2={"Lcom/treemap/tagcloud/RectangularTextShape$Companion;", "", "<init>", "()V", "transformBounds", "Lorg/mkui/geom/Rectangle2D;", "rect", "at", "Lorg/mkui/geom/AffineTransform;", "isOrthogonal", "", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Rectangle2D transformBounds(@NotNull Rectangle2D rect, @NotNull AffineTransform at) {
            Rectangle2D rectangle2D;
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            Intrinsics.checkNotNullParameter((Object)at, (String)"at");
            if (!this.isOrthogonal(at)) {
                Shape shape = at.createTransformedShape((Shape)rect);
                Intrinsics.checkNotNull((Object)shape);
                rectangle2D = shape.getBounds2D();
            } else if (rect instanceof Rectangle2D.Double) {
                Rectangle2D.Double r = (Rectangle2D.Double)rect;
                double[] coords = new double[]{r.getX(), r.getY(), r.getX() + r.getWidth(), r.getY() + r.getHeight()};
                at.transform(coords, 0, coords, 0, 2);
                rectangle2D = (Rectangle2D)new Rectangle2D.Double(coords[0], coords[1], coords[2] - coords[0], coords[3] - coords[1]);
            } else {
                double[] coords;
                coords = new double[]{rect.getX(), rect.getY(), coords[0] + rect.getWidth(), coords[1] + rect.getHeight()};
                at.transform(coords, 0, coords, 0, 2);
                rectangle2D = (Rectangle2D)new Rectangle2D.Double(coords[0], coords[1], coords[2], coords[3]);
            }
            return rectangle2D;
        }

        public final boolean isOrthogonal(@NotNull AffineTransform at) {
            Intrinsics.checkNotNullParameter((Object)at, (String)"at");
            int t = at.getType();
            return (t & 0x38) == 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

