/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.treemap.SurroundLabeling;
import com.treemap.TreeMapModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.MkColor;
import org.mkui.labeling.ContrastEnhancement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JC\u0010\u0004\u001a\u0004\u0018\u00010\u0005\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\u0006\u0010\t\u001a\u0002H\u00062\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\u000bH\u0014\u00a2\u0006\u0002\u0010\fJC\u0010\r\u001a\u0004\u0018\u00010\u0005\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\u0006\u0010\t\u001a\u0002H\u00062\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\u000bH\u0014\u00a2\u0006\u0002\u0010\fJC\u0010\u000e\u001a\u0004\u0018\u00010\u0005\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\u0006\u0010\t\u001a\u0002H\u00062\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\u000bH\u0014\u00a2\u0006\u0002\u0010\fJ\b\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/treemap/ColoredSurroundLabeling;", "Lcom/treemap/SurroundLabeling;", "<init>", "()V", "getForegroundColor", "Lorg/mkui/color/MkColor;", "N", "Row", "Column", "node", "model", "Lcom/treemap/TreeMapModel;", "(Ljava/lang/Object;Lcom/treemap/TreeMapModel;)Lorg/mkui/color/MkColor;", "getEffectColor", "getBackgroundColor", "toString", "", "treemap"})
@StabilityInferred(parameters=0)
public final class ColoredSurroundLabeling
extends SurroundLabeling {
    public static final int $stable = 8;

    @Override
    @Nullable
    protected <N, Row, Column> MkColor getForegroundColor(N node, @NotNull TreeMapModel<N, Row, Column> model) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        MkColor foreground = model.getSettings().getColumnSettings(model.getGroupByColumn(node)).getHeaderForeground();
        MkColor background = this.getBackgroundColor(node, model);
        if (background != null) {
            ContrastEnhancement contrastEnhancement = model.getSettings().getColumnSettings(model.getGroupByColumn(node)).getLabelingContrastEnhancement();
            Intrinsics.checkNotNull((Object)contrastEnhancement);
            MkColor mkColor = foreground;
            Intrinsics.checkNotNull((Object)mkColor);
            foreground = contrastEnhancement.adjustLabelColor(mkColor, background);
        }
        return foreground;
    }

    @Override
    @Nullable
    protected <N, Row, Column> MkColor getEffectColor(N node, @NotNull TreeMapModel<N, Row, Column> model) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        return model.getSettings().getColumnSettings(model.getGroupByColumn(node)).getHeaderEffectColor();
    }

    @Override
    @Nullable
    protected <N, Row, Column> MkColor getBackgroundColor(N node, @NotNull TreeMapModel<N, Row, Column> model) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        return model.getColor(node);
    }

    @Override
    @NotNull
    public String toString() {
        return "Surround (Colored)";
    }
}

