/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.common.command.AbstractUICommand;
import com.macrofocus.common.command.UICommand;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.treemap.AbstractLabeling;
import com.treemap.AbstractTreeMapController$DefaultMouseListener$WhenMappings;
import com.treemap.TreeMapController;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapView;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.ContextMenuEvent;
import org.mkui.canvas.ContextMenuListener;
import org.mkui.canvas.KeyEvent;
import org.mkui.canvas.KeyListener;
import org.mkui.canvas.MouseEvent;
import org.mkui.canvas.MouseListener;
import org.mkui.canvas.MouseMotionListener;
import org.mkui.canvas.MouseWheelEvent;
import org.mkui.canvas.MouseWheelListener;
import org.mkui.component.menu.CPPopupMenu;
import org.mkui.geom.Point;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004:\u0003./0B\u001f\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J/\u0010\u0013\u001a\u00020\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0018J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001aH\u0002J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001fJ\b\u0010!\u001a\u00020\tH\u0016J \u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001aH\u0002J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020&H\u0002J$\u0010'\u001a\u00020\u00142\u001a\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010\u0006H\u0016J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\tH\u0016J \u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u001aH\u0002J\u0010\u0010-\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u001aH\u0004R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00180\u000fR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\"\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/treemap/AbstractTreeMapController;", "N", "Row", "Column", "Lcom/treemap/TreeMapController;", "view", "Lcom/treemap/TreeMapView;", "(Lcom/treemap/TreeMapView;)V", "improvedBorderZooming", "", "keyListener", "Lorg/mkui/canvas/KeyListener;", "mode", "Lcom/treemap/AbstractTreeMapController$Mode;", "mouseListener", "Lcom/treemap/AbstractTreeMapController$DefaultMouseListener;", "multipleSelectionEnabled", "selectOnPopupTrigger", "zoomingEnabled", "assessQuality", "", "model", "Lcom/treemap/TreeMapModel;", "parent", "(Lcom/treemap/TreeMapModel;Ljava/lang/Object;)V", "denormalize", "", "x", "min", "extent", "getViewport", "Lorg/mkui/geom/Rectangle2D;", "getWorld", "isZoomingEnabled", "normalize", "center", "openPopupMenu", "e", "Lorg/mkui/canvas/ContextMenuEvent;", "setView", "setZoomingEnabled", "zoom", "amount", "xCenter", "yCenter", "zoomingCenterFunction", "DefaultMouseListener", "Mode", "Range", "treemap"})
public abstract class AbstractTreeMapController<N, Row, Column>
implements TreeMapController<N, Row, Column> {
    private TreeMapView<N, Row, Column> view;
    private Mode mode;
    private final boolean multipleSelectionEnabled;
    private final boolean selectOnPopupTrigger;
    private boolean zoomingEnabled;
    private final boolean improvedBorderZooming;
    private final DefaultMouseListener mouseListener;
    private final KeyListener keyListener;

    private final void zoom(double amount, double xCenter, double yCenter) {
        double xCenter2 = xCenter;
        double yCenter2 = yCenter;
        if (this.zoomingEnabled) {
            TreeMapView<N, Row, Column> treeMapView = this.view;
            Intrinsics.checkNotNull(treeMapView);
            Rectangle2D viewport = treeMapView.getViewport();
            TreeMapView<N, Row, Column> treeMapView2 = this.view;
            Intrinsics.checkNotNull(treeMapView2);
            Rectangle2D world = treeMapView2.getWorld();
            yCenter2 = world.getMaxY() - yCenter2;
            if (this.improvedBorderZooming) {
                double normalizedXCenter = this.normalize(xCenter2, world.getMinX(), world.getMaxX());
                double normalizedYCenter = this.normalize(yCenter2, world.getMinY(), world.getMaxY());
                xCenter2 = this.denormalize(this.zoomingCenterFunction(normalizedXCenter), world.getMinX(), world.getMaxX());
                yCenter2 = this.denormalize(this.zoomingCenterFunction(normalizedYCenter), world.getMinY(), world.getMaxY());
            }
            Double d = xCenter2;
            double d2 = viewport.getMinX();
            double d3 = viewport.getWidth();
            double d4 = world.getMinX();
            double d5 = world.getMaxX();
            TreeMapView<N, Row, Column> treeMapView3 = this.view;
            Intrinsics.checkNotNull(treeMapView3);
            Range xRange = new Range(amount, d, d2, d3, d4, d5, treeMapView3.getSize().getWidth()).invoke();
            double xMin = xRange.getMin();
            double xMax = xRange.getMax();
            Double d6 = yCenter2;
            double d7 = viewport.getMinY();
            double d8 = viewport.getHeight();
            double d9 = world.getMinY();
            double d10 = world.getMaxY();
            TreeMapView<N, Row, Column> treeMapView4 = this.view;
            Intrinsics.checkNotNull(treeMapView4);
            Range yRange = new Range(amount, d6, d7, d8, d9, d10, treeMapView4.getSize().getHeight()).invoke();
            double yMin = yRange.getMin();
            double yMax = yRange.getMax();
            if (xMin < xMax && yMin < yMax) {
                TreeMapView<N, Row, Column> treeMapView5 = this.view;
                Intrinsics.checkNotNull(treeMapView5);
                treeMapView5.zoom(false, xMin, xMax, yMin, yMax);
            }
        }
    }

    protected final double zoomingCenterFunction(double center) {
        double d = center * (double)3;
        boolean bl = false;
        return Math.tanh(d);
    }

    private final double normalize(double center, double min, double extent) {
        return (center - min) / extent * 2.0 - 1.0;
    }

    private final double denormalize(double x, double min, double extent) {
        return min + extent * ((x + 1.0) / 2.0);
    }

    @Override
    public void setView(@Nullable TreeMapView<N, Row, Column> view) {
        this.view = view;
        if (view != null) {
            view.addKeyListener(this.keyListener);
            view.addMouseListener(this.mouseListener);
            view.addMouseMotionListener(this.mouseListener);
            view.addMouseWheelListener(this.mouseListener);
            view.addContextMenuListener(new ContextMenuListener(this){
                final /* synthetic */ AbstractTreeMapController this$0;

                public void contextMenu(@NotNull ContextMenuEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    AbstractTreeMapController.access$openPopupMenu(this.this$0, event);
                }
                {
                    this.this$0 = this$0;
                }
            });
        }
    }

    private final void openPopupMenu(ContextMenuEvent e) {
        CPPopupMenu popupMenu = new CPPopupMenu();
        int x = e.getX();
        int y = e.getY();
        AbstractUICommand drillDownCommand2 = new AbstractUICommand(this, x, y, "Drill down"){
            final /* synthetic */ AbstractTreeMapController this$0;
            final /* synthetic */ int $x;
            final /* synthetic */ int $y;

            public void execute(@Nullable Object source) {
                TreeMapView treeMapView = AbstractTreeMapController.access$getView$p(this.this$0);
                Intrinsics.checkNotNull((Object)treeMapView);
                treeMapView.drill(this.$x, this.$y);
            }
            {
                this.this$0 = this$0;
                this.$x = $captured_local_variable$1;
                this.$y = $captured_local_variable$2;
                super($super_call_param$3);
            }
        };
        AbstractUICommand drillUpCommand2 = new AbstractUICommand(this, "Drill up"){
            final /* synthetic */ AbstractTreeMapController this$0;

            public void execute(@Nullable Object source) {
                TreeMapView treeMapView = AbstractTreeMapController.access$getView$p(this.this$0);
                Intrinsics.checkNotNull((Object)treeMapView);
                treeMapView.drillUp();
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        };
        AbstractUICommand zoomInCommand2 = new AbstractUICommand(this, "Zoom in"){
            final /* synthetic */ AbstractTreeMapController this$0;

            public void execute(@Nullable Object source) {
                TreeMapView treeMapView = AbstractTreeMapController.access$getView$p(this.this$0);
                Intrinsics.checkNotNull((Object)treeMapView);
                treeMapView.zoomIn();
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        };
        AbstractUICommand zoomOutCommand2 = new AbstractUICommand(this, "Zoom out"){
            final /* synthetic */ AbstractTreeMapController this$0;

            public void execute(@Nullable Object source) {
                TreeMapView treeMapView = AbstractTreeMapController.access$getView$p(this.this$0);
                Intrinsics.checkNotNull((Object)treeMapView);
                treeMapView.zoomOut();
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        };
        popupMenu.add((UICommand)drillDownCommand2);
        popupMenu.add((UICommand)drillUpCommand2);
        popupMenu.add((UICommand)zoomInCommand2);
        popupMenu.add((UICommand)zoomOutCommand2);
        TreeMapView<N, Row, Column> treeMapView = this.view;
        Intrinsics.checkNotNull(treeMapView);
        popupMenu.show(treeMapView.getComponent(), x, y);
    }

    private final void assessQuality(TreeMapModel<N, Row, Column> model, N parent) {
        Object child3;
        double sumSize = 0.0;
        double sumArea = 0.0;
        for (N child2 : model.getChildren(parent)) {
            Shape shape = model.getShape(child2);
            if (shape == null) continue;
            sumSize += model.getSize(child2);
            double d = AbstractLabeling.Companion.getArea(shape);
            boolean bl = false;
            sumArea += Math.abs(d);
        }
        double totalError = 0.0;
        for (Object child3 : model.getChildren(parent)) {
            Shape shape = model.getShape(child3);
            if (shape == null) continue;
            double sizeRatio = model.getSize(child3) / sumSize;
            double d = AbstractLabeling.Companion.getArea(shape);
            boolean bl = false;
            double area = Math.abs(d);
            double areaRatio = area / sumArea;
            double d2 = sizeRatio - areaRatio;
            boolean bl2 = false;
            double error = Math.abs(d2);
            if (error > 0.03) {
                String string = "Error for " + child3 + ": desired=" + sizeRatio + ",actual=" + areaRatio + " (" + area + " pixels instead of " + sizeRatio * sumArea + " pixels)";
                boolean bl3 = false;
                System.out.println((Object)string);
            }
            totalError += error;
        }
        child3 = "Total error for " + parent + ": " + totalError;
        boolean bl = false;
        System.out.println(child3);
        for (Object child3 : model.getChildren(parent)) {
            if (model.hasNoChildren(child3)) continue;
            this.assessQuality(model, child3);
        }
    }

    @NotNull
    public final Rectangle2D getViewport() {
        TreeMapView<N, Row, Column> treeMapView = this.view;
        Intrinsics.checkNotNull(treeMapView);
        double d = treeMapView.getXRangeModel().getStart();
        TreeMapView<N, Row, Column> treeMapView2 = this.view;
        Intrinsics.checkNotNull(treeMapView2);
        double d2 = treeMapView2.getXRangeModel().getStart();
        TreeMapView<N, Row, Column> treeMapView3 = this.view;
        Intrinsics.checkNotNull(treeMapView3);
        double d3 = treeMapView3.getXRangeModel().getExtent();
        TreeMapView<N, Row, Column> treeMapView4 = this.view;
        Intrinsics.checkNotNull(treeMapView4);
        return (Rectangle2D)new Rectangle2D.Double(d, d2, d3, treeMapView4.getXRangeModel().getExtent());
    }

    @NotNull
    public final Rectangle2D getWorld() {
        TreeMapView<N, Row, Column> treeMapView = this.view;
        Intrinsics.checkNotNull(treeMapView);
        double d = treeMapView.getYRangeModel().getMinimum();
        TreeMapView<N, Row, Column> treeMapView2 = this.view;
        Intrinsics.checkNotNull(treeMapView2);
        double d2 = treeMapView2.getYRangeModel().getMinimum();
        TreeMapView<N, Row, Column> treeMapView3 = this.view;
        Intrinsics.checkNotNull(treeMapView3);
        double d3 = treeMapView3.getYRangeModel().getMaximum();
        TreeMapView<N, Row, Column> treeMapView4 = this.view;
        Intrinsics.checkNotNull(treeMapView4);
        double d4 = d3 - treeMapView4.getXRangeModel().getMinimum();
        TreeMapView<N, Row, Column> treeMapView5 = this.view;
        Intrinsics.checkNotNull(treeMapView5);
        double d5 = treeMapView5.getYRangeModel().getMaximum();
        TreeMapView<N, Row, Column> treeMapView6 = this.view;
        Intrinsics.checkNotNull(treeMapView6);
        return (Rectangle2D)new Rectangle2D.Double(d, d2, d4, d5 - treeMapView6.getYRangeModel().getMinimum());
    }

    @Override
    public void setZoomingEnabled(boolean zoomingEnabled) {
        this.zoomingEnabled = zoomingEnabled;
    }

    @Override
    public boolean isZoomingEnabled() {
        return this.zoomingEnabled;
    }

    public AbstractTreeMapController(@NotNull TreeMapView<N, Row, Column> view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        this.mode = Mode.Selection;
        this.multipleSelectionEnabled = true;
        this.zoomingEnabled = true;
        this.mouseListener = new DefaultMouseListener();
        this.keyListener = new KeyListener(this, view){
            @Nullable
            private Mode oldMode;
            final /* synthetic */ AbstractTreeMapController this$0;
            final /* synthetic */ TreeMapView $view;

            @Nullable
            public final Mode getOldMode() {
                return this.oldMode;
            }

            public final void setOldMode(@Nullable Mode mode) {
                this.oldMode = mode;
            }

            public void keyTyped(@NotNull KeyEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            }

            public void keyPressed(@NotNull KeyEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getKeyCode() == 83) {
                    if (this.oldMode == null) {
                        this.oldMode = AbstractTreeMapController.access$getMode$p(this.this$0);
                    }
                    AbstractTreeMapController.access$setMode$p(this.this$0, Mode.Selection);
                }
                if (event.getKeyCode() == 90 || event.getKeyCode() == 16) {
                    if (this.oldMode == null) {
                        this.oldMode = AbstractTreeMapController.access$getMode$p(this.this$0);
                    }
                    AbstractTreeMapController.access$setMode$p(this.this$0, Mode.Zooming);
                }
                if (event.getKeyCode() == 90 || event.getKeyCode() == 32) {
                    if (this.oldMode == null) {
                        this.oldMode = AbstractTreeMapController.access$getMode$p(this.this$0);
                    }
                    AbstractTreeMapController.access$setMode$p(this.this$0, Mode.Panning);
                }
                if (event.getKeyCode() == 40) {
                    this.$view.drillDown();
                }
                if (event.getKeyCode() == 38) {
                    this.$view.drillUp();
                }
                if (event.getKeyCode() == 34) {
                    this.$view.zoomIn();
                }
                if (event.getKeyCode() == 33) {
                    this.$view.zoomOut();
                }
            }

            public void keyReleased(@NotNull KeyEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.oldMode != null) {
                    Mode mode = this.oldMode;
                    Intrinsics.checkNotNull((Object)((Object)mode));
                    AbstractTreeMapController.access$setMode$p(this.this$0, mode);
                    this.oldMode = null;
                }
            }
            {
                this.this$0 = this$0;
                this.$view = $captured_local_variable$1;
            }
        };
        this.setView(view);
    }

    public static final /* synthetic */ void access$setView$p(AbstractTreeMapController $this, TreeMapView treeMapView) {
        $this.view = treeMapView;
    }

    public static final /* synthetic */ Mode access$getMode$p(AbstractTreeMapController $this) {
        return $this.mode;
    }

    public static final /* synthetic */ void access$setMode$p(AbstractTreeMapController $this, Mode mode) {
        $this.mode = mode;
    }

    public static final /* synthetic */ void access$openPopupMenu(AbstractTreeMapController $this, ContextMenuEvent e) {
        $this.openPopupMenu(e);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/treemap/AbstractTreeMapController$Mode;", "", "(Ljava/lang/String;I)V", "Selection", "Zooming", "Panning", "treemap"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode Selection;
        public static final /* enum */ Mode Zooming;
        public static final /* enum */ Mode Panning;
        private static final /* synthetic */ Mode[] $VALUES;

        static {
            Mode[] modeArray = new Mode[3];
            Mode[] modeArray2 = modeArray;
            modeArray[0] = Selection = new Mode();
            modeArray[1] = Zooming = new Mode();
            modeArray[2] = Panning = new Mode();
            $VALUES = modeArray;
        }

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String string) {
            return Enum.valueOf(Mode.class, string);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000e\u001a\u00020\u0003J\u0006\u0010\u000f\u001a\u00020\u0003J\u001f\u0010\u0010\u001a\u00180\u0000R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0011H\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/treemap/AbstractTreeMapController$Range;", "", "_amount", "", "_center", "_start", "_extent", "_minRange", "_maxRange", "_maxExtent", "(Lcom/treemap/AbstractTreeMapController;DLjava/lang/Double;DDDDD)V", "Ljava/lang/Double;", "_max", "_min", "getMax", "getMin", "invoke", "Lcom/treemap/AbstractTreeMapController;", "treemap"})
    private final class Range {
        private double _min;
        private double _max;
        private final double _amount;
        private final Double _center;
        private final double _start;
        private final double _extent;
        private final double _minRange;
        private final double _maxRange;
        private final double _maxExtent;

        public final double getMin() {
            return this._min;
        }

        public final double getMax() {
            return this._max;
        }

        @NotNull
        public final Range invoke() {
            double range = this._extent;
            double d = this._maxExtent;
            double d2 = range + range * this._amount;
            boolean bl = false;
            double newRange = Math.min(d, d2);
            if (this._center != null) {
                this._min = this._center - newRange * ((this._center - this._start) / range);
                this._max = this._center + newRange * ((this._start + this._extent - this._center) / range);
            } else {
                this._min = this._start;
                this._max = this._start + newRange;
            }
            if (this._min < this._minRange) {
                this._max += this._minRange - this._min;
                this._min = this._minRange;
            }
            if (this._max > this._maxRange) {
                this._min -= this._max - this._maxRange;
                this._max = this._maxRange;
            }
            d = this._minRange;
            d2 = this._min;
            bl = false;
            this._min = Math.max(d, d2);
            d = this._maxRange;
            d2 = this._max;
            bl = false;
            this._max = Math.min(d, d2);
            return this;
        }

        public Range(@Nullable double _amount, Double _center, double _start, double _extent, double _minRange, double _maxRange, double _maxExtent) {
            this._amount = _amount;
            this._center = _center;
            this._start = _start;
            this._extent = _extent;
            this._minRange = _minRange;
            this._maxRange = _maxRange;
            this._maxExtent = _maxExtent;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u001cH\u0016J\u0015\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0010J\u0017\u0010\u001e\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010\u0010R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/treemap/AbstractTreeMapController$DefaultMouseListener;", "Lorg/mkui/canvas/MouseListener;", "Lorg/mkui/canvas/MouseMotionListener;", "Lorg/mkui/canvas/MouseWheelListener;", "(Lcom/treemap/AbstractTreeMapController;)V", "last", "Lorg/mkui/canvas/MouseEvent;", "pressedPoint", "Lorg/mkui/geom/Point;", "selectOnRelease", "Ljava/lang/Object;", "zoomOnRelease", "zoomingPoint", "addToSelection", "", "observation", "(Ljava/lang/Object;)V", "newSelection", "", "mouseClicked", "event", "mouseDragged", "mouseEntered", "mouseExited", "mouseMoved", "mousePressed", "mouseReleased", "mouseWheelMoved", "Lorg/mkui/canvas/MouseWheelEvent;", "removeFromSelection", "setSelection", "treemap"})
    public final class DefaultMouseListener
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private MouseEvent last;
        private N selectOnRelease;
        private Point zoomOnRelease;
        private final Point zoomingPoint;
        private Point pressedPoint;

        public void mouseClicked(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        }

        public void mousePressed(@NotNull MouseEvent event) {
            block4: {
                block6: {
                    Object bestrow;
                    block7: {
                        block8: {
                            block5: {
                                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                                if (AbstractTreeMapController.this.view == null) break block4;
                                this.pressedPoint = new Point(event.getX(), event.getY());
                                if (event.getClickCount() <= 1) break block5;
                                TreeMapView treeMapView = AbstractTreeMapController.this.view;
                                Intrinsics.checkNotNull((Object)treeMapView);
                                Point point = this.pressedPoint;
                                Intrinsics.checkNotNull((Object)point);
                                int n = point.getIx();
                                Point point2 = this.pressedPoint;
                                Intrinsics.checkNotNull((Object)point2);
                                treeMapView.drill(n, point2.getIy());
                                break block4;
                            }
                            TreeMapView treeMapView = AbstractTreeMapController.this.view;
                            Intrinsics.checkNotNull((Object)treeMapView);
                            bestrow = treeMapView.getNode(new Point(event.getX(), event.getY()));
                            if (bestrow == null) break block6;
                            if (event.isMultipleSelectionKey()) break block7;
                            TreeMapView treeMapView2 = AbstractTreeMapController.this.view;
                            Intrinsics.checkNotNull((Object)treeMapView2);
                            TreeMapModel treeMapModel = treeMapView2.getModel();
                            Intrinsics.checkNotNull(treeMapModel);
                            if (!treeMapModel.getSelection().isSelected(bestrow)) break block8;
                            TreeMapView treeMapView3 = AbstractTreeMapController.this.view;
                            Intrinsics.checkNotNull((Object)treeMapView3);
                            TreeMapModel treeMapModel2 = treeMapView3.getModel();
                            Intrinsics.checkNotNull(treeMapModel2);
                            if (treeMapModel2.getSelection().getSelectedCount() <= 1) break block4;
                        }
                        TreeMapView treeMapView = AbstractTreeMapController.this.view;
                        Intrinsics.checkNotNull((Object)treeMapView);
                        TreeMapModel treeMapModel = treeMapView.getModel();
                        Intrinsics.checkNotNull(treeMapModel);
                        treeMapModel.getSelection().clearSelection();
                        TreeMapView treeMapView4 = AbstractTreeMapController.this.view;
                        Intrinsics.checkNotNull((Object)treeMapView4);
                        TreeMapModel treeMapModel3 = treeMapView4.getModel();
                        Intrinsics.checkNotNull(treeMapModel3);
                        treeMapModel3.getSelection().setSelectedElement(bestrow);
                        TreeMapView treeMapView5 = AbstractTreeMapController.this.view;
                        Intrinsics.checkNotNull((Object)treeMapView5);
                        TreeMapView treeMapView6 = AbstractTreeMapController.this.view;
                        Intrinsics.checkNotNull((Object)treeMapView6);
                        TreeMapModel treeMapModel4 = treeMapView6.getModel();
                        Intrinsics.checkNotNull(treeMapModel4);
                        treeMapView5.setSelectionMode(treeMapModel4.getSelection().isSelected(bestrow));
                        break block4;
                    }
                    TreeMapView treeMapView = AbstractTreeMapController.this.view;
                    Intrinsics.checkNotNull((Object)treeMapView);
                    TreeMapView treeMapView7 = AbstractTreeMapController.this.view;
                    Intrinsics.checkNotNull((Object)treeMapView7);
                    TreeMapModel treeMapModel = treeMapView7.getModel();
                    Intrinsics.checkNotNull(treeMapModel);
                    treeMapView.setSelectionMode(!treeMapModel.getSelection().isSelected(bestrow));
                    TreeMapView treeMapView8 = AbstractTreeMapController.this.view;
                    Intrinsics.checkNotNull((Object)treeMapView8);
                    if (treeMapView8.isSelectionMode()) {
                        TreeMapView treeMapView9 = AbstractTreeMapController.this.view;
                        Intrinsics.checkNotNull((Object)treeMapView9);
                        TreeMapModel treeMapModel5 = treeMapView9.getModel();
                        Intrinsics.checkNotNull(treeMapModel5);
                        treeMapModel5.getSelection().setSelectedState(bestrow, true);
                    } else {
                        TreeMapView treeMapView10 = AbstractTreeMapController.this.view;
                        Intrinsics.checkNotNull((Object)treeMapView10);
                        TreeMapModel treeMapModel6 = treeMapView10.getModel();
                        Intrinsics.checkNotNull(treeMapModel6);
                        treeMapModel6.getSelection().setSelectedState(bestrow, false);
                    }
                    break block4;
                }
                TreeMapView treeMapView = AbstractTreeMapController.this.view;
                Intrinsics.checkNotNull((Object)treeMapView);
                TreeMapModel treeMapModel = treeMapView.getModel();
                Intrinsics.checkNotNull(treeMapModel);
                treeMapModel.getSelection().clearSelection();
            }
        }

        public void mouseReleased(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (AbstractTreeMapController.this.view != null) {
                if (!event.isPopupTrigger()) {
                    if (this.selectOnRelease != null && event.isLeftMouseButton()) {
                        TreeMapView treeMapView = AbstractTreeMapController.this.view;
                        Intrinsics.checkNotNull((Object)treeMapView);
                        TreeMapModel treeMapModel = treeMapView.getModel();
                        Intrinsics.checkNotNull(treeMapModel);
                        treeMapModel.getSelection().clearSelection();
                        if (AbstractTreeMapController.this.multipleSelectionEnabled) {
                            Object n = this.selectOnRelease;
                            Intrinsics.checkNotNull(n);
                            this.addToSelection(n);
                        } else {
                            this.setSelection(this.selectOnRelease);
                        }
                        this.selectOnRelease = null;
                    }
                    if (this.zoomOnRelease != null) {
                        event.isLeftMouseButton();
                        this.zoomOnRelease = null;
                    }
                    TreeMapView treeMapView = AbstractTreeMapController.this.view;
                    Intrinsics.checkNotNull((Object)treeMapView);
                    treeMapView.getRubberBand().stopRubberBand();
                } else if (AbstractTreeMapController.this.selectOnPopupTrigger) {
                    TreeMapView treeMapView = AbstractTreeMapController.this.view;
                    Intrinsics.checkNotNull((Object)treeMapView);
                    Object node = treeMapView.getNode(new Point(event.getX(), event.getY()));
                    this.setSelection(node);
                }
                this.last = null;
            }
        }

        public void mouseEntered(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (AbstractTreeMapController.this.view != null) {
                TreeMapView treeMapView = AbstractTreeMapController.this.view;
                Intrinsics.checkNotNull((Object)treeMapView);
                if (treeMapView.getModel() != null) {
                    TreeMapView treeMapView2 = AbstractTreeMapController.this.view;
                    Intrinsics.checkNotNull((Object)treeMapView2);
                    TreeMapModel treeMapModel = treeMapView2.getModel();
                    Intrinsics.checkNotNull(treeMapModel);
                    MutableSingleSelection mutableSingleSelection = treeMapModel.getProbing();
                    TreeMapView treeMapView3 = AbstractTreeMapController.this.view;
                    Intrinsics.checkNotNull((Object)treeMapView3);
                    mutableSingleSelection.setSelectedElement(treeMapView3.getNode(new Point(event.getX(), event.getY())));
                }
            }
        }

        public void mouseExited(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (AbstractTreeMapController.this.view != null) {
                TreeMapView treeMapView = AbstractTreeMapController.this.view;
                Intrinsics.checkNotNull((Object)treeMapView);
                if (treeMapView.getModel() != null) {
                    TreeMapView treeMapView2 = AbstractTreeMapController.this.view;
                    Intrinsics.checkNotNull((Object)treeMapView2);
                    TreeMapModel treeMapModel = treeMapView2.getModel();
                    Intrinsics.checkNotNull(treeMapModel);
                    treeMapModel.getProbing().clearSelection();
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        public void mouseDragged(@NotNull MouseEvent event) {
            block20: {
                block21: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this) == null) break block20;
                    v0 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                    Intrinsics.checkNotNull((Object)v0);
                    if (v0.getModel() == null) break block20;
                    if (this.last == null) break block21;
                    switch (AbstractTreeMapController$DefaultMouseListener$WhenMappings.$EnumSwitchMapping$0[AbstractTreeMapController.access$getMode$p(AbstractTreeMapController.this).ordinal()]) {
                        case 1: {
                            if (!event.isLeftMouseButton()) break;
                            if (event.isAltKeyDown() || event.isShiftKeyDown()) {
                                v1 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                                Intrinsics.checkNotNull((Object)v1);
                                v2 = v1.getModel();
                                Intrinsics.checkNotNull(v2);
                                v2.getProbing().clearSelection();
                                if (!AbstractTreeMapController.access$getMultipleSelectionEnabled$p(AbstractTreeMapController.this)) break;
                                v3 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                                Intrinsics.checkNotNull((Object)v3);
                                if (!v3.getRubberBand().getRubberBand().isActive()) {
                                    v4 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                                    Intrinsics.checkNotNull((Object)v4);
                                    v5 = v4.getRubberBand();
                                    v6 = this.pressedPoint;
                                    Intrinsics.checkNotNull((Object)v6);
                                    v7 = v6.getIx();
                                    v8 = this.pressedPoint;
                                    Intrinsics.checkNotNull((Object)v8);
                                    v5.startRubberBand(v7, v8.getIy());
                                }
                                v9 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                                Intrinsics.checkNotNull((Object)v9);
                                v9.getRubberBand().stretchRubberBand(event.getX(), event.getY());
                                v10 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                                Intrinsics.checkNotNull((Object)v10);
                                v11 = v10.getRubberBand().getRubberBandScreen();
                                Intrinsics.checkNotNull((Object)v11);
                                r = v11;
                                rect = new Rectangle((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
                                v12 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                                Intrinsics.checkNotNull((Object)v12);
                                v13 = v12.getNodes(rect);
                                Intrinsics.checkNotNull(v13);
                                toSelect = v13;
                                if (event.isMultipleSelectionKey()) {
                                    this.addToSelection(toSelect);
                                } else {
                                    v14 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                                    Intrinsics.checkNotNull((Object)v14);
                                    v15 = v14.getModel();
                                    Intrinsics.checkNotNull(v15);
                                    v15.getSelection().setSelectedIterable((Iterable)toSelect);
                                }
                                this.selectOnRelease = null;
                                break;
                            }
                            v16 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                            Intrinsics.checkNotNull((Object)v16);
                            v17 = v16.getNode(new Point(event.getX(), event.getY()));
                            Intrinsics.checkNotNull(v17);
                            observation = v17;
                            v18 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                            Intrinsics.checkNotNull((Object)v18);
                            v19 = v18.getModel();
                            Intrinsics.checkNotNull(v19);
                            v19.getProbing().setSelectedElement(observation);
                            this.selectOnRelease = null;
                            v20 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                            Intrinsics.checkNotNull((Object)v20);
                            v21 = v20.getModel();
                            Intrinsics.checkNotNull(v21);
                            if (v21.getSelection() == null) ** GOTO lbl-1000
                            v22 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                            Intrinsics.checkNotNull((Object)v22);
                            v23 = v22.getModel();
                            Intrinsics.checkNotNull(v23);
                            if (v23.getSelection().isSelected(observation)) {
                                v24 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v24 = isAlreadySelected = false;
                            }
                            if (!isAlreadySelected && !event.isMenuShortcutKeyDown()) {
                                v25 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                                Intrinsics.checkNotNull((Object)v25);
                                v26 = v25.getModel();
                                Intrinsics.checkNotNull(v26);
                                v26.getSelection().clearSelection();
                            }
                            if (event.isMenuShortcutKeyDown()) {
                                if (AbstractTreeMapController.access$getMultipleSelectionEnabled$p(AbstractTreeMapController.this)) {
                                    this.addToSelection(observation);
                                    break;
                                }
                                this.setSelection(observation);
                                break;
                            }
                            if (isAlreadySelected) {
                                this.selectOnRelease = observation;
                                break;
                            }
                            if (AbstractTreeMapController.access$getMultipleSelectionEnabled$p(AbstractTreeMapController.this)) {
                                this.addToSelection(observation);
                                break;
                            }
                            this.setSelection(observation);
                            break;
                        }
                        case 2: {
                            if (!event.isLeftMouseButton()) break;
                            viewport = AbstractTreeMapController.this.getViewport();
                            world = AbstractTreeMapController.this.getWorld();
                            v27 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                            Intrinsics.checkNotNull((Object)v27);
                            v28 = v27.getScreenTransform().getX();
                            v29 = this.last;
                            Intrinsics.checkNotNull((Object)v29);
                            x1 = v28.screenToWorld(v29.getX());
                            v30 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                            Intrinsics.checkNotNull((Object)v30);
                            x2 = v30.getScreenTransform().getX().screenToWorld(event.getX());
                            worldDiffX = x1 - x2;
                            xMin = viewport.getMinX() + worldDiffX;
                            xMax = viewport.getMaxX() + worldDiffX;
                            v31 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                            Intrinsics.checkNotNull((Object)v31);
                            v32 = v31.getScreenTransform().getY();
                            v33 = this.last;
                            Intrinsics.checkNotNull((Object)v33);
                            y1 = v32.screenToWorld(v33.getY());
                            v34 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                            Intrinsics.checkNotNull((Object)v34);
                            y2 = v34.getScreenTransform().getY().screenToWorld(event.getY());
                            worldDiffY = y1 - y2;
                            yMin = viewport.getMinY() + worldDiffY;
                            yMax = viewport.getMinY() + worldDiffY;
                            if (xMin < world.getMinX()) {
                                xMax += world.getMinX() - xMin;
                                xMin = world.getMinX();
                            }
                            if (xMax > world.getMaxX()) {
                                xMin -= xMax - world.getMaxX();
                                xMax = world.getMaxX();
                            }
                            var24_19 = world.getMinX();
                            var26_20 = false;
                            xMin = Math.max(var24_19, xMin);
                            var24_19 = world.getMaxX();
                            var26_20 = false;
                            xMax = Math.min(var24_19, xMax);
                            if (yMin < world.getMinY()) {
                                yMax += world.getMinY() - yMin;
                                yMin = world.getMinY();
                            }
                            if (yMax > world.getMaxY()) {
                                yMin -= yMax - world.getMaxY();
                                yMax = world.getMaxY();
                            }
                            var24_19 = world.getMinY();
                            var26_20 = false;
                            yMin = Math.max(var24_19, yMin);
                            var24_19 = world.getMaxY();
                            var26_20 = false;
                            yMax = Math.min(var24_19, yMax);
                            if (!(xMin < xMax) || !(yMin < yMax)) break;
                            v35 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                            Intrinsics.checkNotNull((Object)v35);
                            v35.zoom(false, xMin, xMax, yMin, yMax);
                            break;
                        }
                        case 3: {
                            if (!event.isMiddleMouseButton()) break;
                            v36 = event.getY();
                            v37 = this.last;
                            Intrinsics.checkNotNull((Object)v37);
                            v38 = v36 - (double)v37.getY() / 100.0;
                            v39 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                            Intrinsics.checkNotNull((Object)v39);
                            v40 = v39.getScreenTransform().getX().screenToWorld(event.getX());
                            v41 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                            Intrinsics.checkNotNull((Object)v41);
                            AbstractTreeMapController.access$zoom(AbstractTreeMapController.this, v38, v40, v41.getScreenTransform().getY().screenToWorld(event.getY()));
                            this.zoomOnRelease = null;
                            break;
                        }
                    }
                }
                this.last = event;
            }
        }

        public void mouseMoved(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            TreeMapView treeMapView = AbstractTreeMapController.this.view;
            Intrinsics.checkNotNull((Object)treeMapView);
            Object closest = treeMapView.getNode(new Point(event.getX(), event.getY()));
            TreeMapView treeMapView2 = AbstractTreeMapController.this.view;
            Intrinsics.checkNotNull((Object)treeMapView2);
            TreeMapModel treeMapModel = treeMapView2.getModel();
            Intrinsics.checkNotNull(treeMapModel);
            treeMapModel.getProbing().setSelectedElement(closest);
        }

        public void mouseWheelMoved(@NotNull MouseWheelEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (AbstractTreeMapController.this.view != null) {
                int amount = event.getWheelRotation();
                double d = (double)amount / 20.0;
                TreeMapView treeMapView = AbstractTreeMapController.this.view;
                Intrinsics.checkNotNull((Object)treeMapView);
                double d2 = treeMapView.getScreenTransform().getX().screenToWorld(event.getX());
                TreeMapView treeMapView2 = AbstractTreeMapController.this.view;
                Intrinsics.checkNotNull((Object)treeMapView2);
                AbstractTreeMapController.this.zoom(d, d2, treeMapView2.getScreenTransform().getY().screenToWorld(event.getY()));
            }
        }

        private final void removeFromSelection(N observation) {
            TreeMapView treeMapView = AbstractTreeMapController.this.view;
            Intrinsics.checkNotNull((Object)treeMapView);
            TreeMapModel treeMapModel = treeMapView.getModel();
            Intrinsics.checkNotNull(treeMapModel);
            treeMapModel.getSelection().setSelectedState(observation, false);
        }

        private final void setSelection(N observation) {
            if (observation != null) {
                TreeMapView treeMapView = AbstractTreeMapController.this.view;
                Intrinsics.checkNotNull((Object)treeMapView);
                TreeMapModel treeMapModel = treeMapView.getModel();
                Intrinsics.checkNotNull(treeMapModel);
                treeMapModel.getSelection().setSelectedElements(new Object[]{observation});
            } else {
                TreeMapView treeMapView = AbstractTreeMapController.this.view;
                Intrinsics.checkNotNull((Object)treeMapView);
                TreeMapModel treeMapModel = treeMapView.getModel();
                Intrinsics.checkNotNull(treeMapModel);
                treeMapModel.getSelection().clearSelection();
            }
        }

        private final void addToSelection(N observation) {
            TreeMapView treeMapView = AbstractTreeMapController.this.view;
            Intrinsics.checkNotNull((Object)treeMapView);
            TreeMapModel treeMapModel = treeMapView.getModel();
            Intrinsics.checkNotNull(treeMapModel);
            treeMapModel.getSelection().setSelectedState(observation, true);
        }

        private final void addToSelection(List<? extends N> newSelection) {
            TreeMapView treeMapView = AbstractTreeMapController.this.view;
            Intrinsics.checkNotNull((Object)treeMapView);
            TreeMapModel treeMapModel = treeMapView.getModel();
            Intrinsics.checkNotNull(treeMapModel);
            treeMapModel.getSelection().setSelectedIterableState((Iterable)newSelection, true);
        }
    }
}

