/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.common.geom.Dimension;
import com.treemap.DefaultTreeMapPopup;
import com.treemap.ToolTipTreeMapRenderer;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapPopup;
import com.treemap.TreeMapToolTip;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.TGraphics;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.CPColor;
import org.mkui.color.CPColorKt;
import org.mkui.geom.Point;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;
import org.mkui.graphics.Insets;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b&\u0018\u0000 8*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004:\u00018B\u001f\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010#\u001a\u00020\u000fH\u0004J\n\u0010$\u001a\u0004\u0018\u00010%H\u0004J\u0006\u0010&\u001a\u00020'J\u0012\u0010(\u001a\u0004\u0018\u00010\u00152\b\u0010)\u001a\u0004\u0018\u00010\u0015J\u0014\u0010*\u001a\u0004\u0018\u00010+2\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J\u0018\u0010.\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u001fJ\b\u0010/\u001a\u000200H\u0004J\u0010\u00101\u001a\u0002002\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u00102\u001a\u0002002\u0006\u0010,\u001a\u00020-H\u0016J \u00103\u001a\u0002002\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u001fJ\u0017\u00104\u001a\u0002002\b\u0010\b\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\fJ\u0018\u00105\u001a\u0002002\u0006\u00106\u001a\u00020\u00192\u0006\u00107\u001a\u00020\u0019H\u0004R*\u0010\b\u001a\u0004\u0018\u00018\u00002\b\u0010\b\u001a\u0004\u0018\u00018\u0000@VX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u000f8DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR \u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010\u0007\u00a8\u00069"}, d2={"Lcom/treemap/AbstractTreeMapToolTip;", "N", "Row", "Column", "Lcom/treemap/TreeMapToolTip;", "view", "Lcom/treemap/TreeMapView;", "(Lcom/treemap/TreeMapView;)V", "node", "getNode", "()Ljava/lang/Object;", "setNode", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "popup", "Lcom/treemap/TreeMapPopup;", "getPopup", "()Lcom/treemap/TreeMapPopup;", "setPopup", "(Lcom/treemap/TreeMapPopup;)V", "popupLocation", "Lorg/mkui/geom/Point;", "getPopupLocation", "()Lorg/mkui/geom/Point;", "preferredWidth", "", "getPreferredWidth", "()I", "setPreferredWidth", "(I)V", "renderer", "Lcom/treemap/ToolTipTreeMapRenderer;", "getView", "()Lcom/treemap/TreeMapView;", "setView", "createPopup", "getBorderColor", "Lorg/mkui/color/CPColor;", "getInsets", "Lorg/mkui/graphics/Insets;", "getPreferredLocation", "p", "getPreferredSize", "Lcom/macrofocus/common/geom/Dimension;", "g", "Lcom/treemap/crossplatform/TGraphics;", "getRenderer", "hidePopup", "", "paintBackground", "paintText", "setRenderer", "showNode", "showPopup", "x", "y", "Companion", "treemap"})
public abstract class AbstractTreeMapToolTip<N, Row, Column>
implements TreeMapToolTip<N, Row, Column> {
    @NotNull
    private TreeMapView<N, Row, Column> view;
    @Nullable
    private N node;
    @Nullable
    private TreeMapPopup popup;
    private int preferredWidth;
    private ToolTipTreeMapRenderer<N, Row, Column> renderer;
    protected static final int topShift = 7;
    protected static final int leftShift = 20;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final TreeMapView<N, Row, Column> getView() {
        return this.view;
    }

    protected final void setView(@NotNull TreeMapView<N, Row, Column> treeMapView) {
        Intrinsics.checkNotNullParameter(treeMapView, (String)"<set-?>");
        this.view = treeMapView;
    }

    @Override
    @Nullable
    public N getNode() {
        return this.node;
    }

    @Override
    public void setNode(@Nullable N node) {
        if (this.node != node) {
            this.node = node;
            if (this.node == null) {
                this.hidePopup();
            }
        }
    }

    @Nullable
    protected final TreeMapPopup getPopup() {
        if (this.popup == null) {
            this.popup = this.createPopup();
        }
        return this.popup;
    }

    protected final void setPopup(@Nullable TreeMapPopup treeMapPopup) {
        this.popup = treeMapPopup;
    }

    @Override
    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    @Override
    public void setPreferredWidth(int n) {
        this.preferredWidth = n;
    }

    @NotNull
    public final ToolTipTreeMapRenderer<N, Row, Column> getRenderer() {
        return this.renderer;
    }

    public final void setRenderer(@NotNull ToolTipTreeMapRenderer<N, Row, Column> renderer) {
        Intrinsics.checkNotNullParameter(renderer, (String)"renderer");
        this.renderer = renderer;
    }

    @NotNull
    public final Insets getInsets() {
        return new Insets(2, 2, 2, 2);
    }

    @Override
    @Nullable
    public Dimension getPreferredSize(@Nullable TGraphics g) {
        TreeMapModel<N, Row, Column> model = this.view.getModel();
        if (model != null && this.getNode() != null) {
            Dimension dimension;
            ToolTipTreeMapRenderer<N, Row, Column> toolTipTreeMapRenderer = this.getRenderer();
            N n = this.getNode();
            Intrinsics.checkNotNull(n);
            Rectangle bounds = toolTipTreeMapRenderer.drawToolTip(g, this.view, model, n, this.getPreferredWidth(), 20, 7, false);
            if (bounds != null) {
                Insets insets = this.getInsets();
                dimension = new Dimension(bounds.getIwidth() + 1 + insets.getLeft() + insets.getRight(), bounds.getIheight() + 1 + insets.getTop() + insets.getBottom());
            } else {
                dimension = null;
            }
            return dimension;
        }
        return null;
    }

    @Nullable
    protected final CPColor getBorderColor() {
        TreeMapModel<N, Row, Column> treeMapModel = this.view.getModel();
        Intrinsics.checkNotNull(treeMapModel);
        CPColor probingColor = treeMapModel.getSettings().getProbingColor();
        return probingColor != null ? CPColorKt.alpha((CPColor)probingColor, (float)0.5f) : null;
    }

    @Override
    public void paintBackground(@NotNull TGraphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        TreeMapModel<N, Row, Column> treeMapModel = this.view.getModel();
        Intrinsics.checkNotNull(treeMapModel);
        CPColor background = treeMapModel.getSettings().getTooltipBackground();
        if (background != null) {
            Insets insets = this.getInsets();
            int x = insets.getLeft();
            int y = insets.getTop();
            int width = this.getWidth() - insets.getLeft() - insets.getRight();
            int height = this.getHeight() - insets.getTop() - insets.getBottom();
            g.setFill(background);
            g.fillRoundRect(x, y, width, height, 10.0, 10.0);
            CPColor borderColor = this.getBorderColor();
            if (borderColor != null) {
                g.setStroke(borderColor);
                float borderThickness = insets.getLeft();
                g.setLineWidth(borderThickness);
                double halfThickness = borderThickness / (float)2;
                g.strokeRoundRect(halfThickness, halfThickness, width, height, 10.0, 10.0);
            }
        }
    }

    @Override
    public void paintText(@NotNull TGraphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Insets insets = this.getInsets();
        int x = insets.getLeft();
        int y = insets.getTop();
        int width = this.getWidth() - insets.getLeft() - insets.getRight();
        int height = this.getHeight() - insets.getTop() - insets.getBottom();
        g.save();
        g.translate(x, y);
        g.clip((Shape)new Rectangle2D.Double(0.0, 0.0, (double)width, (double)height));
        g.setAntialias(true);
        this.getRenderer().paint(g, this.view, this.getNode(), this.getPreferredWidth(), 20, 7, null);
        g.restore();
    }

    @Override
    @Nullable
    public Point getPopupLocation() {
        Point point;
        if (this.getPopup() != null) {
            TreeMapPopup treeMapPopup = this.getPopup();
            Intrinsics.checkNotNull((Object)treeMapPopup);
            point = treeMapPopup.getAnchor();
        } else {
            point = null;
        }
        return point;
    }

    @NotNull
    protected final TreeMapPopup createPopup() {
        return new DefaultTreeMapPopup(this.view);
    }

    @Override
    public synchronized void showNode(@Nullable N node) {
        if (this.getNode() != node) {
            TreeMapPopup popup;
            this.setNode(node);
            Point tooltipPosition = this.getPreferredLocation();
            Dimension tooltipDimension = this.getPreferredSize(null);
            if (tooltipPosition != null && tooltipDimension != null && (popup = this.getPopup()) != null) {
                this.showPopup(tooltipPosition.getIx(), tooltipPosition.getIy());
            }
            if (node == null) {
                this.hidePopup();
            }
            if (this.getPopup() != null) {
                TreeMapPopup treeMapPopup = this.getPopup();
                Intrinsics.checkNotNull((Object)treeMapPopup);
                treeMapPopup.repaint();
            }
        }
    }

    @Nullable
    public final Point getPreferredLocation(@Nullable Point p) {
        Point p2 = p;
        TreeMapModel<N, Row, Column> treeMapModel = this.view.getModel();
        Intrinsics.checkNotNull(treeMapModel);
        TreeMapModel<N, Row, Column> model = treeMapModel;
        if (model != null && this.getNode() != null) {
            Dimension size;
            N n = model.getCurrentRoot();
            Intrinsics.checkNotNull(n);
            Shape shape = this.view.getRenderedShape(n);
            if (p2 == null) {
                N n2 = this.getNode();
                Intrinsics.checkNotNull(n2);
                Shape nodeShape = this.view.getRenderedShape(n2);
                if (nodeShape != null) {
                    p2 = new Point((int)nodeShape.getBounds2D().getCenterX(), (int)nodeShape.getBounds2D().getCenterY());
                } else {
                    return null;
                }
            }
            int mouseX = p2.getIx();
            int mouseY = p2.getIy();
            if (shape != null && (size = this.getPreferredSize(null)) != null) {
                int width = size.getIwidth();
                int height = size.getIheight();
                Rectangle bounds = new Rectangle(mouseX + 20, mouseY + 7, width, height);
                Dimension d = this.view.getSize();
                if ((double)mouseX > d.getWidth() - (double)20 - (double)width) {
                    bounds.setIx(mouseX - (20 + width));
                }
                if ((double)mouseY > d.getHeight() - (double)height - (double)7) {
                    bounds.setIy(d.getIheight() - height - 7);
                }
                return new Point(bounds.getIx(), bounds.getIy());
            }
        }
        return null;
    }

    protected final void showPopup(int x, int y) {
        TreeMapPopup popup = this.getPopup();
        if (popup != null) {
            popup.showPopup(x, y, this.view.getComponent());
        }
    }

    protected final void hidePopup() {
        TreeMapPopup popup = this.getPopup();
        if (popup != null) {
            popup.hidePopup();
        }
    }

    public AbstractTreeMapToolTip(@NotNull TreeMapView<N, Row, Column> view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        this.preferredWidth = 230;
        this.renderer = new ToolTipTreeMapRenderer();
        this.view = view;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/treemap/AbstractTreeMapToolTip$Companion;", "", "()V", "leftShift", "", "topShift", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

