/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.treemap.Algorithm;
import com.treemap.BarAlgorithm;
import com.treemap.BinaryTreeAlgorithm;
import com.treemap.CirclePackingAlgorithm;
import com.treemap.CircularAlgorithm;
import com.treemap.IcicleAlgorithm;
import com.treemap.MatrixAlgorithm;
import com.treemap.PieAlgorithm;
import com.treemap.PivotByAlgorithm;
import com.treemap.SliceAndDiceAlgorithm;
import com.treemap.SplitAlgorithm;
import com.treemap.SquarifiedAlgorithm;
import com.treemap.SquarifiedPlusAlgorithm;
import com.treemap.StripAlgorithm;
import com.treemap.SunburstAlgorithm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001b\b\u0004\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u0013\u0010\n\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0086\u0002J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eJ\u0006\u0010\u000f\u001a\u00020\u0004R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/treemap/AlgorithmFactory;", "", "entries", "", "Lcom/treemap/Algorithm;", "([Lcom/treemap/Algorithm;)V", "", "add", "", "entry", "get", "name", "", "getAlgorithms", "", "getDefault", "Companion", "treemap"})
public final class AlgorithmFactory {
    private final List<Algorithm> entries;
    @NotNull
    private static final Algorithm BINARY_TREE;
    @NotNull
    private static final Algorithm SLICE;
    @NotNull
    private static final Algorithm SQUARIFIED;
    @NotNull
    private static final Algorithm SQUARIFIEDPLUS;
    @NotNull
    private static final Algorithm STRIP;
    @NotNull
    private static final Algorithm PIVOT_BY_SPLIT_SIZE;
    @NotNull
    private static final Algorithm SPLIT;
    @NotNull
    private static final Algorithm CIRCULAR;
    @NotNull
    private static final Algorithm CIRCLEPACKING;
    @NotNull
    private static final Algorithm PIE;
    @NotNull
    private static final Algorithm BAR;
    @NotNull
    private static final Algorithm MATRIX;
    @NotNull
    private static final Algorithm SUNBURST;
    @NotNull
    private static final Algorithm ICICLE;
    private static final AlgorithmFactory ourInstance;
    @NotNull
    public static final Companion Companion;

    public final void add(@NotNull Algorithm entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.entries.add(entry);
    }

    @NotNull
    public final Algorithm getDefault() {
        return SQUARIFIEDPLUS;
    }

    @NotNull
    public final List<Algorithm> getAlgorithms() {
        return this.entries;
    }

    @NotNull
    public final Algorithm get(@Nullable String name) {
        for (Algorithm algorithm : this.entries) {
            if (!algorithm.toString().equals(name)) continue;
            return algorithm;
        }
        return this.getDefault();
    }

    protected AlgorithmFactory(Algorithm ... entries) {
        Intrinsics.checkNotNullParameter((Object)entries, (String)"entries");
        this.entries = new ArrayList();
        CollectionsKt.addAll((Collection)this.entries, (Object[])entries);
    }

    static {
        Companion = new Companion(null);
        BINARY_TREE = new BinaryTreeAlgorithm(false, 1, null);
        SLICE = new SliceAndDiceAlgorithm(null, 1, null);
        SQUARIFIED = new SquarifiedAlgorithm();
        SQUARIFIEDPLUS = new SquarifiedPlusAlgorithm();
        STRIP = new StripAlgorithm(false, 1, null);
        PIVOT_BY_SPLIT_SIZE = new PivotByAlgorithm(null, 1, null);
        SPLIT = new SplitAlgorithm();
        CIRCULAR = new CircularAlgorithm();
        CIRCLEPACKING = new CirclePackingAlgorithm();
        PIE = new PieAlgorithm();
        BAR = new BarAlgorithm(0.0, null, 3, null);
        MATRIX = new MatrixAlgorithm();
        SUNBURST = new SunburstAlgorithm();
        ICICLE = new IcicleAlgorithm();
        ourInstance = new AlgorithmFactory(BINARY_TREE, SLICE, SQUARIFIED, SQUARIFIEDPLUS, STRIP, PIVOT_BY_SPLIT_SIZE, SPLIT, CIRCULAR, BAR, PIE, SUNBURST, MATRIX, ICICLE);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010#\u001a\u00020\"R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0011\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006R\u0011\u0010\u001d\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0006R\u0011\u0010\u001f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0006R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/treemap/AlgorithmFactory$Companion;", "", "()V", "BAR", "Lcom/treemap/Algorithm;", "getBAR", "()Lcom/treemap/Algorithm;", "BINARY_TREE", "getBINARY_TREE", "CIRCLEPACKING", "getCIRCLEPACKING", "CIRCULAR", "getCIRCULAR", "ICICLE", "getICICLE", "MATRIX", "getMATRIX", "PIE", "getPIE", "PIVOT_BY_SPLIT_SIZE", "getPIVOT_BY_SPLIT_SIZE", "SLICE", "getSLICE", "SPLIT", "getSPLIT", "SQUARIFIED", "getSQUARIFIED", "SQUARIFIEDPLUS", "getSQUARIFIEDPLUS", "STRIP", "getSTRIP", "SUNBURST", "getSUNBURST", "ourInstance", "Lcom/treemap/AlgorithmFactory;", "getInstance", "treemap"})
    public static final class Companion {
        @NotNull
        public final Algorithm getBINARY_TREE() {
            return BINARY_TREE;
        }

        @NotNull
        public final Algorithm getSLICE() {
            return SLICE;
        }

        @NotNull
        public final Algorithm getSQUARIFIED() {
            return SQUARIFIED;
        }

        @NotNull
        public final Algorithm getSQUARIFIEDPLUS() {
            return SQUARIFIEDPLUS;
        }

        @NotNull
        public final Algorithm getSTRIP() {
            return STRIP;
        }

        @NotNull
        public final Algorithm getPIVOT_BY_SPLIT_SIZE() {
            return PIVOT_BY_SPLIT_SIZE;
        }

        @NotNull
        public final Algorithm getSPLIT() {
            return SPLIT;
        }

        @NotNull
        public final Algorithm getCIRCULAR() {
            return CIRCULAR;
        }

        @NotNull
        public final Algorithm getCIRCLEPACKING() {
            return CIRCLEPACKING;
        }

        @NotNull
        public final Algorithm getPIE() {
            return PIE;
        }

        @NotNull
        public final Algorithm getBAR() {
            return BAR;
        }

        @NotNull
        public final Algorithm getMATRIX() {
            return MATRIX;
        }

        @NotNull
        public final Algorithm getSUNBURST() {
            return SUNBURST;
        }

        @NotNull
        public final Algorithm getICICLE() {
            return ICICLE;
        }

        @NotNull
        public final AlgorithmFactory getInstance() {
            return ourInstance;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

