/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.treemap.AbstractAlgorithm;
import com.treemap.BarAlgorithm$WhenMappings;
import com.treemap.TreeMapAccessor;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapWorker;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001%B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006Jm\u0010\n\u001a\u00020\b\"\u0004\b\u0000\u0010\u000b\"\u0004\b\u0001\u0010\f\"\u0004\b\u0002\u0010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u0002H\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0012\u0010\u001c\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016JG\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u001e\"\u0004\b\u0000\u0010\u000b\"\u0004\b\u0001\u0010\f\"\u0004\b\u0002\u0010\r2\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r0 2\u0006\u0010!\u001a\u0002H\u000bH\u0016\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020$H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/treemap/BarAlgorithm;", "Lcom/treemap/AbstractAlgorithm;", "marginProportion", "", "orientation", "Lcom/treemap/BarAlgorithm$Orientation;", "(DLcom/treemap/BarAlgorithm$Orientation;)V", "isSpaceFilling", "", "()Z", "breadthFirstLayout", "N", "Row", "Column", "shape", "Lorg/mkui/geom/Shape;", "parent", "children", "", "sumSizes", "horizontalVanishingPoint", "", "verticalVanishingPoint", "accessor", "Lcom/treemap/TreeMapAccessor;", "worker", "Lcom/treemap/TreeMapWorker;", "(Lorg/mkui/geom/Shape;Ljava/lang/Object;[Ljava/lang/Object;DIILcom/treemap/TreeMapAccessor;Lcom/treemap/TreeMapWorker;)Z", "isCompatible", "iterator", "", "model", "Lcom/treemap/TreeMapModel;", "root", "(Lcom/treemap/TreeMapModel;Ljava/lang/Object;)Ljava/lang/Iterable;", "toString", "", "Orientation", "treemap"})
public final class BarAlgorithm
extends AbstractAlgorithm {
    private final double marginProportion;
    private final Orientation orientation;

    @Override
    @NotNull
    public <N, Row, Column> Iterable<N> iterator(@NotNull TreeMapModel<N, Row, Column> model, N root) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        return model.depthFirstIterator(root);
    }

    @Override
    public <N, Row, Column> boolean breadthFirstLayout(@NotNull Shape shape, N parent, @NotNull N[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, @NotNull TreeMapAccessor<? super N> accessor, @Nullable TreeMapWorker worker) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
        Rectangle2D bounds = shape.getBounds2D();
        double maxSize = 0.0;
        int count = 0;
        for (N child : children) {
            if (accessor.getSize(child) > maxSize) {
                maxSize = accessor.getSize(child);
            }
            if (!(accessor.getSize(child) > 0.0)) continue;
            ++count;
        }
        switch (BarAlgorithm$WhenMappings.$EnumSwitchMapping$0[this.orientation.ordinal()]) {
            case 1: {
                double margin = bounds.getHeight() * this.marginProportion / (double)count;
                double size = bounds.getHeight() * (1.0 - this.marginProportion) / (double)count;
                double start2 = bounds.getMinY() + margin / (double)2;
                for (N child : children) {
                    if (accessor.getSize(child) > 0.0) {
                        double w = bounds.getWidth() * accessor.getSize(child) / maxSize;
                        accessor.setShape(child, (Shape)new Rectangle2D.Double(0.0, start2, w, size));
                        start2 += size + margin;
                        continue;
                    }
                    accessor.setShape(child, null);
                }
                break;
            }
            case 2: {
                double margin = bounds.getWidth() * this.marginProportion / (double)count;
                double size = bounds.getWidth() * (1.0 - this.marginProportion) / (double)count;
                double start3 = bounds.getMinX() + margin / (double)2;
                for (N child : children) {
                    if (accessor.getSize(child) > 0.0) {
                        double h = bounds.getHeight() * accessor.getSize(child) / maxSize;
                        accessor.setShape(child, (Shape)new Rectangle2D.Double(start3, bounds.getMaxY() - h, size, h));
                        start3 += size + margin;
                        continue;
                    }
                    accessor.setShape(child, null);
                }
                break;
            }
        }
        return false;
    }

    @Override
    public boolean isCompatible(@Nullable Shape shape) {
        return shape instanceof Rectangle2D;
    }

    @Override
    public boolean isSpaceFilling() {
        return false;
    }

    @NotNull
    public String toString() {
        return "Bar";
    }

    public BarAlgorithm(double marginProportion, @NotNull Orientation orientation) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        this.marginProportion = marginProportion;
        this.orientation = orientation;
    }

    public /* synthetic */ BarAlgorithm(double d, Orientation orientation, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        if ((n & 2) != 0) {
            orientation = Orientation.Horizontal;
        }
        this(d, orientation);
    }

    public BarAlgorithm() {
        this(0.0, null, 3, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/treemap/BarAlgorithm$Orientation;", "", "(Ljava/lang/String;I)V", "Vertical", "Horizontal", "treemap"})
    public static final class Orientation
    extends Enum<Orientation> {
        public static final /* enum */ Orientation Vertical;
        public static final /* enum */ Orientation Horizontal;
        private static final /* synthetic */ Orientation[] $VALUES;

        static {
            Orientation[] orientationArray = new Orientation[2];
            Orientation[] orientationArray2 = orientationArray;
            orientationArray[0] = Vertical = new Orientation();
            orientationArray[1] = Horizontal = new Orientation();
            $VALUES = orientationArray;
        }

        public static Orientation[] values() {
            return (Orientation[])$VALUES.clone();
        }

        public static Orientation valueOf(String string) {
            return Enum.valueOf(Orientation.class, string);
        }
    }
}

