/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.common.math.MathKt;
import com.macrofocus.common.properties.MutableProperties;
import com.treemap.Algorithm;
import com.treemap.Itertools;
import com.treemap.TreeMapAccessor;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.AffineTransform;
import org.mkui.geom.Ellipse2D;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\t\b\u0000\u0018\u0000 =2\u00020\u0001:\u0004<=>?B\u0005\u00a2\u0006\u0002\u0010\u0002Jm\u0010\u0018\u001a\u00020\n\"\u0004\b\u0000\u0010\u0019\"\u0004\b\u0001\u0010\u001a\"\u0004\b\u0002\u0010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u0002H\u00192\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00190 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00042\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H\u00190&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016\u00a2\u0006\u0002\u0010)J1\u0010*\u001a\u0004\u0018\u00010+\"\u0004\b\u0000\u0010\u00192\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00190 2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H\u00190&H\u0002\u00a2\u0006\u0002\u0010,Jo\u0010-\u001a\u00020\n\"\u0004\b\u0000\u0010\u0019\"\u0004\b\u0001\u0010\u001a\"\u0004\b\u0002\u0010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u0002H\u00192\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00190 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00042\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H\u00190&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016\u00a2\u0006\u0002\u0010)JM\u0010.\u001a\u00020/\"\u0004\b\u0000\u0010\u0019\"\u0004\b\u0001\u0010\u001a\"\u0004\b\u0002\u0010\u001b2\b\u00100\u001a\u0004\u0018\u00010+2\u001a\u00101\u001a\u0016\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b\u0018\u0001022\u0006\u00103\u001a\u0002H\u0019H\u0016\u00a2\u0006\u0002\u00104J\u0012\u00105\u001a\u00020\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016JG\u00106\u001a\b\u0012\u0004\u0012\u0002H\u001907\"\u0004\b\u0000\u0010\u0019\"\u0004\b\u0001\u0010\u001a\"\u0004\b\u0002\u0010\u001b2\u0018\u00101\u001a\u0014\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b022\u0006\u00103\u001a\u0002H\u0019H\u0016\u00a2\u0006\u0002\u00108JU\u00109\u001a\u00020/\"\u0004\b\u0000\u0010\u0019\"\u0004\b\u0001\u0010\u001a\"\u0004\b\u0002\u0010\u001b2\b\u00100\u001a\u0004\u0018\u00010+2\u0018\u00101\u001a\u0014\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b022\u0006\u00103\u001a\u0002H\u00192\b\u0010'\u001a\u0004\u0018\u00010(H\u0016\u00a2\u0006\u0002\u0010:J\b\u0010;\u001a\u00020\u0012H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000bR\u0014\u0010\f\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\r\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0014\u0010\u000f\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u001e\u0010\u0010\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0006\"\u0004\b\u0017\u0010\b\u00a8\u0006@"}, d2={"Lcom/treemap/CirclePackingAlgorithm;", "Lcom/treemap/Algorithm;", "()V", "horizontalAlignment", "", "getHorizontalAlignment", "()I", "setHorizontalAlignment", "(I)V", "isChildContained", "", "()Z", "isColorParent", "isRenderingLeafLabelsSupported", "isRenderingParentLabelSupported", "isSpaceFilling", "properties", "Lcom/macrofocus/common/properties/MutableProperties;", "", "getProperties", "()Lcom/macrofocus/common/properties/MutableProperties;", "verticalAlignment", "getVerticalAlignment", "setVerticalAlignment", "breadthFirstLayout", "N", "Row", "Column", "shape", "Lorg/mkui/geom/Shape;", "parent", "children", "", "sumSizes", "", "horizontalVanishingPoint", "verticalVanishingPoint", "accessor", "Lcom/treemap/TreeMapAccessor;", "worker", "Lcom/treemap/TreeMapWorker;", "(Lorg/mkui/geom/Shape;Ljava/lang/Object;[Ljava/lang/Object;DIILcom/treemap/TreeMapAccessor;Lcom/treemap/TreeMapWorker;)Z", "computeBoundingBox", "Lorg/mkui/geom/Rectangle2D;", "([Ljava/lang/Object;Lcom/treemap/TreeMapAccessor;)Lorg/mkui/geom/Rectangle2D;", "depthFirstLayout", "finishLayout", "", "bounds", "model", "Lcom/treemap/TreeMapModel;", "root", "(Lorg/mkui/geom/Rectangle2D;Lcom/treemap/TreeMapModel;Ljava/lang/Object;)V", "isCompatible", "iterator", "", "(Lcom/treemap/TreeMapModel;Ljava/lang/Object;)Ljava/lang/Iterable;", "startLayout", "(Lorg/mkui/geom/Rectangle2D;Lcom/treemap/TreeMapModel;Ljava/lang/Object;Lcom/treemap/TreeMapWorker;)V", "toString", "Circle", "Companion", "Complex", "Pair", "treemap"})
public final class CirclePackingAlgorithm
implements Algorithm {
    private int verticalAlignment;
    private int horizontalAlignment;
    private final boolean isRenderingLeafLabelsSupported;
    private final boolean isRenderingParentLabelSupported;
    private final boolean isColorParent;
    private final boolean isChildContained;
    private final boolean isSpaceFilling;
    private static final boolean NEW = true;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public MutableProperties<String> getProperties() {
        return null;
    }

    protected final int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    protected final void setVerticalAlignment(int n) {
        this.verticalAlignment = n;
    }

    protected final int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    protected final void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
    }

    @Override
    @NotNull
    public <N, Row, Column> Iterable<N> iterator(@NotNull TreeMapModel<N, Row, Column> model, N root) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        return model.depthFirstIterator(root);
    }

    @Override
    public <N, Row, Column> void startLayout(@Nullable Rectangle2D bounds, @NotNull TreeMapModel<N, Row, Column> model, N root, @Nullable TreeMapWorker worker) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <N, Row, Column> boolean depthFirstLayout(@Nullable Shape shape, N parent, @NotNull N[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, @NotNull TreeMapAccessor<? super N> accessor, @Nullable TreeMapWorker worker) {
        Circle circle;
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
        ArrayList<Circle> circles = new ArrayList<Circle>();
        for (N child : children) {
            circle = new Circle();
            if (accessor.hasNoChildren(child)) {
                double d = 0.0;
                double d2 = accessor.getSize(child) / Math.PI;
                boolean bl = false;
                d2 = Math.sqrt(d2);
                bl = false;
                circle.setRadius(Math.max(d, d2));
            } else {
                boolean bl;
                double d;
                Shape s = accessor.getShape(child);
                if (s != null) {
                    if (s instanceof Ellipse2D) {
                        Ellipse2D b = (Ellipse2D)s;
                        circle.setRadius(b.getWidth() / (double)2);
                    } else {
                        double b = 0.0;
                        d = accessor.getSize(child) / Math.PI;
                        bl = false;
                        d = Math.sqrt(d);
                        bl = false;
                        circle.setRadius(Math.max(b, d));
                    }
                } else {
                    double b = 0.0;
                    d = accessor.getSize(child) / Math.PI;
                    bl = false;
                    d = Math.sqrt(d);
                    bl = false;
                    circle.setRadius(Math.max(b, d));
                }
            }
            circles.add(circle);
        }
        ArrayList<Circle> sorted = new ArrayList<Circle>((Collection)circles);
        CollectionsKt.sort((List)sorted);
        ArrayList<Circle> placed_circles = Companion.pack_A1_0(sorted);
        int n = 0;
        int n2 = ((Collection)placed_circles).size();
        while (n < n2) {
            Circle t;
            void i;
            Intrinsics.checkNotNullExpressionValue((Object)placed_circles.get((int)i), (String)"placed_circles.get(i)");
            Intrinsics.checkNotNullExpressionValue((Object)sorted.get((int)i), (String)"sorted.get(i)");
            t.setCx(circle.getCx());
            t.setCy(circle.getCy());
            t.setRadius(circle.getRadius());
            ++i;
        }
        Circle boundingCircle = CirclePackingAlgorithm.Companion.boundingCircle(circles);
        Iterator iterator2 = circles.iterator();
        while (iterator2.hasNext()) {
            Circle child;
            Circle circle2 = child = (Circle)iterator2.next();
            circle2.setCx(circle2.getCx() - boundingCircle.getCx());
            Circle circle3 = child;
            circle3.setCy(circle3.getCy() - boundingCircle.getCy());
        }
        boundingCircle = CirclePackingAlgorithm.Companion.boundingCircle(circles);
        if (shape == null) {
            if (boundingCircle != null && !MathKt.isNaN((double)boundingCircle.getRadius())) {
                Rectangle2D b = boundingCircle.getBounds2D();
                accessor.setShape(parent, (Shape)new Ellipse2D.Double(b.getX(), b.getY(), b.getWidth(), b.getHeight()));
            } else {
                accessor.setShape(parent, null);
            }
        }
        int b = 0;
        int n3 = children.length;
        while (b < n3) {
            void i;
            Object e = circles.get((int)i);
            Intrinsics.checkNotNullExpressionValue(e, (String)"circles.get(i)");
            Circle circle4 = (Circle)e;
            N child = children[i];
            if (circle4 != null && !MathKt.isNaN((double)circle4.getRadius()) && circle4.getRadius() > 0.0) {
                Rectangle2D b2 = circle4.getBounds2D();
                accessor.setShape(child, (Shape)new Ellipse2D.Double(b2.getX(), b2.getY(), b2.getWidth(), b2.getHeight()));
            } else {
                accessor.setShape(child, null);
            }
            ++i;
        }
        return false;
    }

    @Override
    public <N, Row, Column> boolean breadthFirstLayout(@NotNull Shape shape, N parent, @NotNull N[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, @NotNull TreeMapAccessor<? super N> accessor, @Nullable TreeMapWorker worker) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
        Rectangle2D bounds = shape.getBounds2D();
        Rectangle2D cb = this.computeBoundingBox(children, accessor);
        if (cb != null) {
            double d = bounds.getWidth();
            double d2 = bounds.getHeight();
            boolean bl = false;
            double size = Math.min(d, d2);
            double xs = size / cb.getWidth();
            double ys = size / cb.getHeight();
            for (N node : children) {
                double tx = -cb.getMinX() * xs + bounds.getX();
                double ty = -cb.getMinY() * ys + bounds.getY();
                switch (this.horizontalAlignment) {
                    case 0: {
                        tx += (bounds.getWidth() - size) / (double)2;
                        break;
                    }
                    case 2: {
                        tx += bounds.getWidth() - size;
                        break;
                    }
                }
                switch (this.verticalAlignment) {
                    case 0: {
                        ty += (bounds.getHeight() - size) / (double)2;
                        break;
                    }
                    case 3: {
                        ty += bounds.getHeight() - size;
                        break;
                    }
                }
                AffineTransform at = new AffineTransform(xs, 0.0, 0.0, ys, tx, ty);
                Shape s = accessor.getShape(node);
                if (s != null) {
                    Shape x;
                    Rectangle2D b1 = s.getBounds2D();
                    Intrinsics.checkNotNull((Object)at.createTransformedShape((Shape)new Rectangle2D.Double(b1.getX(), b1.getY(), b1.getWidth(), b1.getHeight())));
                    Rectangle2D b = x.getBounds2D();
                    accessor.setShape(node, (Shape)new Ellipse2D.Double(b.getX(), b.getY(), b.getWidth(), b.getHeight()));
                    continue;
                }
                accessor.setShape(node, null);
            }
        } else {
            for (N node : children) {
                accessor.setShape(node, null);
            }
        }
        return false;
    }

    private final <N> Rectangle2D computeBoundingBox(N[] children, TreeMapAccessor<? super N> accessor) {
        Rectangle2D rectangle2D;
        ArrayList<Circle> circles = new ArrayList<Circle>();
        for (N child : children) {
            Shape shape = accessor.getShape(child);
            if (shape == null || !(shape instanceof Ellipse2D)) continue;
            Ellipse2D ellipse2D = (Ellipse2D)shape;
            Circle circle = new Circle(ellipse2D.getCenterX(), ellipse2D.getCenterY(), ellipse2D.getWidth() / (double)2);
            circles.add(circle);
        }
        if (circles.size() > 0) {
            Circle circle = CirclePackingAlgorithm.Companion.boundingCircle(circles);
            Rectangle2D b = circle.getBounds2D();
            rectangle2D = new Rectangle2D.Double(b.getX(), b.getY(), b.getWidth(), b.getHeight()).getBounds2D();
        } else {
            rectangle2D = null;
        }
        return rectangle2D;
    }

    @Override
    public <N, Row, Column> void finishLayout(@Nullable Rectangle2D bounds, @Nullable TreeMapModel<N, Row, Column> model, N root) {
    }

    @Override
    public boolean isCompatible(@Nullable Shape shape) {
        return shape instanceof Rectangle2D || shape instanceof Ellipse2D;
    }

    @Override
    public boolean isRenderingLeafLabelsSupported() {
        return this.isRenderingLeafLabelsSupported;
    }

    @Override
    public boolean isRenderingParentLabelSupported() {
        return this.isRenderingParentLabelSupported;
    }

    @Override
    public boolean isColorParent() {
        return this.isColorParent;
    }

    @Override
    public boolean isChildContained() {
        return this.isChildContained;
    }

    @Override
    public boolean isSpaceFilling() {
        return this.isSpaceFilling;
    }

    @NotNull
    public String toString() {
        return "CirclePackging";
    }

    public CirclePackingAlgorithm() {
        this.isRenderingLeafLabelsSupported = true;
        this.isRenderingParentLabelSupported = true;
        this.isChildContained = true;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/treemap/CirclePackingAlgorithm$Pair;", "", "ca", "Lcom/treemap/CirclePackingAlgorithm$Circle;", "cb", "(Lcom/treemap/CirclePackingAlgorithm$Circle;Lcom/treemap/CirclePackingAlgorithm$Circle;)V", "innerSoddyRadius", "", "(Lcom/treemap/CirclePackingAlgorithm$Circle;Lcom/treemap/CirclePackingAlgorithm$Circle;D)V", "getCa", "()Lcom/treemap/CirclePackingAlgorithm$Circle;", "getCb", "getInnerSoddyRadius", "()D", "setInnerSoddyRadius", "(D)V", "treemap"})
    private static final class Pair {
        @NotNull
        private final Circle ca;
        @NotNull
        private final Circle cb;
        private double innerSoddyRadius;

        @NotNull
        public final Circle getCa() {
            return this.ca;
        }

        @NotNull
        public final Circle getCb() {
            return this.cb;
        }

        public final double getInnerSoddyRadius() {
            return this.innerSoddyRadius;
        }

        public final void setInnerSoddyRadius(double d) {
            this.innerSoddyRadius = d;
        }

        public Pair(@NotNull Circle ca, @NotNull Circle cb) {
            Intrinsics.checkNotNullParameter((Object)ca, (String)"ca");
            Intrinsics.checkNotNullParameter((Object)cb, (String)"cb");
            this.innerSoddyRadius = Double.MAX_VALUE;
            this.ca = ca;
            this.cb = cb;
        }

        public Pair(@NotNull Circle ca, @NotNull Circle cb, double innerSoddyRadius) {
            Intrinsics.checkNotNullParameter((Object)ca, (String)"ca");
            Intrinsics.checkNotNullParameter((Object)cb, (String)"cb");
            this.innerSoddyRadius = Double.MAX_VALUE;
            this.ca = ca;
            this.cb = cb;
            this.innerSoddyRadius = innerSoddyRadius;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0002J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0004J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004J\u0013\u0010\u001a\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0000J\b\u0010 \u001a\u00020\u0012H\u0016J\u0018\u0010!\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0017\u001a\u00020\u0004J\b\u0010\"\u001a\u00020#H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u000e\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\t\"\u0004\b\u0010\u0010\u000b\u00a8\u0006$"}, d2={"Lcom/treemap/CirclePackingAlgorithm$Circle;", "", "()V", "cx", "", "cy", "r", "(DDD)V", "getCx", "()D", "setCx", "(D)V", "getCy", "setCy", "radius", "getRadius", "setRadius", "compareTo", "", "c2", "contains", "", "that", "error", "px", "py", "equals", "other", "", "getBounds2D", "Lorg/mkui/geom/Rectangle2D;", "getIntersectionRadius", "hashCode", "intersects", "toString", "", "treemap"})
    public static final class Circle
    implements Comparable<Circle> {
        private double cx;
        private double cy;
        private double radius;

        public final double getCx() {
            return this.cx;
        }

        public final void setCx(double d) {
            this.cx = d;
        }

        public final double getCy() {
            return this.cy;
        }

        public final void setCy(double d) {
            this.cy = d;
        }

        public final double getRadius() {
            return this.radius;
        }

        public final void setRadius(double d) {
            this.radius = d;
        }

        public final boolean intersects(@NotNull Circle that, double error) {
            Intrinsics.checkNotNullParameter((Object)that, (String)"that");
            double dist = (this.cx - that.cx) * (this.cx - that.cx) + (this.cy - that.cy) * (this.cy - that.cy);
            return dist < (this.radius + that.radius) * (this.radius + that.radius) - error;
        }

        public static /* synthetic */ boolean intersects$default(Circle circle, Circle circle2, double d, int n, Object object) {
            if ((n & 2) != 0) {
                d = 0.0;
            }
            return circle.intersects(circle2, d);
        }

        public final double getIntersectionRadius(@NotNull Circle that) {
            Intrinsics.checkNotNullParameter((Object)that, (String)"that");
            double dist = (this.cx - that.cx) * (this.cx - that.cx) + (this.cy - that.cy) * (this.cy - that.cy);
            boolean bl = false;
            return Math.sqrt(dist) - that.radius;
        }

        public final boolean contains(@NotNull Circle that) {
            Intrinsics.checkNotNullParameter((Object)that, (String)"that");
            return this.contains(that, 0.0);
        }

        public final boolean contains(@NotNull Circle that, double error) {
            Intrinsics.checkNotNullParameter((Object)that, (String)"that");
            double d = (this.cx - that.cx) * (this.cx - that.cx) + (this.cy - that.cy) * (this.cy - that.cy);
            boolean bl = false;
            double dist = Math.sqrt(d);
            return this.radius >= dist + that.radius - error;
        }

        public final boolean contains(double px, double py) {
            double d = (this.cx - px) * (this.cx - px) + (this.cy - py) * (this.cy - py);
            boolean bl = false;
            double dist = Math.sqrt(d);
            return this.radius >= dist;
        }

        @NotNull
        public final Rectangle2D getBounds2D() {
            return (Rectangle2D)new Rectangle2D.Double(this.cx - this.radius, this.cy - this.radius, this.radius * 2.0, this.radius * (double)2);
        }

        @Override
        public int compareTo(@NotNull Circle c2) {
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c2");
            double cmp = this.radius - c2.radius;
            return cmp < 0.0 ? 1 : (cmp > 0.0 ? -1 : 0);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)Reflection.getOrCreateKotlinClass(other.getClass())) ^ true) {
                return false;
            }
            Circle cfr_ignored_0 = (Circle)other;
            if (this.cx != ((Circle)other).cx) {
                return false;
            }
            if (this.cy != ((Circle)other).cy) {
                return false;
            }
            return this.radius == ((Circle)other).radius;
        }

        public int hashCode() {
            int result = Double.hashCode(this.cx);
            result = 31 * result + Double.hashCode(this.cy);
            result = 31 * result + Double.hashCode(this.radius);
            return result;
        }

        @NotNull
        public String toString() {
            return Reflection.getOrCreateKotlinClass(this.getClass()).toString() + "[x:" + this.cx + ",y:" + this.cy + ",r:" + this.radius + "]";
        }

        public Circle() {
        }

        public Circle(double cx, double cy, double r) {
            this.cx = cx;
            this.cy = cy;
            this.radius = r;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0000J\u0006\u0010\b\u001a\u00020\u0003J\u0011\u0010\t\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0000H\u0086\u0002J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0006\u0010\u000f\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\u000bJ\u0006\u0010\u0011\u001a\u00020\u0003J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0000J\u0006\u0010\u0013\u001a\u00020\u0003J\u0006\u0010\u0014\u001a\u00020\u0000J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0000J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/treemap/CirclePackingAlgorithm$Complex;", "", "x", "", "y", "(DD)V", "add", "that", "arg", "div", "equals", "", "o", "hashCode", "", "img", "isNaN", "mod", "mul", "real", "sqrt", "sub", "toString", "", "treemap"})
    private static final class Complex {
        private final double x;
        private final double y;

        public final double real() {
            return this.x;
        }

        public final double img() {
            return this.y;
        }

        @NotNull
        public final Complex add(@NotNull Complex that) {
            Intrinsics.checkNotNullParameter((Object)that, (String)"that");
            return new Complex(this.x + that.x, this.y + that.y);
        }

        @NotNull
        public final Complex sub(@NotNull Complex that) {
            Intrinsics.checkNotNullParameter((Object)that, (String)"that");
            return new Complex(this.x - that.x, this.y - that.y);
        }

        @NotNull
        public final Complex mul(@NotNull Complex that) {
            Intrinsics.checkNotNullParameter((Object)that, (String)"that");
            return new Complex(this.x * that.x - this.y * that.y, this.x * that.y + this.y * that.x);
        }

        @NotNull
        public final Complex div(@NotNull Complex that) {
            Intrinsics.checkNotNullParameter((Object)that, (String)"that");
            return new Complex((this.x * that.x + this.y * that.y) / (that.x * that.x + that.y * that.y), (this.y * that.x - this.x * that.y) / (that.x * that.x + that.y * that.y));
        }

        public final double arg() {
            double d = this.y;
            double d2 = this.x;
            boolean bl = false;
            return Math.atan2(d, d2);
        }

        public final double mod() {
            double d = this.x * this.x + this.y * this.y;
            boolean bl = false;
            return Math.sqrt(d);
        }

        @NotNull
        public final Complex sqrt() {
            double d = this.mod();
            boolean bl = false;
            double r = Math.sqrt(d);
            double theta = this.arg() / (double)2;
            bl = false;
            bl = false;
            return new Complex(r * Math.cos(theta), r * Math.sin(theta));
        }

        public boolean equals(@Nullable Object o) {
            if (o instanceof Complex) {
                Object that = o;
                return ((Complex)that).x == this.x && ((Complex)that).y == this.y;
            }
            return false;
        }

        public int hashCode() {
            long bits = MathKt.doubleToLongBits((double)this.x);
            return (int)(bits ^= MathKt.doubleToLongBits((double)this.y) * (long)31) ^ (int)(bits >> 32);
        }

        @NotNull
        public String toString() {
            return this.y >= 0.0 ? "(" + this.x + "+" + this.y + "i)" : "(" + this.x + "" + this.y + "i)";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isNaN() {
            double d = this.x;
            boolean bl = false;
            if (Double.isNaN(d)) return true;
            d = this.y;
            bl = false;
            if (!Double.isNaN(d)) return false;
            return true;
        }

        public Complex(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nH\u0002J \u0010\u000b\u001a\u00020\t2\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0002J<\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\t2\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\tH\u0002J)\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00162\b\u0010\u000e\u001a\u0004\u0018\u00010\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010\u0018J9\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00162\u0006\u0010\u001a\u001a\u00020\r2\b\u0010\u001b\u001a\u0004\u0018\u00010\t2\b\u0010\u001c\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001d\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u001eJ \u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\rH\u0002J \u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\tH\u0002J.\u0010'\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\n2\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/treemap/CirclePackingAlgorithm$Companion;", "", "()V", "NEW", "", "boundingBox", "Lorg/mkui/geom/Rectangle2D$Double;", "circles", "Ljava/util/ArrayList;", "Lcom/treemap/CirclePackingAlgorithm$Circle;", "Lkotlin/collections/ArrayList;", "boundingCircle", "distance", "", "circle1", "circle2", "get_hole_degree", "candidate", "placed_circles", "pc1", "pc2", "get_intersection", "", "Lorg/mkui/geom/Point2D;", "(Lcom/treemap/CirclePackingAlgorithm$Circle;Lcom/treemap/CirclePackingAlgorithm$Circle;)[Lorg/mkui/geom/Point2D;", "get_placement_candidates", "radius", "c1", "c2", "margin", "(DLcom/treemap/CirclePackingAlgorithm$Circle;Lcom/treemap/CirclePackingAlgorithm$Circle;D)[Lcom/treemap/CirclePackingAlgorithm$Circle;", "innerSoddyRadius", "ra", "rb", "rc", "outerSoddyCircle", "circleA", "circleB", "circleC", "pack_A1_0", "treemap"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ArrayList<Circle> pack_A1_0(@NotNull ArrayList<Circle> circles) {
            ArrayList<Circle> arrayList;
            Intrinsics.checkNotNullParameter(circles, (String)"circles");
            switch (circles.size()) {
                case 0: {
                    arrayList = circles;
                    break;
                }
                case 1: {
                    Circle circle = circles.get(0);
                    Intrinsics.checkNotNullExpressionValue((Object)circle, (String)"circles.get(0)");
                    Circle circle2 = circle;
                    circle2.setCx(0.0);
                    circle2.setCy(0.0);
                    arrayList = circles;
                    break;
                }
                default: {
                    void var2_3;
                    ArrayList<Circle> placed_circles = new ArrayList<Circle>();
                    double _eps = 2.220446049250313E-16;
                    for (Circle value : circles) {
                        String string = "Processing " + value;
                        boolean bl = false;
                        System.out.println((Object)string);
                        double radius = value.getRadius();
                        int n_circles = placed_circles.size();
                        if (n_circles <= 1) {
                            Circle circle;
                            double x = n_circles == 0 ? radius : -radius;
                            Object var12_15 = null;
                            Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                            circle.setCx(x);
                            circle.setCy(0.0);
                            circle.setRadius(radius);
                            placed_circles.add(circle);
                            Iterator<Circle> iterator2 = "Initial " + circle;
                            boolean bl2 = false;
                            System.out.println(iterator2);
                            continue;
                        }
                        Double mhd = null;
                        Circle lead_candidate = null;
                        for (List list : Itertools.INSTANCE.combinations((List)placed_circles, 2)) {
                            Circle c1 = (Circle)list.get(0);
                            Circle c2 = (Circle)list.get(1);
                            for (Circle cand : this.get_placement_candidates(radius, c1, c2, _eps)) {
                                if (cand == null) continue;
                                ArrayList other_placed_circles = new ArrayList(placed_circles);
                                if (c1 != null) {
                                    other_placed_circles.remove(c1);
                                }
                                if (c2 != null) {
                                    other_placed_circles.remove(c2);
                                }
                                boolean overlap = false;
                                Iterator iterator3 = other_placed_circles.iterator();
                                while (iterator3.hasNext()) {
                                    Circle pc;
                                    Circle circle = pc = (Circle)iterator3.next();
                                    Intrinsics.checkNotNullExpressionValue((Object)circle, (String)"pc");
                                    double dist = this.distance(circle, cand);
                                    if (!(dist < -_eps)) continue;
                                    overlap = true;
                                    break;
                                }
                                if (overlap) continue;
                                double hd = this.get_hole_degree(cand, placed_circles, c1, c2);
                                if (mhd != null && !(hd > mhd)) continue;
                                mhd = hd;
                                lead_candidate = cand;
                            }
                        }
                        if (lead_candidate == null) {
                            String string2 = "cannot place circle for value " + value;
                            boolean bl3 = false;
                            System.out.println((Object)string2);
                            for (Circle circle : circles) {
                                String string3 = "Circle: " + circle;
                                boolean bl4 = false;
                                System.out.println((Object)string3);
                            }
                            lead_candidate = value;
                        }
                        String string4 = "Placing " + lead_candidate;
                        boolean bl5 = false;
                        System.out.println((Object)string4);
                        placed_circles.add(lead_candidate);
                    }
                    arrayList = var2_3;
                }
            }
            return arrayList;
        }

        private final double distance(Circle circle1, Circle circle2) {
            double x1 = circle1.getCx();
            double y1 = circle1.getCy();
            double r1 = circle1.getRadius();
            double x2 = circle2.getCx();
            double y2 = circle2.getCy();
            double r2 = circle2.getRadius();
            double x = x2 - x1;
            double y = y2 - y1;
            double d = x * x + y * y;
            boolean bl = false;
            return Math.sqrt(d) - r1 - r2;
        }

        private final double get_hole_degree(Circle candidate, ArrayList<Circle> placed_circles, Circle pc1, Circle pc2) {
            double lsq = 0.0;
            for (Circle pc : placed_circles) {
                if (pc1 != null && Intrinsics.areEqual((Object)pc1, (Object)pc) || pc2 != null && Intrinsics.areEqual((Object)pc2, (Object)pc)) continue;
                double d = candidate.getCy() - pc.getCy();
                double d2 = 2.0;
                boolean bl = false;
                double d3 = Math.pow(d, d2);
                d = candidate.getCx() - pc.getCx();
                d2 = 2.0;
                bl = false;
                d = d3 + Math.pow(d, d2);
                boolean bl2 = false;
                lsq += Math.sqrt(d);
            }
            boolean bl = false;
            return -Math.sqrt(lsq);
        }

        private final Circle[] get_placement_candidates(double radius, Circle c1, Circle c2, double margin) {
            Circle ic1 = null;
            Circle ic2 = null;
            Circle circle = c1;
            Intrinsics.checkNotNull((Object)circle);
            ic1 = new Circle(circle.getCx(), c1.getCy(), c1.getRadius() + (radius + margin));
            Circle circle2 = c2;
            Intrinsics.checkNotNull((Object)circle2);
            ic2 = new Circle(circle2.getCx(), c2.getCy(), c2.getRadius() + (radius + margin));
            Point2D[] i = this.get_intersection(ic1, ic2);
            Point2D i1 = i[0];
            Point2D i2 = i[1];
            if (i1 == null) {
                return new Circle[]{null, null};
            }
            double i1_x = i1.getX();
            double i1_y = i1.getY();
            Circle candidate1 = null;
            candidate1 = new Circle(i1_x, i1_y, radius);
            if (i2 == null) {
                return new Circle[]{candidate1, null};
            }
            double i2_x = i2.getX();
            double i2_y = i2.getY();
            Circle candidate2 = null;
            candidate2 = new Circle(i2_x, i2_y, radius);
            return new Circle[]{candidate1, candidate2};
        }

        private final Point2D[] get_intersection(Circle circle1, Circle circle2) {
            Point2D[] point2DArray;
            Circle circle = circle1;
            Intrinsics.checkNotNull((Object)circle);
            double x1 = circle.getCx();
            double y1 = circle1.getCy();
            double r1 = circle1.getRadius();
            Circle circle3 = circle2;
            Intrinsics.checkNotNull((Object)circle3);
            double x2 = circle3.getCx();
            double y2 = circle2.getCy();
            double r2 = circle2.getRadius();
            double dx = x2 - x1;
            double dy = y2 - y1;
            double d = dx * dx + dy * dy;
            boolean bl = false;
            double d2 = Math.sqrt(d);
            if (d2 > r1 + r2) {
                String string = "no solution, the circles are separate: " + circle1 + ", " + circle2;
                boolean bl2 = false;
                System.out.println((Object)string);
                return new Point2D[]{null, null};
            }
            d = r1 - r2;
            bl = false;
            if (d2 < Math.abs(d)) {
                String string = "no solution, circles contained within each other: " + circle1 + ", " + circle2;
                boolean bl3 = false;
                System.out.println((Object)string);
                return new Point2D[]{null, null};
            }
            if (d2 == 0.0 && r1 == r2) {
                String string = "no solution, circles are coincident: " + circle1 + ", " + circle2;
                boolean bl4 = false;
                System.out.println((Object)string);
                return new Point2D[]{null, null};
            }
            double a = (r1 * r1 - r2 * r2 + d2 * d2) / ((double)2 * d2);
            double d3 = r1 * r1 - a * a;
            boolean bl5 = false;
            double h = Math.sqrt(d3);
            double xm = x1 + a * dx / d2;
            double ym = y1 + a * dy / d2;
            double xs1 = xm + h * dy / d2;
            double xs2 = xm - h * dy / d2;
            double ys1 = ym - h * dx / d2;
            double ys2 = ym + h * dx / d2;
            if (xs1 == xs2 && ys1 == ys2) {
                Point2D[] point2DArray2 = new Point2D[2];
                point2DArray2[0] = (Point2D)new Point2D.Double(xs1, ys1);
                point2DArray = point2DArray2;
                point2DArray2[1] = null;
            } else {
                Point2D[] point2DArray3 = new Point2D[2];
                point2DArray3[0] = (Point2D)new Point2D.Double(xs1, ys1);
                point2DArray = point2DArray3;
                point2DArray3[1] = (Point2D)new Point2D.Double(xs2, ys2);
            }
            return point2DArray;
        }

        private final double innerSoddyRadius(double ra, double rb, double rc) {
            double d = (double)4 * ra * rb * rc * (ra + rb + rc);
            boolean bl = false;
            return ra * rb * rc / (ra * rc + ra * rb + rb * rc + Math.sqrt(d));
        }

        private final Circle outerSoddyCircle(Circle circleA, Circle circleB, Circle circleC) {
            double ra = circleA.getRadius();
            double rb = circleB.getRadius();
            double rc = circleC.getRadius();
            double k1 = 0.0;
            double k2 = 0.0;
            double k3 = 0.0;
            double k4 = 0.0;
            k1 = 1.0 / ra;
            k2 = 1.0 / rb;
            k3 = 1.0 / rc;
            double d = k1 * k2 + k2 * k3 + k3 * k1;
            boolean bl = false;
            d = k1 + k2 + k3 - (double)2 * Math.sqrt(d);
            bl = false;
            k4 = Math.abs(d);
            Complex q1 = null;
            Complex q2 = null;
            Complex q3 = null;
            Complex q4 = null;
            q1 = new Complex(k1, 0.0).mul(new Complex(circleA.getCx(), circleA.getCy()));
            q2 = new Complex(k2, 0.0).mul(new Complex(circleB.getCx(), circleB.getCy()));
            q3 = new Complex(k3, 0.0).mul(new Complex(circleC.getCx(), circleC.getCy()));
            q4 = q1.add(q2).add(q3).sub(new Complex(2.0, 0.0).mul(q1.mul(q2).add(q2.mul(q3)).add(q3.mul(q1)).sqrt()));
            Complex z = q4.div(new Complex(k4, 0.0));
            return z.isNaN() || MathKt.isNaN((double)(1.0 / k4)) ? new Circle() : new Circle(-z.real(), -z.img(), 1.0 / k4);
        }

        private final Circle boundingCircle(ArrayList<Circle> circles) {
            double dist;
            double d;
            Circle outerSoddy = null;
            if (circles.size() >= 3) {
                Circle circle = circles.get(0);
                Intrinsics.checkNotNullExpressionValue((Object)circle, (String)"circles.get(0)");
                Circle circle2 = circles.get(1);
                Intrinsics.checkNotNullExpressionValue((Object)circle2, (String)"circles.get(1)");
                Circle circle3 = circles.get(2);
                Intrinsics.checkNotNullExpressionValue((Object)circle3, (String)"circles.get(2)");
                outerSoddy = this.outerSoddyCircle(circle, circle2, circle3);
                for (Circle c : circles) {
                    d = (outerSoddy.getCx() - c.getCx()) * (outerSoddy.getCx() - c.getCx()) + (outerSoddy.getCy() - c.getCy()) * (outerSoddy.getCy() - c.getCy());
                    boolean bl = false;
                    dist = Math.sqrt(d);
                    d = outerSoddy.getRadius();
                    double d2 = dist + c.getRadius();
                    boolean bl2 = false;
                    outerSoddy.setRadius(Math.max(d, d2));
                }
            }
            Rectangle2D.Double bbox = this.boundingBox(circles);
            dist = bbox.getWidth();
            d = bbox.getHeight();
            boolean bl = false;
            Circle bc = new Circle(bbox.getCenterX(), bbox.getCenterY(), Math.max(dist, d) / (double)2);
            for (Circle c : circles) {
                double d3 = (bc.getCx() - c.getCx()) * (bc.getCx() - c.getCx()) + (bc.getCy() - c.getCy()) * (bc.getCy() - c.getCy());
                boolean bl3 = false;
                double dist2 = Math.sqrt(d3);
                d3 = bc.getRadius();
                double d4 = dist2 + c.getRadius();
                boolean bl4 = false;
                bc.setRadius(Math.max(d3, d4));
            }
            return outerSoddy == null || bc.getRadius() < outerSoddy.getRadius() ? bc : outerSoddy;
        }

        private final Rectangle2D.Double boundingBox(ArrayList<Circle> circles) {
            double minx = Double.MAX_VALUE;
            double maxx = Double.MIN_VALUE;
            double miny = Double.MAX_VALUE;
            double maxy = Double.MIN_VALUE;
            for (Circle c : circles) {
                double d = c.getCx() - c.getRadius();
                boolean bl = false;
                minx = Math.min(minx, d);
                d = c.getCx() + c.getRadius();
                bl = false;
                maxx = Math.max(maxx, d);
                d = c.getCy() - c.getRadius();
                bl = false;
                miny = Math.min(miny, d);
                d = c.getCy() + c.getRadius();
                bl = false;
                maxy = Math.max(maxy, d);
            }
            return new Rectangle2D.Double(minx, miny, maxx - minx, maxy - miny);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

