/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.treemap.SurroundLabeling;
import com.treemap.TreeMapModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.CPColor;
import org.mkui.labeling.EnhancedLabel;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JC\u0010\u0003\u001a\u0004\u0018\u00010\u0004\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u0006\"\u0004\b\u0002\u0010\u00072\u0006\u0010\b\u001a\u0002H\u00052\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\nH\u0014\u00a2\u0006\u0002\u0010\u000bJC\u0010\f\u001a\u0004\u0018\u00010\u0004\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u0006\"\u0004\b\u0002\u0010\u00072\u0006\u0010\b\u001a\u0002H\u00052\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\nH\u0014\u00a2\u0006\u0002\u0010\u000bJC\u0010\r\u001a\u0004\u0018\u00010\u0004\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u0006\"\u0004\b\u0002\u0010\u00072\u0006\u0010\b\u001a\u0002H\u00052\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\nH\u0014\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/treemap/ColoredSurroundLabeling;", "Lcom/treemap/SurroundLabeling;", "()V", "getBackgroundColor", "Lorg/mkui/color/CPColor;", "N", "Row", "Column", "node", "model", "Lcom/treemap/TreeMapModel;", "(Ljava/lang/Object;Lcom/treemap/TreeMapModel;)Lorg/mkui/color/CPColor;", "getEffectColor", "getForegroundColor", "toString", "", "treemap"})
public final class ColoredSurroundLabeling
extends SurroundLabeling {
    @Override
    @Nullable
    protected <N, Row, Column> CPColor getForegroundColor(N node, @NotNull TreeMapModel<N, Row, Column> model) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        CPColor foreground = model.getSettings().getColumnSettings(model.getGroupByColumn(node)).getHeaderForeground();
        CPColor background = this.getBackgroundColor(node, model);
        if (background != null) {
            EnhancedLabel.ContrastEnhancement contrastEnhancement = model.getSettings().getColumnSettings(model.getGroupByColumn(node)).getLabelingContrastEnhancement();
            Intrinsics.checkNotNull((Object)contrastEnhancement);
            CPColor cPColor = foreground;
            Intrinsics.checkNotNull((Object)cPColor);
            foreground = contrastEnhancement.adjustLabelColor(cPColor, background);
        }
        return foreground;
    }

    @Override
    @Nullable
    protected <N, Row, Column> CPColor getEffectColor(N node, @NotNull TreeMapModel<N, Row, Column> model) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        return model.getSettings().getColumnSettings(model.getGroupByColumn(node)).getHeaderEffectColor();
    }

    @Override
    @Nullable
    protected <N, Row, Column> CPColor getBackgroundColor(N node, @NotNull TreeMapModel<N, Row, Column> model) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        return model.getColor(node);
    }

    @Override
    @NotNull
    public String toString() {
        return "Surround (Colored)";
    }
}

