/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.treemap.TreeMapModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.CPColor;
import org.mkui.graphics.CPImage;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BK\b\u0016\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bBW\b\u0016\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0000\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\rJF\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0012\u0010\u0002\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005JN\u0010\u0015\u001a\u00020\u00162\u0014\u0010\u0002\u001a\u0010\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/treemap/Cushion;", "", "model", "Lcom/treemap/TreeMapModel;", "left", "", "right", "width", "top", "bottom", "height", "(Lcom/treemap/TreeMapModel;IIIIII)V", "master", "(Lcom/treemap/Cushion;Lcom/treemap/TreeMapModel;IIIIII)V", "_surface", "", "computeColor", "Lorg/mkui/color/CPColor;", "color", "x", "y", "fillRaster", "", "raster", "Lorg/mkui/graphics/CPImage;", "treemap"})
public final class Cushion {
    private final double[] _surface;

    /*
     * WARNING - void declaration
     */
    public final void fillRaster(@Nullable TreeMapModel<?, ?, ?> model, @Nullable CPColor color, int x, int y, int width, int height, @NotNull CPImage raster) {
        Intrinsics.checkNotNullParameter((Object)raster, (String)"raster");
        if (color != null) {
            int bottom = y + height;
            int right = x + width;
            byte by = color.getRed-w2LRezQ();
            boolean bl = false;
            byte by2 = by;
            boolean bl2 = false;
            double colR = by2 & 0xFF;
            by2 = color.getGreen-w2LRezQ();
            bl2 = false;
            byte by3 = by2;
            boolean bl3 = false;
            double colG = by3 & 0xFF;
            by3 = color.getBlue-w2LRezQ();
            bl3 = false;
            byte by4 = by3;
            boolean bl4 = false;
            double colB = by4 & 0xFF;
            TreeMapModel<?, ?, ?> treeMapModel = model;
            Intrinsics.checkNotNull(treeMapModel);
            double ia = treeMapModel.getSettings().getLightSourceAmbient();
            double is = 1.0 - model.getSettings().getLightSourceAmbient();
            double lx = model.getNormalizedLightSourceX();
            double ly = model.getNormalizedLightSourceY();
            double lz = model.getNormalizedLightSourceZ();
            double s0 = (double)2 * this._surface[0];
            double s1 = (double)2 * this._surface[1];
            double s2 = this._surface[2];
            double s3 = this._surface[3];
            if (!raster.isOneSamplePerArrayElement()) {
                int base = 0;
                int[] data = new int[width * height];
                int n = y;
                int n2 = bottom;
                while (n < n2) {
                    void iy;
                    double ny = -(s1 * ((double)iy + 0.5) + s3);
                    int n3 = x;
                    int n4 = right;
                    while (n3 < n4) {
                        void ix;
                        double nx = -(s0 * ((double)ix + 0.5) + s2);
                        double d = 1.0;
                        double d2 = nx * nx + ny * ny + 1.0;
                        boolean bl5 = false;
                        d2 = (nx * lx + ny * ly + lz) / Math.sqrt(d2);
                        bl5 = false;
                        double cosa = Math.min(d, d2);
                        d2 = 1.0;
                        double d3 = 0.0;
                        double d4 = is * cosa + ia;
                        boolean bl6 = false;
                        d3 = Math.max(d3, d4);
                        byte by5 = 0;
                        double pixel = Math.min(d2, d3);
                        int red = (int)(colR * pixel);
                        int green = (int)(colG * pixel);
                        int blue32 = (int)(colB * pixel);
                        by5 = color.getAlpha-w2LRezQ();
                        boolean bl7 = false;
                        int alpha = by5 & 0xFF;
                        data[base] = (alpha << 24) + (red << 16) + (green << 8) + blue32;
                        ++base;
                        ++ix;
                    }
                    ++iy;
                }
                raster.setPixels(0, 0, width, height, data);
            } else {
                int base = 0;
                int[] data = new int[width * height << 2];
                int n = bottom;
                for (int iy = y; iy < n; ++iy) {
                    double ny = -(s1 * ((double)iy + 0.5) + s3);
                    int n5 = right;
                    for (int ix = x; ix < n5; ++ix) {
                        double nx = -(s0 * ((double)ix + 0.5) + s2);
                        double pixel = 1.0;
                        double red = nx * nx + ny * ny + 1.0;
                        int blue32 = 0;
                        red = (nx * lx + ny * ly + lz) / Math.sqrt(red);
                        blue32 = 0;
                        double cosa = Math.min(pixel, red);
                        red = 1.0;
                        double blue32 = 0.0;
                        double d = is * cosa + ia;
                        boolean bl8 = false;
                        blue32 = Math.max(blue32, d);
                        byte by6 = 0;
                        pixel = Math.min(red, blue32);
                        int red2 = (int)(colR * pixel);
                        int green = (int)(colG * pixel);
                        blue32 = (int)(colB * pixel);
                        by6 = color.getAlpha-w2LRezQ();
                        boolean bl9 = false;
                        int alpha = by6 & 0xFF;
                        data[base++] = red2;
                        data[base++] = green;
                        data[base++] = blue32;
                        data[base++] = alpha;
                    }
                }
                raster.setPixels(0, 0, width, height, data);
            }
        }
    }

    @Nullable
    public final CPColor computeColor(@NotNull TreeMapModel<?, ?, ?> model, @Nullable CPColor color, int x, int y, int width, int height) {
        CPColor cPColor;
        Intrinsics.checkNotNullParameter(model, (String)"model");
        if (color != null) {
            int bottom = y + height;
            int right = x + width;
            byte by = color.getRed-w2LRezQ();
            boolean bl = false;
            byte by2 = by;
            boolean bl2 = false;
            double colR = by2 & 0xFF;
            by2 = color.getGreen-w2LRezQ();
            bl2 = false;
            byte by3 = by2;
            boolean bl3 = false;
            double colG = by3 & 0xFF;
            by3 = color.getBlue-w2LRezQ();
            bl3 = false;
            byte by4 = by3;
            boolean bl4 = false;
            double colB = by4 & 0xFF;
            double ia = model.getSettings().getLightSourceAmbient();
            double is = 1.0 - model.getSettings().getLightSourceAmbient();
            double lx = model.getNormalizedLightSourceX();
            double ly = model.getNormalizedLightSourceY();
            double lz = model.getNormalizedLightSourceZ();
            double s0 = (double)2 * this._surface[0];
            double s1 = (double)2 * this._surface[1];
            double s2 = this._surface[2];
            double s3 = this._surface[3];
            int iy = (y + bottom) / 2;
            int ix = (x + right) / 2;
            double nx = -(s0 * ((double)ix + 0.5) + s2);
            double ny = -(s1 * ((double)iy + 0.5) + s3);
            double d = 1.0;
            double d2 = nx * nx + ny * ny + 1.0;
            boolean bl5 = false;
            d2 = (nx * lx + ny * ly + lz) / Math.sqrt(d2);
            bl5 = false;
            double cosa = Math.min(d, d2);
            d2 = 1.0;
            double d3 = 0.0;
            double d4 = is * cosa + ia;
            boolean bl6 = false;
            d3 = Math.max(d3, d4);
            boolean bl7 = false;
            double pixel = Math.min(d2, d3);
            int red = (int)(colR * pixel);
            int green = (int)(colG * pixel);
            int blue = (int)(colB * pixel);
            cPColor = new CPColor(red, green, blue);
        } else {
            cPColor = null;
        }
        return cPColor;
    }

    public Cushion(@NotNull TreeMapModel<?, ?, ?> model, int left, int right, int width, int top, int bottom, int height) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        this._surface = new double[4];
        double h4 = (double)4 * model.getSettings().getLightSourceHeight();
        double wf = 0.0;
        wf = width <= 0 ? 0.0 : h4 / (double)width;
        this._surface[2] = wf * (double)(right + left);
        this._surface[0] = -wf;
        double hf = 0.0;
        hf = height <= 0 ? 0.0 : h4 / (double)height;
        this._surface[3] = hf * (double)(bottom + top);
        this._surface[1] = -hf;
    }

    public Cushion(@Nullable Cushion master, @Nullable TreeMapModel<?, ?, ?> model, int left, int right, int width, int top, int bottom, int height) {
        this._surface = new double[4];
        if (master != null) {
            double d = 4;
            TreeMapModel<?, ?, ?> treeMapModel = model;
            Intrinsics.checkNotNull(treeMapModel);
            double h4 = d * treeMapModel.getSettings().getLightSourceHeight();
            double wf = 0.0;
            wf = width <= 0 ? 0.0 : h4 / (double)width;
            this._surface[2] = master._surface[2] + wf * (double)(right + left);
            this._surface[0] = master._surface[0] - wf;
            double hf = 0.0;
            hf = height <= 0 ? 0.0 : h4 / (double)height;
            this._surface[3] = master._surface[3] + hf * (double)(bottom + top);
            this._surface[1] = master._surface[1] - hf;
        }
    }
}

