/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.treemap.AbstractRendering;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.TGraphics;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.color.CPColor;
import org.mkui.color.CPColorKt;
import org.mkui.font.CPFont;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;
import org.mkui.geom.TextShape;
import org.mkui.graphics.CPImage;
import org.mkui.graphics.IGraphics;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Ja\u0010\u0005\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u0007\"\u0004\b\u0001\u0010\b\"\u0004\b\u0002\u0010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t0\r2\u0006\u0010\u000e\u001a\u0002H\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015JT\u0010\u0016\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u0007\"\u0004\b\u0001\u0010\b\"\u0004\b\u0002\u0010\t2\u0006\u0010\u0017\u001a\u00020\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t0\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002Ja\u0010\u001a\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u0007\"\u0004\b\u0001\u0010\b\"\u0004\b\u0002\u0010\t2\u0006\u0010\u0017\u001a\u00020\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t0\r2\u0006\u0010\u000e\u001a\u0002H\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/treemap/CushionRendering;", "Lcom/treemap/AbstractRendering;", "()V", "drawBorder", "", "paintBorder", "", "N", "Row", "Column", "g2", "Lcom/treemap/crossplatform/TGraphics;", "view", "Lcom/treemap/TreeMapView;", "node", "pass", "", "bounds", "Lorg/mkui/geom/Rectangle;", "shape", "Lorg/mkui/geom/Shape;", "(Lcom/treemap/crossplatform/TGraphics;Lcom/treemap/TreeMapView;Ljava/lang/Object;ILorg/mkui/geom/Rectangle;Lorg/mkui/geom/Shape;)V", "paintCushion", "g", "image", "Lorg/mkui/graphics/CPImage;", "paintNode", "(Lcom/treemap/crossplatform/TGraphics;Lcom/treemap/TreeMapView;Ljava/lang/Object;ILorg/mkui/geom/Rectangle;Lorg/mkui/geom/Shape;)Z", "toString", "", "treemap"})
public final class CushionRendering
extends AbstractRendering {
    private final boolean drawBorder;

    @Override
    public <N, Row, Column> boolean paintNode(@NotNull TGraphics g, @NotNull TreeMapView<N, Row, Column> view, N node, int pass, @NotNull Rectangle bounds, @NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        boolean completed = true;
        TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
        Intrinsics.checkNotNull(treeMapModel);
        TreeMapModel<N, Row, Column> model = treeMapModel;
        switch (pass) {
            case 0: {
                if (!model.getFilter().isFiltered(node) && !model.getSearch().isFiltered(node)) {
                    CPColor color;
                    CPImage cPImage;
                    boolean cushionEnabled;
                    if (shape instanceof TextShape) {
                        CPColor color2;
                        TextShape textShape = (TextShape)shape;
                        CPColor cushionColor = model.getCushionColor(node);
                        CPColor cPColor = color2 = cushionColor != null ? cushionColor : model.getColor(node);
                        if (color2 == null) break;
                        g.setFill(color2);
                        if (textShape.isTextOutline()) {
                            g.fill(shape);
                            break;
                        }
                        CPFont cPFont = textShape.getFont();
                        Intrinsics.checkNotNull((Object)cPFont);
                        g.setFont(cPFont);
                        Rectangle2D bounds2D = textShape.getBounds2D();
                        g.fillText(textShape.getText(), (float)bounds2D.getX(), (float)bounds2D.getMaxY());
                        break;
                    }
                    CPImage image = null;
                    boolean bl = cushionEnabled = shape instanceof Rectangle2D && bounds.getWidth() > (double)4 && bounds.getHeight() > (double)4 || !(shape instanceof Rectangle2D) && bounds.getWidth() > (double)6 && bounds.getHeight() > (double)6;
                    if (cushionEnabled) {
                        CPImage color2;
                        try {
                            color2 = model.getCushionImage(node);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                            color2 = null;
                        }
                        cPImage = color2;
                    } else {
                        cPImage = image = null;
                    }
                    if (image != null) {
                        completed = this.paintCushion(g, view, image, bounds, shape);
                        break;
                    }
                    CPColor cushionColor = model.getCushionColor(node);
                    CPColor cPColor = color = cushionColor != null ? cushionColor : model.getColor(node);
                    if (color == null) break;
                    g.setFill(color);
                    g.fill(shape);
                    break;
                }
                CPColor color = view.getBackground();
                if (color == null) break;
                g.setFill(color);
                g.fill(shape);
                break;
            }
            case 1: {
                CPImage cPImage;
                boolean cushionEnabled;
                if (!(shape instanceof Rectangle2D) || model.getFilter().isFiltered(node) || model.getSearch().isFiltered(node)) break;
                Rectangle2D bottom = (Rectangle2D)shape;
                Shape shape2 = this.getRenderedShape(view, model, node, shape);
                if (shape2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.mkui.geom.Rectangle2D");
                }
                Rectangle2D top = (Rectangle2D)shape2;
                CPImage image = null;
                boolean bl = cushionEnabled = shape instanceof Rectangle2D && bounds.getWidth() > (double)4 && bounds.getHeight() > (double)4 || !(shape instanceof Rectangle2D) && bounds.getWidth() > (double)6 && bounds.getHeight() > (double)6;
                if (cushionEnabled) {
                    CPImage cPImage2;
                    try {
                        cPImage2 = model.getCushionImage(node);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        cPImage2 = null;
                    }
                    cPImage = cPImage2;
                } else {
                    cPImage = image = null;
                }
                if (image != null) {
                    Rectangle2D b = top.getBounds2D();
                    completed = this.paintCushion(g, view, image, new Rectangle((int)b.getX(), (int)b.getY(), (int)b.getWidth(), (int)b.getHeight()), (Shape)top);
                } else {
                    CPColor cushionColor = model.getCushionColor(node);
                    g.setFill(cushionColor != null ? cushionColor : model.getColor(node));
                    g.fill(shape);
                }
                CPColor cPColor = model.getColor(node);
                Intrinsics.checkNotNull((Object)cPColor);
                CPColor color = cPColor;
                IGraphics g2 = g.getIGraphics();
                g2.beginPath();
                g2.moveTo(top.getMinX(), top.getMaxY());
                g2.lineTo(bottom.getX(), bottom.getMaxY());
                g2.lineTo(bottom.getMaxX(), bottom.getMaxY());
                g2.lineTo(top.getMaxX(), top.getMaxY());
                g2.closePath();
                g2.setColor(CPColorKt.darker((CPColor)color));
                g2.fill();
                g2.beginPath();
                g2.moveTo(top.getMaxX(), top.getMaxY());
                g2.lineTo(bottom.getMaxX(), bottom.getMaxY());
                g2.lineTo(bottom.getMaxX(), bottom.getMinY());
                g2.lineTo(top.getMaxX(), top.getMinY());
                g2.closePath();
                g2.setColor(CPColorKt.darker((CPColor)color));
                g2.fill();
                if (!this.drawBorder) break;
                g.setStroke(g.getColorFactory().getDarkGray());
                g.strokeRect(top.getX(), top.getY(), top.getWidth(), top.getHeight());
                g.strokeLine((int)top.getMinX(), (int)top.getMaxY(), (int)bottom.getX(), (int)bottom.getMaxY());
                g.strokeLine((int)top.getMaxX(), (int)top.getMaxY(), (int)bottom.getMaxX(), (int)bottom.getMaxY());
                g.strokeLine((int)top.getMaxX(), (int)top.getMinY(), (int)bottom.getMaxX(), (int)bottom.getMinY());
                break;
            }
        }
        return completed;
    }

    private final <N, Row, Column> boolean paintCushion(TGraphics g, TreeMapView<N, Row, Column> view, CPImage image, Rectangle bounds, Shape shape) {
        boolean completed = true;
        if (shape instanceof Rectangle2D) {
            if (bounds.getWidth() > (double)image.getWidth() || bounds.getHeight() > (double)image.getHeight()) {
                boolean bilinear = g.isInterpolationBilinear();
                g.setInterpolationBilinear(true);
                completed = g.drawImage(image, bounds.getIx(), bounds.getIy(), bounds.getIwidth(), bounds.getIheight());
                g.setInterpolationBilinear(bilinear);
            } else {
                completed = g.drawImage(image, bounds.getIx(), bounds.getIy(), bounds.getIwidth(), bounds.getIheight());
            }
        } else {
            int n = bounds.getIwidth();
            int n2 = view.getSize().getIwidth();
            int n3 = 0;
            int width = Math.min(n, n2);
            n2 = bounds.getIheight();
            n3 = view.getSize().getIheight();
            boolean bl = false;
            int height = Math.min(n2, n3);
            if (bounds.getWidth() > (double)image.getWidth() || bounds.getHeight() > (double)image.getHeight()) {
                boolean bilinear = g.isInterpolationBilinear();
                g.setInterpolationBilinear(true);
                completed = g.drawClippedImage(image, bounds.getIx(), bounds.getIy(), bounds.getIwidth(), bounds.getIheight(), width, height, bounds, shape);
                g.setInterpolationBilinear(bilinear);
            } else {
                completed = g.drawClippedImage(image, bounds.getIx(), bounds.getIy(), bounds.getIwidth(), bounds.getIheight(), width, height, bounds, shape);
            }
        }
        return completed;
    }

    @Override
    public <N, Row, Column> void paintBorder(@NotNull TGraphics g2, @NotNull TreeMapView<N, Row, Column> view, N node, int pass, @NotNull Rectangle bounds, @NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
    }

    @NotNull
    public String toString() {
        return "Cushion";
    }
}

