/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.treemap.Depth;
import com.treemap.InfiniteDepth;
import com.treemap.ThresholdDepth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001b\b\u0002\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\u0013\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0086\u0002R\u0011\u0010\u0006\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/treemap/DepthFactory;", "", "entries", "", "Lcom/treemap/Depth;", "([Lcom/treemap/Depth;)V", "default", "getDefault", "()Lcom/treemap/Depth;", "depths", "", "getDepths", "()Ljava/util/List;", "", "add", "", "entry", "get", "name", "", "Companion", "treemap"})
public final class DepthFactory {
    private final List<Depth> entries = new ArrayList();
    @NotNull
    private static final Depth INFINITE;
    @NotNull
    private static final Depth ONE;
    @NotNull
    private static final Depth TWO;
    private static final Depth THREE;
    private static final Depth FOUR;
    private static final Depth FIVE;
    private static final Depth SIX;
    private static final Depth SEVEN;
    private static final Depth EIGHT;
    private static final Depth NINE;
    @NotNull
    private static final DepthFactory instance;
    @NotNull
    public static final Companion Companion;

    public final void add(@NotNull Depth entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.entries.add(entry);
    }

    @NotNull
    public final Depth getDefault() {
        return INFINITE;
    }

    @NotNull
    public final List<Depth> getDepths() {
        return this.entries;
    }

    @NotNull
    public final Depth get(@Nullable String name) {
        for (Depth depth : this.entries) {
            if (!depth.toString().equals(name)) continue;
            return depth;
        }
        return this.getDefault();
    }

    private DepthFactory(Depth ... entries) {
        CollectionsKt.addAll((Collection)this.entries, (Object[])entries);
    }

    static {
        Companion = new Companion(null);
        INFINITE = new InfiniteDepth();
        ONE = new ThresholdDepth(1);
        TWO = new ThresholdDepth(2);
        THREE = new ThresholdDepth(3);
        FOUR = new ThresholdDepth(4);
        FIVE = new ThresholdDepth(5);
        SIX = new ThresholdDepth(6);
        SEVEN = new ThresholdDepth(7);
        EIGHT = new ThresholdDepth(8);
        NINE = new ThresholdDepth(9);
        instance = new DepthFactory(INFINITE, ONE, TWO, THREE, FOUR, FIVE, SIX, SEVEN, EIGHT, NINE);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/treemap/DepthFactory$Companion;", "", "()V", "EIGHT", "Lcom/treemap/Depth;", "FIVE", "FOUR", "INFINITE", "getINFINITE", "()Lcom/treemap/Depth;", "NINE", "ONE", "getONE", "SEVEN", "SIX", "THREE", "TWO", "getTWO", "instance", "Lcom/treemap/DepthFactory;", "getInstance", "()Lcom/treemap/DepthFactory;", "treemap"})
    public static final class Companion {
        @NotNull
        public final Depth getINFINITE() {
            return INFINITE;
        }

        @NotNull
        public final Depth getONE() {
            return ONE;
        }

        @NotNull
        public final Depth getTWO() {
            return TWO;
        }

        @NotNull
        public final DepthFactory getInstance() {
            return instance;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

