/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.treemap.ColorOrdering;
import com.treemap.HeightOrdering;
import com.treemap.Ordering;
import com.treemap.OriginalOrdering;
import com.treemap.SizeOrdering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001b\b\u0002\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u0013\u0010\n\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0086\u0002J\u0006\u0010\r\u001a\u00020\u0004J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/treemap/OrderingFactory;", "", "entries", "", "Lcom/treemap/Ordering;", "([Lcom/treemap/Ordering;)V", "", "add", "", "entry", "get", "name", "", "getDefault", "getOrderings", "", "Companion", "treemap"})
public final class OrderingFactory {
    private final List<Ordering> entries = new ArrayList();
    @NotNull
    private static final Ordering SIZE;
    @NotNull
    private static final Ordering ORIGINAL;
    @NotNull
    private static final Ordering COLOR;
    @NotNull
    private static final Ordering HEIGHT;
    private static final OrderingFactory ourInstance;
    @NotNull
    public static final Companion Companion;

    public final void add(@NotNull Ordering entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.entries.add(entry);
    }

    @NotNull
    public final Ordering getDefault() {
        return SIZE;
    }

    @NotNull
    public final List<Ordering> getOrderings() {
        return this.entries;
    }

    @NotNull
    public final Ordering get(@Nullable String name) {
        for (Ordering ordering : this.entries) {
            if (!ordering.toString().equals(name)) continue;
            return ordering;
        }
        return this.getDefault();
    }

    private OrderingFactory(Ordering ... entries) {
        CollectionsKt.addAll((Collection)this.entries, (Object[])entries);
    }

    static {
        Companion = new Companion(null);
        SIZE = new SizeOrdering();
        ORIGINAL = new OriginalOrdering();
        COLOR = new ColorOrdering();
        HEIGHT = new HeightOrdering();
        ourInstance = new OrderingFactory(ORIGINAL, SIZE, COLOR, HEIGHT);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000f\u001a\u00020\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/treemap/OrderingFactory$Companion;", "", "()V", "COLOR", "Lcom/treemap/Ordering;", "getCOLOR", "()Lcom/treemap/Ordering;", "HEIGHT", "getHEIGHT", "ORIGINAL", "getORIGINAL", "SIZE", "getSIZE", "ourInstance", "Lcom/treemap/OrderingFactory;", "getInstance", "treemap"})
    public static final class Companion {
        @NotNull
        public final Ordering getSIZE() {
            return SIZE;
        }

        @NotNull
        public final Ordering getORIGINAL() {
            return ORIGINAL;
        }

        @NotNull
        public final Ordering getCOLOR() {
            return COLOR;
        }

        @NotNull
        public final Ordering getHEIGHT() {
            return HEIGHT;
        }

        @NotNull
        public final OrderingFactory getInstance() {
            return ourInstance;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

