/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.treemap.CushionRendering;
import com.treemap.FlatNoBorderRendering;
import com.treemap.FlatRendering;
import com.treemap.Rendering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001b\b\u0002\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u0013\u0010\n\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0086\u0002J\u0006\u0010\r\u001a\u00020\u0004J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/treemap/RenderingFactory;", "", "entries", "", "Lcom/treemap/Rendering;", "([Lcom/treemap/Rendering;)V", "", "add", "", "entry", "get", "name", "", "getDefault", "getRenderings", "", "Companion", "treemap"})
public final class RenderingFactory {
    private final List<Rendering> entries = new ArrayList();
    @NotNull
    private static final Rendering CUSHION;
    @NotNull
    private static final Rendering FLAT;
    @NotNull
    private static final Rendering FLAT_NO_BORDER;
    private static final RenderingFactory ourInstance;
    @NotNull
    public static final Companion Companion;

    public final void add(@NotNull Rendering entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.entries.add(entry);
    }

    @NotNull
    public final Rendering getDefault() {
        return CUSHION;
    }

    @NotNull
    public final List<Rendering> getRenderings() {
        return this.entries;
    }

    @NotNull
    public final Rendering get(@Nullable String name) {
        for (Rendering rendering : this.entries) {
            if (!rendering.toString().equals(name)) continue;
            return rendering;
        }
        return this.getDefault();
    }

    private RenderingFactory(Rendering ... entries) {
        CollectionsKt.addAll((Collection)this.entries, (Object[])entries);
    }

    static {
        Companion = new Companion(null);
        CUSHION = new CushionRendering();
        FLAT = new FlatRendering();
        FLAT_NO_BORDER = new FlatNoBorderRendering();
        ourInstance = new RenderingFactory(FLAT, CUSHION, FLAT_NO_BORDER);
    }

    @NotNull
    public static final Rendering getCUSHION() {
        Companion companion = Companion;
        return CUSHION;
    }

    @NotNull
    public static final Rendering getFLAT() {
        Companion companion = Companion;
        return FLAT;
    }

    @NotNull
    public static final Rendering getFLAT_NO_BORDER() {
        Companion companion = Companion;
        return FLAT_NO_BORDER;
    }

    @JvmStatic
    @NotNull
    public static final RenderingFactory getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0007R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u0007R\u001c\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u0007R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/treemap/RenderingFactory$Companion;", "", "()V", "CUSHION", "Lcom/treemap/Rendering;", "getCUSHION$annotations", "getCUSHION", "()Lcom/treemap/Rendering;", "FLAT", "getFLAT$annotations", "getFLAT", "FLAT_NO_BORDER", "getFLAT_NO_BORDER$annotations", "getFLAT_NO_BORDER", "ourInstance", "Lcom/treemap/RenderingFactory;", "getInstance", "treemap"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getCUSHION$annotations() {
        }

        @NotNull
        public final Rendering getCUSHION() {
            return CUSHION;
        }

        @JvmStatic
        public static /* synthetic */ void getFLAT$annotations() {
        }

        @NotNull
        public final Rendering getFLAT() {
            return FLAT;
        }

        @JvmStatic
        public static /* synthetic */ void getFLAT_NO_BORDER$annotations() {
        }

        @NotNull
        public final Rendering getFLAT_NO_BORDER() {
            return FLAT_NO_BORDER;
        }

        @JvmStatic
        @NotNull
        public final RenderingFactory getInstance() {
            return ourInstance;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

