/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.treemap.AbsScale;
import com.treemap.Exp10Scale;
import com.treemap.ExpScale;
import com.treemap.InverseScale;
import com.treemap.Log1pScale;
import com.treemap.LogScale;
import com.treemap.MaxScale;
import com.treemap.MinScale;
import com.treemap.OriginalScale;
import com.treemap.Scale;
import com.treemap.XPlus1Scale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001b\b\u0002\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\u0013\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0086\u0002R\u0011\u0010\u0006\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/treemap/ScaleFactory;", "", "entries", "", "Lcom/treemap/Scale;", "([Lcom/treemap/Scale;)V", "default", "getDefault", "()Lcom/treemap/Scale;", "", "scales", "", "getScales", "()Ljava/util/List;", "add", "", "entry", "get", "name", "", "Companion", "treemap"})
public final class ScaleFactory {
    private final List<Scale> entries = new ArrayList();
    @NotNull
    private static final Scale ORIGINAL;
    @NotNull
    private static final Scale ABS;
    @NotNull
    private static final Scale EXP10;
    @NotNull
    private static final Scale EXP;
    @NotNull
    private static final Scale INVERSE;
    @NotNull
    private static final Scale LOG;
    @NotNull
    private static final Scale LOG1P;
    @NotNull
    private static final Scale MIN;
    @NotNull
    private static final Scale MAX;
    @NotNull
    private static final Scale XPLUS1;
    @NotNull
    private static final ScaleFactory instance;
    @NotNull
    public static final Companion Companion;

    public final void add(@NotNull Scale entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.entries.add(entry);
    }

    @NotNull
    public final Scale getDefault() {
        return ABS;
    }

    @NotNull
    public final List<Scale> getScales() {
        return this.entries;
    }

    @NotNull
    public final Scale get(@Nullable String name) {
        for (Scale scale : this.entries) {
            if (!scale.toString().equals(name)) continue;
            return scale;
        }
        return this.getDefault();
    }

    private ScaleFactory(Scale ... entries) {
        CollectionsKt.addAll((Collection)this.entries, (Object[])entries);
    }

    static {
        Companion = new Companion(null);
        ORIGINAL = new OriginalScale();
        ABS = new AbsScale();
        EXP10 = new Exp10Scale();
        EXP = new ExpScale();
        INVERSE = new InverseScale();
        LOG = new LogScale();
        LOG1P = new Log1pScale();
        MIN = new MinScale();
        MAX = new MaxScale();
        XPLUS1 = new XPlus1Scale();
        instance = new ScaleFactory(ORIGINAL, ABS, XPLUS1, EXP10, EXP, INVERSE, LOG, LOG1P, MIN, MAX);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lcom/treemap/ScaleFactory$Companion;", "", "()V", "ABS", "Lcom/treemap/Scale;", "getABS", "()Lcom/treemap/Scale;", "EXP", "getEXP", "EXP10", "getEXP10", "INVERSE", "getINVERSE", "LOG", "getLOG", "LOG1P", "getLOG1P", "MAX", "getMAX", "MIN", "getMIN", "ORIGINAL", "getORIGINAL", "XPLUS1", "getXPLUS1", "instance", "Lcom/treemap/ScaleFactory;", "getInstance", "()Lcom/treemap/ScaleFactory;", "treemap"})
    public static final class Companion {
        @NotNull
        public final Scale getORIGINAL() {
            return ORIGINAL;
        }

        @NotNull
        public final Scale getABS() {
            return ABS;
        }

        @NotNull
        public final Scale getEXP10() {
            return EXP10;
        }

        @NotNull
        public final Scale getEXP() {
            return EXP;
        }

        @NotNull
        public final Scale getINVERSE() {
            return INVERSE;
        }

        @NotNull
        public final Scale getLOG() {
            return LOG;
        }

        @NotNull
        public final Scale getLOG1P() {
            return LOG1P;
        }

        @NotNull
        public final Scale getMIN() {
            return MIN;
        }

        @NotNull
        public final Scale getMAX() {
            return MAX;
        }

        @NotNull
        public final Scale getXPLUS1() {
            return XPLUS1;
        }

        @NotNull
        public final ScaleFactory getInstance() {
            return instance;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

