/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.SimpleProperties;
import com.treemap.AbstractAlgorithm;
import com.treemap.TreeMapAccessor;
import com.treemap.TreeMapWorker;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 -2\u00020\u0001:\u0001-B\u0005\u00a2\u0006\u0002\u0010\u0002JQ\u0010\u000b\u001a\u00020\u0005\"\u0004\b\u0000\u0010\f2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\f0\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\f0\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016Jm\u0010\u0017\u001a\u00020\u0018\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\u0019\"\u0004\b\u0002\u0010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u0002H\f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000e2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\f0\u00152\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016\u00a2\u0006\u0002\u0010$J\u0018\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005H\u0002J\u0012\u0010(\u001a\u00020\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010)\u001a\u00020\bH\u0016J\u0018\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006."}, d2={"Lcom/treemap/SquarifiedPlusAlgorithm;", "Lcom/treemap/AbstractAlgorithm;", "()V", "desiredAspectRatio", "Lcom/macrofocus/common/properties/MutableProperty;", "", "properties", "Lcom/macrofocus/common/properties/MutableProperties;", "", "getProperties", "()Lcom/macrofocus/common/properties/MutableProperties;", "bestAspectRatio", "N", "nodes", "", "current", "", "last", "side", "sizeFactor", "accessor", "Lcom/treemap/TreeMapAccessor;", "([Ljava/lang/Object;IIDDLcom/treemap/TreeMapAccessor;)D", "breadthFirstLayout", "", "Row", "Column", "shape", "Lorg/mkui/geom/Shape;", "parent", "children", "sumSize", "horizontalVanishingPoint", "verticalVanishingPoint", "worker", "Lcom/treemap/TreeMapWorker;", "(Lorg/mkui/geom/Shape;Ljava/lang/Object;[Ljava/lang/Object;DIILcom/treemap/TreeMapAccessor;Lcom/treemap/TreeMapWorker;)Z", "computeAspectRatio", "area", "width", "isCompatible", "toString", "willImprove", "actualAR", "expandedAR", "Companion", "treemap"})
public final class SquarifiedPlusAlgorithm
extends AbstractAlgorithm {
    @NotNull
    private final MutableProperties<String> properties = (MutableProperties)new SimpleProperties();
    private final MutableProperty<Double> desiredAspectRatio = this.getProperties().createProperty((Object)"desiredAspectRatio", (Object)1.0);
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public MutableProperties<String> getProperties() {
        return this.properties;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <N, Row, Column> boolean breadthFirstLayout(@NotNull Shape shape, N parent, @NotNull N[] children, double sumSize, int horizontalVanishingPoint, int verticalVanishingPoint, @NotNull TreeMapAccessor<? super N> accessor, @Nullable TreeMapWorker worker) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
        Rectangle2D bounds = shape.getBounds2D();
        int hvp = horizontalVanishingPoint == 0 ? 4 : horizontalVanishingPoint;
        int vvp = verticalVanishingPoint == 0 ? 3 : verticalVanishingPoint;
        double sizeFactor = bounds.getWidth() * bounds.getHeight() / sumSize;
        int current = 0;
        while (current < children.length) {
            Rectangle2D rectangle2D;
            boolean bl;
            double d;
            double d2;
            int n;
            double longestSide;
            int last = current;
            double totalArea = 0.0;
            double previousWorstAspectRatio = Double.POSITIVE_INFINITY;
            double desiredSize = 0.0;
            boolean horizontalSplit = bounds.getWidth() > bounds.getHeight() * ((Number)this.desiredAspectRatio.getValue()).doubleValue();
            double shortestSide = horizontalSplit ? bounds.getHeight() : bounds.getWidth();
            double d3 = longestSide = horizontalSplit ? bounds.getWidth() : bounds.getHeight();
            while (last < children.length) {
                double d4;
                double lastArea = accessor.getSize(children[last]) * sizeFactor;
                desiredSize = (totalArea += lastArea) / shortestSide;
                double currentArea = accessor.getSize(children[current]) * sizeFactor;
                double lastWorstAspectRatio = this.computeAspectRatio(lastArea, desiredSize);
                double currentWorstAspectRatio = this.computeAspectRatio(currentArea, desiredSize);
                double worstAspectRatio = 0.0;
                double d5 = currentWorstAspectRatio;
                boolean bl2 = false;
                if (!Double.isInfinite(d5)) {
                    boolean bl3 = false;
                    d4 = Math.max(currentWorstAspectRatio, lastWorstAspectRatio);
                } else {
                    d4 = worstAspectRatio = lastWorstAspectRatio;
                }
                if (worstAspectRatio > previousWorstAspectRatio) {
                    double alternativeAR;
                    desiredSize = (totalArea -= lastArea) / shortestSide;
                    int n2 = last;
                    last = n2 + -1;
                    SquarifiedPlusAlgorithm squarifiedPlusAlgorithm = this;
                    boolean bl4 = false;
                    bl2 = false;
                    SquarifiedPlusAlgorithm $this$run = squarifiedPlusAlgorithm;
                    boolean bl5 = false;
                    double alternativeDesiredSize = totalArea / longestSide;
                    double actualAR = $this$run.bestAspectRatio(children, current, last, desiredSize, sizeFactor, accessor);
                    if ($this$run.willImprove(actualAR, alternativeAR = $this$run.bestAspectRatio(children, current, last, alternativeDesiredSize, sizeFactor, accessor))) {
                        desiredSize = alternativeDesiredSize;
                        horizontalSplit = !horizontalSplit;
                    }
                    break;
                }
                double d6 = worstAspectRatio;
                bl2 = false;
                if (!Double.isNaN(d6)) {
                    previousWorstAspectRatio = worstAspectRatio;
                }
                n = last;
                last = n + 1;
            }
            if (last == children.length) {
                int n3 = last;
                last = n3 + -1;
            }
            SquarifiedPlusAlgorithm squarifiedPlusAlgorithm = this;
            boolean bl6 = false;
            boolean bl7 = false;
            SquarifiedPlusAlgorithm $this$run = squarifiedPlusAlgorithm;
            boolean bl8 = false;
            double x = bounds.getX();
            double y = bounds.getY();
            int n4 = current;
            n = last;
            if (n4 <= n) {
                while (true) {
                    void i;
                    double size = accessor.getSize(children[i]) * sizeFactor / desiredSize;
                    if (horizontalSplit) {
                        switch (hvp) {
                            case 2: {
                                accessor.setShape(children[i], (Shape)new Rectangle2D.Double(x + bounds.getWidth() - desiredSize, y, desiredSize, size));
                                break;
                            }
                            case 4: {
                                accessor.setShape(children[i], (Shape)new Rectangle2D.Double(x, y, desiredSize, size));
                            }
                        }
                        y += size;
                    } else {
                        block4 : switch (vvp) {
                            case 1: {
                                switch (hvp) {
                                    case 2: {
                                        accessor.setShape(children[i], (Shape)new Rectangle2D.Double(x + bounds.getWidth() - size, y + bounds.getHeight() - desiredSize, size, desiredSize));
                                        x -= size;
                                        break block4;
                                    }
                                    case 4: {
                                        accessor.setShape(children[i], (Shape)new Rectangle2D.Double(x, y + bounds.getHeight() - desiredSize, size, desiredSize));
                                        x += size;
                                        break block4;
                                    }
                                }
                                throw (Throwable)new IllegalArgumentException();
                            }
                            case 3: {
                                switch (hvp) {
                                    case 2: {
                                        accessor.setShape(children[i], (Shape)new Rectangle2D.Double(x + bounds.getWidth() - size, y, size, desiredSize));
                                        x -= size;
                                        break block4;
                                    }
                                    case 4: {
                                        accessor.setShape(children[i], (Shape)new Rectangle2D.Double(x, y, size, desiredSize));
                                        x += size;
                                        break block4;
                                    }
                                }
                                throw (Throwable)new IllegalArgumentException();
                            }
                            default: {
                                throw (Throwable)new IllegalArgumentException();
                            }
                        }
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            current = last + 1;
            if (horizontalSplit) {
                Rectangle2D rectangle2D2;
                switch (hvp) {
                    case 2: {
                        d2 = 0.0;
                        d = bounds.getWidth() - desiredSize;
                        bl = false;
                        rectangle2D2 = (Rectangle2D)new Rectangle2D.Double(bounds.getX(), bounds.getY(), Math.max(d2, d), bounds.getHeight());
                        break;
                    }
                    case 4: {
                        d2 = 0.0;
                        d = bounds.getWidth() - desiredSize;
                        bl = false;
                        rectangle2D2 = (Rectangle2D)new Rectangle2D.Double(bounds.getX() + desiredSize, bounds.getY(), Math.max(d2, d), bounds.getHeight());
                        break;
                    }
                    default: {
                        throw (Throwable)new IllegalArgumentException();
                    }
                }
                bounds = rectangle2D2;
                if (horizontalVanishingPoint != 0) continue;
                hvp = hvp == 2 ? 4 : 2;
                continue;
            }
            switch (vvp) {
                case 1: {
                    d2 = 0.0;
                    d = bounds.getHeight() - desiredSize;
                    bl = false;
                    rectangle2D = (Rectangle2D)new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), Math.max(d2, d));
                    break;
                }
                case 3: {
                    d2 = 0.0;
                    d = bounds.getHeight() - desiredSize;
                    bl = false;
                    rectangle2D = (Rectangle2D)new Rectangle2D.Double(bounds.getX(), bounds.getY() + desiredSize, bounds.getWidth(), Math.max(d2, d));
                    break;
                }
                default: {
                    throw (Throwable)new IllegalArgumentException();
                }
            }
            bounds = rectangle2D;
            if (verticalVanishingPoint != 0) continue;
            vvp = vvp == 3 ? 1 : 3;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final <N> double bestAspectRatio(N[] nodes, int current, int last, double side, double sizeFactor, TreeMapAccessor<? super N> accessor) {
        if (nodes == null || nodes.length == 0) {
            return Double.MAX_VALUE;
        }
        double max = 0.0;
        int n = current;
        int n2 = last;
        if (n <= n2) {
            while (true) {
                void i;
                N node;
                double m;
                if ((m = this.computeAspectRatio(accessor.getSize(node = nodes[i]) * sizeFactor, side)) > max) {
                    max = m;
                }
                if (i == n2) break;
                ++i;
            }
        }
        return max;
    }

    private final double computeAspectRatio(double area, double width) {
        double aspectRatio = area / (width * width * ((Number)this.desiredAspectRatio.getValue()).doubleValue());
        if (aspectRatio < 1.0) {
            aspectRatio = 1.0 / aspectRatio;
        }
        return aspectRatio;
    }

    private final boolean willImprove(double actualAR, double expandedAR) {
        if (actualAR == 0.0) {
            return true;
        }
        if (expandedAR == 0.0) {
            return false;
        }
        double d = actualAR - ((Number)this.desiredAspectRatio.getValue()).doubleValue();
        boolean bl = false;
        double v1 = Math.abs(d);
        double d2 = expandedAR - ((Number)this.desiredAspectRatio.getValue()).doubleValue();
        boolean bl2 = false;
        double v2 = Math.abs(d2);
        return v1 > v2;
    }

    @Override
    public boolean isCompatible(@Nullable Shape shape) {
        return shape instanceof Rectangle2D;
    }

    @NotNull
    public String toString() {
        return SquarifiedPlusAlgorithm.Companion.getName();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lcom/treemap/SquarifiedPlusAlgorithm$Companion;", "", "()V", "getAspectRatio", "", "shape", "Lorg/mkui/geom/Rectangle2D;", "getName", "", "treemap"})
    public static final class Companion {
        private final String getName() {
            return "Squarified+";
        }

        private final double getAspectRatio(Rectangle2D shape) {
            return shape.getWidth() > shape.getHeight() ? shape.getWidth() / shape.getHeight() : shape.getHeight() / shape.getWidth();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

