/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.treemap.Aggregation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/treemap/StdDevAggregation;", "Lcom/treemap/Aggregation;", "()V", "aggregate", "", "values", "", "([D)Ljava/lang/Double;", "requestSizeWeightValues", "", "toString", "", "treemap"})
public final class StdDevAggregation
implements Aggregation {
    @Override
    @NotNull
    public Double aggregate(@NotNull double[] values) {
        double d;
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        int count = 0;
        double sum = 0.0;
        double[] dArray = values;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double value;
            double d2 = value = dArray[i];
            boolean bl = false;
            if (Double.isInfinite(d2)) continue;
            d2 = value;
            bl = false;
            if (Double.isNaN(d2)) continue;
            ++count;
            sum += value;
        }
        if (count < 2) {
            d = 0.0;
        } else {
            int n2;
            double average = sum / (double)count;
            double stddev = 0.0;
            double[] dArray2 = values;
            int n3 = dArray2.length;
            for (n2 = 0; n2 < n3; ++n2) {
                double value;
                double d3 = value = dArray2[n2];
                boolean bl = false;
                if (Double.isInfinite(d3)) continue;
                d3 = value;
                bl = false;
                if (Double.isNaN(d3)) continue;
                d3 = value - average;
                double d4 = 2.0;
                boolean bl2 = false;
                stddev += Math.pow(d3, d4);
            }
            double d5 = stddev / (double)count;
            n2 = 0;
            d = Math.sqrt(d5);
        }
        return d;
    }

    @Override
    public boolean requestSizeWeightValues() {
        return false;
    }

    @NotNull
    public String toString() {
        return "StdDev";
    }
}

