/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.treemap.AbstractAlgorithm;
import com.treemap.TreeMapAccessor;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapWorker;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.Ellipse2D;
import org.mkui.geom.Path2D;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00012B\u0005\u00a2\u0006\u0002\u0010\u0002Jm\u0010\u0010\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u0011\"\u0004\b\u0001\u0010\u0012\"\u0004\b\u0002\u0010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u0002H\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00110\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016\u00a2\u0006\u0002\u0010!JA\u0010\"\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u0011\"\u0004\b\u0001\u0010\u0012\"\u0004\b\u0002\u0010\u00132\u0018\u0010#\u001a\u0014\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00130$2\u0006\u0010%\u001a\u0002H\u0011H\u0002\u00a2\u0006\u0002\u0010&J\u0012\u0010'\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016JG\u0010(\u001a\b\u0012\u0004\u0012\u0002H\u00110)\"\u0004\b\u0000\u0010\u0011\"\u0004\b\u0001\u0010\u0012\"\u0004\b\u0002\u0010\u00132\u0018\u0010#\u001a\u0014\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00130$2\u0006\u0010%\u001a\u0002H\u0011H\u0016\u00a2\u0006\u0002\u0010*JU\u0010+\u001a\u00020,\"\u0004\b\u0000\u0010\u0011\"\u0004\b\u0001\u0010\u0012\"\u0004\b\u0002\u0010\u00132\b\u0010-\u001a\u0004\u0018\u00010.2\u0018\u0010#\u001a\u0014\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00130$2\u0006\u0010%\u001a\u0002H\u00112\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u000201H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0005R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0014\u0010\b\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0005R\u0014\u0010\t\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u00063"}, d2={"Lcom/treemap/SunburstAlgorithm;", "Lcom/treemap/AbstractAlgorithm;", "()V", "isChildContained", "", "()Z", "isColorParent", "isRenderingLeafLabelsSupported", "isRenderingParentLabelSupported", "isSpaceFilling", "maxDepth", "", "getMaxDepth", "()I", "setMaxDepth", "(I)V", "breadthFirstLayout", "N", "Row", "Column", "shape", "Lorg/mkui/geom/Shape;", "parent", "children", "", "sumSizes", "", "horizontalVanishingPoint", "verticalVanishingPoint", "accessor", "Lcom/treemap/TreeMapAccessor;", "worker", "Lcom/treemap/TreeMapWorker;", "(Lorg/mkui/geom/Shape;Ljava/lang/Object;[Ljava/lang/Object;DIILcom/treemap/TreeMapAccessor;Lcom/treemap/TreeMapWorker;)Z", "getMaxDepthToLeaf", "model", "Lcom/treemap/TreeMapModel;", "root", "(Lcom/treemap/TreeMapModel;Ljava/lang/Object;)I", "isCompatible", "iterator", "", "(Lcom/treemap/TreeMapModel;Ljava/lang/Object;)Ljava/lang/Iterable;", "startLayout", "", "bounds", "Lorg/mkui/geom/Rectangle2D;", "(Lorg/mkui/geom/Rectangle2D;Lcom/treemap/TreeMapModel;Ljava/lang/Object;Lcom/treemap/TreeMapWorker;)V", "toString", "", "Arc", "treemap"})
public final class SunburstAlgorithm
extends AbstractAlgorithm {
    private int maxDepth;

    public final int getMaxDepth() {
        return this.maxDepth;
    }

    public final void setMaxDepth(int n) {
        this.maxDepth = n;
    }

    @Override
    public <N, Row, Column> void startLayout(@Nullable Rectangle2D bounds, @NotNull TreeMapModel<N, Row, Column> model, N root, @Nullable TreeMapWorker worker) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        super.startLayout(bounds, model, root, worker);
        this.maxDepth = this.getMaxDepthToLeaf(model, root) - model.getLevel(root);
    }

    private final <N, Row, Column> int getMaxDepthToLeaf(TreeMapModel<N, Row, Column> model, N root) {
        int maxDepth = 0;
        Iterator<N> it = model.depthFirstIterator(root).iterator();
        while (it.hasNext()) {
            int curDepth;
            N o;
            Intrinsics.checkNotNull(it.next());
            if (!model.hasNoChildren(o) || (curDepth = model.getLevel(o)) <= maxDepth) continue;
            maxDepth = curDepth;
        }
        return maxDepth;
    }

    @Override
    @NotNull
    public <N, Row, Column> Iterable<N> iterator(@NotNull TreeMapModel<N, Row, Column> model, N root) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        return model.depthFirstIterator(root);
    }

    @Override
    public <N, Row, Column> boolean breadthFirstLayout(@NotNull Shape shape, N parent, @NotNull N[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, @NotNull TreeMapAccessor<? super N> accessor, @Nullable TreeMapWorker worker) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
        double centerX = 0.0;
        double centerY = 0.0;
        double startAngle = 0.0;
        double arcAngle = 0.0;
        double outerRadius = 0.0;
        double innerRadius = 0.0;
        double stripeRadius = 0.0;
        if (shape instanceof Arc) {
            Shape arc = shape;
            centerX = ((Arc)arc).getX();
            centerY = ((Arc)arc).getY();
            startAngle = ((Arc)arc).getStartAngle();
            arcAngle = ((Arc)arc).getArcAngle();
            outerRadius = ((Arc)arc).getOuterRadius();
            innerRadius = ((Arc)arc).getInnerRadius() + ((Arc)arc).getStripRadius();
            stripeRadius = ((Arc)arc).getStripRadius();
        } else {
            Rectangle2D bounds = shape.getBounds2D();
            double d = bounds.getWidth();
            double d2 = bounds.getHeight();
            boolean bl = false;
            double size = Math.min(d, d2);
            double shiftX = (bounds.getWidth() - size) / (double)2;
            double shiftY = (bounds.getHeight() - size) / (double)2;
            bounds = (Rectangle2D)new Rectangle2D.Double(bounds.getX() + shiftX, bounds.getY() + shiftY, size, size);
            centerX = bounds.getCenterX();
            centerY = bounds.getCenterY();
            startAngle = 180.0;
            arcAngle = 360.0;
            stripeRadius = size / (double)this.maxDepth / (double)2;
            outerRadius = size / (double)2;
            innerRadius = 0.0;
        }
        double currentSize = 0.0;
        for (N child : children) {
            double s = startAngle + currentSize * arcAngle / sumSizes;
            double a = accessor.getSize(child) * arcAngle / sumSizes;
            accessor.setShape(child, (Shape)new Arc(centerX, centerY, s, a, outerRadius, innerRadius, stripeRadius));
            currentSize += accessor.getSize(child);
        }
        return false;
    }

    @Override
    public boolean isRenderingLeafLabelsSupported() {
        return false;
    }

    @Override
    public boolean isRenderingParentLabelSupported() {
        return false;
    }

    @Override
    public boolean isColorParent() {
        return true;
    }

    @Override
    public boolean isChildContained() {
        return false;
    }

    @Override
    public boolean isSpaceFilling() {
        return false;
    }

    @Override
    public boolean isCompatible(@Nullable Shape shape) {
        return shape instanceof Rectangle2D || shape instanceof Ellipse2D || shape instanceof Arc;
    }

    @NotNull
    public String toString() {
        return "Sunburst";
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0013\b\u0002\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\f\"\u0004\b\u0012\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/treemap/SunburstAlgorithm$Arc;", "Lorg/mkui/geom/Path2D$Double;", "x", "", "y", "startAngle", "arcAngle", "outerRadius", "innerRadius", "stripRadius", "(DDDDDDD)V", "getArcAngle", "()D", "setArcAngle", "(D)V", "getInnerRadius", "getOuterRadius", "getStartAngle", "setStartAngle", "getStripRadius", "getX", "getY", "treemap"})
    private static final class Arc
    extends Path2D.Double {
        private final double x;
        private final double y;
        private double startAngle;
        private double arcAngle;
        private final double outerRadius;
        private final double innerRadius;
        private final double stripRadius;

        public final double getX() {
            return this.x;
        }

        public final double getY() {
            return this.y;
        }

        public final double getStartAngle() {
            return this.startAngle;
        }

        public final void setStartAngle(double d) {
            this.startAngle = d;
        }

        public final double getArcAngle() {
            return this.arcAngle;
        }

        public final void setArcAngle(double d) {
            this.arcAngle = d;
        }

        public final double getOuterRadius() {
            return this.outerRadius;
        }

        public final double getInnerRadius() {
            return this.innerRadius;
        }

        public final double getStripRadius() {
            return this.stripRadius;
        }

        public Arc(double x, double y, double startAngle, double arcAngle, double outerRadius, double innerRadius, double stripRadius) {
            super(Path2D.Companion.getWIND_NON_ZERO(), 20);
            this.x = x;
            this.y = y;
            this.startAngle = startAngle;
            this.arcAngle = arcAngle;
            this.outerRadius = outerRadius;
            this.innerRadius = innerRadius;
            this.stripRadius = stripRadius;
            double segAngle_a = 0.0;
            double segAngle_b = 0.0;
            double theta_a = 0.0;
            double theta_b = 0.0;
            double angle = 0.0;
            double angleMid = 0.0;
            double segs = 0.0;
            double ax = 0.0;
            double ay = 0.0;
            double bx = 0.0;
            double _by = 0.0;
            double cx = 0.0;
            double cy = 0.0;
            double dx = 0.0;
            double dy = 0.0;
            bx = _by = 0.0;
            double d = this.arcAngle;
            boolean bl = false;
            if (Math.abs(d) > (double)360) {
                this.arcAngle = 360.0;
            }
            d = this.arcAngle;
            bl = false;
            d = Math.abs(d) / (double)45;
            bl = false;
            segs = Math.ceil(d);
            segAngle_a = this.arcAngle / segs;
            segAngle_b = -this.arcAngle / segs;
            theta_a = -(segAngle_a / (double)180) * Math.PI;
            theta_b = -(segAngle_b / (double)180) * Math.PI;
            angle = -(this.startAngle / (double)180) * Math.PI;
            if (segs > 0.0) {
                double d2;
                boolean bl2;
                d = -this.startAngle / (double)180 * Math.PI;
                bl = false;
                ax = this.x + Math.sin(d) * this.outerRadius;
                d = this.startAngle / (double)180 * Math.PI;
                bl = false;
                ay = this.y + Math.cos(d) * this.outerRadius;
                this.moveTo(ax, ay);
                int i = 0;
                while ((double)i < segs) {
                    angleMid = (angle += theta_a) - theta_a / (double)2;
                    boolean bl3 = false;
                    bx = this.x + Math.sin(angle) * this.outerRadius;
                    bl3 = false;
                    _by = this.y + Math.cos(angle) * this.outerRadius;
                    bl3 = false;
                    double d3 = theta_a / (double)2;
                    bl2 = false;
                    cx = this.x + Math.sin(angleMid) * (this.outerRadius / Math.cos(d3));
                    boolean bl4 = false;
                    d2 = theta_a / (double)2;
                    bl2 = false;
                    cy = this.y + Math.cos(angleMid) * (this.outerRadius / Math.cos(d2));
                    this.quadTo(cx, cy, bx, _by);
                    ++i;
                }
                this.startAngle += this.arcAngle;
                angle = -(this.startAngle / (double)180) * Math.PI;
                d2 = -this.startAngle / (double)180 * Math.PI;
                bl2 = false;
                dx = this.x + Math.sin(d2) * this.innerRadius;
                d2 = this.startAngle / (double)180 * Math.PI;
                bl2 = false;
                dy = this.y + Math.cos(d2) * this.innerRadius;
                if (this.arcAngle < (double)360) {
                    this.lineTo(dx, dy);
                } else {
                    this.moveTo(dx, dy);
                }
                if (this.innerRadius > 0.0) {
                    int i2 = 0;
                    while ((double)i2 < segs) {
                        angleMid = (angle += theta_b) - theta_b / (double)2;
                        bl = false;
                        bx = this.x + Math.sin(angle) * this.innerRadius;
                        bl = false;
                        _by = this.y + Math.cos(angle) * this.innerRadius;
                        bl = false;
                        double d4 = theta_b / (double)2;
                        boolean bl5 = false;
                        cx = this.x + Math.sin(angleMid) * (this.innerRadius / Math.cos(d4));
                        boolean bl6 = false;
                        double d5 = theta_b / (double)2;
                        bl5 = false;
                        cy = this.y + Math.cos(angleMid) * (this.innerRadius / Math.cos(d5));
                        this.quadTo(cx, cy, bx, _by);
                        ++i2;
                    }
                }
                if (this.arcAngle < (double)360) {
                    this.lineTo(ax, ay);
                }
            }
        }
    }
}

