/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.common.command.Future;
import com.macrofocus.common.geom.Dimension;
import com.treemap.DefaultTreeMapTooltipRenderer;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapTooltipRenderer;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.PreferredSize;
import com.treemap.crossplatform.TGraphics;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.CPColor;
import org.mkui.font.CPFont;
import org.mkui.font.Weight;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Shape;
import org.mkui.labeling.EnhancedLabel;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u00020\u0004:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0005Js\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J]\u0010\u0017\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\f\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001c\u00a2\u0006\u0002\u0010\u001dR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001f"}, d2={"Lcom/treemap/ToolTipTreeMapRenderer;", "N", "Row", "Column", "", "()V", "labelRenderer", "Lorg/mkui/labeling/EnhancedLabel;", "getLabelRenderer", "()Lorg/mkui/labeling/EnhancedLabel;", "drawToolTip", "Lorg/mkui/geom/Rectangle;", "g", "Lcom/treemap/crossplatform/TGraphics;", "view", "Lcom/treemap/TreeMapView;", "model", "Lcom/treemap/TreeMapModel;", "node", "width", "", "leftShift", "topShift", "paint", "", "(Lcom/treemap/crossplatform/TGraphics;Lcom/treemap/TreeMapView;Lcom/treemap/TreeMapModel;Ljava/lang/Object;IIIZ)Lorg/mkui/geom/Rectangle;", "", "progress", "Lcom/macrofocus/common/command/Future;", "(Lcom/treemap/crossplatform/TGraphics;Lcom/treemap/TreeMapView;Ljava/lang/Object;IIILcom/macrofocus/common/command/Future;)V", "Companion", "treemap"})
public final class ToolTipTreeMapRenderer<N, Row, Column> {
    @NotNull
    private final EnhancedLabel labelRenderer = new EnhancedLabel();
    private static final int leftMargin = 2;
    private static final int rightMargin = 1;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final EnhancedLabel getLabelRenderer() {
        return this.labelRenderer;
    }

    public final void paint(@NotNull TGraphics g, @NotNull TreeMapView<N, Row, Column> view, @Nullable N node, int width, int leftShift, int topShift, @Nullable Future<?> progress) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter(view, (String)"view");
        TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
        Intrinsics.checkNotNull(treeMapModel);
        TreeMapModel<N, Row, Column> model = treeMapModel;
        if (node != null) {
            N n = model.getCurrentRoot();
            Intrinsics.checkNotNull(n);
            Shape shape = view.getRenderedShape(n);
            if (shape != null) {
                this.drawToolTip(g, view, model, node, width, leftShift, topShift, true);
            }
        }
    }

    @Nullable
    public final Rectangle drawToolTip(@Nullable TGraphics g, @NotNull TreeMapView<N, Row, Column> view, @NotNull TreeMapModel<N, Row, Column> model, N node, int width, int leftShift, int topShift, boolean paint) {
        Rectangle rectangle;
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        List<Column> labelColumn = model.getSettings().getToolTipColumns();
        if (labelColumn != null && labelColumn.size() >= 0) {
            int height = 0;
            for (Column column : labelColumn) {
                CPFont font;
                if (column == null) continue;
                TreeMapTooltipRenderer<N, Row, Column> treeMapTooltipRenderer = view.getTooltipRenderer();
                Intrinsics.checkNotNull(treeMapTooltipRenderer);
                EnhancedLabel valueLabel = treeMapTooltipRenderer.getTooltipRendererComponent(view, column, node, new Dimension(width, 1000));
                if (valueLabel == null) continue;
                Intrinsics.checkNotNull((Object)model.getSettings().getColumnSettings(column).getTooltipFont());
                CPFont boldFont = font.deriveFontWeight(Weight.BOLD);
                valueLabel.setFont(boldFont);
                CPColor cPColor = model.getSettings().getColumnSettings(column).getTooltipForeground();
                Intrinsics.checkNotNull((Object)cPColor);
                valueLabel.setForeground(cPColor);
                valueLabel.setBackground(null);
                int valueWidth = width - 2 - 1;
                Dimension labelSize = null;
                Boolean bl = model.getSettings().getColumnSettings(column).getShowLabel();
                Intrinsics.checkNotNull((Object)bl);
                if (bl.booleanValue() && model.getSettings().getColumnSettings(column).getTooltipRendering() == EnhancedLabel.Rendering.WordWrap) {
                    this.labelRenderer.setFont(font);
                    CPColor cPColor2 = model.getSettings().getColumnSettings(column).getTooltipForeground();
                    Intrinsics.checkNotNull((Object)cPColor2);
                    this.labelRenderer.setForeground(cPColor2);
                    this.labelRenderer.setBackground(null);
                    this.labelRenderer.setText(Intrinsics.stringPlus((String)model.getColumnName(column), (Object)": "));
                    labelSize = view.getHeadless().sizeLabel(this.labelRenderer, g, valueWidth, 1000).getPreferredSize();
                } else {
                    labelSize = new Dimension(0, 0);
                }
                PreferredSize pf = view.getHeadless().sizeLabel(valueLabel, g, valueWidth - labelSize.getIwidth(), 1000);
                height += (int)pf.getPreferredHeight();
            }
            Rectangle bounds = new Rectangle(0, 0, width, height);
            if (height <= 0) {
                return null;
            }
            int top = bounds.getIy();
            for (Column column : labelColumn) {
                Rectangle rect;
                CPFont font;
                if (column == null) continue;
                TreeMapTooltipRenderer<N, Row, Column> treeMapTooltipRenderer = view.getTooltipRenderer();
                Intrinsics.checkNotNull(treeMapTooltipRenderer);
                EnhancedLabel valueLabel = treeMapTooltipRenderer.getTooltipRendererComponent(view, column, node, new Dimension(width, 1000));
                if (valueLabel == null) continue;
                Intrinsics.checkNotNull((Object)model.getSettings().getColumnSettings(column).getTooltipFont());
                CPFont boldFont = font.deriveFontWeight(Weight.BOLD);
                valueLabel.setFont(boldFont);
                CPColor cPColor = model.getSettings().getColumnSettings(column).getTooltipForeground();
                Intrinsics.checkNotNull((Object)cPColor);
                valueLabel.setForeground(cPColor);
                valueLabel.setBackground(null);
                int valueWidth = bounds.getIwidth() - 2 - 1;
                Dimension labelSize = null;
                Boolean bl = model.getSettings().getColumnSettings(column).getShowLabel();
                Intrinsics.checkNotNull((Object)bl);
                if (bl.booleanValue()) {
                    this.labelRenderer.setFont(font);
                    CPColor cPColor3 = model.getSettings().getColumnSettings(column).getTooltipForeground();
                    Intrinsics.checkNotNull((Object)cPColor3);
                    this.labelRenderer.setForeground(cPColor3);
                    this.labelRenderer.setBackground(null);
                    this.labelRenderer.setText(String.valueOf(model.getColumnName(column)) + ": ");
                    labelSize = view.getHeadless().sizeLabel(this.labelRenderer, g, valueWidth, 1000).getPreferredSize();
                } else {
                    labelSize = new Dimension(0, 0);
                }
                PreferredSize pf = view.getHeadless().sizeLabel(valueLabel, g, valueWidth - labelSize.getIwidth(), 1000);
                Dimension valueSize = pf.getPreferredSize();
                if (!((double)top + valueSize.getHeight() <= bounds.getY() + bounds.getHeight())) break;
                int x = bounds.getIx() + 2;
                Boolean bl2 = model.getSettings().getColumnSettings(column).getShowLabel();
                Intrinsics.checkNotNull((Object)bl2);
                if (bl2.booleanValue()) {
                    rect = new Rectangle(x, top, labelSize.getIwidth(), labelSize.getIheight());
                    if (paint && g != null) {
                        g.paintLabel(this.labelRenderer, rect.getIx(), rect.getIy(), rect.getIwidth(), rect.getIheight());
                    }
                    if (model.isNumericType(column)) {
                        x += labelSize.getIwidth();
                        valueWidth -= labelSize.getIwidth();
                    } else {
                        x += labelSize.getIwidth();
                        valueWidth -= labelSize.getIwidth();
                    }
                }
                rect = new Rectangle(x, top, valueWidth, valueSize.getIheight());
                if (paint && g != null) {
                    g.paintLabel(valueLabel, rect.getIx(), rect.getIy(), rect.getIwidth(), rect.getIheight());
                }
                top += valueSize.getIheight();
            }
            rectangle = bounds;
        } else {
            rectangle = null;
        }
        return rectangle;
    }

    public ToolTipTreeMapRenderer() {
        this.labelRenderer.setInsets(DefaultTreeMapTooltipRenderer.Companion.getDEFAULT_BORDER().getTop(), DefaultTreeMapTooltipRenderer.Companion.getDEFAULT_BORDER().getLeft(), DefaultTreeMapTooltipRenderer.Companion.getDEFAULT_BORDER().getBottom(), DefaultTreeMapTooltipRenderer.Companion.getDEFAULT_BORDER().getRight());
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/treemap/ToolTipTreeMapRenderer$Companion;", "", "()V", "leftMargin", "", "rightMargin", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

