/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.crossplatform;

import com.treemap.crossplatform.JavaFXFontMetrics;
import com.treemap.crossplatform.JavaFXIGraphics$WhenMappings;
import java.util.Arrays;
import javafx.geometry.Bounds;
import javafx.geometry.VPos;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.CPColor;
import org.mkui.font.CPFont;
import org.mkui.font.CPFontMetrics;
import org.mkui.geom.PathIterator;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;
import org.mkui.graphics.AbstractIGraphics;
import org.mkui.graphics.IGraphics;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 A2\u00020\u0001:\u0001AB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\u0012\u0010\n\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J(\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J(\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\fJ\u000e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018J\"\u0010\u0019\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020\bH\u0016J\u0012\u0010\u001f\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J\u0010\u0010 \u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010!\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\"\u001a\u00020\u000fH\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u000fH\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u000fH\u0016J\u0012\u0010)\u001a\u00020\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0012\u0010*\u001a\u00020\u001d2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0012\u0010+\u001a\u00020\u001d2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0018\u0010,\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000fH\u0016J\u0018\u0010-\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000fH\u0016J\u0010\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u00020\u000fH\u0016J\u0010\u00100\u001a\u00020\b2\u0006\u00101\u001a\u00020$H\u0016J\u0012\u00102\u001a\u00020\b2\b\u00103\u001a\u0004\u0018\u000104H\u0016J\u0010\u00105\u001a\u00020\b2\u0006\u00106\u001a\u00020\u000fH\u0016J\u0012\u00107\u001a\u00020\b2\b\u00108\u001a\u0004\u0018\u000109H\u0016J\u0010\u0010:\u001a\u00020\b2\u0006\u0010;\u001a\u00020\u000fH\u0016J\u0012\u0010<\u001a\u00020\b2\b\u0010=\u001a\u0004\u0018\u00010>H\u0016J\b\u0010?\u001a\u00020\bH\u0016J\u0018\u0010@\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0013H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006B"}, d2={"Lcom/treemap/crossplatform/JavaFXIGraphics;", "Lorg/mkui/graphics/AbstractIGraphics;", "context", "Ljavafx/scene/canvas/GraphicsContext;", "(Ljavafx/scene/canvas/GraphicsContext;)V", "getContext", "()Ljavafx/scene/canvas/GraphicsContext;", "beginPath", "", "closePath", "draw", "geometry", "Lorg/mkui/geom/Shape;", "drawLine", "x1", "", "y1", "x2", "y2", "", "drawPath", "path", "drawRectangle", "rectangle", "Lorg/mkui/geom/Rectangle2D;", "drawString", "text", "", "x", "", "y", "fill", "fillCircle", "fillRectangle2D", "getAscent", "getColor", "Lorg/mkui/color/CPColor;", "getDescent", "getFontMetrics", "Lorg/mkui/font/CPFontMetrics;", "getLineWidth", "getStringBounds", "getStringHeight", "getStringWidth", "lineTo", "moveTo", "rotate", "theta", "setColor", "color", "setFont", "font", "Lorg/mkui/font/CPFont;", "setGlobalAlpha", "alpha", "setLineDash", "dashPattern", "", "setLineWidth", "lineWidth", "setTextBaseline", "baseline", "Lorg/mkui/graphics/IGraphics$TextBaseline;", "stroke", "translate", "Companion", "treemap"})
public final class JavaFXIGraphics
extends AbstractIGraphics {
    @Nullable
    private final GraphicsContext context;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public double getLineWidth() {
        GraphicsContext graphicsContext = this.context;
        Intrinsics.checkNotNull((Object)graphicsContext);
        return graphicsContext.getLineWidth();
    }

    public void setLineWidth(double lineWidth) {
        GraphicsContext graphicsContext = this.context;
        Intrinsics.checkNotNull((Object)graphicsContext);
        graphicsContext.setLineWidth(lineWidth);
    }

    public void setLineDash(@Nullable float[] dashPattern) {
        GraphicsContext graphicsContext = this.context;
        Intrinsics.checkNotNull((Object)graphicsContext);
        double[] dArray = JavaFXIGraphics.Companion.convertFloatsToDoubles(dashPattern);
        Intrinsics.checkNotNull((Object)dArray);
        graphicsContext.setLineDashes(Arrays.copyOf(dArray, dArray.length));
    }

    @NotNull
    public CPColor getColor() {
        GraphicsContext graphicsContext = this.context;
        Intrinsics.checkNotNull((Object)graphicsContext);
        Paint paint = graphicsContext.getFill();
        if (paint == null) {
            throw new NullPointerException("null cannot be cast to non-null type javafx.scene.paint.Color");
        }
        return new CPColor((Color)paint);
    }

    public void setGlobalAlpha(double alpha) {
        GraphicsContext graphicsContext = this.context;
        Intrinsics.checkNotNull((Object)graphicsContext);
        graphicsContext.setGlobalAlpha(alpha);
    }

    public void setColor(@NotNull CPColor color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        GraphicsContext graphicsContext = this.context;
        Intrinsics.checkNotNull((Object)graphicsContext);
        graphicsContext.setFill((Paint)color.getNative());
        this.context.setStroke((Paint)color.getNative());
    }

    protected void draw(@Nullable Shape geometry) {
        if (this.context != null) {
            GraphicsContext context = this.context;
            Shape shape = geometry;
            Intrinsics.checkNotNull((Object)shape);
            this.drawPath(shape);
            context.stroke();
        }
    }

    protected void fill(@Nullable Shape geometry) {
        if (this.context != null) {
            GraphicsContext context = this.context;
            Shape shape = geometry;
            Intrinsics.checkNotNull((Object)shape);
            this.drawPath(shape);
            context.fill();
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        GraphicsContext graphicsContext = this.context;
        Intrinsics.checkNotNull((Object)graphicsContext);
        graphicsContext.strokeLine((double)x1, (double)y1, (double)x2, (double)y2);
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        GraphicsContext graphicsContext = this.context;
        Intrinsics.checkNotNull((Object)graphicsContext);
        graphicsContext.strokeLine(x1, y1, x2, y2);
    }

    public final void drawRectangle(@NotNull Rectangle2D rectangle) {
        GraphicsContext context;
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        GraphicsContext graphicsContext = context = this.context;
        Intrinsics.checkNotNull((Object)graphicsContext);
        graphicsContext.rect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public void fillRectangle2D(@Nullable Rectangle2D rectangle) {
        GraphicsContext graphicsContext = this.context;
        Intrinsics.checkNotNull((Object)graphicsContext);
        Rectangle2D rectangle2D = rectangle;
        Intrinsics.checkNotNull((Object)rectangle2D);
        graphicsContext.fillRect(rectangle2D.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public void fillCircle(@NotNull Rectangle2D rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        GraphicsContext graphicsContext = this.context;
        Intrinsics.checkNotNull((Object)graphicsContext);
        graphicsContext.fillOval(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public final void drawPath(@NotNull Shape path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        GraphicsContext context = this.context;
        PathIterator iterator2 = path.getPathIterator();
        double[] coords = new double[6];
        GraphicsContext graphicsContext = context;
        Intrinsics.checkNotNull((Object)graphicsContext);
        graphicsContext.beginPath();
        while (!iterator2.isDone()) {
            int segment = iterator2.currentSegment(coords);
            if (segment == 0) {
                context.moveTo(coords[0], coords[1]);
            } else if (segment == 1) {
                context.lineTo(coords[0], coords[1]);
            } else if (segment == 2) {
                context.quadraticCurveTo(coords[0], coords[1], coords[2], coords[3]);
            } else if (segment == 3) {
                context.bezierCurveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
            } else if (segment == 4) {
                context.closePath();
            } else {
                throw (Throwable)new RuntimeException("Unknown Segment " + segment);
            }
            iterator2.next();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTextBaseline(@Nullable IGraphics.TextBaseline baseline) {
        IGraphics.TextBaseline textBaseline = baseline;
        if (textBaseline == null) throw (Throwable)new IllegalArgumentException();
        switch (JavaFXIGraphics$WhenMappings.$EnumSwitchMapping$0[textBaseline.ordinal()]) {
            case 1: {
                GraphicsContext graphicsContext = this.context;
                Intrinsics.checkNotNull((Object)graphicsContext);
                graphicsContext.setTextBaseline(VPos.TOP);
                return;
            }
            case 2: {
                GraphicsContext graphicsContext = this.context;
                Intrinsics.checkNotNull((Object)graphicsContext);
                graphicsContext.setTextBaseline(VPos.BOTTOM);
                return;
            }
            case 3: {
                GraphicsContext graphicsContext = this.context;
                Intrinsics.checkNotNull((Object)graphicsContext);
                graphicsContext.setTextBaseline(VPos.CENTER);
                return;
            }
            case 4: {
                GraphicsContext graphicsContext = this.context;
                Intrinsics.checkNotNull((Object)graphicsContext);
                graphicsContext.setTextBaseline(VPos.BASELINE);
                return;
            }
            case 5: {
                throw (Throwable)new UnsupportedOperationException();
            }
            case 6: {
                throw (Throwable)new UnsupportedOperationException();
            }
            default: {
                throw (Throwable)new IllegalArgumentException();
            }
        }
    }

    public void setFont(@Nullable CPFont font) {
        GraphicsContext graphicsContext = this.context;
        Intrinsics.checkNotNull((Object)graphicsContext);
        CPFont cPFont = font;
        Intrinsics.checkNotNull((Object)cPFont);
        graphicsContext.setFont(cPFont.getNativeFont());
    }

    @NotNull
    public Rectangle2D getStringBounds(@Nullable String text) {
        Bounds stringBounds;
        Text t = new Text(text);
        GraphicsContext graphicsContext = this.context;
        Intrinsics.checkNotNull((Object)graphicsContext);
        t.setFont(graphicsContext.getFont());
        Bounds bounds = stringBounds = t.getLayoutBounds();
        Intrinsics.checkNotNullExpressionValue((Object)bounds, (String)"stringBounds");
        return (Rectangle2D)new Rectangle2D.Double(bounds.getMinX(), stringBounds.getMinY(), stringBounds.getWidth(), stringBounds.getHeight());
    }

    @NotNull
    public CPFontMetrics getFontMetrics() {
        GraphicsContext graphicsContext = this.context;
        Intrinsics.checkNotNull((Object)graphicsContext);
        return new JavaFXFontMetrics(graphicsContext);
    }

    public void drawString(@Nullable String text, float x, float y) {
        GraphicsContext graphicsContext = this.context;
        Intrinsics.checkNotNull((Object)graphicsContext);
        graphicsContext.fillText(text, (double)x, (double)y);
    }

    public float getStringWidth(@Nullable String text) {
        return (float)this.getStringBounds(text).getWidth();
    }

    public float getStringHeight(@Nullable String text) {
        return (float)this.getStringBounds(text).getHeight();
    }

    public double getAscent() {
        GraphicsContext graphicsContext = this.context;
        Intrinsics.checkNotNull((Object)graphicsContext);
        Font font = graphicsContext.getFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"context!!.font");
        return font.getSize();
    }

    public double getDescent() {
        return 0.0;
    }

    public void translate(int x, int y) {
        GraphicsContext graphicsContext = this.context;
        Intrinsics.checkNotNull((Object)graphicsContext);
        graphicsContext.translate((double)x, (double)y);
    }

    public void rotate(double theta) {
        GraphicsContext graphicsContext = this.context;
        Intrinsics.checkNotNull((Object)graphicsContext);
        graphicsContext.rotate(Math.toDegrees(theta));
    }

    public void beginPath() {
        GraphicsContext graphicsContext = this.context;
        Intrinsics.checkNotNull((Object)graphicsContext);
        graphicsContext.beginPath();
    }

    public void moveTo(double x, double y) {
        GraphicsContext graphicsContext = this.context;
        Intrinsics.checkNotNull((Object)graphicsContext);
        graphicsContext.moveTo(x, y);
    }

    public void lineTo(double x, double y) {
        GraphicsContext graphicsContext = this.context;
        Intrinsics.checkNotNull((Object)graphicsContext);
        graphicsContext.lineTo(x, y);
    }

    public void closePath() {
        GraphicsContext graphicsContext = this.context;
        Intrinsics.checkNotNull((Object)graphicsContext);
        graphicsContext.closePath();
    }

    public void stroke() {
        GraphicsContext graphicsContext = this.context;
        Intrinsics.checkNotNull((Object)graphicsContext);
        graphicsContext.stroke();
    }

    public void fill() {
        GraphicsContext graphicsContext = this.context;
        Intrinsics.checkNotNull((Object)graphicsContext);
        graphicsContext.fill();
    }

    @Nullable
    public final GraphicsContext getContext() {
        return this.context;
    }

    public JavaFXIGraphics(@Nullable GraphicsContext context) {
        this.context = context;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0014\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/treemap/crossplatform/JavaFXIGraphics$Companion;", "", "()V", "convertFloatsToDoubles", "", "input", "", "treemap"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        private final double[] convertFloatsToDoubles(float[] input) {
            if (input == null) {
                return null;
            }
            double[] output = new double[input.length];
            int n = 0;
            int n2 = input.length;
            while (n < n2) {
                void i;
                output[i] = input[i];
                ++i;
            }
            return output;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

