/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.crossplatform;

import com.macrofocus.common.geom.Dimension;
import com.treemap.crossplatform.AbstractTGraphics;
import com.treemap.crossplatform.Headless;
import com.treemap.crossplatform.JavaFXIGraphics;
import com.treemap.crossplatform.PreferredSize;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.Arrays;
import javafx.geometry.Bounds;
import javafx.geometry.VPos;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.CPColor;
import org.mkui.color.CPColorFactory;
import org.mkui.font.CPFont;
import org.mkui.geom.AffineTransform;
import org.mkui.geom.Arc2D;
import org.mkui.geom.Ellipse2D;
import org.mkui.geom.GeneralPath;
import org.mkui.geom.PathIterator;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.RoundRectangle2D;
import org.mkui.geom.Shape;
import org.mkui.graphics.CPImage;
import org.mkui.graphics.IGraphics;
import org.mkui.labeling.EnhancedLabel;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00e8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 \u00a1\u00012\u00020\u0001:\u0002\u00a1\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BJ\u000e\u0010C\u001a\u00020D2\u0006\u0010A\u001a\u00020EJ\u000e\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020EJ(\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020E2\u0006\u0010L\u001a\u00020E2\u0006\u0010M\u001a\u00020E2\u0006\u0010N\u001a\u00020EH\u0016J\u0012\u0010O\u001a\u00020J2\b\u0010P\u001a\u0004\u0018\u00010QH\u0016J\u0018\u0010R\u001a\u00020S2\u0006\u0010M\u001a\u00020E2\u0006\u0010N\u001a\u00020EH\u0016J&\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020W2\u0006\u0010Y\u001a\u00020E2\u0006\u0010Z\u001a\u00020!J8\u0010[\u001a\u00020J2\u0006\u0010K\u001a\u00020E2\u0006\u0010L\u001a\u00020E2\u0006\u0010M\u001a\u00020E2\u0006\u0010N\u001a\u00020E2\u0006\u0010\\\u001a\u00020E2\u0006\u0010]\u001a\u00020EH\u0016J\"\u0010^\u001a\u00020!2\b\u0010_\u001a\u0004\u0018\u00010S2\u0006\u0010K\u001a\u00020E2\u0006\u0010L\u001a\u00020EH\u0016J2\u0010^\u001a\u00020!2\b\u0010_\u001a\u0004\u0018\u00010S2\u0006\u0010K\u001a\u00020E2\u0006\u0010L\u001a\u00020E2\u0006\u0010`\u001a\u00020E2\u0006\u0010a\u001a\u00020EH\u0016J \u0010b\u001a\u00020!2\b\u0010_\u001a\u0004\u0018\u00010c2\u0006\u0010K\u001a\u00020E2\u0006\u0010L\u001a\u00020EJ(\u0010d\u001a\u00020J2\u0006\u0010K\u001a\u00020E2\u0006\u0010L\u001a\u00020E2\u0006\u0010M\u001a\u00020E2\u0006\u0010N\u001a\u00020EH\u0016J$\u0010e\u001a\u00020J2\b\u0010V\u001a\u0004\u0018\u00010W2\b\u0010X\u001a\u0004\u0018\u00010W2\u0006\u0010Y\u001a\u00020EH\u0016J$\u0010f\u001a\u00020J2\b\u0010V\u001a\u0004\u0018\u00010W2\b\u0010X\u001a\u0004\u0018\u00010W2\u0006\u0010Y\u001a\u00020EH\u0016J\u0012\u0010g\u001a\u00020J2\b\u0010P\u001a\u0004\u0018\u00010QH\u0016J8\u0010h\u001a\u00020J2\u0006\u0010K\u001a\u00020E2\u0006\u0010L\u001a\u00020E2\u0006\u0010M\u001a\u00020E2\u0006\u0010N\u001a\u00020E2\u0006\u0010\\\u001a\u00020E2\u0006\u0010]\u001a\u00020EH\u0016J(\u0010i\u001a\u00020J2\u0006\u0010K\u001a\u00020E2\u0006\u0010L\u001a\u00020E2\u0006\u0010M\u001a\u00020E2\u0006\u0010N\u001a\u00020EH\u0016J$\u0010j\u001a\u00020J2\b\u0010V\u001a\u0004\u0018\u00010W2\b\u0010X\u001a\u0004\u0018\u00010W2\u0006\u0010Y\u001a\u00020EH\u0016J(\u0010k\u001a\u00020J2\u0006\u0010K\u001a\u00020>2\u0006\u0010L\u001a\u00020>2\u0006\u0010M\u001a\u00020>2\u0006\u0010N\u001a\u00020>H\u0016J(\u0010k\u001a\u00020J2\u0006\u0010K\u001a\u00020E2\u0006\u0010L\u001a\u00020E2\u0006\u0010M\u001a\u00020E2\u0006\u0010N\u001a\u00020EH\u0016J8\u0010l\u001a\u00020J2\u0006\u0010K\u001a\u00020>2\u0006\u0010L\u001a\u00020>2\u0006\u0010M\u001a\u00020>2\u0006\u0010N\u001a\u00020>2\u0006\u0010m\u001a\u00020>2\u0006\u0010n\u001a\u00020>H\u0016J\"\u0010o\u001a\u00020J2\b\u0010p\u001a\u0004\u0018\u00010q2\u0006\u0010K\u001a\u00020r2\u0006\u0010L\u001a\u00020rH\u0016J\"\u0010o\u001a\u00020J2\b\u0010p\u001a\u0004\u0018\u00010q2\u0006\u0010K\u001a\u00020E2\u0006\u0010L\u001a\u00020EH\u0016J\u0012\u0010s\u001a\u0004\u0018\u00010\u00112\b\u0010t\u001a\u0004\u0018\u00010uJ\u0010\u0010v\u001a\u00020w2\b\u0010x\u001a\u0004\u0018\u00010qJ\u0012\u0010y\u001a\u00020>2\b\u0010x\u001a\u0004\u0018\u00010qH\u0016J\u000e\u0010z\u001a\u00020{2\u0006\u00106\u001a\u00020EJ2\u0010|\u001a\u00020J2\b\u0010}\u001a\u0004\u0018\u00010~2\u0006\u0010K\u001a\u00020E2\u0006\u0010L\u001a\u00020E2\u0006\u0010`\u001a\u00020E2\u0006\u0010a\u001a\u00020EH\u0016J\b\u0010\u007f\u001a\u00020JH\u0016J\u0012\u0010\u0080\u0001\u001a\u00020J2\u0007\u0010\u0081\u0001\u001a\u00020>H\u0016J\"\u0010\u0080\u0001\u001a\u00020J2\u0007\u0010\u0081\u0001\u001a\u00020>2\u0006\u0010K\u001a\u00020>2\u0006\u0010L\u001a\u00020>H\u0016J\t\u0010\u0082\u0001\u001a\u00020JH\u0016J\u001b\u0010\u0083\u0001\u001a\u00020J2\u0007\u0010\u0084\u0001\u001a\u00020>2\u0007\u0010\u0085\u0001\u001a\u00020>H\u0016J\u0013\u0010\u0086\u0001\u001a\u00020J2\b\u0010A\u001a\u0004\u0018\u00010\u0006H\u0016J\u0013\u0010\u0087\u0001\u001a\u00020J2\b\u0010A\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u0088\u0001\u001a\u00020J2\u0007\u0010\u0089\u0001\u001a\u00020>H\u0016J\u0014\u0010\u008a\u0001\u001a\u00020J2\t\u0010\u008b\u0001\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010\u008c\u0001\u001a\u00020J2\u0007\u0010\u008d\u0001\u001a\u00020>H\u0016J\u0011\u0010\u008e\u0001\u001a\u00020J2\b\u00102\u001a\u0004\u0018\u000103J\t\u0010\u008f\u0001\u001a\u00020JH\u0016J\u0013\u0010\u0090\u0001\u001a\u00020J2\b\u0010A\u001a\u0004\u0018\u00010\u0006H\u0016J\u000f\u0010\u0091\u0001\u001a\u00020J2\u0006\u0010P\u001a\u00020QJ\u001b\u0010\u0092\u0001\u001a\u00020J2\u0007\u0010\u0093\u0001\u001a\u00020>2\u0007\u0010\u0094\u0001\u001a\u00020>H\u0016J$\u0010\u0095\u0001\u001a\u00030\u0096\u00012\b\u0010}\u001a\u0004\u0018\u00010~2\u0006\u0010`\u001a\u00020E2\u0006\u0010a\u001a\u00020EH\u0016J\u0012\u00104\u001a\u00020J2\b\u0010P\u001a\u0004\u0018\u00010QH\u0016J-\u0010\u0097\u0001\u001a\u00020J2\u0007\u0010\u0098\u0001\u001a\u00020E2\u0007\u0010\u0099\u0001\u001a\u00020E2\u0007\u0010\u009a\u0001\u001a\u00020E2\u0007\u0010\u009b\u0001\u001a\u00020EH\u0016J)\u0010\u009c\u0001\u001a\u00020J2\u0006\u0010K\u001a\u00020>2\u0006\u0010L\u001a\u00020>2\u0006\u0010M\u001a\u00020>2\u0006\u0010N\u001a\u00020>H\u0016J9\u0010\u009d\u0001\u001a\u00020J2\u0006\u0010K\u001a\u00020>2\u0006\u0010L\u001a\u00020>2\u0006\u0010M\u001a\u00020>2\u0006\u0010N\u001a\u00020>2\u0006\u0010m\u001a\u00020>2\u0006\u0010n\u001a\u00020>H\u0016J\u0012\u00108\u001a\u00020J2\b\u00106\u001a\u0004\u0018\u000107H\u0016J\u001b\u0010\u009e\u0001\u001a\u00020J2\u0007\u0010\u009f\u0001\u001a\u00020>2\u0007\u0010\u00a0\u0001\u001a\u00020>H\u0016J\u001b\u0010\u009e\u0001\u001a\u00020J2\u0007\u0010\u009f\u0001\u001a\u00020E2\u0007\u0010\u00a0\u0001\u001a\u00020EH\u0016R&\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00138V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR$\u0010\"\u001a\u00020!2\u0006\u0010 \u001a\u00020!8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R$\u0010'\u001a\u00020!2\u0006\u0010&\u001a\u00020!8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010#\"\u0004\b(\u0010%R$\u0010*\u001a\u00020!2\u0006\u0010)\u001a\u00020!8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010#\"\u0004\b+\u0010%R$\u0010,\u001a\u00020!2\u0006\u0010 \u001a\u00020!8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010#\"\u0004\b-\u0010%R\u0014\u0010.\u001a\u00020/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u000e\u00102\u001a\u000203X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00104\u001a\u0004\u0018\u000105X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u00108\u001a\u0004\u0018\u0001072\b\u00106\u001a\u0004\u0018\u0001078V@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u000e\u0010=\u001a\u00020>X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00a2\u0001"}, d2={"Lcom/treemap/crossplatform/JavaFXTGraphics;", "Lcom/treemap/crossplatform/AbstractTGraphics;", "gc", "Ljavafx/scene/canvas/GraphicsContext;", "(Ljavafx/scene/canvas/GraphicsContext;)V", "color", "Lorg/mkui/color/CPColor;", "background", "getBackground", "()Lorg/mkui/color/CPColor;", "setBackground", "(Lorg/mkui/color/CPColor;)V", "colorFactory", "Lorg/mkui/color/CPColorFactory;", "getColorFactory", "()Lorg/mkui/color/CPColorFactory;", "coords", "", "font", "Lorg/mkui/font/CPFont;", "getFont", "()Lorg/mkui/font/CPFont;", "setFont", "(Lorg/mkui/font/CPFont;)V", "headless", "Lcom/treemap/crossplatform/Headless;", "hints", "Ljava/awt/RenderingHints;", "iGraphics", "Lorg/mkui/graphics/IGraphics;", "getIGraphics", "()Lorg/mkui/graphics/IGraphics;", "antialias", "", "isAntialias", "()Z", "setAntialias", "(Z)V", "bilinear", "isInterpolationBilinear", "setInterpolationBilinear", "paintingForPrint", "isPaintingForPrint", "setPaintingForPrint", "isTextAntialias", "setTextAntialias", "nativeGraphics", "", "getNativeGraphics", "()Ljava/lang/Object;", "paint", "Ljava/awt/Paint;", "stroke", "Ljava/awt/Stroke;", "t", "Lorg/mkui/geom/AffineTransform;", "transform", "getTransform", "()Lorg/mkui/geom/AffineTransform;", "setTransform", "(Lorg/mkui/geom/AffineTransform;)V", "zeroStrokeWidth", "", "awtColorToJavaFX", "Ljavafx/scene/paint/Color;", "c", "Ljava/awt/Color;", "awtToJavaFXLineCap", "Ljavafx/scene/shape/StrokeLineCap;", "", "awtToJavaFXLineJoin", "Ljavafx/scene/shape/StrokeLineJoin;", "j", "clearRect", "", "x", "y", "width", "height", "clip", "s", "Lorg/mkui/geom/Shape;", "createImage", "Lorg/mkui/graphics/CPImage;", "createPolygon", "Lorg/mkui/geom/GeneralPath;", "xPoints", "", "yPoints", "nPoints", "close", "drawArc", "startAngle", "arcAngle", "drawImage", "img", "w", "h", "drawNativeImage", "Ljava/awt/Image;", "drawOval", "drawPolygon", "drawPolyline", "fill", "fillArc", "fillOval", "fillPolygon", "fillRect", "fillRoundRect", "arcWidth", "arcHeight", "fillText", "str", "", "", "floatToDoubleArray", "f", "", "getStringBounds", "Lorg/mkui/geom/Rectangle2D;", "text", "getStringWidth", "intToArcType", "Ljavafx/scene/shape/ArcType;", "paintLabel", "l", "Lorg/mkui/labeling/EnhancedLabel;", "restore", "rotate", "theta", "save", "scale", "sx", "sy", "setColor", "setFill", "setGlobalAlpha", "alpha", "setLineDash", "dashPattern", "setLineWidth", "lw", "setPaint", "setRadialGradient", "setStroke", "shapeToPath", "shear", "shx", "shy", "sizeLabel", "Lcom/treemap/crossplatform/PreferredSize;", "strokeLine", "x1", "y1", "x2", "y2", "strokeRect", "strokeRoundRect", "translate", "tx", "ty", "Companion", "treemap"})
public final class JavaFXTGraphics
extends AbstractTGraphics {
    private final RenderingHints hints;
    private Paint paint;
    private CPColor color;
    private final Stroke stroke;
    private final double zeroStrokeWidth;
    private final double[] coords;
    private final Headless headless;
    @NotNull
    private CPColor background;
    @Nullable
    private AffineTransform transform;
    private final GraphicsContext gc;
    @Nullable
    private static Text text;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public CPColorFactory getColorFactory() {
        return CPColorFactory.Companion.getInstance();
    }

    @Override
    public void paintLabel(@Nullable EnhancedLabel l, int x, int y, int w, int h) {
        String text;
        this.gc.save();
        EnhancedLabel enhancedLabel = l;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        if (enhancedLabel.isOpaque()) {
            CPColor cPColor = l.getBackground();
            Intrinsics.checkNotNull((Object)cPColor);
            this.gc.setFill((javafx.scene.paint.Paint)cPColor.getNative());
            this.gc.fillRect((double)x, (double)y, (double)w, (double)h);
        }
        if ((text = l.getText()) != null) {
            this.gc.setTextBaseline(VPos.TOP);
            CPFont cPFont = l.getFont();
            Intrinsics.checkNotNull((Object)cPFont);
            this.gc.setFont(cPFont.getNativeFont());
            CPColor cPColor = l.getForeground();
            Intrinsics.checkNotNull((Object)cPColor);
            this.gc.setFill((javafx.scene.paint.Paint)cPColor.getNative());
            if (l.getMinimumCharactersToDisplay() != null) {
                Integer n = l.getMinimumCharactersToDisplay();
                Intrinsics.checkNotNull((Object)n);
                int minimumCharactersToDisplay = n;
                if (text.length() > minimumCharactersToDisplay) {
                    String string = text;
                    int n2 = 0;
                    boolean bl = false;
                    String string2 = string.substring(n2, minimumCharactersToDisplay);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String s = string2;
                    CPFont cPFont2 = l.getFont();
                    Intrinsics.checkNotNull((Object)cPFont2);
                    Bounds b = this.headless.computeStringBounds(s, cPFont2.getNativeFont());
                    double width = b.getWidth();
                    if (width > (double)(w - l.getInsetLeft() - l.getInsetRight())) {
                        this.gc.restore();
                        return;
                    }
                }
            }
            switch (l.getHorizontalAlignment()) {
                case 2: 
                case 10: {
                    this.gc.setTextAlign(TextAlignment.LEFT);
                    this.gc.fillText(text, (double)x + (double)l.getInsetLeft(), (double)y + (double)l.getInsetTop());
                    break;
                }
                case 4: 
                case 11: {
                    this.gc.setTextAlign(TextAlignment.RIGHT);
                    this.gc.fillText(text, (double)(x + w) - (double)l.getInsetRight(), (double)y + (double)l.getInsetTop());
                    break;
                }
                case 0: {
                    this.gc.setTextAlign(TextAlignment.LEFT);
                    String string = l.getText();
                    CPFont cPFont3 = l.getFont();
                    Intrinsics.checkNotNull((Object)cPFont3);
                    Bounds b = this.headless.computeStringBounds(string, cPFont3.getNativeFont());
                    double width = Math.max(0.0, ((double)(w - l.getInsetLeft() - l.getInsetRight()) - b.getWidth()) / (double)2);
                    this.gc.fillText(text, (double)x + width + (double)l.getInsetLeft(), (double)y + (double)l.getInsetTop());
                    break;
                }
            }
        }
        this.gc.restore();
    }

    @Override
    @NotNull
    public PreferredSize sizeLabel(@Nullable EnhancedLabel l, int w, int h) {
        return new PreferredSize(this, l){
            final /* synthetic */ JavaFXTGraphics this$0;
            final /* synthetic */ EnhancedLabel $l;

            @NotNull
            public Dimension getMinimumSize() {
                return new Dimension(0, (int)this.getPreferredHeight());
            }

            public double getPreferredHeight() {
                Headless headless = JavaFXTGraphics.access$getHeadless$p(this.this$0);
                EnhancedLabel enhancedLabel = this.$l;
                Intrinsics.checkNotNull((Object)enhancedLabel);
                String string = enhancedLabel.getText();
                EnhancedLabel enhancedLabel2 = this.$l;
                Intrinsics.checkNotNull((Object)enhancedLabel2);
                CPFont cPFont = enhancedLabel2.getFont();
                Intrinsics.checkNotNull((Object)cPFont);
                Bounds b = headless.computeStringBounds(string, cPFont.getNativeFont());
                return b.getHeight();
            }

            @NotNull
            public Dimension getPreferredSize() {
                Headless headless = JavaFXTGraphics.access$getHeadless$p(this.this$0);
                EnhancedLabel enhancedLabel = this.$l;
                Intrinsics.checkNotNull((Object)enhancedLabel);
                String string = enhancedLabel.getText();
                CPFont cPFont = this.$l.getFont();
                Intrinsics.checkNotNull((Object)cPFont);
                Bounds b = headless.computeStringBounds(string, cPFont.getNativeFont());
                return new Dimension((int)b.getWidth(), (int)b.getHeight());
            }

            @NotNull
            public Dimension getMaximumSize() {
                return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
            {
                this.this$0 = this$0;
                this.$l = $captured_local_variable$1;
            }
        };
    }

    @Override
    public void save() {
        this.gc.save();
    }

    @Override
    public void restore() {
        this.gc.restore();
    }

    @Override
    public void setGlobalAlpha(double alpha) {
        this.gc.setGlobalAlpha(alpha);
    }

    /*
     * WARNING - void declaration
     */
    public final void setPaint(@Nullable Paint paint) {
        if (paint != null) {
            this.paint = paint;
            if (paint instanceof Color) {
                this.setColor(new CPColor(this.awtColorToJavaFX((Color)paint)));
            } else if (paint instanceof GradientPaint) {
                Paint gp = paint;
                Stop[] stopArray = new Stop[2];
                Color color = ((GradientPaint)gp).getColor1();
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"gp.color1");
                stopArray[0] = new Stop(0.0, this.awtColorToJavaFX(color));
                Color color2 = ((GradientPaint)gp).getColor2();
                Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"gp.color2");
                stopArray[1] = new Stop(1.0, this.awtColorToJavaFX(color2));
                Stop[] stops = stopArray;
                Point2D p1 = ((GradientPaint)gp).getPoint1();
                Point2D p2 = ((GradientPaint)gp).getPoint2();
                Point2D point2D = p1;
                Intrinsics.checkNotNullExpressionValue((Object)point2D, (String)"p1");
                double d = point2D.getX();
                double d2 = p1.getY();
                Point2D point2D2 = p2;
                Intrinsics.checkNotNullExpressionValue((Object)point2D2, (String)"p2");
                LinearGradient lg = new LinearGradient(d, d2, point2D2.getX(), p2.getY(), false, CycleMethod.NO_CYCLE, Arrays.copyOf(stops, stops.length));
                this.gc.setStroke((javafx.scene.paint.Paint)lg);
                this.gc.setFill((javafx.scene.paint.Paint)lg);
            } else if (paint instanceof MultipleGradientPaint) {
                Paint mgp = paint;
                Color[] colors = ((MultipleGradientPaint)mgp).getColors();
                float[] fractions = ((MultipleGradientPaint)mgp).getFractions();
                Stop[] stops = new Stop[colors.length];
                int lg = 0;
                Intrinsics.checkNotNullExpressionValue((Object)colors, (String)"colors");
                int n = colors.length;
                while (lg < n) {
                    void i;
                    double d = fractions[i];
                    Color color = colors[i];
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"colors[i]");
                    stops[i] = new Stop(d, this.awtColorToJavaFX(color));
                    ++i;
                }
                Point2D center = null;
                Point2D focus = null;
                if (paint instanceof RadialGradientPaint) {
                    Paint rgp = paint;
                    Point2D point2D = ((RadialGradientPaint)rgp).getCenterPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point2D, (String)"rgp.centerPoint");
                    center = point2D;
                    Point2D point2D3 = ((RadialGradientPaint)rgp).getFocusPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point2D3, (String)"rgp.focusPoint");
                    focus = point2D3;
                    double focusDistance = focus.distance(center);
                    double focusAngle = 0.0;
                    if (Intrinsics.areEqual((Object)focus, (Object)center) ^ true) {
                        focusAngle = Math.atan2(focus.getY() - center.getY(), focus.getX() - center.getX());
                    }
                    double radius = ((RadialGradientPaint)rgp).getRadius();
                    RadialGradient rg = new RadialGradient(Math.toDegrees(focusAngle), focusDistance, center.getX(), center.getY(), radius, false, CycleMethod.NO_CYCLE, Arrays.copyOf(stops, stops.length));
                    this.gc.setStroke((javafx.scene.paint.Paint)rg);
                    this.gc.setFill((javafx.scene.paint.Paint)rg);
                } else if (paint instanceof LinearGradientPaint) {
                    Paint lgp = paint;
                    Point2D point2D = ((LinearGradientPaint)lgp).getStartPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point2D, (String)"lgp.startPoint");
                    center = point2D;
                    Point2D point2D4 = ((LinearGradientPaint)lgp).getEndPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point2D4, (String)"lgp.endPoint");
                    focus = point2D4;
                    LinearGradient lg2 = new LinearGradient(center.getX(), center.getY(), focus.getX(), focus.getY(), false, CycleMethod.NO_CYCLE, Arrays.copyOf(stops, stops.length));
                    this.gc.setStroke((javafx.scene.paint.Paint)lg2);
                    this.gc.setFill((javafx.scene.paint.Paint)lg2);
                }
            }
        }
    }

    @Override
    public void setFill(@Nullable CPColor c) {
        CPColor cPColor = c;
        Intrinsics.checkNotNull((Object)cPColor);
        this.gc.setFill((javafx.scene.paint.Paint)cPColor.getNative());
    }

    @Override
    public void setStroke(@Nullable CPColor c) {
        CPColor cPColor = c;
        Intrinsics.checkNotNull((Object)cPColor);
        this.gc.setStroke((javafx.scene.paint.Paint)cPColor.getNative());
    }

    @Override
    public void setColor(@Nullable CPColor c) {
        this.color = c;
        this.gc.setFill(c != null ? (javafx.scene.paint.Paint)c.getNative() : null);
        this.gc.setStroke(c != null ? (javafx.scene.paint.Paint)c.getNative() : null);
    }

    @Override
    public void setRadialGradient() {
    }

    @Override
    public boolean isPaintingForPrint() {
        return false;
    }

    @Override
    public void setPaintingForPrint(boolean paintingForPrint) {
    }

    @Override
    @NotNull
    public Object getNativeGraphics() {
        return this.gc;
    }

    @Override
    @NotNull
    public IGraphics getIGraphics() {
        return (IGraphics)new JavaFXIGraphics(this.gc);
    }

    @NotNull
    public final javafx.scene.paint.Color awtColorToJavaFX(@NotNull Color c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        javafx.scene.paint.Color color = javafx.scene.paint.Color.rgb((int)c.getRed(), (int)c.getGreen(), (int)c.getBlue(), (double)((double)c.getAlpha() / 255.0));
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"Color.rgb(c.red, c.green\u2026alpha.toDouble() / 255.0)");
        return color;
    }

    @Override
    @NotNull
    public CPColor getBackground() {
        return this.background;
    }

    @Override
    public void setBackground(@NotNull CPColor color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
    }

    @Override
    public void setLineWidth(double lw) {
        this.gc.setLineWidth(lw);
    }

    @Override
    public void setLineDash(@Nullable double[] dashPattern) {
        double[] dArray = dashPattern;
        Intrinsics.checkNotNull((Object)dashPattern);
        this.gc.setLineDashes(Arrays.copyOf(dArray, dArray.length));
    }

    @NotNull
    public final StrokeLineCap awtToJavaFXLineCap(int c) {
        StrokeLineCap strokeLineCap;
        if (c == 0) {
            strokeLineCap = StrokeLineCap.BUTT;
        } else if (c == 1) {
            strokeLineCap = StrokeLineCap.ROUND;
        } else if (c == 2) {
            strokeLineCap = StrokeLineCap.SQUARE;
        } else {
            throw (Throwable)new IllegalArgumentException("Unrecognised cap code: " + c);
        }
        return strokeLineCap;
    }

    @NotNull
    public final StrokeLineJoin awtToJavaFXLineJoin(int j) {
        StrokeLineJoin strokeLineJoin;
        if (j == 2) {
            strokeLineJoin = StrokeLineJoin.BEVEL;
        } else if (j == 0) {
            strokeLineJoin = StrokeLineJoin.MITER;
        } else if (j == 1) {
            strokeLineJoin = StrokeLineJoin.ROUND;
        } else {
            throw (Throwable)new IllegalArgumentException("Unrecognised join code: " + j);
        }
        return strokeLineJoin;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final double[] floatToDoubleArray(@Nullable float[] f) {
        double[] dArray;
        if (f == null) {
            dArray = null;
        } else {
            void var2_2;
            double[] d = new double[f.length];
            int n = 0;
            int n2 = f.length;
            while (n < n2) {
                void i;
                d[i] = f[i];
                ++i;
            }
            dArray = var2_2;
        }
        return dArray;
    }

    @Override
    public boolean isInterpolationBilinear() {
        return false;
    }

    @Override
    public void setInterpolationBilinear(boolean bilinear) {
    }

    @Override
    public boolean isAntialias() {
        return false;
    }

    @Override
    public void setAntialias(boolean antialias) {
    }

    @Override
    public boolean isTextAntialias() {
        return false;
    }

    @Override
    public void setTextAntialias(boolean antialias) {
    }

    @Override
    public void stroke(@Nullable Shape s) {
        boolean bl = this.stroke == null || this.stroke instanceof BasicStroke;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (s instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)s;
            this.gc.strokeRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        } else if (s instanceof RoundRectangle2D) {
            RoundRectangle2D rr = (RoundRectangle2D)s;
            this.gc.strokeRoundRect(rr.getX(), rr.getY(), rr.getWidth(), rr.getHeight(), rr.getArcWidth(), rr.getArcHeight());
        } else if (s instanceof Ellipse2D) {
            Ellipse2D e = (Ellipse2D)s;
            this.gc.strokeOval(e.getX(), e.getY(), e.getWidth(), e.getHeight());
        } else if (s instanceof Arc2D) {
            Arc2D a = (Arc2D)s;
            this.gc.strokeArc(a.getX(), a.getY(), a.getWidth(), a.getHeight(), a.getAngleStart(), a.getAngleExtent(), this.intToArcType(a.getArcType()));
        } else {
            Shape shape = s;
            Intrinsics.checkNotNull((Object)shape);
            this.shapeToPath(shape);
            this.gc.stroke();
        }
    }

    public final void shapeToPath(@NotNull Shape s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.gc.beginPath();
        PathIterator iterator2 = s.getPathIterator(null);
        while (!iterator2.isDone()) {
            int segType = iterator2.currentSegment(this.coords);
            switch (segType) {
                case 0: {
                    this.gc.moveTo(this.coords[0], this.coords[1]);
                    break;
                }
                case 1: {
                    this.gc.lineTo(this.coords[0], this.coords[1]);
                    break;
                }
                case 2: {
                    this.gc.quadraticCurveTo(this.coords[0], this.coords[1], this.coords[2], this.coords[3]);
                    break;
                }
                case 3: {
                    this.gc.bezierCurveTo(this.coords[0], this.coords[1], this.coords[2], this.coords[3], this.coords[4], this.coords[5]);
                    break;
                }
                case 4: {
                    this.gc.closePath();
                    break;
                }
                default: {
                    throw (Throwable)new RuntimeException("Unrecognised segment type " + segType);
                }
            }
            iterator2.next();
        }
    }

    @NotNull
    public final ArcType intToArcType(int t) {
        ArcType arcType;
        if (t == 1) {
            arcType = ArcType.CHORD;
        } else if (t == 0) {
            arcType = ArcType.OPEN;
        } else if (t == 2) {
            arcType = ArcType.ROUND;
        } else {
            throw (Throwable)new IllegalArgumentException("Unrecognised t: " + t);
        }
        return arcType;
    }

    @Override
    public void fill(@Nullable Shape s) {
        if (s instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)s;
            this.gc.fillRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        } else if (s instanceof RoundRectangle2D) {
            RoundRectangle2D rr = (RoundRectangle2D)s;
            this.gc.fillRoundRect(rr.getX(), rr.getY(), rr.getWidth(), rr.getHeight(), rr.getArcWidth(), rr.getArcHeight());
        } else if (s instanceof Ellipse2D) {
            Ellipse2D e = (Ellipse2D)s;
            this.gc.fillOval(e.getX(), e.getY(), e.getWidth(), e.getHeight());
        } else if (s instanceof Arc2D) {
            Arc2D a = (Arc2D)s;
            this.gc.fillArc(a.getX(), a.getY(), a.getWidth(), a.getHeight(), a.getAngleStart(), a.getAngleExtent(), this.intToArcType(a.getArcType()));
        } else {
            Shape shape = s;
            Intrinsics.checkNotNull((Object)shape);
            this.shapeToPath(shape);
            this.gc.fill();
        }
    }

    @Override
    @NotNull
    public CPFont getFont() {
        Font font = this.gc.getFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"gc.font");
        return new CPFont(font, null, null, 6, null);
    }

    @Override
    public void setFont(@NotNull CPFont font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        this.gc.setFont(font.getNativeFont());
    }

    @NotNull
    public final Rectangle2D getStringBounds(@Nullable String text) {
        Bounds stringBounds;
        Text t = new Text(text);
        t.setFont(this.gc.getFont());
        Bounds bounds = stringBounds = t.getLayoutBounds();
        Intrinsics.checkNotNullExpressionValue((Object)bounds, (String)"stringBounds");
        return (Rectangle2D)new Rectangle2D.Double(bounds.getMinX(), stringBounds.getMinY(), stringBounds.getWidth(), stringBounds.getHeight());
    }

    @Override
    public double getStringWidth(@Nullable String text) {
        return this.getStringBounds(text).getWidth();
    }

    @Override
    public void fillText(@Nullable String str, int x, int y) {
        this.fillText(str, (float)x, (float)y);
    }

    @Override
    public void fillText(@Nullable String str, float x, float y) {
        if (str == null) {
            throw (Throwable)new NullPointerException("Null 'str' argument.");
        }
        this.gc.fillText(str, (double)x, (double)y);
    }

    @Override
    public void translate(int tx, int ty) {
        this.translate((double)tx, (double)ty);
    }

    @Override
    public void translate(double tx, double ty) {
        AffineTransform affineTransform = this.getTransform();
        Intrinsics.checkNotNull((Object)affineTransform);
        affineTransform.translate(tx, ty);
        this.gc.translate(tx, ty);
    }

    @Override
    public void rotate(double theta) {
        AffineTransform affineTransform = this.getTransform();
        Intrinsics.checkNotNull((Object)affineTransform);
        affineTransform.rotate(theta);
        this.gc.rotate(Math.toDegrees(theta));
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.translate(x, y);
        this.rotate(theta);
        this.translate(-x, -y);
    }

    @Override
    public void scale(double sx, double sy) {
        AffineTransform affineTransform = this.getTransform();
        Intrinsics.checkNotNull((Object)affineTransform);
        affineTransform.scale(sx, sy);
        this.gc.scale(sx, sy);
    }

    @Override
    public void shear(double shx, double shy) {
        this.transform(AffineTransform.Companion.getShearInstance(shx, shy));
    }

    @Override
    public void transform(@Nullable AffineTransform t) {
        AffineTransform tx;
        AffineTransform affineTransform = tx = this.getTransform();
        Intrinsics.checkNotNull((Object)affineTransform);
        AffineTransform affineTransform2 = t;
        Intrinsics.checkNotNull((Object)affineTransform2);
        affineTransform.concatenate(affineTransform2);
        this.setTransform(tx);
    }

    @Override
    @Nullable
    public AffineTransform getTransform() {
        AffineTransform affineTransform = this.transform;
        Intrinsics.checkNotNull((Object)affineTransform);
        return new AffineTransform(affineTransform);
    }

    @Override
    public void setTransform(@Nullable AffineTransform t) {
        AffineTransform t2 = t;
        if (t2 == null) {
            this.transform = new AffineTransform();
            t2 = this.getTransform();
        } else {
            this.transform = new AffineTransform(t2);
        }
        AffineTransform affineTransform = t2;
        Intrinsics.checkNotNull((Object)affineTransform);
        this.gc.setTransform(affineTransform.getScaleX(), t2.getShearY(), t2.getShearX(), t2.getScaleY(), t2.getTranslateX(), t2.getTranslateY());
    }

    @Override
    public void clip(@Nullable Shape s) {
        if (s instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)s;
            this.gc.beginPath();
            this.gc.rect(Math.floor(r.getX()), Math.floor(r.getY()), Math.ceil(r.getWidth()), Math.ceil(r.getHeight()));
        } else {
            Shape shape = s;
            Intrinsics.checkNotNull((Object)shape);
            this.shapeToPath(shape);
        }
        this.gc.clip();
    }

    @Override
    public void strokeLine(int x1, int y1, int x2, int y2) {
        this.gc.strokeLine((double)x1, (double)y1, (double)x2, (double)y2);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.gc.fillRect((double)x, (double)y, (double)width, (double)height);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        if (this.getBackground() != null) {
            this.fillRect(x, y, width, height);
        }
    }

    @Override
    public void strokeRect(double x, double y, double width, double height) {
        this.gc.strokeRect(x, y, width, height);
    }

    @Override
    public void fillRect(double x, double y, double width, double height) {
        this.gc.fillRect(x, y, width, height);
    }

    @Override
    public void strokeRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        this.gc.strokeRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        this.gc.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.gc.strokeOval((double)x, (double)y, (double)width, (double)height);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.gc.fillOval((double)x, (double)y, (double)width, (double)height);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.gc.strokeArc((double)x, (double)y, (double)width, (double)height, (double)startAngle, (double)arcAngle, this.intToArcType(0));
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.gc.fillArc((double)x, (double)y, (double)width, (double)height, (double)startAngle, (double)arcAngle, this.intToArcType(0));
    }

    @Override
    public void drawPolyline(@Nullable int[] xPoints, @Nullable int[] yPoints, int nPoints) {
        Intrinsics.checkNotNull((Object)xPoints);
        Intrinsics.checkNotNull((Object)yPoints);
        GeneralPath p = this.createPolygon(xPoints, yPoints, nPoints, false);
        this.stroke((Shape)p);
    }

    @Override
    public void drawPolygon(@Nullable int[] xPoints, @Nullable int[] yPoints, int nPoints) {
        Intrinsics.checkNotNull((Object)xPoints);
        Intrinsics.checkNotNull((Object)yPoints);
        GeneralPath p = this.createPolygon(xPoints, yPoints, nPoints, true);
        this.stroke((Shape)p);
    }

    @Override
    public void fillPolygon(@Nullable int[] xPoints, @Nullable int[] yPoints, int nPoints) {
        Intrinsics.checkNotNull((Object)xPoints);
        Intrinsics.checkNotNull((Object)yPoints);
        GeneralPath p = this.createPolygon(xPoints, yPoints, nPoints, true);
        this.fill((Shape)p);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final GeneralPath createPolygon(@NotNull int[] xPoints, @NotNull int[] yPoints, int nPoints, boolean close) {
        Intrinsics.checkNotNullParameter((Object)xPoints, (String)"xPoints");
        Intrinsics.checkNotNullParameter((Object)yPoints, (String)"yPoints");
        GeneralPath p = new GeneralPath();
        p.moveTo((double)xPoints[0], (double)yPoints[0]);
        int n = 1;
        int n2 = nPoints;
        while (n < n2) {
            void i;
            p.lineTo((double)xPoints[i], (double)yPoints[i]);
            ++i;
        }
        if (close) {
            p.closePath();
        }
        return p;
    }

    @Override
    @NotNull
    public CPImage createImage(int width, int height) {
        return new CPImage(width, height);
    }

    public final boolean drawNativeImage(@Nullable Image img, int x, int y) {
        boolean bl;
        if (img == null) {
            bl = true;
        } else {
            int w = img.getWidth(null);
            if (w < 0) {
                bl = false;
            } else {
                int h = img.getHeight(null);
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean drawImage(@Nullable CPImage img, int x, int y) {
        CPImage cPImage = img;
        Intrinsics.checkNotNull((Object)cPImage);
        WritableImage writableImage = cPImage.getNativeImage();
        if (writableImage == null) {
            throw new NullPointerException("null cannot be cast to non-null type javafx.scene.image.WritableImage");
        }
        WritableImage nativeImage = writableImage;
        this.gc.drawImage((javafx.scene.image.Image)nativeImage, (double)x, (double)y);
        return true;
    }

    @Override
    public boolean drawImage(@Nullable CPImage img, int x, int y, int w, int h) {
        CPImage cPImage = img;
        Intrinsics.checkNotNull((Object)cPImage);
        WritableImage writableImage = cPImage.getNativeImage();
        if (writableImage == null) {
            throw new NullPointerException("null cannot be cast to non-null type javafx.scene.image.WritableImage");
        }
        WritableImage nativeImage = writableImage;
        this.gc.drawImage((javafx.scene.image.Image)nativeImage, (double)x, (double)y, (double)w, (double)h);
        return true;
    }

    public JavaFXTGraphics(@NotNull GraphicsContext gc) {
        Intrinsics.checkNotNullParameter((Object)gc, (String)"gc");
        this.gc = gc;
        this.headless = new Headless();
        this.background = CPColorFactory.Companion.getInstance().getBlack();
        Color color = Color.BLACK;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"java.awt.Color.BLACK");
        this.paint = color;
        this.color = CPColorFactory.Companion.getInstance().getBlack();
        this.stroke = new BasicStroke(1.0f);
        this.setFont(new CPFont(new Font("SansSerif", 12.0), null, null, 6, null));
        this.setTransform(new AffineTransform());
        this.setBackground(CPColorFactory.Companion.getInstance().getBlack());
        this.coords = new double[6];
        this.zeroStrokeWidth = 0.5;
        this.hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ Headless access$getHeadless$p(JavaFXTGraphics $this) {
        return $this.headless;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/treemap/crossplatform/JavaFXTGraphics$Companion;", "", "()V", "text", "Ljavafx/scene/text/Text;", "getText", "()Ljavafx/scene/text/Text;", "setText", "(Ljavafx/scene/text/Text;)V", "treemap"})
    public static final class Companion {
        @Nullable
        public final Text getText() {
            return text;
        }

        public final void setText(@Nullable Text text) {
            JavaFXTGraphics.text = text;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

