/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.treemap.Cushion;
import com.treemap.MutableTreeMapNode;
import com.treemap.TreeMapModel;
import java.lang.ref.SoftReference;
import java.util.Collection;
import javafx.scene.paint.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;
import org.mkui.graphics.CPImage;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0007\b'\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00020\u0003B-\b\u0004\u0012$\u0010\u0004\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u00102\u001a\u0002032\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000H&J\n\u00105\u001a\u0004\u0018\u00010\u0018H\u0002J \u00106\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00002\b\u00107\u001a\u0004\u0018\u000108H&J\b\u00109\u001a\u00020\u001bH&J\u001c\u0010:\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000\u0018\u00010;H&J\u001c\u0010<\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000\u0018\u00010;H&J\b\u0010=\u001a\u0004\u0018\u00010\u0015J\u000e\u0010>\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u000eJ\b\u0010?\u001a\u0004\u0018\u00010\u0018J\b\u0010@\u001a\u0004\u0018\u00010AJ\n\u0010B\u001a\u0004\u0018\u000108H&J\u0014\u0010C\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000J\u001b\u0010D\u001a\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00000E\u00a2\u0006\u0002\u0010FJ\r\u0010G\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010HJ\u0014\u0010I\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000H\u0004J\u0006\u0010J\u001a\u00020KJ#\u0010L\u001a\u0004\u0018\u00010M2\b\u0010\"\u001a\u0004\u0018\u00010M2\b\u0010N\u001a\u0004\u0018\u00018\u0001H\u0004\u00a2\u0006\u0002\u0010OJ\u001a\u0010P\u001a\u0002032\u0012\u0010Q\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000J\b\u0010R\u001a\u00020AH\u0016J#\u0010S\u001a\u0004\u0018\u00010M2\b\u0010\"\u001a\u0004\u0018\u00010M2\b\u0010N\u001a\u0004\u0018\u00018\u0001H\u0004\u00a2\u0006\u0002\u0010OR\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR4\u0010\u000f\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u000e2\u000e\u0010\f\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u000e@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017j\n\u0012\u0004\u0012\u00020\u0018\u0018\u0001`\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u001bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR2\u0010\u0004\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R(\u0010$\u001a\u0004\u0018\u00010#2\b\u0010\"\u001a\u0004\u0018\u00010#8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R(\u0010)\u001a\u0004\u0018\u00010#2\b\u0010)\u001a\u0004\u0018\u00010#@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010&\"\u0004\b+\u0010(R\u001a\u0010,\u001a\u00020-X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101\u00a8\u0006T"}, d2={"Lcom/treemap/AbstractTreeMapNode;", "Row", "Column", "Lcom/treemap/MutableTreeMapNode;", "model", "Lcom/treemap/TreeMapModel;", "(Lcom/treemap/TreeMapModel;)V", "_parent", "bounds", "Lorg/mkui/geom/Rectangle2D;", "getBounds", "()Lorg/mkui/geom/Rectangle2D;", "c", "Ljavafx/scene/paint/Color;", "Lorg/mkui/color/MkColor;", "color", "getColor", "()Ljavafx/scene/paint/Color;", "setColor", "(Ljavafx/scene/paint/Color;)V", "cushion", "Lcom/treemap/Cushion;", "cushionImageReference", "Ljava/lang/ref/SoftReference;", "Lorg/mkui/graphics/CPImage;", "Lcom/macrofocus/common/collection/SoftReference;", "level", "", "getLevel", "()I", "setLevel", "(I)V", "getModel", "()Lcom/treemap/TreeMapModel;", "value", "Lorg/mkui/geom/Shape;", "nestedShape", "getNestedShape", "()Lorg/mkui/geom/Shape;", "setNestedShape", "(Lorg/mkui/geom/Shape;)V", "shape", "getShape", "setShape", "size", "", "getSize", "()D", "setSize", "(D)V", "add", "", "newChild", "createCushionImage", "findChild", "name", "", "getChildCount", "getChildren", "", "getChildrenOfTypeParent", "getCushion", "getCushionColor", "getCushionImage", "getLabelName", "", "getNodeName", "getParent", "getPath", "", "()[Lcom/treemap/AbstractTreeMapNode;", "getRow", "()Ljava/lang/Object;", "getSelf", "isRoot", "", "normalizedToWorld", "", "columnIndex", "(Ljava/lang/Number;Ljava/lang/Object;)Ljava/lang/Number;", "setParent", "parent", "toString", "worldToNormalized", "treemap"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAbstractTreeMapNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractTreeMapNode.kt\ncom/treemap/AbstractTreeMapNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,281:1\n1#2:282\n*E\n"})
public abstract class AbstractTreeMapNode<Row, Column>
implements MutableTreeMapNode<Column> {
    private double size;
    @Nullable
    private Shape shape;
    @NotNull
    private final TreeMapModel<AbstractTreeMapNode<Row, Column>, Row, Column> model;
    @Nullable
    private Color color;
    @Nullable
    private Cushion cushion;
    @Nullable
    private SoftReference<CPImage> cushionImageReference;
    @Nullable
    private AbstractTreeMapNode<Row, Column> _parent;
    private int level;
    public static final int $stable = 8;

    protected AbstractTreeMapNode(@NotNull TreeMapModel<AbstractTreeMapNode<Row, Column>, Row, Column> model) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        this.size = 1.0;
        this.model = model;
        this.setColor(model.getColorFactory().getLightGray());
    }

    @Override
    public double getSize() {
        return this.size;
    }

    @Override
    public void setSize(double d) {
        this.size = d;
    }

    @Override
    @Nullable
    public Shape getShape() {
        return this.shape;
    }

    @Override
    public void setShape(@Nullable Shape shape) {
        block6: {
            block5: {
                if (this.shape == null) break block5;
                Shape shape2 = this.shape;
                Intrinsics.checkNotNull((Object)shape2);
                if (shape2.equals(shape)) break block6;
            }
            this.shape = shape;
            this.cushion = null;
            if (this.cushionImageReference != null) {
                SoftReference<CPImage> softReference = this.cushionImageReference;
                Intrinsics.checkNotNull(softReference);
                CPImage cushionImage = softReference.get();
                if (cushionImage != null) {
                    cushionImage.flush();
                }
                this.cushionImageReference = null;
            }
        }
    }

    @NotNull
    protected final TreeMapModel<AbstractTreeMapNode<Row, Column>, Row, Column> getModel() {
        return this.model;
    }

    @Override
    @Nullable
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(@Nullable Color c) {
        this.color = c;
        this.cushion = null;
        if (this.cushionImageReference != null) {
            SoftReference<CPImage> softReference = this.cushionImageReference;
            Intrinsics.checkNotNull(softReference);
            CPImage cushionImage = softReference.get();
            if (cushionImage != null) {
                cushionImage.flush();
            }
            this.cushionImageReference = null;
        }
    }

    @Override
    @Nullable
    public Shape getNestedShape() {
        return this.getShape();
    }

    @Override
    public void setNestedShape(@Nullable Shape value) {
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public abstract int getChildCount();

    @Nullable
    public final AbstractTreeMapNode<Row, Column> getParent() {
        return this._parent;
    }

    public final boolean isRoot() {
        return this._parent == null;
    }

    @Nullable
    public abstract Iterable<AbstractTreeMapNode<Row, Column>> getChildren();

    @Nullable
    public abstract Iterable<AbstractTreeMapNode<Row, Column>> getChildrenOfTypeParent();

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AbstractTreeMapNode<?, ?>[] getPath() {
        AbstractTreeMapNode[] abstractTreeMapNodeArray;
        AbstractTreeMapNode<Row, Column> parent = this.getParent();
        if (parent != null) {
            void var3_4;
            int parentLevel = parent.getLevel();
            AbstractTreeMapNode[] path = new AbstractTreeMapNode[parentLevel + 2];
            AbstractTreeMapNode<Row, Column> ancestor = null;
            ancestor = this;
            int i = parentLevel + 1;
            path[i] = this;
            --i;
            while (true) {
                AbstractTreeMapNode<Row, Column> abstractTreeMapNode;
                AbstractTreeMapNode<Row, Column> it = abstractTreeMapNode = ancestor.getParent();
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                if (abstractTreeMapNode == null) break;
                path[i] = ancestor;
                --i;
            }
            abstractTreeMapNodeArray = var3_4;
        } else {
            AbstractTreeMapNode[] abstractTreeMapNodeArray2 = new AbstractTreeMapNode[]{this};
            abstractTreeMapNodeArray = abstractTreeMapNodeArray2;
        }
        return abstractTreeMapNodeArray;
    }

    public abstract void add(@NotNull AbstractTreeMapNode<Row, Column> var1);

    public final void setParent(@NotNull AbstractTreeMapNode<Row, Column> parent) {
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        this._parent = parent;
        AbstractTreeMapNode<Row, Column> abstractTreeMapNode = this.getParent();
        Intrinsics.checkNotNull(abstractTreeMapNode);
        this.setLevel(abstractTreeMapNode.getLevel() + 1);
    }

    @Nullable
    public abstract AbstractTreeMapNode<Row, Column> findChild(@Nullable Object var1);

    @Nullable
    public abstract Object getNodeName();

    public abstract Row getRow();

    @Nullable
    public final String getLabelName() {
        String string;
        Column column;
        if (this.model.getSettings().getBackgroundColumn() != null && (column = this.model.getSettings().getBackgroundColumn()) != null && this.hasNoChildren()) {
            String string2;
            if (!this.model.isNumericType(column)) {
                Object value;
                Object object = value = this.model.getValueAt(this, column);
                string2 = object != null ? object.toString() : null;
            } else {
                Object value;
                Object object = value = this.model.getValueAt(this, column);
                string2 = object != null ? object.toString() : null;
            }
            return string2;
        }
        if (this.model.getSettings().getLabelsColumns() != null && !((Collection)this.model.getSettings().getLabelsColumns()).isEmpty()) {
            column = this.model.getSettings().getLabelsColumns().get(0);
            if (column != null || !this.hasNoChildren()) {
                string = this.getNodeName() != null ? String.valueOf(this.getNodeName()) : null;
            } else if (!this.model.isNumericType(column)) {
                Object value;
                Object object = value = this.model.getValueAt(this, column);
                string = object != null ? object.toString() : null;
            } else {
                Object value;
                Object object = value = this.model.getValueAt(this, column);
                string = object != null ? object.toString() : null;
            }
        } else {
            string = this.getNodeName() != null ? String.valueOf(this.getNodeName()) : null;
        }
        return string;
    }

    @Nullable
    protected final Number worldToNormalized(@Nullable Number value, @Nullable Column columnIndex) {
        Number number;
        Number min = this.model.getNumericMin(columnIndex);
        Number max = this.model.getNumericMax(columnIndex);
        if (min != null && max != null && value != null) {
            double range = max.doubleValue() - min.doubleValue();
            number = (value.doubleValue() - min.doubleValue()) / range;
        } else {
            number = null;
        }
        return number;
    }

    @Nullable
    protected final Number normalizedToWorld(@Nullable Number value, @Nullable Column columnIndex) {
        Number number;
        Number min = this.model.getNumericMin(columnIndex);
        Number max = this.model.getNumericMax(columnIndex);
        if (min != null && max != null && value != null) {
            double range = max.doubleValue() - min.doubleValue();
            number = value.doubleValue() * range + min.doubleValue();
        } else {
            number = null;
        }
        return number;
    }

    @Override
    @Nullable
    public Rectangle2D getBounds() {
        Rectangle2D rectangle2D;
        if (this.getShape() != null) {
            Shape shape = this.getShape();
            Intrinsics.checkNotNull((Object)shape);
            rectangle2D = shape.getBounds2D();
        } else {
            rectangle2D = null;
        }
        return rectangle2D;
    }

    @NotNull
    public String toString() {
        String string = this.getLabelName();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Cushion getCushion() {
        Cushion cushion;
        if (this.cushion != null) {
            cushion = this.cushion;
        } else {
            void var1_1;
            Cushion data = null;
            AbstractTreeMapNode<Row, Column> parent = this.getParent();
            if (parent != null && this.getShape() != null) {
                Rectangle bounds = null;
                if (this.getShape() instanceof Rectangle) {
                    Shape shape = this.getShape();
                    Intrinsics.checkNotNull((Object)shape, (String)"null cannot be cast to non-null type org.mkui.geom.Rectangle");
                    bounds = (Rectangle)shape;
                } else {
                    Shape shape = this.getShape();
                    Intrinsics.checkNotNull((Object)shape);
                    Rectangle2D b = shape.getBounds2D();
                    bounds = new Rectangle((int)b.getX(), (int)b.getY(), (int)b.getWidth(), (int)b.getHeight());
                }
                int top = bounds.getIy();
                int bottom = bounds.getIy() + bounds.getIheight();
                int left = bounds.getIx();
                int right = bounds.getIx() + bounds.getIwidth();
                data = parent.getParent() == null ? new Cushion(this.model, left, right, bounds.getIwidth(), top, bottom, bounds.getIheight()) : new Cushion(parent.getCushion(), this.model, left, right, bounds.getIwidth(), top, bottom, bounds.getIheight());
            }
            this.cushion = data;
            cushion = var1_1;
        }
        return cushion;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final CPImage getCushionImage() {
        CPImage cPImage;
        if (this.cushionImageReference == null) {
            CPImage image = this.createCushionImage();
            if (image != null) {
                this.cushionImageReference = new SoftReference<CPImage>(image);
                cPImage = image;
            } else {
                cPImage = null;
            }
        } else {
            void var1_2;
            SoftReference<CPImage> softReference = this.cushionImageReference;
            Intrinsics.checkNotNull(softReference);
            CPImage image = softReference.get();
            if (image == null) {
                image = this.createCushionImage();
                if (image != null) {
                    this.cushionImageReference = new SoftReference<CPImage>(image);
                } else {
                    return null;
                }
            }
            cPImage = var1_2;
        }
        return cPImage;
    }

    private final CPImage createCushionImage() {
        if (this.getShape() == null) {
            return null;
        }
        Rectangle bounds = null;
        if (this.getShape() instanceof Rectangle) {
            Shape shape = this.getShape();
            Intrinsics.checkNotNull((Object)shape, (String)"null cannot be cast to non-null type org.mkui.geom.Rectangle");
            bounds = (Rectangle)shape;
        } else {
            Shape shape = this.getShape();
            Intrinsics.checkNotNull((Object)shape);
            Rectangle2D b = shape.getBounds2D();
            bounds = new Rectangle((int)b.getX(), (int)b.getY(), (int)b.getWidth(), (int)b.getHeight());
        }
        int width = Math.max(1, bounds.getIwidth());
        int height = Math.max(1, bounds.getIheight());
        CPImage image = new CPImage(width, height);
        Cushion cushion = this.getCushion();
        Intrinsics.checkNotNull((Object)cushion);
        cushion.fillRaster(this.model, this.getColor(), bounds.getIx(), bounds.getIy(), width, height, image);
        return image;
    }

    @Nullable
    public final Color getCushionColor() {
        if (this.getShape() == null) {
            return null;
        }
        Rectangle bounds = null;
        if (this.getShape() instanceof Rectangle) {
            Shape shape = this.getShape();
            Intrinsics.checkNotNull((Object)shape, (String)"null cannot be cast to non-null type org.mkui.geom.Rectangle");
            bounds = (Rectangle)shape;
        } else {
            Shape shape = this.getShape();
            Intrinsics.checkNotNull((Object)shape);
            Rectangle2D b = shape.getBounds2D();
            bounds = new Rectangle((int)b.getX(), (int)b.getY(), (int)b.getWidth(), (int)b.getHeight());
        }
        int width = Math.max(1, bounds.getIwidth());
        int height = Math.max(1, bounds.getIheight());
        Cushion cushion = this.getCushion();
        Intrinsics.checkNotNull((Object)cushion);
        return cushion.computeColor(this.model, this.getColor(), bounds.getIx(), bounds.getIy(), width, height);
    }

    @NotNull
    protected final AbstractTreeMapNode<Row, Column> getSelf() {
        return this;
    }
}

