/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.treemap.ColoredSurroundLabeling;
import com.treemap.ExpandLabeling;
import com.treemap.Labeling;
import com.treemap.NoneLabeling;
import com.treemap.OverlayLabeling;
import com.treemap.SurroundLabeling;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001b\b\u0002\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u0011\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0086\u0002J\u0006\u0010\r\u001a\u00020\u0004J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/treemap/LabelingFactory;", "", "entries", "", "Lcom/treemap/Labeling;", "([Lcom/treemap/Labeling;)V", "", "add", "", "entry", "get", "name", "", "getDefault", "getLabelings", "", "Companion", "treemap"})
@StabilityInferred(parameters=0)
public final class LabelingFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Labeling> entries = new ArrayList();
    public static final int $stable = 8;
    @NotNull
    private static final Labeling OVERLAY = new OverlayLabeling();
    @NotNull
    private static final SurroundLabeling SURROUND = new SurroundLabeling();
    @NotNull
    private static final SurroundLabeling COLORED_SURROUND = new ColoredSurroundLabeling();
    @NotNull
    private static final Labeling NONE = new NoneLabeling();
    @NotNull
    private static final Labeling EXPAND = new ExpandLabeling();
    @NotNull
    private static final LabelingFactory ourInstance;

    private LabelingFactory(Labeling ... entries) {
        CollectionsKt.addAll((Collection)this.entries, (Object[])entries);
    }

    public final void add(@NotNull Labeling entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.entries.add(entry);
    }

    @NotNull
    public final Labeling getDefault() {
        return SURROUND;
    }

    @NotNull
    public final List<Labeling> getLabelings() {
        return this.entries;
    }

    @NotNull
    public final Labeling get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        for (Labeling labeling : this.entries) {
            if (!labeling.toString().equals(name)) continue;
            return labeling;
        }
        if (Intrinsics.areEqual((Object)"On top", (Object)name)) {
            return SURROUND;
        }
        if (Intrinsics.areEqual((Object)"On top (no border)", (Object)name)) {
            return OVERLAY;
        }
        if (Intrinsics.areEqual((Object)"Overlaid", (Object)name)) {
            return EXPAND;
        }
        if (Intrinsics.areEqual((Object)"Leaf Only", (Object)name)) {
            return NONE;
        }
        return this.getDefault();
    }

    static {
        Labeling[] labelingArray = new Labeling[]{OVERLAY, SURROUND, COLORED_SURROUND, NONE, EXPAND};
        ourInstance = new LabelingFactory(labelingArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0013\u001a\u00020\u0012R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/treemap/LabelingFactory$Companion;", "", "()V", "COLORED_SURROUND", "Lcom/treemap/SurroundLabeling;", "getCOLORED_SURROUND", "()Lcom/treemap/SurroundLabeling;", "EXPAND", "Lcom/treemap/Labeling;", "getEXPAND", "()Lcom/treemap/Labeling;", "NONE", "getNONE", "OVERLAY", "getOVERLAY", "SURROUND", "getSURROUND", "ourInstance", "Lcom/treemap/LabelingFactory;", "getInstance", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Labeling getOVERLAY() {
            return OVERLAY;
        }

        @NotNull
        public final SurroundLabeling getSURROUND() {
            return SURROUND;
        }

        @NotNull
        public final SurroundLabeling getCOLORED_SURROUND() {
            return COLORED_SURROUND;
        }

        @NotNull
        public final Labeling getNONE() {
            return NONE;
        }

        @NotNull
        public final Labeling getEXPAND() {
            return EXPAND;
        }

        @NotNull
        public final LabelingFactory getInstance() {
            return ourInstance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

