/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.common.command.Future;
import com.treemap.Depth;
import com.treemap.NodeRenderer;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapRenderer;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.TGraphics;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u001b*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004:\u0001\u001bB!\b\u0016\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B'\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ8\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0014H\u0016Jo\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00122\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0014H\u0002\u00a2\u0006\u0002\u0010\u001aR \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/treemap/NodesTreeMapRenderer;", "N", "Row", "Column", "Lcom/treemap/TreeMapRenderer;", "nodeRenderer", "Lcom/treemap/NodeRenderer;", "(Lcom/treemap/NodeRenderer;)V", "selectedPass", "", "(Lcom/treemap/NodeRenderer;I)V", "_nodeRenderer", "_selectedPass", "paint", "", "g2", "Lcom/treemap/crossplatform/TGraphics;", "view", "Lcom/treemap/TreeMapView;", "progress", "Lcom/macrofocus/common/command/Future;", "model", "Lcom/treemap/TreeMapModel;", "root", "pass", "passes", "(Lcom/treemap/crossplatform/TGraphics;Lcom/treemap/TreeMapView;Lcom/treemap/TreeMapModel;Ljava/lang/Object;IILcom/macrofocus/common/command/Future;)V", "Companion", "treemap"})
public final class NodesTreeMapRenderer<N, Row, Column>
implements TreeMapRenderer<N, Row, Column> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NodeRenderer<N, Row, Column> _nodeRenderer;
    private final int _selectedPass;
    private static final boolean SOFT_CLIPPING = true;

    public NodesTreeMapRenderer(@NotNull NodeRenderer<N, Row, Column> nodeRenderer, int selectedPass) {
        Intrinsics.checkNotNullParameter(nodeRenderer, (String)"nodeRenderer");
        this._nodeRenderer = nodeRenderer;
        this._selectedPass = selectedPass;
    }

    public NodesTreeMapRenderer(@NotNull NodeRenderer<N, Row, Column> nodeRenderer) {
        Intrinsics.checkNotNullParameter(nodeRenderer, (String)"nodeRenderer");
        this(nodeRenderer, -1);
    }

    @Override
    public void paint(@NotNull TGraphics g2, @NotNull TreeMapView<N, Row, Column> view, @Nullable Future<?> progress) {
        N root;
        TreeMapModel<N, Row, Column> model;
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter(view, (String)"view");
        if ((progress == null || !progress.isCancelled()) && (model = view.getModel()) != null && (root = model.getCurrentRoot()) != null && this._nodeRenderer.isEnabled(view)) {
            int passes = this._nodeRenderer.getPasses(model);
            if (this._selectedPass >= 0) {
                if (this._selectedPass < passes) {
                    this.paint(g2, view, model, root, this._selectedPass, passes, progress);
                }
            } else {
                for (int pass = 0; pass < passes; ++pass) {
                    this.paint(g2, view, model, root, pass, passes, progress);
                }
            }
        }
    }

    private final void paint(TGraphics g2, TreeMapView<N, Row, Column> view, TreeMapModel<N, Row, Column> model, N root, int pass, int passes, Future<?> progress) {
        boolean completed = true;
        Rectangle2D.Double screenBounds = new Rectangle2D.Double(0.0, 0.0, (double)view.getScreenTransform().getX().getScreenSize(), (double)view.getScreenTransform().getY().getScreenSize());
        g2.softClip((Shape)screenBounds);
        for (N node : this._nodeRenderer.getOrder(view, root, pass)) {
            if (progress == null || !progress.isCancelled()) {
                Shape shape;
                if (model.isRoot(node) || !this._nodeRenderer.shouldPaint(view, node)) continue;
                int depth = model.getLevel(node) - model.getLevel(root);
                Depth depth2 = model.getSettings().getDepth();
                Intrinsics.checkNotNull((Object)depth2);
                if (!depth2.display(depth) || (shape = view.worldToScreen(node)) == null) continue;
                Rectangle bounds = shape.getBounds();
                boolean hitClip = g2.hitClip(bounds);
                if (!hitClip) continue;
                completed &= this._nodeRenderer.paintNode(g2, view, node, pass, passes, bounds, shape);
                continue;
            }
            return;
        }
        if (!completed) {
            view.repaint();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/treemap/NodesTreeMapRenderer$Companion;", "", "()V", "SOFT_CLIPPING", "", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

