/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.treemap.AbstractAlgorithm;
import com.treemap.TreeMapAccessor;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapWorker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.Arc2D;
import org.mkui.geom.Ellipse2D;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Jm\u0010\u0006\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u0007\"\u0004\b\u0001\u0010\b\"\u0004\b\u0002\u0010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u0002H\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00070\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0012\u0010\u0019\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016JG\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00070\u001b\"\u0004\b\u0000\u0010\u0007\"\u0004\b\u0001\u0010\b\"\u0004\b\u0002\u0010\t2\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t0\u001d2\u0006\u0010\u001e\u001a\u0002H\u0007H\u0016\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020!H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\""}, d2={"Lcom/treemap/PieAlgorithm;", "Lcom/treemap/AbstractAlgorithm;", "()V", "isSpaceFilling", "", "()Z", "breadthFirstLayout", "N", "Row", "Column", "shape", "Lorg/mkui/geom/Shape;", "parent", "children", "", "sumSizes", "", "horizontalVanishingPoint", "", "verticalVanishingPoint", "accessor", "Lcom/treemap/TreeMapAccessor;", "worker", "Lcom/treemap/TreeMapWorker;", "(Lorg/mkui/geom/Shape;Ljava/lang/Object;[Ljava/lang/Object;DIILcom/treemap/TreeMapAccessor;Lcom/treemap/TreeMapWorker;)Z", "isCompatible", "iterator", "", "model", "Lcom/treemap/TreeMapModel;", "root", "(Lcom/treemap/TreeMapModel;Ljava/lang/Object;)Ljava/lang/Iterable;", "toString", "", "treemap"})
@StabilityInferred(parameters=0)
public final class PieAlgorithm
extends AbstractAlgorithm {
    public static final int $stable;

    @Override
    @NotNull
    public <N, Row, Column> Iterable<N> iterator(@NotNull TreeMapModel<N, Row, Column> model, N root) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        return model.depthFirstIterator(root);
    }

    @Override
    public <N, Row, Column> boolean breadthFirstLayout(@NotNull Shape shape, N parent, @NotNull N[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, @NotNull TreeMapAccessor<? super N> accessor, @Nullable TreeMapWorker worker) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
        Rectangle2D bounds = shape.getBounds2D();
        double size = Math.min(bounds.getWidth(), bounds.getHeight());
        double shiftX = (bounds.getWidth() - size) / (double)2;
        double shiftY = (bounds.getHeight() - size) / (double)2;
        bounds = (Rectangle2D)new Rectangle2D.Double(bounds.getX() + shiftX, bounds.getY() + shiftY, size, size);
        double startAngle = 90.0;
        for (N child : children) {
            double arcAngle = accessor.getSize(child) * (double)360 / sumSizes;
            accessor.setShape(child, (Shape)new Arc2D.Double(bounds, startAngle, -arcAngle, 2));
            startAngle -= arcAngle;
        }
        return false;
    }

    @Override
    public boolean isCompatible(@Nullable Shape shape) {
        return shape instanceof Rectangle2D || shape instanceof Ellipse2D;
    }

    @Override
    public boolean isSpaceFilling() {
        return false;
    }

    @NotNull
    public String toString() {
        return "Pie";
    }
}

