/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.treemap.AbstractAlgorithm;
import com.treemap.TreeMapAccessor;
import com.treemap.TreeMapWorker;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004Jm\u0010\u0005\u001a\u00020\u0003\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u0002H\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00060\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J=\u0010\u0018\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00060\r2\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0014\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0012\u0010\u001e\u001a\u00020\u00032\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016JI\u0010\u001f\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00060\r2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0014\u00a2\u0006\u0002\u0010\"JQ\u0010#\u001a\u00020$\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00060\r2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0014\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/treemap/StripAlgorithm;", "Lcom/treemap/AbstractAlgorithm;", "lookAhead", "", "(Z)V", "breadthFirstLayout", "N", "Row", "Column", "shape", "Lorg/mkui/geom/Shape;", "parent", "children", "", "sumSizes", "", "horizontalVanishingPoint", "", "verticalVanishingPoint", "accessor", "Lcom/treemap/TreeMapAccessor;", "worker", "Lcom/treemap/TreeMapWorker;", "(Lorg/mkui/geom/Shape;Ljava/lang/Object;[Ljava/lang/Object;DIILcom/treemap/TreeMapAccessor;Lcom/treemap/TreeMapWorker;)Z", "computeAverageAspectRatio", "index", "count", "([Ljava/lang/Object;IILcom/treemap/TreeMapAccessor;)D", "getName", "", "isCompatible", "layout", "box", "Lorg/mkui/geom/Rectangle2D;", "([Ljava/lang/Object;Lorg/mkui/geom/Rectangle2D;ILcom/treemap/TreeMapAccessor;)I", "layoutHorizontal", "", "numItems", "([Ljava/lang/Object;Lorg/mkui/geom/Rectangle2D;IILcom/treemap/TreeMapAccessor;)V", "toString", "treemap"})
public final class StripAlgorithm
extends AbstractAlgorithm {
    private final boolean lookAhead;

    public StripAlgorithm(boolean lookAhead) {
        this.lookAhead = lookAhead;
    }

    public /* synthetic */ StripAlgorithm(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    @Override
    public <N, Row, Column> boolean breadthFirstLayout(@NotNull Shape shape, N parent, @NotNull N[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, @NotNull TreeMapAccessor<? super N> accessor, @Nullable TreeMapWorker worker) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
        Rectangle2D bounds = shape.getBounds2D();
        double area = bounds.getWidth() * bounds.getHeight();
        double scaleFactor = Math.sqrt(area / sumSizes);
        Rectangle2D.Double scaledBounds = new Rectangle2D.Double(bounds.getX() / scaleFactor, bounds.getY() / scaleFactor, bounds.getWidth() / scaleFactor, bounds.getHeight() / scaleFactor);
        int count2 = 0;
        double yOffset = 0.0;
        for (int finishedIndex = 0; finishedIndex < children.length; finishedIndex += count2) {
            count2 = this.layout(children, (Rectangle2D)scaledBounds, finishedIndex, accessor);
            if (this.lookAhead && finishedIndex + count2 < children.length) {
                int countSecondStrip = this.layout(children, (Rectangle2D)scaledBounds, finishedIndex + count2, accessor);
                double aspectRatioFirstPlusSecond = this.computeAverageAspectRatio(children, finishedIndex, count2 + countSecondStrip, accessor);
                this.layoutHorizontal(children, (Rectangle2D)scaledBounds, finishedIndex, count2 + countSecondStrip, accessor);
                double aspectRatioTogether = this.computeAverageAspectRatio(children, finishedIndex, count2 + countSecondStrip, accessor);
                if (aspectRatioTogether < aspectRatioFirstPlusSecond) {
                    count2 += countSecondStrip;
                } else {
                    this.layoutHorizontal(children, (Rectangle2D)scaledBounds, finishedIndex, count2, accessor);
                }
            }
            int n = finishedIndex + count2;
            for (int i = finishedIndex; i < n; ++i) {
                N child = children[i];
                Rectangle2D rectangle = accessor.getBounds(child);
                accessor.setShape(child, (Shape)new Rectangle2D.Double(rectangle.getX(), rectangle.getY() + yOffset, rectangle.getWidth(), rectangle.getHeight()));
            }
            double height = accessor.getBounds(children[finishedIndex]).getHeight();
            yOffset += height;
            scaledBounds = new Rectangle2D.Double(scaledBounds.getX(), scaledBounds.getY() + height, scaledBounds.getWidth(), scaledBounds.getHeight() - height);
        }
        for (N child : children) {
            Rectangle2D childBounds = accessor.getBounds(child);
            accessor.setShape(child, (Shape)new Rectangle2D.Double(childBounds.getX() * scaleFactor + bounds.getX(), childBounds.getY() * scaleFactor + bounds.getY(), childBounds.getWidth() * scaleFactor, childBounds.getHeight() * scaleFactor));
        }
        return false;
    }

    public final <N, Row, Column> int layout(@NotNull N[] children, @NotNull Rectangle2D box, int index, @NotNull TreeMapAccessor<? super N> accessor) {
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter((Object)box, (String)"box");
        Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
        int count2 = 0;
        double previousAspectRatio = 0.0;
        double aspectRatio = Double.MAX_VALUE;
        do {
            previousAspectRatio = aspectRatio;
            this.layoutHorizontal(children, box, index, ++count2, accessor);
        } while ((aspectRatio = this.computeAverageAspectRatio(children, index, count2, accessor)) < previousAspectRatio && index + count2 < children.length);
        if (aspectRatio >= previousAspectRatio) {
            this.layoutHorizontal(children, box, index, --count2, accessor);
        }
        return count2;
    }

    public final <N, Row, Column> void layoutHorizontal(@NotNull N[] children, @NotNull Rectangle2D box, int index, int numItems, @NotNull TreeMapAccessor<? super N> accessor) {
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter((Object)box, (String)"box");
        Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
        double totalSize = this.sum(children, index, index + numItems - 1, accessor);
        double height = totalSize / box.getWidth();
        double x = 0.0;
        for (int i = 0; i < numItems; ++i) {
            N child = children[i + index];
            double width = accessor.getSize(child) / height;
            accessor.setShape(child, (Shape)new Rectangle2D.Double(x, 0.0, width, height));
            x += width;
        }
    }

    public final <N> double computeAverageAspectRatio(@NotNull N[] children, int index, int count2, @NotNull TreeMapAccessor<? super N> accessor) {
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
        double sum = 0.0;
        for (int i = 0; i < count2; ++i) {
            N child = children[i + index];
            double width = accessor.getBounds(child).getWidth();
            double height = accessor.getBounds(child).getHeight();
            double aspectRatio = Math.max(width / height, height / width);
            sum += aspectRatio;
        }
        return sum / (double)count2;
    }

    @Override
    public boolean isCompatible(@Nullable Shape shape) {
        return shape instanceof Rectangle2D;
    }

    @NotNull
    public final String getName() {
        return "Strip";
    }

    @NotNull
    public String toString() {
        return this.getName();
    }

    public StripAlgorithm() {
        this(false, 1, null);
    }
}

