/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.tagcloud;

import androidx.compose.runtime.internal.StabilityInferred;
import com.treemap.tagcloud.Interpolator;
import com.treemap.tagcloud.Point2d;
import com.treemap.tagcloud.PointPlusAccumulatedDistance;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.geom.PathIterator;
import org.mkui.geom.Shape;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/treemap/tagcloud/LinearizedPathIterator;", "", "shape", "Lorg/mkui/geom/Shape;", "(Lorg/mkui/geom/Shape;)V", "<set-?>", "", "outlineLength", "getOutlineLength", "()D", "pointsPlusAccumulatedDistances", "", "Lcom/treemap/tagcloud/PointPlusAccumulatedDistance;", "calculate", "", "getPointOnPath", "pathPositionRelative", "pointOnPath", "Lcom/treemap/tagcloud/Point2d;", "treemap"})
@StabilityInferred(parameters=0)
public final class LinearizedPathIterator {
    private double outlineLength;
    @NotNull
    private final List<PointPlusAccumulatedDistance> pointsPlusAccumulatedDistances;
    @NotNull
    private final Shape shape;
    public static final int $stable = 8;

    public LinearizedPathIterator(@NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        this.pointsPlusAccumulatedDistances = new ArrayList();
        this.shape = shape;
        this.calculate();
    }

    public final double getOutlineLength() {
        return this.outlineLength;
    }

    private final void calculate() {
        this.pointsPlusAccumulatedDistances.clear();
        this.outlineLength = 0.0;
        PathIterator pathIterator = this.shape.getPathIterator();
        double[] points = new double[6];
        Point2d currentPointOnPath = new Point2d();
        Point2d lastPointOnPath = new Point2d();
        boolean firstPoint = true;
        while (!pathIterator.isDone()) {
            int type = pathIterator.currentSegment(points);
            switch (type) {
                case 0: 
                case 1: {
                    currentPointOnPath.set(points[0], points[1]);
                    if (!firstPoint && !currentPointOnPath.equals(lastPointOnPath)) {
                        this.outlineLength += currentPointOnPath.distance(lastPointOnPath);
                        this.pointsPlusAccumulatedDistances.add(new PointPlusAccumulatedDistance(currentPointOnPath, this.outlineLength));
                    } else {
                        firstPoint = false;
                        this.pointsPlusAccumulatedDistances.add(new PointPlusAccumulatedDistance(currentPointOnPath, 0.0));
                    }
                    lastPointOnPath.set(currentPointOnPath);
                }
            }
            pathIterator.next();
        }
    }

    public final void getPointOnPath(double pathPositionRelative, @NotNull Point2d pointOnPath) {
        Intrinsics.checkNotNullParameter((Object)pointOnPath, (String)"pointOnPath");
        double pathPositionAbsolute = pathPositionRelative * this.outlineLength;
        double previousDistance = 0.0;
        Point2d previousPointOnPath = null;
        for (PointPlusAccumulatedDistance pointPlusAccumulatedDistance : this.pointsPlusAccumulatedDistances) {
            double currentDistance = pointPlusAccumulatedDistance.getAccumulatedDistance();
            Point2d currentPointOnPath = pointPlusAccumulatedDistance.getPointOnPath();
            if (previousPointOnPath != null && currentDistance > pathPositionAbsolute) {
                double fractionOnSegment = (pathPositionAbsolute - previousDistance) / (currentDistance - previousDistance);
                Interpolator.INSTANCE.getInterpolated(previousPointOnPath, currentPointOnPath, fractionOnSegment, pointOnPath);
                return;
            }
            previousDistance = currentDistance;
            previousPointOnPath = currentPointOnPath;
        }
    }
}

