/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.command.Future;
import com.macrofocus.common.geom.Dimension;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapRenderer;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.TGraphics;
import javafx.scene.paint.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.MkColorKt;
import org.mkui.geom.Shape;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J8\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/treemap/BackgroundRootNodeTreeMapRenderer;", "N", "Row", "Column", "Lcom/treemap/TreeMapRenderer;", "()V", "paint", "", "g", "Lcom/treemap/crossplatform/TGraphics;", "view", "Lcom/treemap/TreeMapView;", "progress", "Lcom/macrofocus/common/command/Future;", "treemap"})
@StabilityInferred(parameters=8)
public final class BackgroundRootNodeTreeMapRenderer<N, Row, Column>
implements TreeMapRenderer<N, Row, Column> {
    public static final int $stable;

    @Override
    public void paint(@NotNull TGraphics g, @NotNull TreeMapView<N, Row, Column> view, @Nullable Future<?> progress) {
        TreeMapModel<N, Row, Column> model;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter(view, (String)"view");
        TreeMapModel<N, Row, Column> treeMapModel = model = view.getModel();
        if ((treeMapModel != null ? treeMapModel.getCurrentRoot() : null) != null) {
            N n = model.getCurrentRoot();
            Intrinsics.checkNotNull(n);
            Shape shape = view.getRenderedShape(n);
            if (shape != null) {
                Color background = model.getSettings().getBackground();
                if (background == null && (background = view.getBackground()) == null) {
                    background = MkColorKt.colorOf-8NGXxBw((byte)-17, (byte)-17, (byte)-17);
                }
                if (background != null) {
                    g.setFill(background);
                    Dimension d = view.getSize();
                    g.fillRect(0.0, 0.0, d.getWidth(), d.getHeight());
                }
            }
        }
    }
}

