/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.treemap.AbstractAlgorithm;
import com.treemap.TreeMapAccessor;
import com.treemap.TreeMapWorker;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002Jm\u0010\u0006\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u0007\"\u0004\b\u0001\u0010\b\"\u0004\b\u0002\u0010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u0002H\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00070\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J \u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0012H\u0004J\u0012\u0010\u001d\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006!"}, d2={"Lcom/treemap/MatrixAlgorithm;", "Lcom/treemap/AbstractAlgorithm;", "()V", "isSpaceFilling", "", "()Z", "breadthFirstLayout", "N", "Row", "Column", "shape", "Lorg/mkui/geom/Shape;", "parent", "children", "", "sumSize", "", "horizontalVanishingPoint", "", "verticalVanishingPoint", "accessor", "Lcom/treemap/TreeMapAccessor;", "worker", "Lcom/treemap/TreeMapWorker;", "(Lorg/mkui/geom/Shape;Ljava/lang/Object;[Ljava/lang/Object;DIILcom/treemap/TreeMapAccessor;Lcom/treemap/TreeMapWorker;)Z", "calculateTileSize", "width", "height", "count", "isCompatible", "toString", "", "Companion", "treemap"})
@StabilityInferred(parameters=1)
public final class MatrixAlgorithm
extends AbstractAlgorithm {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;

    @Override
    public <N, Row, Column> boolean breadthFirstLayout(@NotNull Shape shape, N parent, @NotNull N[] children, double sumSize, int horizontalVanishingPoint, int verticalVanishingPoint, @NotNull TreeMapAccessor<? super N> accessor, @Nullable TreeMapWorker worker) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
        if (children.length == 0) {
            return true;
        }
        if (children.length == 1) {
            accessor.setShape(children[0], shape);
            return true;
        }
        Rectangle2D bounds = shape.getBounds2D();
        double size = this.calculateTileSize(bounds.getWidth(), bounds.getHeight(), children.length);
        double x = bounds.getX();
        double y = bounds.getY();
        int col = 0;
        int row = 0;
        for (N child : children) {
            accessor.setShape(child, (Shape)new Rectangle2D.Double(x, y, size, size));
            x = bounds.getX() + size * (double)(++col);
            if (!(size * (double)(col + 1) > bounds.getWidth())) continue;
            x = bounds.getX();
            y = bounds.getY() + size * (double)(++row);
            col = 0;
        }
        return false;
    }

    protected final double calculateTileSize(double width, double height, int count2) {
        double cols = Math.ceil(Math.sqrt(width * (double)count2 / height));
        double rows = Math.ceil((double)count2 / cols);
        double p1 = width / cols;
        double p2 = height / rows;
        return Math.min(p1, p2);
    }

    @Override
    public boolean isCompatible(@Nullable Shape shape) {
        return shape instanceof Rectangle2D;
    }

    @Override
    public boolean isSpaceFilling() {
        return false;
    }

    @NotNull
    public String toString() {
        return MatrixAlgorithm.Companion.getName();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u0005"}, d2={"Lcom/treemap/MatrixAlgorithm$Companion;", "", "()V", "getName", "", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        private final String getName() {
            return "Matrix";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

