/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.geom.Dimension;
import com.treemap.AbstractLabeling;
import com.treemap.TreeMapColumnSettings;
import com.treemap.TreeMapHeaderRenderer;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.TGraphics;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.font.MkFontKt;
import org.mkui.geom.Arc2D;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Shape;
import org.mkui.labeling.EnhancedLabel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Jc\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u0006\"\u0004\b\u0002\u0010\u00072\u0006\u0010\b\u001a\u0002H\u00052\u0006\u0010\t\u001a\u0002H\u00052\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\rH\u0016\u00a2\u0006\u0002\u0010\u000eJa\u0010\u000f\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u0006\"\u0004\b\u0002\u0010\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u0002H\u00052\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016\u00a8\u0006\u001b"}, d2={"Lcom/treemap/OverlayLabeling;", "Lcom/treemap/AbstractLabeling;", "()V", "getTopHeaderSpacing", "", "N", "Row", "Column", "parent", "node", "view", "Lcom/treemap/TreeMapView;", "model", "Lcom/treemap/TreeMapModel;", "(Ljava/lang/Object;Ljava/lang/Object;Lcom/treemap/TreeMapView;Lcom/treemap/TreeMapModel;)D", "paintParent", "", "g2", "Lcom/treemap/crossplatform/TGraphics;", "bounds", "Lorg/mkui/geom/Rectangle;", "pass", "", "passes", "(Lcom/treemap/crossplatform/TGraphics;Lorg/mkui/geom/Rectangle;Ljava/lang/Object;Lcom/treemap/TreeMapView;II)V", "toString", "", "treemap"})
@StabilityInferred(parameters=1)
public final class OverlayLabeling
extends AbstractLabeling {
    public static final int $stable;

    @Override
    public <N, Row, Column> void paintParent(@NotNull TGraphics g2, @NotNull Rectangle bounds, N node, @NotNull TreeMapView<N, Row, Column> view, int pass, int passes) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter(view, (String)"view");
        if (pass == passes - 1) {
            Font headerFont;
            TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
            Intrinsics.checkNotNull(treeMapModel);
            TreeMapModel<N, Row, Column> model = treeMapModel;
            TreeMapColumnSettings columnSettings = model.getSettings().getColumnSettings(model.getGroupByColumn(node));
            Font font = headerFont = columnSettings.getHeaderFont();
            Intrinsics.checkNotNull((Object)font);
            double fontSize = MkFontKt.getFontSize((Font)font) * (double)(1.0f + (view.getZoomFactor() - 1.0f) * 0.15f);
            TreeMapHeaderRenderer<N, Row, Column> treeMapHeaderRenderer = view.getHeaderRenderer();
            Intrinsics.checkNotNull(treeMapHeaderRenderer);
            EnhancedLabel label = treeMapHeaderRenderer.getTreeMapHeaderRendererComponent(model, node, new Dimension(bounds.getIwidth(), bounds.getIheight()));
            Color foreground = columnSettings.getHeaderForeground();
            Color background = columnSettings.getHeaderEffectColor();
            Font derivedFont = null;
            derivedFont = !(fontSize == MkFontKt.getFontSize((Font)headerFont)) ? MkFontKt.deriveFontSize((Font)headerFont, (double)fontSize) : headerFont;
            label.setFont(derivedFont);
            Color color = foreground;
            Intrinsics.checkNotNull((Object)color);
            label.setForeground(color);
            if (background != null) {
                label.setBackground(background.brighter());
            }
            Point2D position = null;
            Shape shape = model.getShape(node);
            position = shape instanceof Arc2D ? AbstractLabeling.Companion.getCentroid(shape) : null;
            Rectangle rect = null;
            if (position != null) {
                Dimension size = g2.sizeLabel(label, bounds.getIwidth(), bounds.getIheight()).getPreferredSize();
                int w = size.getIwidth();
                if (shape instanceof Arc2D) {
                    Arc2D arc = (Arc2D)shape;
                    Point2D startPoint = arc.getStartPoint();
                    Point2D endPoint = arc.getEndPoint();
                    Point2D s = (Point2D)new Point2D.Double((double)view.worldToScreenX(startPoint.getX()), (double)view.worldToScreenY(startPoint.getY()));
                    Point2D e = (Point2D)new Point2D.Double((double)view.worldToScreenX(endPoint.getX()), (double)view.worldToScreenY(endPoint.getY()));
                    w = Math.min((int)s.distance(e), w);
                }
                int h = size.getIheight();
                int x = view.worldToScreenX(position.getX()) - w / 2;
                int y = view.worldToScreenY(position.getY()) - h / 2;
                rect = new Rectangle(x, y, w, h).intersection(bounds);
            } else {
                Shape shape2 = model.getNestedShape(node);
                Intrinsics.checkNotNull((Object)shape2);
                Shape rectangle = shape2;
                rect = view.worldToScreenRectangle(rectangle.getBounds2D());
            }
            g2.paintLabel(label, rect.getIx(), rect.getIy(), rect.getIwidth(), rect.getIheight());
        }
    }

    @Override
    public <N, Row, Column> double getTopHeaderSpacing(N parent, N node, @NotNull TreeMapView<N, Row, Column> view, @NotNull TreeMapModel<N, Row, Column> model) {
        int n;
        TreeMapColumnSettings parentColumnSettings;
        int headerVerticalAlignment;
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        if (!model.isRoot(parent) && (headerVerticalAlignment = (parentColumnSettings = model.getSettings().getColumnSettings(model.getGroupByColumn(parent))).getHeaderVerticalAlignment()) == (n = 1)) {
            Shape shape = model.getNestedShape(parent);
            Intrinsics.checkNotNull((Object)shape);
            if (shape.getBounds2D().getY() == model.getBounds(node).getY()) {
                Font font = parentColumnSettings.getHeaderFont();
                Intrinsics.checkNotNull((Object)font);
                Font headerFont = font;
                double headerZoomedSize = MkFontKt.getFontSize((Font)headerFont) * (double)(1.0f + (view.getZoomFactor() - 1.0f) * 0.15f);
                if (!(MkFontKt.getFontSize((Font)headerFont) == headerZoomedSize)) {
                    headerFont = MkFontKt.deriveFontSize((Font)headerFont, (double)headerZoomedSize);
                }
                return MkFontKt.getFontSize((Font)headerFont);
            }
        }
        return 0.0;
    }

    @NotNull
    public String toString() {
        return "Overlay";
    }
}

