/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.collection.ArrayFnKt;
import com.treemap.AbstractAlgorithm;
import com.treemap.PivotByAlgorithmKt;
import com.treemap.TreeMapAccessor;
import com.treemap.TreeMapWorker;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0007\u0018\u00002\u00020\u0001:\u0004*+,-B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004Jm\u0010\u0005\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u0007\"\u0004\b\u0001\u0010\b\"\u0004\b\u0002\u0010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u0002H\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00070\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\u001b\u0010\u0019\u001a\u00020\u00102\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u000e\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0012\u0010\u001f\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016JK\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u000e\"\u0004\b\u0000\u0010\u0007\"\u0004\b\u0001\u0010\b\"\u0004\b\u0002\u0010\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000e2\b\u0010!\u001a\u0004\u0018\u00010\u001b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0015\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020\u001eH\u0016JM\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u000e\"\u0004\b\u0000\u0010\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000e2\u0006\u0010!\u001a\u00020\u001b2\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0015\u00a2\u0006\u0002\u0010%J?\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u000e\"\u0004\b\u0000\u0010\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000e2\u0006\u0010!\u001a\u00020\u001b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0015H\u0002\u00a2\u0006\u0002\u0010\"J?\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u000e\"\u0004\b\u0000\u0010\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000e2\u0006\u0010!\u001a\u00020\u001b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0015H\u0002\u00a2\u0006\u0002\u0010\"J?\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u000e\"\u0004\b\u0000\u0010\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000e2\u0006\u0010!\u001a\u00020\u001b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0015H\u0002\u00a2\u0006\u0002\u0010\"J?\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u000e\"\u0004\b\u0000\u0010\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000e2\u0006\u0010!\u001a\u00020\u001b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0015H\u0002\u00a2\u0006\u0002\u0010\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/treemap/PivotByAlgorithm;", "Lcom/treemap/AbstractAlgorithm;", "type", "Lcom/treemap/PivotByAlgorithm$Type;", "(Lcom/treemap/PivotByAlgorithm$Type;)V", "breadthFirstLayout", "", "N", "Row", "Column", "shape", "Lorg/mkui/geom/Shape;", "parent", "children", "", "sumSizes", "", "horizontalVanishingPoint", "", "verticalVanishingPoint", "accessor", "Lcom/treemap/TreeMapAccessor;", "worker", "Lcom/treemap/TreeMapWorker;", "(Lorg/mkui/geom/Shape;Ljava/lang/Object;[Ljava/lang/Object;DIILcom/treemap/TreeMapAccessor;Lcom/treemap/TreeMapWorker;)Z", "computeAverageAspectRatio", "rectangles", "Lorg/mkui/geom/Rectangle2D;", "([Lorg/mkui/geom/Rectangle2D;)D", "getName", "", "isCompatible", "layout", "bounds", "([Ljava/lang/Object;Lorg/mkui/geom/Rectangle2D;Lcom/treemap/TreeMapAccessor;)[Lorg/mkui/geom/Rectangle2D;", "toString", "tryAlternativeLayouts", "([Ljava/lang/Object;Lorg/mkui/geom/Rectangle2D;[Lorg/mkui/geom/Rectangle2D;Lcom/treemap/TreeMapAccessor;)[Lorg/mkui/geom/Rectangle2D;", "tryLayout3", "tryLayout4Quad", "tryLayout4Snake", "tryLayout5", "Biggest", "Middle", "SplitSize", "Type", "treemap"})
@StabilityInferred(parameters=0)
public final class PivotByAlgorithm
extends AbstractAlgorithm {
    @NotNull
    private final Type type;
    public static final int $stable = 8;

    public PivotByAlgorithm(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.type = type;
    }

    public /* synthetic */ PivotByAlgorithm(Type type, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            type = new SplitSize();
        }
        this(type);
    }

    @Override
    public <N, Row, Column> boolean breadthFirstLayout(@NotNull Shape shape, N parent, @NotNull N[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, @NotNull TreeMapAccessor<? super N> accessor, @Nullable TreeMapWorker worker) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
        Rectangle2D bounds = shape.getBounds2D();
        double area = bounds.getWidth() * bounds.getHeight();
        double scaleFactor = Math.sqrt(area / sumSizes);
        Rectangle2D.Double scaledBounds = new Rectangle2D.Double(0.0, 0.0, bounds.getWidth() / scaleFactor, bounds.getHeight() / scaleFactor);
        Rectangle2D[] results = this.layout(children, (Rectangle2D)scaledBounds, accessor);
        int n = children.length;
        for (int i = 0; i < n; ++i) {
            Rectangle2D r;
            Intrinsics.checkNotNull((Object)results[i]);
            accessor.setShape(children[i], (Shape)new Rectangle2D.Double(r.getX() * scaleFactor + bounds.getX(), r.getY() * scaleFactor + bounds.getY(), r.getWidth() * scaleFactor, r.getHeight() * scaleFactor));
        }
        return false;
    }

    @NotNull
    public final <N, Row, Column> Rectangle2D[] layout(@NotNull N[] children, @Nullable Rectangle2D bounds, @NotNull TreeMapAccessor<? super N> accessor) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
        Rectangle2D rectangle2D = bounds;
        Intrinsics.checkNotNull((Object)rectangle2D);
        double aspectRatio = rectangle2D.getWidth() / bounds.getHeight();
        if (children.length == 1) {
            Rectangle2D[] rectangles = new Rectangle2D[]{bounds};
            objectArray = rectangles;
        } else if (children.length == 2) {
            Rectangle2D[] rectangles = new Rectangle2D[2];
            N n = children[0];
            Intrinsics.checkNotNull(n);
            double d = accessor.getSize(n);
            N n2 = children[0];
            Intrinsics.checkNotNull(n2);
            double d2 = accessor.getSize(n2);
            N n3 = children[1];
            Intrinsics.checkNotNull(n3);
            double ratio = d / (d2 + accessor.getSize(n3));
            if (aspectRatio >= 1.0) {
                double w = ratio * bounds.getWidth();
                rectangles[0] = new Rectangle2D.Double(bounds.getX(), bounds.getY(), w, bounds.getHeight());
                rectangles[1] = new Rectangle2D.Double(bounds.getX() + w, bounds.getY(), bounds.getWidth() - w, bounds.getHeight());
            } else {
                double h = ratio * bounds.getHeight();
                rectangles[0] = new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), h);
                rectangles[1] = new Rectangle2D.Double(bounds.getX(), bounds.getY() + h, bounds.getWidth(), bounds.getHeight() - h);
            }
            objectArray = rectangles;
        } else {
            Rectangle2D rp = null;
            int pivotIndex = this.type.computePivotIndex(children, accessor);
            N pivotSize = children[pivotIndex];
            int d = children.length - pivotIndex - 1;
            N[] l1 = PivotByAlgorithmKt.copyFromSize(children, 0, pivotIndex);
            double l1Size = this.sum(l1, 0, l1.length - 1, accessor);
            Rectangle2D box2 = null;
            Rectangle2D r1 = null;
            if (aspectRatio >= 1.0) {
                double h = bounds.getHeight();
                double w = l1Size / h;
                r1 = (Rectangle2D)new Rectangle2D.Double(bounds.getX(), bounds.getY(), w, h);
                box2 = (Rectangle2D)new Rectangle2D.Double(r1.getX() + r1.getWidth(), bounds.getY(), bounds.getWidth() - r1.getWidth(), bounds.getHeight());
            } else {
                double w = bounds.getWidth();
                double h = l1Size / w;
                r1 = (Rectangle2D)new Rectangle2D.Double(bounds.getX(), bounds.getY(), w, h);
                box2 = (Rectangle2D)new Rectangle2D.Double(r1.getX(), r1.getY() + r1.getHeight(), bounds.getWidth(), bounds.getHeight() - r1.getHeight());
            }
            N[] l2 = null;
            N[] l3 = null;
            Rectangle2D r2 = null;
            Rectangle2D r3 = null;
            if (d >= 3) {
                boolean first = true;
                double bestAspectRatio = 0.0;
                double bestWidth = 0.0;
                double bestHeight = 0.0;
                int bestIndex = 0;
                int n = children.length;
                for (int i = pivotIndex + 1; i < n; ++i) {
                    double l2Size = this.sum(children, pivotIndex + 1, i, accessor);
                    double l3Size = this.sum(children, i + 1, children.length - 1, accessor);
                    N n4 = pivotSize;
                    Intrinsics.checkNotNull(n4);
                    double ratio = (accessor.getSize(n4) + l2Size) / (accessor.getSize(pivotSize) + l2Size + l3Size);
                    double w = 0.0;
                    double h = 0.0;
                    if (aspectRatio >= 1.0) {
                        w = ratio * box2.getWidth();
                        ratio = accessor.getSize(pivotSize) / (accessor.getSize(pivotSize) + l2Size);
                        h = ratio * box2.getHeight();
                    } else {
                        h = ratio * box2.getHeight();
                        ratio = accessor.getSize(pivotSize) / (accessor.getSize(pivotSize) + l2Size);
                        w = ratio * box2.getWidth();
                    }
                    double pivotAspectRatio = w / h;
                    if (first) {
                        first = false;
                        bestAspectRatio = pivotAspectRatio;
                        bestWidth = w;
                        bestHeight = h;
                        bestIndex = i;
                        continue;
                    }
                    if (!(Math.abs(pivotAspectRatio - 1.0) < Math.abs(bestAspectRatio - 1.0))) continue;
                    bestAspectRatio = pivotAspectRatio;
                    bestWidth = w;
                    bestHeight = h;
                    bestIndex = i;
                }
                l2 = PivotByAlgorithmKt.copyFromSize(children, pivotIndex + 1, bestIndex - pivotIndex);
                l3 = children.length - 1 - bestIndex > 0 ? PivotByAlgorithmKt.copyFromSize(children, bestIndex + 1, children.length - 1 - bestIndex) : null;
                if (aspectRatio >= 1.0) {
                    rp = (Rectangle2D)new Rectangle2D.Double(box2.getX(), box2.getY(), bestWidth, bestHeight);
                    r2 = (Rectangle2D)new Rectangle2D.Double(box2.getX(), box2.getY() + bestHeight, bestWidth, box2.getHeight() - bestHeight);
                    if (l3 != null) {
                        r3 = (Rectangle2D)new Rectangle2D.Double(box2.getX() + bestWidth, box2.getY(), box2.getWidth() - bestWidth, box2.getHeight());
                    }
                } else {
                    rp = (Rectangle2D)new Rectangle2D.Double(box2.getX(), box2.getY(), bestWidth, bestHeight);
                    r2 = (Rectangle2D)new Rectangle2D.Double(box2.getX() + bestWidth, box2.getY(), box2.getWidth() - bestWidth, bestHeight);
                    if (l3 != null) {
                        r3 = (Rectangle2D)new Rectangle2D.Double(box2.getX(), box2.getY() + bestHeight, box2.getWidth(), box2.getHeight() - bestHeight);
                    }
                }
            } else if (d > 0) {
                l2 = PivotByAlgorithmKt.copyFromSize(children, pivotIndex + 1, d);
                N n = pivotSize;
                Intrinsics.checkNotNull(n);
                double ratio = accessor.getSize(n) / (accessor.getSize(pivotSize) + this.sum(l2, 0, l2.length - 1, accessor));
                if (aspectRatio >= 1.0) {
                    double h = ratio * box2.getHeight();
                    rp = (Rectangle2D)new Rectangle2D.Double(box2.getX(), box2.getY(), box2.getWidth(), h);
                    r2 = (Rectangle2D)new Rectangle2D.Double(box2.getX(), box2.getY() + h, box2.getWidth(), box2.getHeight() - h);
                } else {
                    double w = ratio * box2.getWidth();
                    rp = (Rectangle2D)new Rectangle2D.Double(box2.getX(), box2.getY(), w, box2.getHeight());
                    r2 = (Rectangle2D)new Rectangle2D.Double(box2.getX() + w, box2.getY(), box2.getWidth() - w, box2.getHeight());
                }
            } else {
                rp = box2;
            }
            Object l1rectangles = null;
            Object l2rectangles = null;
            Object l3rectangles = null;
            l1rectangles = l1.length > 1 ? this.layout(l1, r1, accessor) : (l1.length == 1 ? new Rectangle2D[]{r1} : null);
            l2rectangles = l2 != null ? (l2.length > 1 ? this.layout(l2, r2, accessor) : (l2.length == 1 ? new Rectangle2D[]{r2} : null)) : null;
            l3rectangles = l3 != null ? (l3.length > 1 ? this.layout(l3, r3, accessor) : (l3.length == 1 ? new Rectangle2D[]{r3} : null)) : null;
            int count2 = l1.length + 1;
            if (l2 != null) {
                count2 += l2.length;
            }
            if (l3 != null) {
                count2 += l3.length;
            }
            Object[] rectangles = new Rectangle2D[count2];
            int i = 0;
            if (l1rectangles != null) {
                ArrayFnKt.arraycopy((Object[])l1rectangles, (int)0, (Object[])rectangles, (int)0, (int)((Rectangle2D[])l1rectangles).length);
                i = ((Object[])l1rectangles).length;
            }
            rectangles[i] = rp;
            ++i;
            if (l2rectangles != null) {
                ArrayFnKt.arraycopy((Object[])l2rectangles, (int)0, (Object[])rectangles, (int)i, (int)((Rectangle2D[])l2rectangles).length);
                i += ((Object[])l2rectangles).length;
            }
            if (l3rectangles != null) {
                ArrayFnKt.arraycopy((Object[])l3rectangles, (int)0, (Object[])rectangles, (int)i, (int)((Rectangle2D[])l3rectangles).length);
            }
            objectArray = rectangles.length >= 3 && rectangles.length <= 5 ? this.tryAlternativeLayouts(children, bounds, (Rectangle2D[])rectangles, accessor) : rectangles;
        }
        return objectArray;
    }

    @NotNull
    public final <N> Rectangle2D[] tryAlternativeLayouts(@NotNull N[] children, @NotNull Rectangle2D bounds, @NotNull Rectangle2D[] rectangles, @NotNull TreeMapAccessor<? super N> accessor) {
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)rectangles, (String)"rectangles");
        Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
        Rectangle2D[] bestRectangles = rectangles;
        switch (children.length) {
            case 3: {
                Rectangle2D[] newRectangles = this.tryLayout3(children, bounds, accessor);
                if (!(this.computeAverageAspectRatio(newRectangles) < this.computeAverageAspectRatio(bestRectangles))) break;
                bestRectangles = newRectangles;
                break;
            }
            case 4: {
                Rectangle2D[] newRectangles = this.tryLayout4Quad(children, bounds, accessor);
                if (this.computeAverageAspectRatio(newRectangles) < this.computeAverageAspectRatio(bestRectangles)) {
                    bestRectangles = newRectangles;
                }
                if (!(this.computeAverageAspectRatio(newRectangles = this.tryLayout4Snake(children, bounds, accessor)) < this.computeAverageAspectRatio(bestRectangles))) break;
                bestRectangles = newRectangles;
                break;
            }
            case 5: {
                Rectangle2D[] newRectangles = this.tryLayout5(children, bounds, accessor);
                if (!(this.computeAverageAspectRatio(newRectangles) < this.computeAverageAspectRatio(bestRectangles))) break;
                bestRectangles = newRectangles;
            }
        }
        return bestRectangles;
    }

    private final <N> Rectangle2D[] tryLayout3(N[] children, Rectangle2D bounds, TreeMapAccessor<? super N> accessor) {
        Rectangle2D[] newRectangles = new Rectangle2D[3];
        N n = children[0];
        Intrinsics.checkNotNull(n);
        double d = accessor.getSize(n);
        N n2 = children[1];
        Intrinsics.checkNotNull(n2);
        double d2 = d + accessor.getSize(n2);
        N n3 = children[2];
        Intrinsics.checkNotNull(n3);
        double sumSize = d2 + accessor.getSize(n3);
        N n4 = children[0];
        Intrinsics.checkNotNull(n4);
        double ratio1 = accessor.getSize(n4) / sumSize;
        N n5 = children[1];
        Intrinsics.checkNotNull(n5);
        double ratio2 = accessor.getSize(n5) / sumSize;
        N n6 = children[2];
        Intrinsics.checkNotNull(n6);
        double ratio3 = accessor.getSize(n6) / sumSize;
        double aspectRatio = bounds.getWidth() / bounds.getHeight();
        if (aspectRatio >= 1.0) {
            double w1 = ratio1 * bounds.getWidth();
            double w2 = ratio2 * bounds.getWidth();
            double w3 = ratio3 * bounds.getWidth();
            newRectangles[0] = new Rectangle2D.Double(bounds.getX(), bounds.getY(), w1, bounds.getHeight());
            newRectangles[1] = new Rectangle2D.Double(bounds.getX() + w1, bounds.getY(), w2, bounds.getHeight());
            newRectangles[2] = new Rectangle2D.Double(bounds.getX() + w1 + w2, bounds.getY(), w3, bounds.getHeight());
        } else {
            double h1 = ratio1 * bounds.getHeight();
            double h2 = ratio2 * bounds.getHeight();
            double h3 = ratio3 * bounds.getHeight();
            newRectangles[0] = new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), h1);
            newRectangles[1] = new Rectangle2D.Double(bounds.getX(), bounds.getY() + h1, bounds.getWidth(), h2);
            newRectangles[2] = new Rectangle2D.Double(bounds.getX(), bounds.getY() + h1 + h2, bounds.getWidth(), h3);
        }
        return newRectangles;
    }

    private final <N> Rectangle2D[] tryLayout4Quad(N[] children, Rectangle2D bounds, TreeMapAccessor<? super N> accessor) {
        Rectangle2D[] newRectangles = new Rectangle2D[4];
        N n = children[0];
        Intrinsics.checkNotNull(n);
        double d = accessor.getSize(n);
        N n2 = children[1];
        Intrinsics.checkNotNull(n2);
        double d2 = d + accessor.getSize(n2);
        N n3 = children[2];
        Intrinsics.checkNotNull(n3);
        double d3 = d2 + accessor.getSize(n3);
        N n4 = children[3];
        Intrinsics.checkNotNull(n4);
        double sumSize = d3 + accessor.getSize(n4);
        N n5 = children[0];
        Intrinsics.checkNotNull(n5);
        double d4 = accessor.getSize(n5);
        N n6 = children[1];
        Intrinsics.checkNotNull(n6);
        double ratio1 = (d4 + accessor.getSize(n6)) / sumSize;
        double aspectRatio = bounds.getWidth() / bounds.getHeight();
        if (aspectRatio >= 1.0) {
            double w = ratio1 * bounds.getWidth();
            N n7 = children[0];
            Intrinsics.checkNotNull(n7);
            double d5 = accessor.getSize(n7);
            N n8 = children[0];
            Intrinsics.checkNotNull(n8);
            double d6 = accessor.getSize(n8);
            N n9 = children[1];
            Intrinsics.checkNotNull(n9);
            double ratio2 = d5 / (d6 + accessor.getSize(n9));
            double h = ratio2 * bounds.getHeight();
            newRectangles[0] = new Rectangle2D.Double(bounds.getX(), bounds.getY(), w, h);
            newRectangles[1] = new Rectangle2D.Double(bounds.getX(), bounds.getY() + h, w, bounds.getHeight() - h);
            N n10 = children[2];
            Intrinsics.checkNotNull(n10);
            double d7 = accessor.getSize(n10);
            N n11 = children[2];
            Intrinsics.checkNotNull(n11);
            double d8 = accessor.getSize(n11);
            N n12 = children[3];
            Intrinsics.checkNotNull(n12);
            ratio2 = d7 / (d8 + accessor.getSize(n12));
            h = ratio2 * bounds.getHeight();
            newRectangles[2] = new Rectangle2D.Double(bounds.getX() + w, bounds.getY(), bounds.getWidth() - w, h);
            newRectangles[3] = new Rectangle2D.Double(bounds.getX() + w, bounds.getY() + h, bounds.getWidth() - w, bounds.getHeight() - h);
        } else {
            double h = ratio1 * bounds.getHeight();
            N n13 = children[0];
            Intrinsics.checkNotNull(n13);
            double d9 = accessor.getSize(n13);
            N n14 = children[0];
            Intrinsics.checkNotNull(n14);
            double d10 = accessor.getSize(n14);
            N n15 = children[1];
            Intrinsics.checkNotNull(n15);
            double ratio2 = d9 / (d10 + accessor.getSize(n15));
            double w = ratio2 * bounds.getWidth();
            newRectangles[0] = new Rectangle2D.Double(bounds.getX(), bounds.getY(), w, h);
            newRectangles[1] = new Rectangle2D.Double(bounds.getX(), bounds.getY() + h, w, bounds.getHeight() - h);
            N n16 = children[2];
            Intrinsics.checkNotNull(n16);
            double d11 = accessor.getSize(n16);
            N n17 = children[2];
            Intrinsics.checkNotNull(n17);
            double d12 = accessor.getSize(n17);
            N n18 = children[3];
            Intrinsics.checkNotNull(n18);
            ratio2 = d11 / (d12 + accessor.getSize(n18));
            h = ratio2 * bounds.getHeight();
            newRectangles[2] = new Rectangle2D.Double(bounds.getX() + w, bounds.getY(), bounds.getWidth() - w, h);
            newRectangles[3] = new Rectangle2D.Double(bounds.getX() + w, bounds.getY() + h, bounds.getWidth() - w, bounds.getHeight() - h);
        }
        return newRectangles;
    }

    private final <N> Rectangle2D[] tryLayout4Snake(N[] children, Rectangle2D bounds, TreeMapAccessor<? super N> accessor) {
        Rectangle2D[] newRectangles = new Rectangle2D[4];
        N n = children[0];
        Intrinsics.checkNotNull(n);
        double d = accessor.getSize(n);
        N n2 = children[1];
        Intrinsics.checkNotNull(n2);
        double d2 = d + accessor.getSize(n2);
        N n3 = children[2];
        Intrinsics.checkNotNull(n3);
        double d3 = d2 + accessor.getSize(n3);
        N n4 = children[3];
        Intrinsics.checkNotNull(n4);
        double sumSize = d3 + accessor.getSize(n4);
        N n5 = children[0];
        Intrinsics.checkNotNull(n5);
        double ratio1 = accessor.getSize(n5) / sumSize;
        N n6 = children[1];
        Intrinsics.checkNotNull(n6);
        double ratio2 = accessor.getSize(n6) / sumSize;
        N n7 = children[2];
        Intrinsics.checkNotNull(n7);
        double ratio3 = accessor.getSize(n7) / sumSize;
        N n8 = children[3];
        Intrinsics.checkNotNull(n8);
        double ratio4 = accessor.getSize(n8) / sumSize;
        double aspectRatio = bounds.getWidth() / bounds.getHeight();
        if (aspectRatio >= 1.0) {
            double w1 = ratio1 * bounds.getWidth();
            double w2 = ratio2 * bounds.getWidth();
            double w3 = ratio3 * bounds.getWidth();
            double w4 = ratio4 * bounds.getWidth();
            newRectangles[0] = new Rectangle2D.Double(bounds.getX(), bounds.getY(), w1, bounds.getHeight());
            newRectangles[1] = new Rectangle2D.Double(bounds.getX() + w1, bounds.getY(), w2, bounds.getHeight());
            newRectangles[2] = new Rectangle2D.Double(bounds.getX() + w1 + w2, bounds.getY(), w3, bounds.getHeight());
            newRectangles[3] = new Rectangle2D.Double(bounds.getX() + w1 + w2 + w3, bounds.getY(), w4, bounds.getHeight());
        } else {
            double h1 = ratio1 * bounds.getHeight();
            double h2 = ratio2 * bounds.getHeight();
            double h3 = ratio3 * bounds.getHeight();
            double h4 = ratio4 * bounds.getHeight();
            newRectangles[0] = new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), h1);
            newRectangles[1] = new Rectangle2D.Double(bounds.getX(), bounds.getY() + h1, bounds.getWidth(), h2);
            newRectangles[2] = new Rectangle2D.Double(bounds.getX(), bounds.getY() + h1 + h2, bounds.getWidth(), h3);
            newRectangles[3] = new Rectangle2D.Double(bounds.getX(), bounds.getY() + h1 + h2 + h3, bounds.getWidth(), h4);
        }
        return newRectangles;
    }

    private final <N> Rectangle2D[] tryLayout5(N[] children, Rectangle2D bounds, TreeMapAccessor<? super N> accessor) {
        Rectangle2D[] newRectangles = new Rectangle2D[5];
        N n = children[0];
        Intrinsics.checkNotNull(n);
        double d = accessor.getSize(n);
        N n2 = children[1];
        Intrinsics.checkNotNull(n2);
        double d2 = d + accessor.getSize(n2);
        N n3 = children[2];
        Intrinsics.checkNotNull(n3);
        double d3 = d2 + accessor.getSize(n3);
        N n4 = children[3];
        Intrinsics.checkNotNull(n4);
        double d4 = d3 + accessor.getSize(n4);
        N n5 = children[4];
        Intrinsics.checkNotNull(n5);
        double sumSize = d4 + accessor.getSize(n5);
        N n6 = children[0];
        Intrinsics.checkNotNull(n6);
        double ratio1 = accessor.getSize(n6) / sumSize;
        N n7 = children[1];
        Intrinsics.checkNotNull(n7);
        double ratio2 = accessor.getSize(n7) / sumSize;
        N n8 = children[2];
        Intrinsics.checkNotNull(n8);
        double ratio3 = accessor.getSize(n8) / sumSize;
        N n9 = children[3];
        Intrinsics.checkNotNull(n9);
        double ratio4 = accessor.getSize(n9) / sumSize;
        N n10 = children[4];
        Intrinsics.checkNotNull(n10);
        double ratio5 = accessor.getSize(n10) / sumSize;
        double aspectRatio = bounds.getWidth() / bounds.getHeight();
        if (aspectRatio >= 1.0) {
            double w1 = ratio1 * bounds.getWidth();
            double w2 = ratio2 * bounds.getWidth();
            double w3 = ratio3 * bounds.getWidth();
            double w4 = ratio4 * bounds.getWidth();
            double w5 = ratio5 * bounds.getWidth();
            newRectangles[0] = new Rectangle2D.Double(bounds.getX(), bounds.getY(), w1, bounds.getHeight());
            newRectangles[1] = new Rectangle2D.Double(bounds.getX() + w1, bounds.getY(), w2, bounds.getHeight());
            newRectangles[2] = new Rectangle2D.Double(bounds.getX() + w1 + w2, bounds.getY(), w3, bounds.getHeight());
            newRectangles[3] = new Rectangle2D.Double(bounds.getX() + w1 + w2 + w3, bounds.getY(), w4, bounds.getHeight());
            newRectangles[4] = new Rectangle2D.Double(bounds.getX() + w1 + w2 + w3 + w4, bounds.getY(), w5, bounds.getHeight());
        } else {
            double h1 = ratio1 * bounds.getHeight();
            double h2 = ratio2 * bounds.getHeight();
            double h3 = ratio3 * bounds.getHeight();
            double h4 = ratio4 * bounds.getHeight();
            double h5 = ratio5 * bounds.getHeight();
            newRectangles[0] = new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), h1);
            newRectangles[1] = new Rectangle2D.Double(bounds.getX(), bounds.getY() + h1, bounds.getWidth(), h2);
            newRectangles[2] = new Rectangle2D.Double(bounds.getX(), bounds.getY() + h1 + h2, bounds.getWidth(), h3);
            newRectangles[3] = new Rectangle2D.Double(bounds.getX(), bounds.getY() + h1 + h2 + h3, bounds.getWidth(), h4);
            newRectangles[4] = new Rectangle2D.Double(bounds.getX(), bounds.getY() + h1 + h2 + h3 + h4, bounds.getWidth(), h5);
        }
        return newRectangles;
    }

    public final double computeAverageAspectRatio(@NotNull Rectangle2D[] rectangles) {
        Intrinsics.checkNotNullParameter((Object)rectangles, (String)"rectangles");
        double sum = 0.0;
        int count2 = 0;
        int n = rectangles.length;
        for (int i = 0; i < n; ++i) {
            Rectangle2D rectangle2D = rectangles[i];
            Intrinsics.checkNotNull((Object)rectangle2D);
            double width = rectangle2D.getWidth();
            Rectangle2D rectangle2D2 = rectangles[i];
            Intrinsics.checkNotNull((Object)rectangle2D2);
            double height = rectangle2D2.getHeight();
            if (width == 0.0 || height == 0.0) continue;
            double aspectRatio = Math.max(width / height, height / width);
            sum += aspectRatio;
            ++count2;
        }
        return sum / (double)count2;
    }

    @Override
    public boolean isCompatible(@Nullable Shape shape) {
        return shape instanceof Rectangle2D;
    }

    @NotNull
    public final String getName() {
        return "Pivot by " + this.type;
    }

    @NotNull
    public String toString() {
        return this.getName();
    }

    public PivotByAlgorithm() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\tH\u0016\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/treemap/PivotByAlgorithm$Biggest;", "Lcom/treemap/PivotByAlgorithm$Type;", "()V", "computePivotIndex", "", "N", "children", "", "accessor", "Lcom/treemap/TreeMapAccessor;", "([Ljava/lang/Object;Lcom/treemap/TreeMapAccessor;)I", "toString", "", "treemap"})
    @StabilityInferred(parameters=1)
    public static final class Biggest
    implements Type {
        public static final int $stable;

        @Override
        public <N> int computePivotIndex(@NotNull N[] children, @NotNull TreeMapAccessor<? super N> accessor) {
            Intrinsics.checkNotNullParameter(children, (String)"children");
            Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
            int index = 0;
            double biggest = 0.0;
            boolean first = true;
            int n = children.length;
            for (int i = 0; i < n; ++i) {
                if (!first) {
                    N n2 = children[i];
                    Intrinsics.checkNotNull(n2);
                    if (!(accessor.getSize(n2) > biggest)) continue;
                }
                first = false;
                N n3 = children[i];
                Intrinsics.checkNotNull(n3);
                biggest = accessor.getSize(n3);
                index = i;
            }
            return index;
        }

        @NotNull
        public String toString() {
            return "Biggest";
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\tH\u0016\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/treemap/PivotByAlgorithm$Middle;", "Lcom/treemap/PivotByAlgorithm$Type;", "()V", "computePivotIndex", "", "N", "children", "", "accessor", "Lcom/treemap/TreeMapAccessor;", "([Ljava/lang/Object;Lcom/treemap/TreeMapAccessor;)I", "toString", "", "treemap"})
    @StabilityInferred(parameters=1)
    public static final class Middle
    implements Type {
        public static final int $stable;

        @Override
        public <N> int computePivotIndex(@NotNull N[] children, @NotNull TreeMapAccessor<? super N> accessor) {
            Intrinsics.checkNotNullParameter(children, (String)"children");
            Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
            return (children.length - 1) / 2;
        }

        @NotNull
        public String toString() {
            return "Middle";
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\tH\u0016\u00a2\u0006\u0002\u0010\nJ?\u0010\u000b\u001a\u00020\f\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\tH\u0004\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/treemap/PivotByAlgorithm$SplitSize;", "Lcom/treemap/PivotByAlgorithm$Type;", "()V", "computePivotIndex", "", "N", "children", "", "accessor", "Lcom/treemap/TreeMapAccessor;", "([Ljava/lang/Object;Lcom/treemap/TreeMapAccessor;)I", "sum", "", "start", "end", "([Ljava/lang/Object;IILcom/treemap/TreeMapAccessor;)D", "toString", "", "treemap"})
    @StabilityInferred(parameters=1)
    public static final class SplitSize
    implements Type {
        public static final int $stable;

        @Override
        public <N> int computePivotIndex(@NotNull N[] children, @NotNull TreeMapAccessor<? super N> accessor) {
            Intrinsics.checkNotNullParameter(children, (String)"children");
            Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
            int index = 0;
            double ratio = 0.0;
            double bestRatio = 0.0;
            boolean first = true;
            double leftSize = 0.0;
            double rightSize = this.sum(children, 0, children.length - 1, accessor);
            int n = children.length;
            for (int i = 0; i < n; ++i) {
                ratio = Math.max(leftSize / rightSize, rightSize / leftSize);
                if (first || ratio < bestRatio) {
                    first = false;
                    bestRatio = ratio;
                    index = i;
                }
                N n2 = children[i];
                Intrinsics.checkNotNull(n2);
                leftSize += accessor.getSize(n2);
                N n3 = children[i];
                Intrinsics.checkNotNull(n3);
                rightSize -= accessor.getSize(n3);
            }
            return index;
        }

        protected final <N> double sum(@NotNull N[] children, int start2, int end, @NotNull TreeMapAccessor<? super N> accessor) {
            Intrinsics.checkNotNullParameter(children, (String)"children");
            Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
            double sum = 0.0;
            int i = start2;
            if (i <= end) {
                while (true) {
                    N n = children[i];
                    Intrinsics.checkNotNull(n);
                    sum += accessor.getSize(n);
                    if (i == end) break;
                    ++i;
                }
            }
            return sum;
        }

        @NotNull
        public String toString() {
            return "Split Size";
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J/\u0010\u0002\u001a\u00020\u0003\"\u0004\b\u0000\u0010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00040\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00040\bH&\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/treemap/PivotByAlgorithm$Type;", "", "computePivotIndex", "", "N", "children", "", "accessor", "Lcom/treemap/TreeMapAccessor;", "([Ljava/lang/Object;Lcom/treemap/TreeMapAccessor;)I", "treemap"})
    public static interface Type {
        public <N> int computePivotIndex(@NotNull N[] var1, @NotNull TreeMapAccessor<? super N> var2);
    }
}

