/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.collection.Iterables;
import com.treemap.AbstractNodeRenderer;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.TGraphics;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Shape;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J=\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\t2\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\"\u0010\u000e\u001a\u00020\f2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0010H\u0016J\"\u0010\u0011\u001a\u00020\u00122\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\tH\u0016JW\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\t2\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ/\u0010\u001d\u001a\u00020\u00122\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\t2\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lcom/treemap/SelectionNodeRenderer;", "N", "Row", "Column", "Lcom/treemap/AbstractNodeRenderer;", "()V", "getOrder", "", "view", "Lcom/treemap/TreeMapView;", "root", "pass", "", "(Lcom/treemap/TreeMapView;Ljava/lang/Object;I)Ljava/lang/Iterable;", "getPasses", "model", "Lcom/treemap/TreeMapModel;", "isEnabled", "", "paintNode", "g", "Lcom/treemap/crossplatform/TGraphics;", "node", "passes", "bounds", "Lorg/mkui/geom/Rectangle;", "shape", "Lorg/mkui/geom/Shape;", "(Lcom/treemap/crossplatform/TGraphics;Lcom/treemap/TreeMapView;Ljava/lang/Object;IILorg/mkui/geom/Rectangle;Lorg/mkui/geom/Shape;)Z", "shouldPaint", "(Lcom/treemap/TreeMapView;Ljava/lang/Object;)Z", "treemap"})
@StabilityInferred(parameters=8)
public final class SelectionNodeRenderer<N, Row, Column>
extends AbstractNodeRenderer<N, Row, Column> {
    public static final int $stable;

    @Override
    public boolean isEnabled(@NotNull TreeMapView<N, Row, Column> view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
        Intrinsics.checkNotNull(treeMapModel);
        TreeMapModel<N, Row, Column> model = treeMapModel;
        return model.getHighlighting().isActive() || model.getSelection().isActive();
    }

    @Override
    @NotNull
    public Iterable<N> getOrder(@NotNull TreeMapView<N, Row, Column> view, N root, int pass) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
        Intrinsics.checkNotNull(treeMapModel);
        TreeMapModel<N, Row, Column> model = treeMapModel;
        Iterable[] iterableArray = new Iterable[]{model.getHighlighting(), model.getSelection()};
        return Iterables.INSTANCE.concatenate(iterableArray);
    }

    @Override
    public int getPasses(@NotNull TreeMapModel<N, Row, Column> model) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        return 1;
    }

    @Override
    public boolean shouldPaint(@NotNull TreeMapView<N, Row, Column> view, N node) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
        Intrinsics.checkNotNull(treeMapModel);
        TreeMapModel<N, Row, Column> model = treeMapModel;
        return model.hasNoChildren(node) && (model.getHighlighting().isActive() && model.getHighlighting().isSelected(node) || model.getSelection().isActive() && model.getSelection().isSelected(node));
    }

    @Override
    public boolean paintNode(@NotNull TGraphics g, @NotNull TreeMapView<N, Row, Column> view, N node, int pass, int passes, @NotNull Rectangle bounds, @NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
        Intrinsics.checkNotNull(treeMapModel);
        TreeMapModel<N, Row, Column> model = treeMapModel;
        if (model.hasNoChildren(node) && bounds.getWidth() > 0.0 && bounds.getHeight() > 0.0) {
            if (model.getHighlighting().isActive() && model.getHighlighting().isSelected(node)) {
                g.save();
                g.setStroke(model.getSettings().getProbingColor());
                g.setLineWidth(2.0);
                g.stroke(view.getRenderedShape(node));
                g.restore();
            }
            if (model.getSelection().isActive() && model.getSelection().isSelected(node)) {
                g.save();
                g.setStroke(model.getSettings().getSelectionColor());
                g.setLineWidth(1.0);
                g.stroke(view.getRenderedShape(node));
                g.restore();
            }
        }
        return true;
    }
}

