/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.crossplatform;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.geom.Dimension;
import com.macrofocus.common.geom.PreferredSize;
import com.treemap.crossplatform.JavaFXFontMetrics;
import java.util.Arrays;
import javafx.application.Platform;
import javafx.geometry.Bounds;
import javafx.geometry.VPos;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.MkColorKt;
import org.mkui.font.CPFontMetrics;
import org.mkui.geom.PathIterator;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;
import org.mkui.graphics.AbstractIGraphics;
import org.mkui.graphics.IGraphics;
import org.mkui.labeling.EnhancedLabel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 S2\u00020\u0001:\u0001SB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u001a\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J(\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001bH\u0016J(\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u000e\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u0018J\u000e\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$J \u0010%\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0016J\b\u0010)\u001a\u00020\u000eH\u0016J\u0010\u0010)\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010*\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010+\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010,\u001a\u00020\u001bH\u0016J\f\u0010-\u001a\u00060.j\u0002`/H\u0016J\b\u00100\u001a\u00020\u001bH\u0016J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020\u001bH\u0016J\u0010\u00104\u001a\u00020$2\u0006\u0010\u0007\u001a\u00020\u0013H\u0016J\u0010\u00105\u001a\u00020'2\u0006\u0010\u0007\u001a\u00020\u0013H\u0016J\u0010\u00106\u001a\u00020'2\u0006\u0010\u0007\u001a\u00020\u0013H\u0016J\u0018\u00107\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001bH\u0016J\u0018\u00108\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001bH\u0016J0\u00109\u001a\u00020\u000e2\u0006\u0010:\u001a\u00020;2\u0006\u0010&\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u001f2\u0006\u0010<\u001a\u00020\u001f2\u0006\u0010=\u001a\u00020\u001fH\u0016J\u0010\u0010>\u001a\u00020\u000e2\u0006\u0010?\u001a\u00020\u001bH\u0016J\u0014\u0010@\u001a\u00020\u000e2\n\u0010A\u001a\u00060.j\u0002`/H\u0016J\u0018\u0010B\u001a\u00020\u000e2\u000e\u0010C\u001a\n\u0018\u00010\u0015j\u0004\u0018\u0001`DH\u0016J\u0010\u0010E\u001a\u00020\u000e2\u0006\u0010F\u001a\u00020\u001bH\u0016J\u0012\u0010G\u001a\u00020\u000e2\b\u0010H\u001a\u0004\u0018\u00010IH\u0016J\u0010\u0010J\u001a\u00020\u000e2\u0006\u0010K\u001a\u00020\u001bH\u0016J\u0012\u0010L\u001a\u00020\u000e2\b\u0010M\u001a\u0004\u0018\u00010NH\u0016J \u0010O\u001a\u00020P2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u001f2\u0006\u0010=\u001a\u00020\u001fH\u0016J\b\u0010Q\u001a\u00020\u000eH\u0016J\u0018\u0010R\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u001fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006T"}, d2={"Lcom/treemap/crossplatform/JavaFXIGraphics;", "Lorg/mkui/graphics/AbstractIGraphics;", "context", "Ljavafx/scene/canvas/GraphicsContext;", "(Ljavafx/scene/canvas/GraphicsContext;)V", "getContext", "()Ljavafx/scene/canvas/GraphicsContext;", "text", "Ljavafx/scene/text/Text;", "getText", "()Ljavafx/scene/text/Text;", "setText", "(Ljavafx/scene/text/Text;)V", "beginPath", "", "closePath", "computeStringBounds", "Ljavafx/geometry/Bounds;", "s", "", "myFont", "Ljavafx/scene/text/Font;", "draw", "geometry", "Lorg/mkui/geom/Shape;", "drawLine", "x1", "", "y1", "x2", "y2", "", "drawPath", "path", "drawRectangle", "rectangle", "Lorg/mkui/geom/Rectangle2D;", "drawString", "x", "", "y", "fill", "fillCircle", "fillRectangle2D", "getAscent", "getColor", "Ljavafx/scene/paint/Color;", "Lorg/mkui/color/MkColor;", "getDescent", "getFontMetrics", "Lorg/mkui/font/CPFontMetrics;", "getLineWidth", "getStringBounds", "getStringHeight", "getStringWidth", "lineTo", "moveTo", "paintLabel", "l", "Lorg/mkui/labeling/EnhancedLabel;", "w", "h", "rotate", "theta", "setColor", "color", "setFont", "font", "Lorg/mkui/font/MkFont;", "setGlobalAlpha", "alpha", "setLineDash", "dashPattern", "", "setLineWidth", "lineWidth", "setTextBaseline", "baseline", "Lorg/mkui/graphics/IGraphics$TextBaseline;", "sizeLabel", "Lcom/macrofocus/common/geom/PreferredSize;", "stroke", "translate", "Companion", "treemap"})
@StabilityInferred(parameters=0)
public final class JavaFXIGraphics
extends AbstractIGraphics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GraphicsContext context;
    @Nullable
    private Text text;
    public static final int $stable = 8;

    public JavaFXIGraphics(@NotNull GraphicsContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final GraphicsContext getContext() {
        return this.context;
    }

    @Nullable
    protected final Text getText() {
        return this.text;
    }

    protected final void setText(@Nullable Text text) {
        this.text = text;
    }

    public void paintLabel(@NotNull EnhancedLabel l, int x, int y, int w, int h) {
        String text;
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.context.save();
        if (l.isOpaque()) {
            Color color = l.getBackground();
            Intrinsics.checkNotNull((Object)color);
            this.context.setFill((Paint)color);
            this.context.fillRect((double)x, (double)y, (double)w, (double)h);
        }
        if ((text = l.getText()) != null) {
            this.context.setTextBaseline(VPos.TOP);
            Font font = l.getFont();
            Intrinsics.checkNotNull((Object)font);
            this.context.setFont(font);
            Color color = l.getForeground();
            Intrinsics.checkNotNull((Object)color);
            this.context.setFill((Paint)color);
            if (l.getMinimumCharactersToDisplay() != null) {
                Integer n = l.getMinimumCharactersToDisplay();
                Intrinsics.checkNotNull((Object)n);
                int minimumCharactersToDisplay = n;
                if (text.length() > minimumCharactersToDisplay) {
                    String string = text.substring(0, minimumCharactersToDisplay);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    String s = string;
                    Font font2 = l.getFont();
                    Intrinsics.checkNotNull((Object)font2);
                    Bounds b = this.computeStringBounds(s, font2);
                    double width = b.getWidth();
                    if (width > (double)(w - l.getInsetLeft() - l.getInsetRight())) {
                        this.context.restore();
                        return;
                    }
                }
            }
            switch (l.getHorizontalAlignment()) {
                case 2: 
                case 10: {
                    this.context.setTextAlign(TextAlignment.LEFT);
                    this.context.fillText(text, (double)x + (double)l.getInsetLeft(), (double)y + (double)l.getInsetTop());
                    break;
                }
                case 4: 
                case 11: {
                    this.context.setTextAlign(TextAlignment.RIGHT);
                    this.context.fillText(text, (double)(x + w) - (double)l.getInsetRight(), (double)y + (double)l.getInsetTop());
                    break;
                }
                case 0: {
                    this.context.setTextAlign(TextAlignment.LEFT);
                    String string = l.getText();
                    Font font3 = l.getFont();
                    Intrinsics.checkNotNull((Object)font3);
                    Bounds b = this.computeStringBounds(string, font3);
                    double width = Math.max(0.0, ((double)(w - l.getInsetLeft() - l.getInsetRight()) - b.getWidth()) / (double)2);
                    this.context.fillText(text, (double)x + width + (double)l.getInsetLeft(), (double)y + (double)l.getInsetTop());
                }
            }
        }
        this.context.restore();
    }

    @NotNull
    public PreferredSize sizeLabel(@NotNull EnhancedLabel l, int w, int h) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        return new PreferredSize(this, l){
            final /* synthetic */ JavaFXIGraphics this$0;
            final /* synthetic */ EnhancedLabel $l;
            {
                this.this$0 = $receiver;
                this.$l = $l;
            }

            @NotNull
            public Dimension getMinimumSize() {
                return new Dimension(0, (int)this.getPreferredHeight());
            }

            public double getPreferredHeight() {
                String string = this.$l.getText();
                Font font = this.$l.getFont();
                Intrinsics.checkNotNull((Object)font);
                Bounds b = this.this$0.computeStringBounds(string, font);
                return b.getHeight();
            }

            @NotNull
            public Dimension getPreferredSize() {
                String string = this.$l.getText();
                Font font = this.$l.getFont();
                Intrinsics.checkNotNull((Object)font);
                Bounds b = this.this$0.computeStringBounds(string, font);
                return new Dimension((int)b.getWidth(), (int)b.getHeight());
            }

            @NotNull
            public Dimension getMaximumSize() {
                return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
        };
    }

    @NotNull
    public final Bounds computeStringBounds(@Nullable String s, @Nullable Font myFont) {
        Text text = null;
        if (Platform.isFxApplicationThread()) {
            if (this.text == null) {
                text = this.text = new Text(s);
            } else {
                Text text2 = this.text;
                Intrinsics.checkNotNull((Object)text2);
                text2.setText(s);
                text = this.text;
            }
        } else {
            text = new Text(s);
        }
        Text text3 = text;
        Intrinsics.checkNotNull((Object)text3);
        text3.setFont(myFont);
        Bounds bounds = text.getBoundsInLocal();
        Intrinsics.checkNotNullExpressionValue((Object)bounds, (String)"getBoundsInLocal(...)");
        return bounds;
    }

    public double getLineWidth() {
        return this.context.getLineWidth();
    }

    public void setLineWidth(double lineWidth) {
        this.context.setLineWidth(lineWidth);
    }

    public void setLineDash(@Nullable float[] dashPattern) {
        double[] dArray = JavaFXIGraphics.Companion.convertFloatsToDoubles(dashPattern);
        Intrinsics.checkNotNull((Object)dArray);
        double[] dArray2 = dArray;
        this.context.setLineDashes(Arrays.copyOf(dArray2, dArray2.length));
    }

    @NotNull
    public Color getColor() {
        Paint paint = this.context.getFill();
        Intrinsics.checkNotNull((Object)paint, (String)"null cannot be cast to non-null type javafx.scene.paint.Color");
        return MkColorKt.colorOf((Color)((Color)paint));
    }

    public void setGlobalAlpha(double alpha) {
        this.context.setGlobalAlpha(alpha);
    }

    public void setColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.context.setFill((Paint)color);
        this.context.setStroke((Paint)color);
    }

    protected void draw(@NotNull Shape geometry) {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        if (this.context != null) {
            GraphicsContext context = this.context;
            this.drawPath(geometry);
            context.stroke();
        }
    }

    protected void fill(@NotNull Shape geometry) {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        if (this.context != null) {
            GraphicsContext context = this.context;
            this.drawPath(geometry);
            context.fill();
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.context.strokeLine((double)x1, (double)y1, (double)x2, (double)y2);
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this.context.strokeLine(x1, y1, x2, y2);
    }

    public final void drawRectangle(@NotNull Rectangle2D rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        GraphicsContext context = this.context;
        context.rect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public void fillRectangle2D(@NotNull Rectangle2D rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        this.context.fillRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public void fillCircle(@NotNull Rectangle2D rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        this.context.fillOval(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public final void drawPath(@NotNull Shape path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        GraphicsContext context = this.context;
        PathIterator iterator2 = path.getPathIterator();
        double[] coords = new double[6];
        context.beginPath();
        while (!iterator2.isDone()) {
            int segment = iterator2.currentSegment(coords);
            switch (segment) {
                case 0: {
                    context.moveTo(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    context.lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    context.quadraticCurveTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    context.bezierCurveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 4: {
                    context.closePath();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown Segment " + segment);
                }
            }
            iterator2.next();
        }
    }

    public void setTextBaseline(@Nullable IGraphics.TextBaseline baseline) {
        IGraphics.TextBaseline textBaseline = baseline;
        switch (textBaseline == null ? -1 : WhenMappings.$EnumSwitchMapping$0[textBaseline.ordinal()]) {
            case 1: {
                this.context.setTextBaseline(VPos.TOP);
                break;
            }
            case 2: {
                this.context.setTextBaseline(VPos.BOTTOM);
                break;
            }
            case 3: {
                this.context.setTextBaseline(VPos.CENTER);
                break;
            }
            case 4: {
                this.context.setTextBaseline(VPos.BASELINE);
                break;
            }
            case 5: {
                throw new UnsupportedOperationException();
            }
            case 6: {
                throw new UnsupportedOperationException();
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setFont(@Nullable Font font) {
        Font font2 = font;
        Intrinsics.checkNotNull((Object)font2);
        this.context.setFont(font2);
    }

    @NotNull
    public Rectangle2D getStringBounds(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Text t = new Text(text);
        t.setFont(this.context.getFont());
        Bounds stringBounds = t.getLayoutBounds();
        return (Rectangle2D)new Rectangle2D.Double(stringBounds.getMinX(), stringBounds.getMinY(), stringBounds.getWidth(), stringBounds.getHeight());
    }

    @NotNull
    public CPFontMetrics getFontMetrics() {
        return new JavaFXFontMetrics(this.context);
    }

    public void drawString(@NotNull String text, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.context.fillText(text, (double)x, (double)y);
    }

    public float getStringWidth(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return (float)this.getStringBounds(text).getWidth();
    }

    public float getStringHeight(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return (float)this.getStringBounds(text).getHeight();
    }

    public double getAscent() {
        return this.context.getFont().getSize();
    }

    public double getDescent() {
        return 0.0;
    }

    public void translate(int x, int y) {
        this.context.translate((double)x, (double)y);
    }

    public void rotate(double theta) {
        this.context.rotate(Math.toDegrees(theta));
    }

    public void beginPath() {
        this.context.beginPath();
    }

    public void moveTo(double x, double y) {
        this.context.moveTo(x, y);
    }

    public void lineTo(double x, double y) {
        this.context.lineTo(x, y);
    }

    public void closePath() {
        this.context.closePath();
    }

    public void stroke() {
        this.context.stroke();
    }

    public void fill() {
        this.context.fill();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0014\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/treemap/crossplatform/JavaFXIGraphics$Companion;", "", "()V", "convertFloatsToDoubles", "", "input", "", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        private final double[] convertFloatsToDoubles(float[] input) {
            if (input == null) {
                return null;
            }
            double[] output = new double[input.length];
            int n = input.length;
            for (int i = 0; i < n; ++i) {
                output[i] = input[i];
            }
            return output;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IGraphics.TextBaseline.values().length];
            try {
                nArray[IGraphics.TextBaseline.Top.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IGraphics.TextBaseline.Bottom.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IGraphics.TextBaseline.Middle.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IGraphics.TextBaseline.Alphabetic.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IGraphics.TextBaseline.Hanging.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IGraphics.TextBaseline.Ideographic.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

