/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.crossplatform;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.geom.Dimension;
import com.macrofocus.common.geom.PreferredSize;
import com.treemap.crossplatform.AbstractTGraphics;
import com.treemap.crossplatform.Headless;
import com.treemap.crossplatform.JavaFXIGraphics;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.Arrays;
import javafx.geometry.Bounds;
import javafx.geometry.VPos;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.MkColorFactory;
import org.mkui.color.MkColorKt;
import org.mkui.geom.AffineTransform;
import org.mkui.geom.Arc2D;
import org.mkui.geom.Ellipse2D;
import org.mkui.geom.GeneralPath;
import org.mkui.geom.PathIterator;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.RoundRectangle2D;
import org.mkui.geom.Shape;
import org.mkui.graphics.CPImage;
import org.mkui.graphics.IGraphics;
import org.mkui.labeling.EnhancedLabel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ec\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\f\b\u0007\u0018\u0000 \u00a4\u00012\u00020\u0001:\u0002\u00a4\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010A\u001a\u00020\u00062\u0006\u0010B\u001a\u00020CJ\u000e\u0010D\u001a\u00020E2\u0006\u0010B\u001a\u00020FJ\u000e\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020FJ(\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020F2\u0006\u0010M\u001a\u00020F2\u0006\u0010N\u001a\u00020F2\u0006\u0010O\u001a\u00020FH\u0016J\u0012\u0010P\u001a\u00020K2\b\u0010Q\u001a\u0004\u0018\u00010RH\u0016J\u0018\u0010S\u001a\u00020T2\u0006\u0010N\u001a\u00020F2\u0006\u0010O\u001a\u00020FH\u0016J&\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020X2\u0006\u0010Z\u001a\u00020F2\u0006\u0010[\u001a\u00020#J8\u0010\\\u001a\u00020K2\u0006\u0010L\u001a\u00020F2\u0006\u0010M\u001a\u00020F2\u0006\u0010N\u001a\u00020F2\u0006\u0010O\u001a\u00020F2\u0006\u0010]\u001a\u00020F2\u0006\u0010^\u001a\u00020FH\u0016J\"\u0010_\u001a\u00020#2\b\u0010`\u001a\u0004\u0018\u00010T2\u0006\u0010L\u001a\u00020F2\u0006\u0010M\u001a\u00020FH\u0016J2\u0010a\u001a\u00020#2\b\u0010`\u001a\u0004\u0018\u00010T2\u0006\u0010L\u001a\u00020F2\u0006\u0010M\u001a\u00020F2\u0006\u0010b\u001a\u00020F2\u0006\u0010c\u001a\u00020FH\u0016J \u0010d\u001a\u00020#2\b\u0010`\u001a\u0004\u0018\u00010e2\u0006\u0010L\u001a\u00020F2\u0006\u0010M\u001a\u00020FJ(\u0010f\u001a\u00020K2\u0006\u0010L\u001a\u00020F2\u0006\u0010M\u001a\u00020F2\u0006\u0010N\u001a\u00020F2\u0006\u0010O\u001a\u00020FH\u0016J$\u0010g\u001a\u00020K2\b\u0010W\u001a\u0004\u0018\u00010X2\b\u0010Y\u001a\u0004\u0018\u00010X2\u0006\u0010Z\u001a\u00020FH\u0016J$\u0010h\u001a\u00020K2\b\u0010W\u001a\u0004\u0018\u00010X2\b\u0010Y\u001a\u0004\u0018\u00010X2\u0006\u0010Z\u001a\u00020FH\u0016J\u0012\u0010i\u001a\u00020K2\b\u0010Q\u001a\u0004\u0018\u00010RH\u0016J8\u0010j\u001a\u00020K2\u0006\u0010L\u001a\u00020F2\u0006\u0010M\u001a\u00020F2\u0006\u0010N\u001a\u00020F2\u0006\u0010O\u001a\u00020F2\u0006\u0010]\u001a\u00020F2\u0006\u0010^\u001a\u00020FH\u0016J(\u0010k\u001a\u00020K2\u0006\u0010L\u001a\u00020F2\u0006\u0010M\u001a\u00020F2\u0006\u0010N\u001a\u00020F2\u0006\u0010O\u001a\u00020FH\u0016J$\u0010l\u001a\u00020K2\b\u0010W\u001a\u0004\u0018\u00010X2\b\u0010Y\u001a\u0004\u0018\u00010X2\u0006\u0010Z\u001a\u00020FH\u0016J(\u0010m\u001a\u00020K2\u0006\u0010L\u001a\u00020@2\u0006\u0010M\u001a\u00020@2\u0006\u0010N\u001a\u00020@2\u0006\u0010O\u001a\u00020@H\u0016J&\u0010m\u001a\u00020K2\u0006\u0010L\u001a\u00020F2\u0006\u0010M\u001a\u00020F2\u0006\u0010N\u001a\u00020F2\u0006\u0010O\u001a\u00020FJ8\u0010n\u001a\u00020K2\u0006\u0010L\u001a\u00020@2\u0006\u0010M\u001a\u00020@2\u0006\u0010N\u001a\u00020@2\u0006\u0010O\u001a\u00020@2\u0006\u0010o\u001a\u00020@2\u0006\u0010p\u001a\u00020@H\u0016J\"\u0010q\u001a\u00020K2\b\u0010r\u001a\u0004\u0018\u00010s2\u0006\u0010L\u001a\u00020t2\u0006\u0010M\u001a\u00020tH\u0016J\u0012\u0010u\u001a\u0004\u0018\u00010\u00122\b\u0010v\u001a\u0004\u0018\u00010wJ\u0010\u0010x\u001a\u00020y2\b\u0010z\u001a\u0004\u0018\u00010sJ\u0012\u0010{\u001a\u00020@2\b\u0010z\u001a\u0004\u0018\u00010sH\u0016J\u000e\u0010|\u001a\u00020}2\u0006\u00108\u001a\u00020FJ1\u0010~\u001a\u00020K2\u0007\u0010\u007f\u001a\u00030\u0080\u00012\u0006\u0010L\u001a\u00020F2\u0006\u0010M\u001a\u00020F2\u0006\u0010b\u001a\u00020F2\u0006\u0010c\u001a\u00020FH\u0016J\t\u0010\u0081\u0001\u001a\u00020KH\u0016J\u0012\u0010\u0082\u0001\u001a\u00020K2\u0007\u0010\u0083\u0001\u001a\u00020@H\u0016J\"\u0010\u0084\u0001\u001a\u00020K2\u0007\u0010\u0083\u0001\u001a\u00020@2\u0006\u0010L\u001a\u00020@2\u0006\u0010M\u001a\u00020@H\u0016J\t\u0010\u0085\u0001\u001a\u00020KH\u0016J\u001b\u0010\u0086\u0001\u001a\u00020K2\u0007\u0010\u0087\u0001\u001a\u00020@2\u0007\u0010\u0088\u0001\u001a\u00020@H\u0016J\u0019\u0010\u0089\u0001\u001a\u00020K2\u000e\u0010B\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007H\u0016J\u0019\u0010\u008a\u0001\u001a\u00020K2\u000e\u0010B\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007H\u0016J\u0012\u0010\u008b\u0001\u001a\u00020K2\u0007\u0010\u008c\u0001\u001a\u00020@H\u0016J\u0014\u0010\u008d\u0001\u001a\u00020K2\t\u0010\u008e\u0001\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u008f\u0001\u001a\u00020K2\u0007\u0010\u0090\u0001\u001a\u00020@H\u0016J\u0011\u0010\u0091\u0001\u001a\u00020K2\b\u00104\u001a\u0004\u0018\u000105J\t\u0010\u0092\u0001\u001a\u00020KH\u0016J\u0019\u0010\u0093\u0001\u001a\u00020K2\u000e\u0010B\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007H\u0016J\u000f\u0010\u0094\u0001\u001a\u00020K2\u0006\u0010Q\u001a\u00020RJ\u001b\u0010\u0095\u0001\u001a\u00020K2\u0007\u0010\u0096\u0001\u001a\u00020@2\u0007\u0010\u0097\u0001\u001a\u00020@H\u0016J#\u0010\u0098\u0001\u001a\u00030\u0099\u00012\u0007\u0010\u007f\u001a\u00030\u0080\u00012\u0006\u0010b\u001a\u00020F2\u0006\u0010c\u001a\u00020FH\u0016J\u0012\u00106\u001a\u00020K2\b\u0010Q\u001a\u0004\u0018\u00010RH\u0016J-\u0010\u009a\u0001\u001a\u00020K2\u0007\u0010\u009b\u0001\u001a\u00020F2\u0007\u0010\u009c\u0001\u001a\u00020F2\u0007\u0010\u009d\u0001\u001a\u00020F2\u0007\u0010\u009e\u0001\u001a\u00020FH\u0016J)\u0010\u009f\u0001\u001a\u00020K2\u0006\u0010L\u001a\u00020@2\u0006\u0010M\u001a\u00020@2\u0006\u0010N\u001a\u00020@2\u0006\u0010O\u001a\u00020@H\u0016J9\u0010\u00a0\u0001\u001a\u00020K2\u0006\u0010L\u001a\u00020@2\u0006\u0010M\u001a\u00020@2\u0006\u0010N\u001a\u00020@2\u0006\u0010O\u001a\u00020@2\u0006\u0010o\u001a\u00020@2\u0006\u0010p\u001a\u00020@H\u0016J\u0012\u0010:\u001a\u00020K2\b\u00108\u001a\u0004\u0018\u000109H\u0016J\u001b\u0010\u00a1\u0001\u001a\u00020K2\u0007\u0010\u00a2\u0001\u001a\u00020@2\u0007\u0010\u00a3\u0001\u001a\u00020@H\u0016R.\u0010\b\u001a\u00060\u0006j\u0002`\u00072\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00078V@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0016\u0010\u0005\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0013\u001a\u00060\u0014j\u0002`\u00152\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u00158V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R$\u0010$\u001a\u00020#2\u0006\u0010\"\u001a\u00020#8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R$\u0010)\u001a\u00020#2\u0006\u0010(\u001a\u00020#8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010%\"\u0004\b*\u0010'R$\u0010,\u001a\u00020#2\u0006\u0010+\u001a\u00020#8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010%\"\u0004\b-\u0010'R$\u0010.\u001a\u00020#2\u0006\u0010\"\u001a\u00020#8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010%\"\u0004\b/\u0010'R\u0014\u00100\u001a\u0002018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u000e\u00104\u001a\u000205X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00106\u001a\u0004\u0018\u000107X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010:\u001a\u0004\u0018\u0001092\b\u00108\u001a\u0004\u0018\u0001098V@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u000e\u0010?\u001a\u00020@X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00a5\u0001"}, d2={"Lcom/treemap/crossplatform/JavaFXTGraphics;", "Lcom/treemap/crossplatform/AbstractTGraphics;", "gc", "Ljavafx/scene/canvas/GraphicsContext;", "(Ljavafx/scene/canvas/GraphicsContext;)V", "color", "Ljavafx/scene/paint/Color;", "Lorg/mkui/color/MkColor;", "background", "getBackground", "()Ljavafx/scene/paint/Color;", "setBackground", "(Ljavafx/scene/paint/Color;)V", "colorFactory", "Lorg/mkui/color/MkColorFactory;", "getColorFactory", "()Lorg/mkui/color/MkColorFactory;", "coords", "", "font", "Ljavafx/scene/text/Font;", "Lorg/mkui/font/MkFont;", "getFont", "()Ljavafx/scene/text/Font;", "setFont", "(Ljavafx/scene/text/Font;)V", "headless", "Lcom/treemap/crossplatform/Headless;", "hints", "Ljava/awt/RenderingHints;", "iGraphics", "Lorg/mkui/graphics/IGraphics;", "getIGraphics", "()Lorg/mkui/graphics/IGraphics;", "antialias", "", "isAntialias", "()Z", "setAntialias", "(Z)V", "bilinear", "isInterpolationBilinear", "setInterpolationBilinear", "paintingForPrint", "isPaintingForPrint", "setPaintingForPrint", "isTextAntialias", "setTextAntialias", "nativeGraphics", "", "getNativeGraphics", "()Ljava/lang/Object;", "paint", "Ljava/awt/Paint;", "stroke", "Ljava/awt/Stroke;", "t", "Lorg/mkui/geom/AffineTransform;", "transform", "getTransform", "()Lorg/mkui/geom/AffineTransform;", "setTransform", "(Lorg/mkui/geom/AffineTransform;)V", "zeroStrokeWidth", "", "awtColorToJavaFX", "c", "Ljava/awt/Color;", "awtToJavaFXLineCap", "Ljavafx/scene/shape/StrokeLineCap;", "", "awtToJavaFXLineJoin", "Ljavafx/scene/shape/StrokeLineJoin;", "j", "clearRect", "", "x", "y", "width", "height", "clip", "s", "Lorg/mkui/geom/Shape;", "createImage", "Lorg/mkui/graphics/CPImage;", "createPolygon", "Lorg/mkui/geom/GeneralPath;", "xPoints", "", "yPoints", "nPoints", "close", "drawArc", "startAngle", "arcAngle", "drawImage", "img", "drawImageStretch", "w", "h", "drawNativeImage", "Ljava/awt/Image;", "drawOval", "drawPolygon", "drawPolyline", "fill", "fillArc", "fillOval", "fillPolygon", "fillRect", "fillRoundRect", "arcWidth", "arcHeight", "fillText", "str", "", "", "floatToDoubleArray", "f", "", "getStringBounds", "Lorg/mkui/geom/Rectangle2D;", "text", "getStringWidth", "intToArcType", "Ljavafx/scene/shape/ArcType;", "paintLabel", "l", "Lorg/mkui/labeling/EnhancedLabel;", "restore", "rotate", "theta", "rotateTranslate", "save", "scale", "sx", "sy", "setColor", "setFill", "setGlobalAlpha", "alpha", "setLineDash", "dashPattern", "setLineWidth", "lw", "setPaint", "setRadialGradient", "setStroke", "shapeToPath", "shear", "shx", "shy", "sizeLabel", "Lcom/macrofocus/common/geom/PreferredSize;", "strokeLine", "x1", "y1", "x2", "y2", "strokeRect", "strokeRoundRect", "translate", "tx", "ty", "Companion", "treemap"})
@StabilityInferred(parameters=0)
public final class JavaFXTGraphics
extends AbstractTGraphics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GraphicsContext gc;
    @NotNull
    private final RenderingHints hints;
    @NotNull
    private Paint paint;
    @Nullable
    private javafx.scene.paint.Color color;
    @Nullable
    private final Stroke stroke;
    private final double zeroStrokeWidth;
    @NotNull
    private final double[] coords;
    @NotNull
    private final Headless headless;
    @NotNull
    private javafx.scene.paint.Color background;
    @Nullable
    private AffineTransform transform;
    public static final int $stable = 8;
    @Nullable
    private static Text text;

    public JavaFXTGraphics(@NotNull GraphicsContext gc) {
        Intrinsics.checkNotNullParameter((Object)gc, (String)"gc");
        this.gc = gc;
        this.headless = new Headless();
        this.background = MkColorFactory.Companion.getInstance().getBlack();
        Color color = Color.BLACK;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"BLACK");
        this.paint = color;
        this.color = MkColorFactory.Companion.getInstance().getBlack();
        this.stroke = new BasicStroke(1.0f);
        this.setFont(new Font("SansSerif", 12.0));
        this.setTransform(new AffineTransform());
        this.setBackground(MkColorFactory.Companion.getInstance().getBlack());
        this.coords = new double[6];
        this.zeroStrokeWidth = 0.5;
        this.hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    @Override
    @NotNull
    public MkColorFactory getColorFactory() {
        return MkColorFactory.Companion.getInstance();
    }

    @Override
    public void paintLabel(@NotNull EnhancedLabel l, int x, int y, int w, int h) {
        String text;
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.gc.save();
        if (l.isOpaque()) {
            javafx.scene.paint.Color color = l.getBackground();
            Intrinsics.checkNotNull((Object)color);
            this.gc.setFill((javafx.scene.paint.Paint)color);
            this.gc.fillRect((double)x, (double)y, (double)w, (double)h);
        }
        if ((text = l.getText()) != null) {
            this.gc.setTextBaseline(VPos.TOP);
            Font font = l.getFont();
            Intrinsics.checkNotNull((Object)font);
            this.gc.setFont(font);
            javafx.scene.paint.Color color = l.getForeground();
            Intrinsics.checkNotNull((Object)color);
            this.gc.setFill((javafx.scene.paint.Paint)color);
            if (l.getMinimumCharactersToDisplay() != null) {
                Integer n = l.getMinimumCharactersToDisplay();
                Intrinsics.checkNotNull((Object)n);
                int minimumCharactersToDisplay = n;
                if (text.length() > minimumCharactersToDisplay) {
                    String string = text.substring(0, minimumCharactersToDisplay);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    String s = string;
                    Font font2 = l.getFont();
                    Intrinsics.checkNotNull((Object)font2);
                    Bounds b = this.headless.computeStringBounds(s, font2);
                    double width = b.getWidth();
                    if (width > (double)(w - l.getInsetLeft() - l.getInsetRight())) {
                        this.gc.restore();
                        return;
                    }
                }
            }
            switch (l.getHorizontalAlignment()) {
                case 2: 
                case 10: {
                    this.gc.setTextAlign(TextAlignment.LEFT);
                    this.gc.fillText(text, (double)x + (double)l.getInsetLeft(), (double)y + (double)l.getInsetTop());
                    break;
                }
                case 4: 
                case 11: {
                    this.gc.setTextAlign(TextAlignment.RIGHT);
                    this.gc.fillText(text, (double)(x + w) - (double)l.getInsetRight(), (double)y + (double)l.getInsetTop());
                    break;
                }
                case 0: {
                    this.gc.setTextAlign(TextAlignment.LEFT);
                    String string = l.getText();
                    Font font3 = l.getFont();
                    Intrinsics.checkNotNull((Object)font3);
                    Bounds b = this.headless.computeStringBounds(string, font3);
                    double width = Math.max(0.0, ((double)(w - l.getInsetLeft() - l.getInsetRight()) - b.getWidth()) / (double)2);
                    this.gc.fillText(text, (double)x + width + (double)l.getInsetLeft(), (double)y + (double)l.getInsetTop());
                }
            }
        }
        this.gc.restore();
    }

    @Override
    @NotNull
    public PreferredSize sizeLabel(@NotNull EnhancedLabel l, int w, int h) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        return new PreferredSize(this, l){
            final /* synthetic */ JavaFXTGraphics this$0;
            final /* synthetic */ EnhancedLabel $l;
            {
                this.this$0 = $receiver;
                this.$l = $l;
            }

            @NotNull
            public Dimension getMinimumSize() {
                return new Dimension(0, (int)this.getPreferredHeight());
            }

            public double getPreferredHeight() {
                Headless headless = JavaFXTGraphics.access$getHeadless$p(this.this$0);
                String string = this.$l.getText();
                Font font = this.$l.getFont();
                Intrinsics.checkNotNull((Object)font);
                Bounds b = headless.computeStringBounds(string, font);
                return b.getHeight();
            }

            @NotNull
            public Dimension getPreferredSize() {
                Headless headless = JavaFXTGraphics.access$getHeadless$p(this.this$0);
                String string = this.$l.getText();
                Font font = this.$l.getFont();
                Intrinsics.checkNotNull((Object)font);
                Bounds b = headless.computeStringBounds(string, font);
                return new Dimension((int)b.getWidth(), (int)b.getHeight());
            }

            @NotNull
            public Dimension getMaximumSize() {
                return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
        };
    }

    @Override
    public void save() {
        this.gc.save();
    }

    @Override
    public void restore() {
        this.gc.restore();
    }

    @Override
    public void setGlobalAlpha(double alpha) {
        this.gc.setGlobalAlpha(alpha);
    }

    public final void setPaint(@Nullable Paint paint) {
        if (paint != null) {
            this.paint = paint;
            if (paint instanceof Color) {
                this.setColor(MkColorKt.colorOf((javafx.scene.paint.Color)this.awtColorToJavaFX((Color)paint)));
            } else if (paint instanceof GradientPaint) {
                Paint gp = paint;
                Stop[] stopArray = new Stop[2];
                Color color = ((GradientPaint)gp).getColor1();
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getColor1(...)");
                stopArray[0] = new Stop(0.0, this.awtColorToJavaFX(color));
                Color color2 = ((GradientPaint)gp).getColor2();
                Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getColor2(...)");
                stopArray[1] = new Stop(1.0, this.awtColorToJavaFX(color2));
                Stop[] stops = stopArray;
                Point2D p1 = ((GradientPaint)gp).getPoint1();
                Point2D p2 = ((GradientPaint)gp).getPoint2();
                LinearGradient lg = new LinearGradient(p1.getX(), p1.getY(), p2.getX(), p2.getY(), false, CycleMethod.NO_CYCLE, Arrays.copyOf(stops, stops.length));
                this.gc.setStroke((javafx.scene.paint.Paint)lg);
                this.gc.setFill((javafx.scene.paint.Paint)lg);
            } else if (paint instanceof MultipleGradientPaint) {
                Paint mgp = paint;
                Color[] colors = ((MultipleGradientPaint)mgp).getColors();
                float[] fractions = ((MultipleGradientPaint)mgp).getFractions();
                Stop[] stops = new Stop[colors.length];
                int n = colors.length;
                for (int i = 0; i < n; ++i) {
                    double d = fractions[i];
                    Color color = colors[i];
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"get(...)");
                    stops[i] = new Stop(d, this.awtColorToJavaFX(color));
                }
                Point2D center = null;
                Point2D focus = null;
                if (paint instanceof RadialGradientPaint) {
                    Paint rgp = paint;
                    Point2D point2D = ((RadialGradientPaint)rgp).getCenterPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point2D, (String)"getCenterPoint(...)");
                    center = point2D;
                    Point2D point2D2 = ((RadialGradientPaint)rgp).getFocusPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point2D2, (String)"getFocusPoint(...)");
                    focus = point2D2;
                    double focusDistance = focus.distance(center);
                    double focusAngle = 0.0;
                    if (!Intrinsics.areEqual((Object)focus, (Object)center)) {
                        focusAngle = Math.atan2(focus.getY() - center.getY(), focus.getX() - center.getX());
                    }
                    double radius = ((RadialGradientPaint)rgp).getRadius();
                    RadialGradient rg = new RadialGradient(Math.toDegrees(focusAngle), focusDistance, center.getX(), center.getY(), radius, false, CycleMethod.NO_CYCLE, Arrays.copyOf(stops, stops.length));
                    this.gc.setStroke((javafx.scene.paint.Paint)rg);
                    this.gc.setFill((javafx.scene.paint.Paint)rg);
                } else if (paint instanceof LinearGradientPaint) {
                    Paint lgp = paint;
                    Point2D point2D = ((LinearGradientPaint)lgp).getStartPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point2D, (String)"getStartPoint(...)");
                    center = point2D;
                    Point2D point2D3 = ((LinearGradientPaint)lgp).getEndPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point2D3, (String)"getEndPoint(...)");
                    focus = point2D3;
                    LinearGradient lg = new LinearGradient(center.getX(), center.getY(), focus.getX(), focus.getY(), false, CycleMethod.NO_CYCLE, Arrays.copyOf(stops, stops.length));
                    this.gc.setStroke((javafx.scene.paint.Paint)lg);
                    this.gc.setFill((javafx.scene.paint.Paint)lg);
                }
            }
        }
    }

    @Override
    public void setFill(@Nullable javafx.scene.paint.Color c) {
        javafx.scene.paint.Color color = c;
        Intrinsics.checkNotNull((Object)color);
        this.gc.setFill((javafx.scene.paint.Paint)color);
    }

    @Override
    public void setStroke(@Nullable javafx.scene.paint.Color c) {
        javafx.scene.paint.Color color = c;
        Intrinsics.checkNotNull((Object)color);
        this.gc.setStroke((javafx.scene.paint.Paint)color);
    }

    @Override
    public void setColor(@Nullable javafx.scene.paint.Color c) {
        this.color = c;
        javafx.scene.paint.Color color = c;
        this.gc.setFill((javafx.scene.paint.Paint)(color != null ? (javafx.scene.paint.Paint)color : null));
        javafx.scene.paint.Color color2 = c;
        this.gc.setStroke((javafx.scene.paint.Paint)(color2 != null ? (javafx.scene.paint.Paint)color2 : null));
    }

    @Override
    public void setRadialGradient() {
    }

    @Override
    public boolean isPaintingForPrint() {
        return false;
    }

    @Override
    public void setPaintingForPrint(boolean paintingForPrint) {
    }

    @Override
    @NotNull
    public Object getNativeGraphics() {
        return this.gc;
    }

    @Override
    @NotNull
    public IGraphics getIGraphics() {
        return (IGraphics)new JavaFXIGraphics(this.gc);
    }

    @NotNull
    public final javafx.scene.paint.Color awtColorToJavaFX(@NotNull Color c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        javafx.scene.paint.Color color = javafx.scene.paint.Color.rgb((int)c.getRed(), (int)c.getGreen(), (int)c.getBlue(), (double)((double)c.getAlpha() / 255.0));
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"rgb(...)");
        return color;
    }

    @Override
    @NotNull
    public javafx.scene.paint.Color getBackground() {
        return this.background;
    }

    @Override
    public void setBackground(@NotNull javafx.scene.paint.Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
    }

    @Override
    public void setLineWidth(double lw) {
        this.gc.setLineWidth(lw);
    }

    @Override
    public void setLineDash(@Nullable double[] dashPattern) {
        Intrinsics.checkNotNull((Object)dashPattern);
        double[] dArray = dashPattern;
        this.gc.setLineDashes(Arrays.copyOf(dArray, dArray.length));
    }

    @NotNull
    public final StrokeLineCap awtToJavaFXLineCap(int c) {
        return switch (c) {
            case 0 -> StrokeLineCap.BUTT;
            case 1 -> StrokeLineCap.ROUND;
            case 2 -> StrokeLineCap.SQUARE;
            default -> throw new IllegalArgumentException("Unrecognised cap code: " + c);
        };
    }

    @NotNull
    public final StrokeLineJoin awtToJavaFXLineJoin(int j) {
        return switch (j) {
            case 2 -> StrokeLineJoin.BEVEL;
            case 0 -> StrokeLineJoin.MITER;
            case 1 -> StrokeLineJoin.ROUND;
            default -> throw new IllegalArgumentException("Unrecognised join code: " + j);
        };
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final double[] floatToDoubleArray(@Nullable float[] f) {
        double[] dArray;
        if (f == null) {
            dArray = null;
        } else {
            void var2_2;
            double[] d = new double[f.length];
            int n = f.length;
            for (int i = 0; i < n; ++i) {
                d[i] = f[i];
            }
            dArray = var2_2;
        }
        return dArray;
    }

    @Override
    public boolean isInterpolationBilinear() {
        return false;
    }

    @Override
    public void setInterpolationBilinear(boolean bilinear) {
    }

    @Override
    public boolean isAntialias() {
        return false;
    }

    @Override
    public void setAntialias(boolean antialias) {
    }

    @Override
    public boolean isTextAntialias() {
        return false;
    }

    @Override
    public void setTextAntialias(boolean antialias) {
    }

    @Override
    public void stroke(@Nullable Shape s) {
        if (!(this.stroke == null || this.stroke instanceof BasicStroke)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (s instanceof Rectangle2D) {
            this.gc.strokeRect(((Rectangle2D)s).getX(), ((Rectangle2D)s).getY(), ((Rectangle2D)s).getWidth(), ((Rectangle2D)s).getHeight());
        } else if (s instanceof RoundRectangle2D) {
            this.gc.strokeRoundRect(((RoundRectangle2D)s).getX(), ((RoundRectangle2D)s).getY(), ((RoundRectangle2D)s).getWidth(), ((RoundRectangle2D)s).getHeight(), ((RoundRectangle2D)s).getArcWidth(), ((RoundRectangle2D)s).getArcHeight());
        } else if (s instanceof Ellipse2D) {
            this.gc.strokeOval(((Ellipse2D)s).getX(), ((Ellipse2D)s).getY(), ((Ellipse2D)s).getWidth(), ((Ellipse2D)s).getHeight());
        } else if (s instanceof Arc2D) {
            this.gc.strokeArc(((Arc2D)s).getX(), ((Arc2D)s).getY(), ((Arc2D)s).getWidth(), ((Arc2D)s).getHeight(), ((Arc2D)s).getAngleStart(), ((Arc2D)s).getAngleExtent(), this.intToArcType(((Arc2D)s).getArcType()));
        } else {
            Shape shape = s;
            Intrinsics.checkNotNull((Object)shape);
            this.shapeToPath(shape);
            this.gc.stroke();
        }
    }

    public final void shapeToPath(@NotNull Shape s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.gc.beginPath();
        PathIterator iterator2 = s.getPathIterator(null);
        while (!iterator2.isDone()) {
            int segType = iterator2.currentSegment(this.coords);
            switch (segType) {
                case 0: {
                    this.gc.moveTo(this.coords[0], this.coords[1]);
                    break;
                }
                case 1: {
                    this.gc.lineTo(this.coords[0], this.coords[1]);
                    break;
                }
                case 2: {
                    this.gc.quadraticCurveTo(this.coords[0], this.coords[1], this.coords[2], this.coords[3]);
                    break;
                }
                case 3: {
                    this.gc.bezierCurveTo(this.coords[0], this.coords[1], this.coords[2], this.coords[3], this.coords[4], this.coords[5]);
                    break;
                }
                case 4: {
                    this.gc.closePath();
                    break;
                }
                default: {
                    throw new RuntimeException("Unrecognised segment type " + segType);
                }
            }
            iterator2.next();
        }
    }

    @NotNull
    public final ArcType intToArcType(int t) {
        return switch (t) {
            case 1 -> ArcType.CHORD;
            case 0 -> ArcType.OPEN;
            case 2 -> ArcType.ROUND;
            default -> throw new IllegalArgumentException("Unrecognised t: " + t);
        };
    }

    @Override
    public void fill(@Nullable Shape s) {
        if (s instanceof Rectangle2D) {
            Shape r = s;
            this.gc.fillRect(((Rectangle2D)r).getX(), ((Rectangle2D)r).getY(), ((Rectangle2D)r).getWidth(), ((Rectangle2D)r).getHeight());
        } else if (s instanceof RoundRectangle2D) {
            RoundRectangle2D rr = (RoundRectangle2D)s;
            this.gc.fillRoundRect(rr.getX(), rr.getY(), rr.getWidth(), rr.getHeight(), rr.getArcWidth(), rr.getArcHeight());
        } else if (s instanceof Ellipse2D) {
            Ellipse2D e = (Ellipse2D)s;
            this.gc.fillOval(e.getX(), e.getY(), e.getWidth(), e.getHeight());
        } else if (s instanceof Arc2D) {
            Arc2D a = (Arc2D)s;
            this.gc.fillArc(a.getX(), a.getY(), a.getWidth(), a.getHeight(), a.getAngleStart(), a.getAngleExtent(), this.intToArcType(a.getArcType()));
        } else {
            Shape shape = s;
            Intrinsics.checkNotNull((Object)shape);
            this.shapeToPath(shape);
            this.gc.fill();
        }
    }

    @Override
    @NotNull
    public Font getFont() {
        Font font = this.gc.getFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        return font;
    }

    @Override
    public void setFont(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        this.gc.setFont(font);
    }

    @NotNull
    public final Rectangle2D getStringBounds(@Nullable String text) {
        Text t = new Text(text);
        t.setFont(this.gc.getFont());
        Bounds stringBounds = t.getLayoutBounds();
        return (Rectangle2D)new Rectangle2D.Double(stringBounds.getMinX(), stringBounds.getMinY(), stringBounds.getWidth(), stringBounds.getHeight());
    }

    @Override
    public double getStringWidth(@Nullable String text) {
        return this.getStringBounds(text).getWidth();
    }

    @Override
    public void fillText(@Nullable String str, float x, float y) {
        if (str == null) {
            throw new NullPointerException("Null 'str' argument.");
        }
        this.gc.fillText(str, (double)x, (double)y);
    }

    @Override
    public void translate(double tx, double ty) {
        AffineTransform affineTransform = this.getTransform();
        Intrinsics.checkNotNull((Object)affineTransform);
        affineTransform.translate(tx, ty);
        this.gc.translate(tx, ty);
    }

    @Override
    public void rotate(double theta) {
        AffineTransform affineTransform = this.getTransform();
        Intrinsics.checkNotNull((Object)affineTransform);
        affineTransform.rotate(theta);
        this.gc.rotate(Math.toDegrees(theta));
    }

    @Override
    public void rotateTranslate(double theta, double x, double y) {
        this.translate(x, y);
        this.rotate(theta);
        this.translate(-x, -y);
    }

    @Override
    public void scale(double sx, double sy) {
        AffineTransform affineTransform = this.getTransform();
        Intrinsics.checkNotNull((Object)affineTransform);
        affineTransform.scale(sx, sy);
        this.gc.scale(sx, sy);
    }

    @Override
    public void shear(double shx, double shy) {
        this.transform(AffineTransform.Companion.getShearInstance(shx, shy));
    }

    @Override
    public void transform(@Nullable AffineTransform t) {
        AffineTransform tx;
        AffineTransform affineTransform = tx = this.getTransform();
        Intrinsics.checkNotNull((Object)affineTransform);
        AffineTransform affineTransform2 = t;
        Intrinsics.checkNotNull((Object)affineTransform2);
        affineTransform.concatenate(affineTransform2);
        this.setTransform(tx);
    }

    @Override
    @Nullable
    public AffineTransform getTransform() {
        AffineTransform affineTransform = this.transform;
        Intrinsics.checkNotNull((Object)affineTransform);
        return new AffineTransform(affineTransform);
    }

    @Override
    public void setTransform(@Nullable AffineTransform t) {
        AffineTransform t2 = t;
        if (t2 == null) {
            this.transform = new AffineTransform();
            t2 = this.getTransform();
        } else {
            this.transform = new AffineTransform(t2);
        }
        AffineTransform affineTransform = t2;
        Intrinsics.checkNotNull((Object)affineTransform);
        this.gc.setTransform(affineTransform.getScaleX(), t2.getShearY(), t2.getShearX(), t2.getScaleY(), t2.getTranslateX(), t2.getTranslateY());
    }

    @Override
    public void clip(@Nullable Shape s) {
        if (s instanceof Rectangle2D) {
            Shape r = s;
            this.gc.beginPath();
            this.gc.rect(Math.floor(((Rectangle2D)r).getX()), Math.floor(((Rectangle2D)r).getY()), Math.ceil(((Rectangle2D)r).getWidth()), Math.ceil(((Rectangle2D)r).getHeight()));
        } else {
            Shape shape = s;
            Intrinsics.checkNotNull((Object)shape);
            this.shapeToPath(shape);
        }
        this.gc.clip();
    }

    @Override
    public void strokeLine(int x1, int y1, int x2, int y2) {
        this.gc.strokeLine((double)x1, (double)y1, (double)x2, (double)y2);
    }

    public final void fillRect(int x, int y, int width, int height) {
        this.gc.fillRect((double)x, (double)y, (double)width, (double)height);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        if (this.getBackground() != null) {
            this.fillRect(x, y, width, height);
        }
    }

    @Override
    public void strokeRect(double x, double y, double width, double height) {
        this.gc.strokeRect(x, y, width, height);
    }

    @Override
    public void fillRect(double x, double y, double width, double height) {
        this.gc.fillRect(x, y, width, height);
    }

    @Override
    public void strokeRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        this.gc.strokeRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        this.gc.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.gc.strokeOval((double)x, (double)y, (double)width, (double)height);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.gc.fillOval((double)x, (double)y, (double)width, (double)height);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.gc.strokeArc((double)x, (double)y, (double)width, (double)height, (double)startAngle, (double)arcAngle, this.intToArcType(0));
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.gc.fillArc((double)x, (double)y, (double)width, (double)height, (double)startAngle, (double)arcAngle, this.intToArcType(0));
    }

    @Override
    public void drawPolyline(@Nullable int[] xPoints, @Nullable int[] yPoints, int nPoints) {
        Intrinsics.checkNotNull((Object)xPoints);
        Intrinsics.checkNotNull((Object)yPoints);
        GeneralPath p = this.createPolygon(xPoints, yPoints, nPoints, false);
        this.stroke((Shape)p);
    }

    @Override
    public void drawPolygon(@Nullable int[] xPoints, @Nullable int[] yPoints, int nPoints) {
        Intrinsics.checkNotNull((Object)xPoints);
        Intrinsics.checkNotNull((Object)yPoints);
        GeneralPath p = this.createPolygon(xPoints, yPoints, nPoints, true);
        this.stroke((Shape)p);
    }

    @Override
    public void fillPolygon(@Nullable int[] xPoints, @Nullable int[] yPoints, int nPoints) {
        Intrinsics.checkNotNull((Object)xPoints);
        Intrinsics.checkNotNull((Object)yPoints);
        GeneralPath p = this.createPolygon(xPoints, yPoints, nPoints, true);
        this.fill((Shape)p);
    }

    @NotNull
    public final GeneralPath createPolygon(@NotNull int[] xPoints, @NotNull int[] yPoints, int nPoints, boolean close) {
        Intrinsics.checkNotNullParameter((Object)xPoints, (String)"xPoints");
        Intrinsics.checkNotNullParameter((Object)yPoints, (String)"yPoints");
        GeneralPath p = new GeneralPath();
        p.moveTo((double)xPoints[0], (double)yPoints[0]);
        for (int i = 1; i < nPoints; ++i) {
            p.lineTo((double)xPoints[i], (double)yPoints[i]);
        }
        if (close) {
            p.closePath();
        }
        return p;
    }

    @Override
    @NotNull
    public CPImage createImage(int width, int height) {
        return new CPImage(width, height);
    }

    public final boolean drawNativeImage(@Nullable Image img, int x, int y) {
        boolean bl;
        if (img == null) {
            bl = true;
        } else {
            int w = img.getWidth(null);
            if (w < 0) {
                bl = false;
            } else {
                int h = img.getHeight(null);
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean drawImage(@Nullable CPImage img, int x, int y) {
        CPImage cPImage = img;
        Intrinsics.checkNotNull((Object)cPImage);
        WritableImage nativeImage = cPImage.getNativeImage();
        this.gc.drawImage((javafx.scene.image.Image)nativeImage, (double)x, (double)y);
        return true;
    }

    @Override
    public boolean drawImageStretch(@Nullable CPImage img, int x, int y, int w, int h) {
        CPImage cPImage = img;
        Intrinsics.checkNotNull((Object)cPImage);
        WritableImage nativeImage = cPImage.getNativeImage();
        this.gc.drawImage((javafx.scene.image.Image)nativeImage, (double)x, (double)y, (double)w, (double)h);
        return true;
    }

    public static final /* synthetic */ Headless access$getHeadless$p(JavaFXTGraphics $this) {
        return $this.headless;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/treemap/crossplatform/JavaFXTGraphics$Companion;", "", "()V", "text", "Ljavafx/scene/text/Text;", "getText", "()Ljavafx/scene/text/Text;", "setText", "(Ljavafx/scene/text/Text;)V", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Text getText() {
            return text;
        }

        public final void setText(@Nullable Text text) {
            JavaFXTGraphics.text = text;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

