/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.tagcloud;

import androidx.compose.runtime.internal.StabilityInferred;
import com.treemap.tagcloud.LinearizedPathIterator;
import com.treemap.tagcloud.Point2d;
import com.treemap.tagcloud.Vector2d;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0006J\b\u0010\u001a\u001a\u00020\u0014H\u0002J\b\u0010\u001b\u001a\u00020\u0014H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/treemap/tagcloud/PositionIterator;", "", "outline", "Lorg/mkui/geom/Shape;", "(Lorg/mkui/geom/Shape;)V", "absoluteStepSize", "", "currentOutlineWidth", "linearizedPathIterator", "Lcom/treemap/tagcloud/LinearizedPathIterator;", "offset", "Lcom/treemap/tagcloud/Vector2d;", "outlineBounds", "Lorg/mkui/geom/Rectangle2D;", "outlineBoundsAspect", "positionOnPath", "relativeStepSize", "scale", "shellStep", "doubleStepSize", "", "getNextPosition", "position", "Lcom/treemap/tagcloud/Point2d;", "resetIterator", "startOutlineWidth", "updateRelativeStepSize", "updateScaleAndOfffset", "treemap"})
@StabilityInferred(parameters=0)
public final class PositionIterator {
    private double positionOnPath;
    private double relativeStepSize;
    @NotNull
    private final Rectangle2D outlineBounds;
    @NotNull
    private final LinearizedPathIterator linearizedPathIterator;
    private double currentOutlineWidth;
    private final double outlineBoundsAspect;
    @NotNull
    private final Vector2d offset;
    private double scale;
    private double shellStep;
    private double absoluteStepSize;
    public static final int $stable = 8;

    public PositionIterator(@NotNull Shape outline) {
        Intrinsics.checkNotNullParameter((Object)outline, (String)"outline");
        this.offset = new Vector2d();
        this.linearizedPathIterator = new LinearizedPathIterator(outline);
        this.outlineBounds = outline.getBounds2D();
        this.outlineBoundsAspect = this.outlineBounds.getWidth() / this.outlineBounds.getHeight();
        this.resetIterator(1.0);
    }

    public final void getNextPosition(@NotNull Point2d position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.positionOnPath += this.relativeStepSize;
        if (this.positionOnPath >= 1.0) {
            this.currentOutlineWidth += this.shellStep;
            this.positionOnPath = 0.0;
            this.updateScaleAndOfffset();
            this.updateRelativeStepSize();
        }
        this.linearizedPathIterator.getPointOnPath(this.positionOnPath, position);
        position.scale(this.scale);
        position.add(this.offset);
    }

    public final void resetIterator(double startOutlineWidth) {
        this.shellStep = startOutlineWidth / (double)2;
        this.currentOutlineWidth = startOutlineWidth;
        this.positionOnPath = 0.0;
        this.absoluteStepSize = startOutlineWidth;
        this.updateScaleAndOfffset();
        this.updateRelativeStepSize();
    }

    private final void updateRelativeStepSize() {
        double scaledOutlineLength = this.linearizedPathIterator.getOutlineLength() * this.scale;
        double nSteps = scaledOutlineLength / this.absoluteStepSize;
        this.relativeStepSize = 1.0 / nSteps;
    }

    private final void updateScaleAndOfffset() {
        this.scale = this.currentOutlineWidth / this.outlineBounds.getWidth();
        this.offset.set(-this.currentOutlineWidth / 2.0 - this.outlineBounds.getX() * this.scale, -this.currentOutlineWidth / this.outlineBoundsAspect / 2.0 - this.outlineBounds.getY() * this.scale);
    }

    public final void doubleStepSize() {
        this.relativeStepSize *= 2.0;
    }
}

