/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.geom.Dimension;
import com.macrofocus.common.geom.PreferredSize;
import com.treemap.Labeling;
import com.treemap.TreeMapColumnSettings;
import com.treemap.TreeMapLabelRenderer;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapSettings;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.TGraphics;
import corg.mkui.geom.Area;
import io.nacular.doodle.drawing.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.font.MkFont;
import org.mkui.font.MkFontKt;
import org.mkui.geom.PathIterator;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;
import org.mkui.labeling.EnhancedLabel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b'\u0018\u0000 32\u00020\u0001:\u00013B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\u0004j\u0002`\u00052\n\u0010\t\u001a\u00060\u0004j\u0002`\u0005H\u0004J6\u0010\n\u001a\u00020\u000b\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\r\"\u0004\b\u0002\u0010\u000e2\u001a\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000e\u0018\u00010\u0010H\u0016Jc\u0010\u0011\u001a\u00020\u000b\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\r\"\u0004\b\u0002\u0010\u000e2\u0006\u0010\u0012\u001a\u0002H\f2\u0006\u0010\u0013\u001a\u0002H\f2\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000e0\u00152\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000e0\u0010H\u0016\u00a2\u0006\u0002\u0010\u0016J6\u0010\u0017\u001a\u00020\u000b\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\r\"\u0004\b\u0002\u0010\u000e2\u001a\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000e\u0018\u00010\u0010H\u0016JR\u0010\u0018\u001a\n\u0012\u0004\u0012\u0002H\u000e\u0018\u00010\u0019\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\r\"\u0004\b\u0002\u0010\u000e2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000e0\u00102\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0004J\u0091\u0001\u0010\u001d\u001a\u00020\u001c\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\r\"\u0004\b\u0002\u0010\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0013\u001a\u0002H\f2\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000e0\u00152\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000e0\u00102\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00192\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001cH\u0004\u00a2\u0006\u0002\u0010'JS\u0010(\u001a\u00020)\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\r\"\u0004\b\u0002\u0010\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u0002H\f2\b\u0010*\u001a\u0004\u0018\u0001H\u000e2\u0006\u0010+\u001a\u00020,2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010-\u001a\u00020#H\u0004\u00a2\u0006\u0002\u0010.JY\u0010/\u001a\u00020)\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\r\"\u0004\b\u0002\u0010\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0013\u001a\u0002H\f2\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000e0\u0015H\u0016\u00a2\u0006\u0002\u00100JO\u00101\u001a\u0004\u0018\u00010!\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\r\"\u0004\b\u0002\u0010\u000e2\u001a\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000e\u0018\u00010\u00102\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0013\u001a\u0002H\fH\u0016\u00a2\u0006\u0002\u00102\u00a8\u00064"}, d2={"Lcom/treemap/AbstractLabeling;", "Lcom/treemap/Labeling;", "()V", "adjustLabelColor", "Lio/nacular/doodle/drawing/Color;", "Lorg/mkui/color/MkColor;", "settings", "Lcom/treemap/TreeMapColumnSettings;", "foreground", "nodeColor", "getLeftSpace", "", "N", "Row", "Column", "model", "Lcom/treemap/TreeMapModel;", "getTopHeaderSpacing", "parent", "node", "view", "Lcom/treemap/TreeMapView;", "(Ljava/lang/Object;Ljava/lang/Object;Lcom/treemap/TreeMapView;Lcom/treemap/TreeMapModel;)D", "getTopSpace", "getTreeMapColumnByVerticalAlignment", "", "columns", "alignement", "", "paintColumns", "g2", "Lcom/treemap/crossplatform/TGraphics;", "shape", "Lorg/mkui/geom/Shape;", "bounds", "Lorg/mkui/geom/Rectangle;", "paint", "", "y", "(Lcom/treemap/crossplatform/TGraphics;Lorg/mkui/geom/Shape;Lorg/mkui/geom/Rectangle;Ljava/lang/Object;Lcom/treemap/TreeMapView;Lcom/treemap/TreeMapModel;Ljava/util/List;ZI)I", "paintLabel", "", "column", "label", "Lorg/mkui/labeling/EnhancedLabel;", "drawingArea", "(Lcom/treemap/crossplatform/TGraphics;Ljava/lang/Object;Ljava/lang/Object;Lorg/mkui/labeling/EnhancedLabel;Lorg/mkui/geom/Rectangle;Lorg/mkui/geom/Rectangle;)V", "paintLeaf", "(Lcom/treemap/crossplatform/TGraphics;Lorg/mkui/geom/Shape;Lorg/mkui/geom/Rectangle;Ljava/lang/Object;Lcom/treemap/TreeMapView;)V", "subtract", "(Lcom/treemap/TreeMapModel;Lorg/mkui/geom/Shape;Ljava/lang/Object;)Lorg/mkui/geom/Shape;", "Companion", "treemap"})
@StabilityInferred(parameters=1)
public abstract class AbstractLabeling
implements Labeling {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    public static final float SHARE_OF_ZOOM_FACTOR = 0.15f;
    public static final float COLOR_SIMILARITY_THRESHOLD = 0.5f;

    @Override
    @Nullable
    public <N, Row, Column> Shape subtract(@Nullable TreeMapModel<N, Row, Column> model, @Nullable Shape shape, N node) {
        return shape;
    }

    @Override
    public <N, Row, Column> double getTopSpace(@Nullable TreeMapModel<N, Row, Column> model) {
        return 0.0;
    }

    @Override
    public <N, Row, Column> double getLeftSpace(@Nullable TreeMapModel<N, Row, Column> model) {
        return 0.0;
    }

    @Override
    public <N, Row, Column> void paintLeaf(@NotNull TGraphics g2, @NotNull Shape shape, @NotNull Rectangle bounds, N node, @NotNull TreeMapView<N, Row, Column> view) {
        List<Column> columns;
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter(view, (String)"view");
        TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
        Intrinsics.checkNotNull(treeMapModel);
        TreeMapModel<N, Row, Column> model = treeMapModel;
        if (!model.getFilter().isFiltered(node) && !model.getSearch().isFiltered(node) && !((Collection)(columns = model.getSettings().getLabelsColumns())).isEmpty()) {
            List<Column> bottomFields;
            List<Column> centerFields;
            int n;
            int initialY = 0;
            N n2 = model.getParent(node);
            Intrinsics.checkNotNull(n2);
            N parent = n2;
            if (!model.isRoot(parent)) {
                TreeMapSettings<Column> treeMapSettings = model.getSettings();
                Column Column = model.getGroupByColumn(parent);
                Intrinsics.checkNotNull(Column);
                TreeMapColumnSettings groupByColumnSettings = treeMapSettings.getColumnSettings(Column);
                Labeling labeling = groupByColumnSettings.getLabeling();
                Intrinsics.checkNotNull((Object)labeling);
                Labeling labeling2 = labeling;
                n = bounds.getIy() + (int)Math.rint(labeling2.getTopHeaderSpacing(parent, node, view, model));
            } else {
                n = bounds.getIy();
            }
            initialY = n;
            int y = 0;
            y = initialY;
            int todo = 0;
            todo = columns.size();
            AbstractLabeling $this$paintLeaf_u24lambda_u240 = this;
            boolean bl = false;
            List<Column> topFields = $this$paintLeaf_u24lambda_u240.getTreeMapColumnByVerticalAlignment(model, columns, 1);
            if (topFields != null) {
                int topHeight = $this$paintLeaf_u24lambda_u240.paintColumns(g2, shape, bounds, node, view, model, topFields, true, y);
                if (topHeight > 0) {
                    y += topHeight;
                    todo -= topFields.size();
                } else {
                    return;
                }
            }
            if (todo > 0 && (centerFields = this.getTreeMapColumnByVerticalAlignment(model, columns, 0)) != null) {
                int centerHeight = this.paintColumns(g2, shape, bounds, node, view, model, centerFields, false, initialY);
                if (centerHeight > 0) {
                    int center = bounds.getIy() + (bounds.getIheight() - centerHeight) / 2;
                    if (center > y) {
                        y = center;
                    }
                    this.paintColumns(g2, shape, bounds, node, view, model, centerFields, true, y);
                    y += centerHeight;
                    todo -= centerFields.size();
                } else {
                    return;
                }
            }
            if (todo > 0 && (bottomFields = this.getTreeMapColumnByVerticalAlignment(model, columns, 3)) != null) {
                int bottomHeight = this.paintColumns(g2, shape, bounds, node, view, model, bottomFields, false, initialY);
                if (bottomHeight > 0) {
                    int top = bounds.getIy() + (bounds.getIheight() - bottomHeight);
                    if (top > y) {
                        y = top;
                    }
                    this.paintColumns(g2, shape, bounds, node, view, model, bottomFields, true, y);
                    y += bottomHeight;
                } else {
                    return;
                }
            }
        }
    }

    @Nullable
    protected final <N, Row, Column> List<Column> getTreeMapColumnByVerticalAlignment(@NotNull TreeMapModel<N, Row, Column> model, @NotNull List<? extends Column> columns, int alignement) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        List list = null;
        for (Column column : columns) {
            Integer n = model.getSettings().getColumnSettings(column).getLabelingVerticalAlignment();
            int n2 = alignement;
            if (n == null || n != n2) continue;
            if (list == null) {
                list = new ArrayList();
            }
            list.add(column);
        }
        return list;
    }

    protected final <N, Row, Column> int paintColumns(@NotNull TGraphics g2, @NotNull Shape shape, @NotNull Rectangle bounds, N node, @NotNull TreeMapView<N, Row, Column> view, @NotNull TreeMapModel<N, Row, Column> model, @NotNull List<? extends Column> columns, boolean paint, int y) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        int height = 0;
        for (Column column : columns) {
            Dimension preferredSize;
            boolean expand;
            boolean shrink;
            MkFont font;
            Color foreground;
            Color background;
            TreeMapColumnSettings columnSettings;
            block15: {
                block14: {
                    if (column == null) continue;
                    columnSettings = model.getSettings().getColumnSettings(column);
                    background = columnSettings.getLabelingEffectColor();
                    foreground = columnSettings.getLabelingForeground();
                    if (foreground == null) continue;
                    font = columnSettings.getLabelingFont();
                    Boolean bl = columnSettings.getLabelingShrinkTextToFitShape();
                    Intrinsics.checkNotNull((Object)bl);
                    shrink = bl;
                    Boolean bl2 = columnSettings.getLabelingResizeTextToFitShape();
                    Intrinsics.checkNotNull((Object)bl2);
                    expand = bl2;
                    if (!shrink && !expand) {
                        double zoomedSize;
                        MkFont mkFont = font;
                        Intrinsics.checkNotNull((Object)mkFont);
                        if (!(MkFontKt.getFontSize((MkFont)mkFont) <= bounds.getHeight()) || !(bounds.getWidth() > 4.0)) continue;
                        float zoomFactor = view.getZoomFactor();
                        MkFont derivedFont = null;
                        MkFont mkFont2 = !(zoomFactor == 1.0f) ? (!((zoomedSize = MkFontKt.getFontSize((MkFont)font) * (double)(1.0f + ((float)Math.sqrt(zoomFactor) - 1.0f) * 0.15f)) == MkFontKt.getFontSize((MkFont)font)) ? MkFontKt.deriveFontSize((MkFont)font, (double)zoomedSize) : font) : font;
                        derivedFont = mkFont2;
                        if (!(MkFontKt.getFontSize((MkFont)derivedFont) <= bounds.getHeight())) continue;
                        TreeMapLabelRenderer<N, Row, Column> treeMapLabelRenderer = view.getLabelRenderer();
                        Intrinsics.checkNotNull(treeMapLabelRenderer);
                        EnhancedLabel label = treeMapLabelRenderer.getTreeMapLabelRendererComponent(view, column, node, new Dimension(bounds.getIwidth(), bounds.getIheight()));
                        if (label == null) continue;
                        Color nodeColor = model.getColor(node);
                        if (background == null && nodeColor != null) {
                            foreground = this.adjustLabelColor(columnSettings, foreground, nodeColor);
                        }
                        label.setFont(derivedFont);
                        label.setForeground(foreground);
                        label.setBackground(background);
                        PreferredSize size = g2.sizeLabel(label, bounds.getIwidth(), bounds.getIheight());
                        double preferredHeight = size.getPreferredHeight();
                        int cy = y + height;
                        if (!((double)cy + preferredHeight <= bounds.getY() + bounds.getHeight())) break;
                        if (paint) {
                            Rectangle drawingArea = Companion.findEnclosedRectangle(shape, cy, (int)preferredHeight);
                            this.paintLabel(g2, node, column, label, bounds, drawingArea);
                        }
                        Boolean bl3 = columnSettings.getLabelingFloat();
                        Intrinsics.checkNotNull((Object)bl3);
                        if (bl3.booleanValue()) continue;
                        height += (int)preferredHeight;
                        continue;
                    }
                    if (!(bounds.getWidth() > 5.0) || !(bounds.getHeight() > 5.0)) continue;
                    if (!expand) break block14;
                    double d = bounds.getHeight();
                    MkFont mkFont = font;
                    Intrinsics.checkNotNull((Object)mkFont);
                    if (d >= MkFontKt.getFontSize((MkFont)mkFont)) break block15;
                }
                if (!shrink) continue;
            }
            TreeMapLabelRenderer<N, Row, Column> treeMapLabelRenderer = view.getLabelRenderer();
            Intrinsics.checkNotNull(treeMapLabelRenderer);
            EnhancedLabel elabel = treeMapLabelRenderer.getTreeMapLabelRendererComponent(view, column, node, new Dimension(bounds.getIwidth(), bounds.getIheight()));
            if (elabel == null) continue;
            int innerWidth = 0;
            int innerHeight = 0;
            int insetWidth = 0;
            int insetHeight = 0;
            insetWidth = elabel.getInsetRight() + elabel.getInsetLeft();
            insetHeight = elabel.getInsetTop() + elabel.getInsetBottom();
            innerWidth = bounds.getIwidth() - insetWidth;
            innerHeight = bounds.getIheight() - insetHeight;
            MkFont mkFont = font;
            Intrinsics.checkNotNull((Object)mkFont);
            elabel.setFont(mkFont);
            Color nodeColor = model.getColor(node);
            if (background == null && nodeColor != null) {
                foreground = this.adjustLabelColor(columnSettings, foreground, nodeColor);
            }
            elabel.setForeground(foreground);
            elabel.setBackground(background);
            PreferredSize pf = g2.sizeLabel(elabel, bounds.getIwidth(), bounds.getIheight());
            double fontSize = 0.0;
            double scaleFactor = 0.9;
            if (columnSettings.getLabelingRendering() != EnhancedLabel.Rendering.WordWrap.INSTANCE) {
                boolean legacy = true;
                preferredSize = pf.getPreferredSize();
                float scaleX = (float)bounds.getWidth() / (float)preferredSize.getWidth();
                float scaleY = (float)bounds.getHeight() / (float)preferredSize.getHeight();
                float scale = Math.min(scaleX, scaleY);
                v10 = MkFontKt.getFontSize((MkFont)font) * (double)scale * scaleFactor;
            } else {
                v10 = fontSize = g2.fitTextInsideRectangle(elabel, pf, font, (Rectangle2D)bounds, scaleFactor, expand);
            }
            if (!shrink) {
                fontSize = Math.max(MkFontKt.getFontSize((MkFont)font), fontSize);
            }
            if (!expand) {
                fontSize = Math.min(MkFontKt.getFontSize((MkFont)font), fontSize);
            }
            if (!(fontSize >= 5.0)) continue;
            MkFont scaledFont = MkFontKt.deriveFontSize((MkFont)font, (double)fontSize);
            elabel.setFont(scaledFont);
            if (!Intrinsics.areEqual((Object)columnSettings.getLabelingRendering(), (Object)EnhancedLabel.Rendering.WordWrap.INSTANCE)) {
                // empty if block
            }
            preferredSize = pf.getPreferredSize();
            if (paint) {
                int cy = y + height;
                Rectangle drawingArea = Companion.findEnclosedRectangle(shape, cy, preferredSize.getIheight());
                this.paintLabel(g2, node, column, elabel, bounds, drawingArea);
            }
            Boolean bl = columnSettings.getLabelingFloat();
            Intrinsics.checkNotNull((Object)bl);
            if (bl.booleanValue()) continue;
            height += preferredSize.getIheight();
        }
        return height;
    }

    protected final <N, Row, Column> void paintLabel(@NotNull TGraphics g2, N node, @Nullable Column column, @NotNull EnhancedLabel label, @Nullable Rectangle bounds, @NotNull Rectangle drawingArea) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)drawingArea, (String)"drawingArea");
        g2.paintLabel(label, drawingArea.getIx(), drawingArea.getIy(), drawingArea.getIwidth(), drawingArea.getIheight());
    }

    @NotNull
    protected final Color adjustLabelColor(@NotNull TreeMapColumnSettings settings, @NotNull Color foreground, @NotNull Color nodeColor) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)foreground, (String)"foreground");
        Intrinsics.checkNotNullParameter((Object)nodeColor, (String)"nodeColor");
        EnhancedLabel.ContrastEnhancement contrastEnhancement = settings.getLabelingContrastEnhancement();
        Intrinsics.checkNotNull((Object)contrastEnhancement);
        return contrastEnhancement.adjustLabelColor(foreground, nodeColor);
    }

    @Override
    public <N, Row, Column> double getTopHeaderSpacing(N parent, N node, @NotNull TreeMapView<N, Row, Column> view, @NotNull TreeMapModel<N, Row, Column> model) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        return 0.0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0002\u0010\nJ\u001b\u0010\u000b\u001a\u00020\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0002\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u0010\u0010\u0015\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u000e\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011J\u0019\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/treemap/AbstractLabeling$Companion;", "", "()V", "COLOR_SIMILARITY_THRESHOLD", "", "SHARE_OF_ZOOM_FACTOR", "calcCenterOfMass", "Lorg/mkui/geom/Point2D;", "points", "", "([Lorg/mkui/geom/Point2D;)Lorg/mkui/geom/Point2D;", "calcSignedPolygonArea", "", "([Lorg/mkui/geom/Point2D;)D", "findEnclosedRectangle", "Lorg/mkui/geom/Rectangle;", "shape", "Lorg/mkui/geom/Shape;", "y", "", "height", "getArea", "getCentroid", "getPoints", "(Lorg/mkui/geom/Shape;)[Lorg/mkui/geom/Point2D;", "treemap"})
    @SourceDebugExtension(value={"SMAP\nAbstractLabeling.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractLabeling.kt\ncom/treemap/AbstractLabeling$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,457:1\n37#2,2:458\n*S KotlinDebug\n*F\n+ 1 AbstractLabeling.kt\ncom/treemap/AbstractLabeling$Companion\n*L\n453#1:458,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Rectangle findEnclosedRectangle(@NotNull Shape shape, int y, int height) {
            Rectangle rectangle;
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            if (shape instanceof Rectangle) {
                Rectangle bounds = (Rectangle)shape;
                rectangle = new Rectangle(bounds.getIx(), y, bounds.getIwidth(), height);
            } else if (shape instanceof Rectangle2D) {
                Rectangle2D bounds = (Rectangle2D)shape;
                rectangle = new Rectangle((int)Math.ceil(bounds.getX()), y, (int)Math.floor(bounds.getWidth()), height);
            } else {
                Rectangle2D bounds = shape.getBounds2D();
                double hh = 0.001;
                Rectangle2D topHit = (Rectangle2D)new Rectangle2D.Double(bounds.getX(), (double)y, bounds.getWidth(), hh);
                Rectangle2D bottomHit = (Rectangle2D)new Rectangle2D.Double(bounds.getX(), (double)(y + height) - hh, bounds.getWidth(), hh);
                Area shapeArea = new Area(shape);
                Area topArea = new Area((Shape)topHit);
                topArea.intersect(shapeArea);
                Area bottomArea = new Area((Shape)bottomHit);
                bottomArea.intersect(shapeArea);
                Rectangle2D topBounds = topArea.getBounds2D();
                Rectangle2D bottomBounds = bottomArea.getBounds2D();
                int x = (int)Math.ceil(Math.max(topBounds.getMinX(), bottomBounds.getMinX()));
                int width = (int)Math.floor(Math.min(topBounds.getMaxX(), bottomBounds.getMaxX())) - x;
                rectangle = new Rectangle(x, y, width, height);
            }
            return rectangle;
        }

        public final double getArea(@Nullable Shape shape) {
            return shape != null ? this.calcSignedPolygonArea(this.getPoints(shape)) : 0.0;
        }

        private final double calcSignedPolygonArea(Point2D[] points) {
            int N = points.length;
            int i = 0;
            int j = 0;
            double area = 0.0;
            for (i = 0; i < N; ++i) {
                j = (i + 1) % N;
                area += points[i].getX() * points[j].getY();
                area -= points[i].getY() * points[j].getX();
            }
            return area /= 2.0;
        }

        @NotNull
        public final Point2D calcCenterOfMass(@NotNull Point2D[] points) {
            Intrinsics.checkNotNullParameter((Object)points, (String)"points");
            int N = points.length;
            double cx = 0.0;
            double cy = 0.0;
            double area = this.calcSignedPolygonArea(points);
            int i = 0;
            int j = 0;
            double factor = 0.0;
            for (i = 0; i < N; ++i) {
                j = (i + 1) % N;
                factor = points[i].getX() * points[j].getY() - points[j].getX() * points[i].getY();
                cx += (points[i].getX() + points[j].getX()) * factor;
                cy += (points[i].getY() + points[j].getY()) * factor;
            }
            factor = 1.0 / (area *= 6.0);
            return (Point2D)new Point2D.Double(cx *= factor, cy *= factor);
        }

        @NotNull
        public final Point2D getCentroid(@NotNull Shape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Point2D[] points = this.getPoints(shape);
            return this.calcCenterOfMass(points);
        }

        @NotNull
        public final Point2D[] getPoints(@NotNull Shape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            ArrayList<Object> pointList = new ArrayList<Object>(32);
            PathIterator pathIterator = shape.getPathIterator();
            int lastMoveToIndex = -1;
            while (!pathIterator.isDone()) {
                double[] coordinates = new double[6];
                switch (pathIterator.currentSegment(coordinates)) {
                    case 0: {
                        pointList.add(new Point2D.Double(coordinates[0], coordinates[1]));
                        ++lastMoveToIndex;
                        break;
                    }
                    case 1: {
                        pointList.add(new Point2D.Double(coordinates[0], coordinates[1]));
                        break;
                    }
                    case 2: {
                        pointList.add(new Point2D.Double(coordinates[0], coordinates[1]));
                        pointList.add(new Point2D.Double(coordinates[2], coordinates[3]));
                        break;
                    }
                    case 3: {
                        pointList.add(new Point2D.Double(coordinates[0], coordinates[1]));
                        pointList.add(new Point2D.Double(coordinates[2], coordinates[3]));
                        pointList.add(new Point2D.Double(coordinates[4], coordinates[5]));
                        break;
                    }
                    case 4: {
                        if (lastMoveToIndex < 0) break;
                        pointList.add(pointList.get(lastMoveToIndex));
                    }
                }
                pathIterator.next();
            }
            Collection $this$toTypedArray$iv = pointList;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Point2D[] points = thisCollection$iv.toArray(new Point2D[0]);
            return points;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

