/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.treemap.AbstractAlgorithm;
import com.treemap.TreeMapAccessor;
import com.treemap.TreeMapWorker;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004Jm\u0010\u0005\u001a\u00020\u0003\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u0002H\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00060\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0006\u0010\u0018\u001a\u00020\u0019J\u0012\u0010\u001a\u001a\u00020\u00032\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016JY\u0010\u001b\u001a\u00020\u001c\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00060\r2\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0014\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/treemap/BinaryTreeAlgorithm;", "Lcom/treemap/AbstractAlgorithm;", "vertical", "", "(Z)V", "breadthFirstLayout", "N", "Row", "Column", "shape", "Lorg/mkui/geom/Shape;", "parent", "children", "", "sumSizes", "", "horizontalVanishingPoint", "", "verticalVanishingPoint", "accessor", "Lcom/treemap/TreeMapAccessor;", "worker", "Lcom/treemap/TreeMapWorker;", "(Lorg/mkui/geom/Shape;Ljava/lang/Object;[Ljava/lang/Object;DIILcom/treemap/TreeMapAccessor;Lcom/treemap/TreeMapWorker;)Z", "getName", "", "isCompatible", "layout", "", "items", "start", "end", "bounds", "Lorg/mkui/geom/Rectangle2D;", "([Ljava/lang/Object;IILorg/mkui/geom/Rectangle2D;ZLcom/treemap/TreeMapAccessor;)V", "toString", "treemap"})
@StabilityInferred(parameters=1)
public final class BinaryTreeAlgorithm
extends AbstractAlgorithm {
    private final boolean vertical;
    public static final int $stable;

    public BinaryTreeAlgorithm(boolean vertical) {
        this.vertical = vertical;
    }

    public /* synthetic */ BinaryTreeAlgorithm(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    @Override
    public <N, Row, Column> boolean breadthFirstLayout(@NotNull Shape shape, N parent, @NotNull N[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, @NotNull TreeMapAccessor<? super N> accessor, @Nullable TreeMapWorker worker) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
        Rectangle2D bounds = shape.getBounds2D();
        this.layout(children, 0, children.length - 1, bounds, this.vertical, accessor);
        return false;
    }

    public final <N, Row, Column> void layout(@NotNull N[] items, int start, int end, @NotNull Rectangle2D bounds, boolean vertical, @NotNull TreeMapAccessor<? super N> accessor) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
        if (start < end) {
            double total = this.sum(items, start, end, accessor);
            int middle = (start + end) / 2;
            double first = this.sum(items, start, middle, accessor);
            double share = first / total;
            double x = bounds.getX();
            double y = bounds.getY();
            double w = bounds.getWidth();
            double h = bounds.getHeight();
            Rectangle2D r1 = null;
            Rectangle2D r2 = null;
            if (vertical) {
                r1 = (Rectangle2D)new Rectangle2D.Double(x, y, w * share, h);
                r2 = (Rectangle2D)new Rectangle2D.Double(x + w * share, y, w * (1.0 - share), h);
            } else {
                r1 = (Rectangle2D)new Rectangle2D.Double(x, y, w, h * share);
                r2 = (Rectangle2D)new Rectangle2D.Double(x, y + h * share, w, h * (1.0 - share));
            }
            this.layout(items, start, middle, r1, !vertical, accessor);
            this.layout(items, middle + 1, end, r2, !vertical, accessor);
        } else {
            accessor.setShape(items[start], (Shape)bounds);
        }
    }

    @Override
    public boolean isCompatible(@Nullable Shape shape) {
        return shape instanceof Rectangle2D;
    }

    @NotNull
    public final String getName() {
        return "Binary Tree";
    }

    @NotNull
    public String toString() {
        return this.getName();
    }

    public BinaryTreeAlgorithm() {
        this(false, 1, null);
    }
}

