/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.treemap.AbstractNesting;
import com.treemap.TreeMapModel;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002JQ\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u0006\"\u0004\b\u0002\u0010\u00072\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u0002H\u00052\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/treemap/ProportionalNesting;", "Lcom/treemap/AbstractNesting;", "()V", "subtract", "Lorg/mkui/geom/Shape;", "N", "Row", "Column", "model", "Lcom/treemap/TreeMapModel;", "shape", "node", "amount", "", "(Lcom/treemap/TreeMapModel;Lorg/mkui/geom/Shape;Ljava/lang/Object;D)Lorg/mkui/geom/Shape;", "toString", "", "Companion", "Type", "treemap"})
@StabilityInferred(parameters=1)
public final class ProportionalNesting
extends AbstractNesting {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    private static final Type type;

    @Override
    @NotNull
    public <N, Row, Column> Shape subtract(@NotNull TreeMapModel<N, Row, Column> model, @NotNull Shape shape, N node, double amount) {
        Shape shape2;
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        if (!model.isRoot(node) && shape instanceof Rectangle2D) {
            Rectangle2D rectangle = (Rectangle2D)shape;
            double proportion = amount / (double)100;
            shape2 = (Shape)(switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1 -> {
                    double x = rectangle.getX() + rectangle.getWidth() * proportion;
                    double y = rectangle.getY() + rectangle.getHeight() * proportion;
                    double width = rectangle.getWidth() * (1.0 - (double)2 * proportion);
                    double height = rectangle.getHeight() * (1.0 - (double)2 * proportion);
                    yield (Rectangle2D)new Rectangle2D.Double(x, y, width, height);
                }
                case 2 -> {
                    double a = rectangle.getWidth() * rectangle.getHeight();
                    double b = (1.0 - proportion) * a;
                    double width = rectangle.getWidth() * Math.sqrt(b / a);
                    double height = rectangle.getHeight() * Math.sqrt(b / a);
                    double x = rectangle.getX() + (rectangle.getWidth() - width) / 2.0;
                    double y = rectangle.getY() + (rectangle.getHeight() - height) / 2.0;
                    Rectangle2D.Double scaled = new Rectangle2D.Double(x, y, width, height);
                    yield (Rectangle2D)scaled;
                }
                case 3 -> {
                    double a = rectangle.getWidth() * rectangle.getHeight();
                    double b = (1.0 - proportion) * a;
                    double w = rectangle.getWidth();
                    double h = rectangle.getHeight();
                    double x = (-Math.sqrt((double)4 * b + h * h - (double)2 * h * w + w * w) + h + w) / (double)4;
                    Rectangle2D.Double scaled = new Rectangle2D.Double(rectangle.getX() + x, rectangle.getY() + x, rectangle.getWidth() - (double)2 * x, rectangle.getHeight() - (double)2 * x);
                    yield (Rectangle2D)scaled;
                }
                default -> (Rectangle2D)shape;
            });
        } else {
            shape2 = shape;
        }
        return shape2;
    }

    @NotNull
    public String toString() {
        return "Proportional";
    }

    static {
        type = Type.EqualBorderWidth;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/treemap/ProportionalNesting$Companion;", "", "()V", "type", "Lcom/treemap/ProportionalNesting$Type;", "getType", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Type getType() {
            return type;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/treemap/ProportionalNesting$Type;", "", "(Ljava/lang/String;I)V", "Raw", "KeepAspectRatio", "EqualBorderWidth", "treemap"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type Raw = new Type();
        public static final /* enum */ Type KeepAspectRatio = new Type();
        public static final /* enum */ Type EqualBorderWidth = new Type();
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.Raw, Type.KeepAspectRatio, Type.EqualBorderWidth};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            try {
                nArray[Type.Raw.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.KeepAspectRatio.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.EqualBorderWidth.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

