/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.treemap.Aggregation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/treemap/StdDevAggregation;", "Lcom/treemap/Aggregation;", "()V", "aggregate", "", "values", "", "([D)Ljava/lang/Double;", "requestSizeWeightValues", "", "toString", "", "treemap"})
@StabilityInferred(parameters=1)
public final class StdDevAggregation
implements Aggregation {
    public static final int $stable;

    @Override
    @NotNull
    public Double aggregate(@NotNull double[] values) {
        double d;
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        int count2 = 0;
        double sum = 0.0;
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            double value = values[i];
            if (Double.isInfinite(value) || Double.isNaN(value)) continue;
            ++count2;
            sum += value;
        }
        if (count2 < 2) {
            d = 0.0;
        } else {
            double average = sum / (double)count2;
            double stddev = 0.0;
            for (double value : values) {
                if (Double.isInfinite(value) || Double.isNaN(value)) continue;
                stddev += Math.pow(value - average, 2.0);
            }
            d = Math.sqrt(stddev / (double)count2);
        }
        return d;
    }

    @Override
    public boolean requestSizeWeightValues() {
        return false;
    }

    @NotNull
    public String toString() {
        return "StdDev";
    }
}

