/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.crossplatform;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.geom.Dimension;
import com.macrofocus.common.geom.PreferredSize;
import com.treemap.crossplatform.TGraphics;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.font.MkFont;
import org.mkui.font.MkFontKt;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;
import org.mkui.graphics.CPImage;
import org.mkui.labeling.EnhancedLabel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u0000 #2\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0002JV\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J$\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J@\u0010\u001a\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0010\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0006H\u0016J\u0012\u0010 \u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0016J\u0012\u0010!\u001a\u00020\"2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/treemap/crossplatform/AbstractTGraphics;", "Lcom/treemap/crossplatform/TGraphics;", "()V", "clipBounds", "Lorg/mkui/geom/Rectangle;", "drawClippedImage", "", "img", "Lorg/mkui/graphics/CPImage;", "x", "", "y", "w", "h", "width", "height", "bounds", "shape", "Lorg/mkui/geom/Shape;", "findMaxFontSize", "", "elabel", "Lorg/mkui/labeling/EnhancedLabel;", "font", "Lorg/mkui/font/MkFont;", "maxWidth", "fitTextInsideRectangle", "pf", "Lcom/macrofocus/common/geom/PreferredSize;", "Lorg/mkui/geom/Rectangle2D;", "scaleFactor", "expand", "hitClip", "softClip", "", "Companion", "treemap"})
@StabilityInferred(parameters=0)
public abstract class AbstractTGraphics
implements TGraphics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Rectangle clipBounds;
    public static final int $stable = 8;
    public static final float MINIMUM_FONT_SIZE_TO_DISPLAY = 5.0f;
    private static final int MAX_ITERATION = 5;

    @Override
    public double fitTextInsideRectangle(@Nullable EnhancedLabel elabel, @Nullable PreferredSize pf, @Nullable MkFont font, @Nullable Rectangle2D bounds, double scaleFactor, boolean expand) {
        double maxFontSize;
        double height = 0.0;
        Dimension size = null;
        EnhancedLabel enhancedLabel = elabel;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        double fontSize = maxFontSize = this.findMaxFontSize(elabel, font, enhancedLabel.getDesiredWidth()) * scaleFactor;
        MkFont mkFont = elabel.getFont();
        Intrinsics.checkNotNull((Object)mkFont);
        MkFont scaledFont = MkFontKt.deriveFontSize((MkFont)mkFont, (double)fontSize);
        elabel.setFont(scaledFont);
        PreferredSize preferredSize = pf;
        Intrinsics.checkNotNull((Object)preferredSize);
        size = preferredSize.getPreferredSize();
        height = size.getHeight() - (double)elabel.getInsetTop() - (double)elabel.getInsetBottom();
        int i = 0;
        while (height > (double)elabel.getDesiredHeight() && i < 5) {
            Dimension newSize;
            ++i;
            double scale = Math.sqrt((double)elabel.getDesiredHeight() / height);
            MkFont mkFont2 = elabel.getFont();
            Intrinsics.checkNotNull((Object)mkFont2);
            double newFontSize = MkFontKt.getFontSize((MkFont)mkFont2) * scale;
            if (newFontSize > maxFontSize) {
                newFontSize = maxFontSize;
            }
            fontSize = newFontSize;
            MkFont mkFont3 = elabel.getFont();
            Intrinsics.checkNotNull((Object)mkFont3);
            double oldFontSize = MkFontKt.getFontSize((MkFont)mkFont3);
            MkFont mkFont4 = elabel.getFont();
            Intrinsics.checkNotNull((Object)mkFont4);
            scaledFont = MkFontKt.deriveFontSize((MkFont)mkFont4, (double)fontSize);
            if (MkFontKt.getFontSize((MkFont)scaledFont) == oldFontSize) break;
            elabel.setFont(scaledFont);
            if (fontSize < 5.0) break;
            size = newSize = pf.getPreferredSize();
            height = size.getHeight() - (double)elabel.getInsetTop() - (double)elabel.getInsetBottom();
        }
        return fontSize;
    }

    @Override
    public double findMaxFontSize(@Nullable EnhancedLabel elabel, @Nullable MkFont font, double maxWidth) {
        double fontSize;
        MkFont mkFont = font;
        Intrinsics.checkNotNull((Object)mkFont);
        this.setFont(mkFont);
        EnhancedLabel enhancedLabel = elabel;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        String string = enhancedLabel.getText();
        Intrinsics.checkNotNull((Object)string);
        String[] stringArray = new String[]{" "};
        List words = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        double width = 0.0;
        String longest = null;
        for (String word : words) {
            double preferredWidth = this.getStringWidth(word);
            if (!(preferredWidth > width)) continue;
            longest = word;
            width = preferredWidth;
        }
        double maxFontSize = 0.0;
        maxFontSize = fontSize = MkFontKt.getFontSize((MkFont)font) * maxWidth / width;
        return maxFontSize;
    }

    @Override
    public boolean drawClippedImage(@Nullable CPImage img, int x, int y, int w, int h, int width, int height, @Nullable Rectangle bounds, @Nullable Shape shape) {
        this.save();
        this.clip(shape);
        boolean b = this.drawImageStretch(img, x, y, w, h);
        this.restore();
        return b;
    }

    @Override
    public void softClip(@Nullable Shape shape) {
        if (shape instanceof Rectangle2D) {
            this.clipBounds = ((Rectangle2D)shape).getBounds();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hitClip(@Nullable Rectangle bounds) {
        if (this.clipBounds == null) return true;
        Rectangle rectangle = this.clipBounds;
        Intrinsics.checkNotNull((Object)rectangle);
        Rectangle rectangle2 = bounds;
        Intrinsics.checkNotNull((Object)rectangle2);
        if (!rectangle.intersects((Rectangle2D)rectangle2)) return false;
        return true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/treemap/crossplatform/AbstractTGraphics$Companion;", "", "()V", "MAX_ITERATION", "", "MINIMUM_FONT_SIZE_TO_DISPLAY", "", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

