/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.tagcloud;

import androidx.compose.runtime.internal.StabilityInferred;
import com.treemap.tagcloud.TextShape;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.font.MkFont;
import org.mkui.font.MkFontKt;
import org.mkui.geom.AffineTransform;
import org.mkui.geom.PathIterator;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;
import org.mkui.graphics.IHeadless;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0007\u0018\u0000 (2\u00020\u0001:\u0001(B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0011\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0096\u0002J\u0012\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%H\u0016J\u0012\u0010\u0018\u001a\u00020\u00172\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0010\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\nH\u0016R\u0014\u0010\f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006)"}, d2={"Lcom/treemap/tagcloud/RectangularTextShape;", "Lcom/treemap/tagcloud/TextShape;", "headless", "Lorg/mkui/graphics/IHeadless;", "font", "Lorg/mkui/font/MkFont;", "text", "", "(Lorg/mkui/graphics/IHeadless;Lorg/mkui/font/MkFont;Ljava/lang/String;)V", "shape", "Lorg/mkui/geom/Rectangle2D;", "(Lorg/mkui/font/MkFont;Ljava/lang/String;Lorg/mkui/geom/Rectangle2D;)V", "bounds2D", "getBounds2D", "()Lorg/mkui/geom/Rectangle2D;", "getFont", "()Lorg/mkui/font/MkFont;", "setFont", "(Lorg/mkui/font/MkFont;)V", "isTextOutline", "", "()Z", "pathIterator", "Lorg/mkui/geom/PathIterator;", "getPathIterator", "()Lorg/mkui/geom/PathIterator;", "getText", "()Ljava/lang/String;", "contains", "point", "Lorg/mkui/geom/Point2D;", "createTransformedShape", "Lorg/mkui/geom/Shape;", "at", "Lorg/mkui/geom/AffineTransform;", "getFlattenPathIterator", "flatness", "", "intersects", "r", "Companion", "treemap"})
@StabilityInferred(parameters=0)
public final class RectangularTextShape
implements TextShape {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String text;
    @NotNull
    private MkFont font;
    @NotNull
    private final Rectangle2D shape;
    public static final int $stable = 8;

    @Override
    @NotNull
    public String getText() {
        return this.text;
    }

    @Override
    @NotNull
    public MkFont getFont() {
        return this.font;
    }

    public void setFont(@NotNull MkFont mkFont) {
        Intrinsics.checkNotNullParameter((Object)mkFont, (String)"<set-?>");
        this.font = mkFont;
    }

    public RectangularTextShape(@NotNull IHeadless headless, @NotNull MkFont font, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)headless, (String)"headless");
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Rectangle2D r = headless.getStringBounds(null, font, text);
        this.shape = (Rectangle2D)new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        this.setFont(font);
        this.text = text;
    }

    public RectangularTextShape(@NotNull MkFont font, @NotNull String text, @NotNull Rectangle2D shape) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        this.setFont(font);
        this.text = text;
        this.shape = shape;
    }

    @Override
    public boolean isTextOutline() {
        return false;
    }

    @NotNull
    public Rectangle2D getBounds2D() {
        return this.shape.getBounds2D();
    }

    public boolean intersects(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.shape.intersects(r);
    }

    public boolean contains(@NotNull Point2D point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        double x = point.getX();
        double y = point.getY();
        double x0 = this.shape.getX();
        double y0 = this.shape.getY();
        return x >= x0 && y >= y0 && x < x0 + this.shape.getWidth() && y < y0 + this.shape.getHeight();
    }

    @NotNull
    public PathIterator getPathIterator() {
        return this.shape.getPathIterator();
    }

    @NotNull
    public PathIterator getPathIterator(@Nullable AffineTransform at) {
        return this.shape.getPathIterator(at);
    }

    @NotNull
    public PathIterator getFlattenPathIterator(double flatness) {
        return this.shape.getFlattenPathIterator(flatness);
    }

    @Override
    @NotNull
    public synchronized Shape createTransformedShape(@Nullable AffineTransform at) {
        MkFont mkFont = this.getFont();
        AffineTransform affineTransform = at;
        Intrinsics.checkNotNull((Object)affineTransform);
        this.setFont(MkFontKt.deriveFontSize((MkFont)mkFont, (double)(affineTransform.getScaleY() * MkFontKt.getFontSize((MkFont)this.getFont()))));
        return new RectangularTextShape(this.getFont(), this.getText(), Companion.transformBounds(this.shape, at));
    }

    @NotNull
    public Rectangle getBounds() {
        return TextShape.DefaultImpls.getBounds(this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\n"}, d2={"Lcom/treemap/tagcloud/RectangularTextShape$Companion;", "", "()V", "isOrthogonal", "", "at", "Lorg/mkui/geom/AffineTransform;", "transformBounds", "Lorg/mkui/geom/Rectangle2D;", "rect", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Rectangle2D transformBounds(@NotNull Rectangle2D rect, @NotNull AffineTransform at) {
            Rectangle2D rectangle2D;
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            Intrinsics.checkNotNullParameter((Object)at, (String)"at");
            if (!this.isOrthogonal(at)) {
                Shape shape = at.createTransformedShape((Shape)rect);
                Intrinsics.checkNotNull((Object)shape);
                rectangle2D = shape.getBounds2D();
            } else if (rect instanceof Rectangle2D.Double) {
                Rectangle2D.Double r = (Rectangle2D.Double)rect;
                double[] coords = new double[]{r.getX(), r.getY(), r.getX() + r.getWidth(), r.getY() + r.getHeight()};
                at.transform(coords, 0, coords, 0, 2);
                rectangle2D = (Rectangle2D)new Rectangle2D.Double(coords[0], coords[1], coords[2] - coords[0], coords[3] - coords[1]);
            } else {
                double[] coords;
                coords = new double[]{rect.getX(), rect.getY(), coords[0] + rect.getWidth(), coords[1] + rect.getHeight()};
                at.transform(coords, 0, coords, 0, 2);
                rectangle2D = (Rectangle2D)new Rectangle2D.Double(coords[0], coords[1], coords[2], coords[3]);
            }
            return rectangle2D;
        }

        public final boolean isOrthogonal(@NotNull AffineTransform at) {
            Intrinsics.checkNotNullParameter((Object)at, (String)"at");
            int t = at.getType();
            return (t & 0x38) == 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

