/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.geom.Dimension;
import com.macrofocus.common.geom.PreferredSize;
import com.macrofocus.common.math.MathKt;
import com.treemap.AbstractLabeling;
import com.treemap.Algorithm;
import com.treemap.Depth;
import com.treemap.Labeling;
import com.treemap.RectangularTransform;
import com.treemap.Rendering;
import com.treemap.TreeMapColumnSettings;
import com.treemap.TreeMapLabelRenderer;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.TGraphics;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.font.MkFontKt;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;
import org.mkui.geom.TextShape;
import org.mkui.labeling.EnhancedLabel;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b'\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002JI\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\t\"\u0004\b\u0000\u0010\n\"\u0004\b\u0001\u0010\u000b\"\u0004\b\u0002\u0010\f2\u0006\u0010\r\u001a\u0002H\n2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010JO\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\n0\u0012\"\u0004\b\u0000\u0010\n\"\u0004\b\u0001\u0010\u000b\"\u0004\b\u0002\u0010\f2\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\u00142\u0006\u0010\u0015\u001a\u0002H\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018JO\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\n0\u0012\"\u0004\b\u0000\u0010\n\"\u0004\b\u0001\u0010\u000b\"\u0004\b\u0002\u0010\f2\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\u00142\u0006\u0010\u0015\u001a\u0002H\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J4\u0010\u001a\u001a\u00020\u0017\"\u0004\b\u0000\u0010\n\"\u0004\b\u0001\u0010\u000b\"\u0004\b\u0002\u0010\f2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\u000fH\u0016Jc\u0010\u001b\u001a\u00020\u0006\"\u0004\b\u0000\u0010\n\"\u0004\b\u0001\u0010\u000b\"\u0004\b\u0002\u0010\f2\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\u00142\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\u000f2\u0006\u0010\r\u001a\u0002H\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u001cJi\u0010\u001d\u001a\u00020\u001e\"\u0004\b\u0000\u0010\n\"\u0004\b\u0001\u0010\u000b\"\u0004\b\u0002\u0010\f2\u0006\u0010\u001f\u001a\u00020 2\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\u00142\u0006\u0010\r\u001a\u0002H\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010#Ji\u0010$\u001a\u00020\u001e\"\u0004\b\u0000\u0010\n\"\u0004\b\u0001\u0010\u000b\"\u0004\b\u0002\u0010\f2\u0006\u0010\u001f\u001a\u00020 2\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\u00142\u0006\u0010\r\u001a\u0002H\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010#Ja\u0010&\u001a\u00020\u001e\"\u0004\b\u0000\u0010\n\"\u0004\b\u0001\u0010\u000b\"\u0004\b\u0002\u0010\f2\u0006\u0010\u001f\u001a\u00020 2\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\u00142\u0006\u0010\r\u001a\u0002H\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010'JY\u0010(\u001a\u00020\u001e\"\u0004\b\u0000\u0010\n\"\u0004\b\u0001\u0010\u000b\"\u0004\b\u0002\u0010\f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\r\u001a\u0002H\n2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\u000fH\u0016\u00a2\u0006\u0002\u0010)Jc\u0010*\u001a\u00020\u001e\"\u0004\b\u0000\u0010\n\"\u0004\b\u0001\u0010\u000b\"\u0004\b\u0002\u0010\f2\u0006\u0010+\u001a\u00020 2\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\u00142\u0006\u0010\r\u001a\u0002H\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a2\u0006\u0002\u0010'\u00a8\u0006-"}, d2={"Lcom/treemap/AbstractRendering;", "Lcom/treemap/Rendering;", "()V", "computeBounds", "Lorg/mkui/geom/Rectangle;", "shape", "Lorg/mkui/geom/Shape;", "getNestingBackground", "Ljava/awt/Color;", "Lorg/mkui/color/MkColor;", "N", "Row", "Column", "node", "model", "Lcom/treemap/TreeMapModel;", "(Ljava/lang/Object;Lcom/treemap/TreeMapModel;)Ljava/awt/Color;", "getOrder", "", "view", "Lcom/treemap/TreeMapView;", "root", "pass", "", "(Lcom/treemap/TreeMapView;Ljava/lang/Object;I)Ljava/lang/Iterable;", "getParentOrder", "getPasses", "getRenderedShape", "(Lcom/treemap/TreeMapView;Lcom/treemap/TreeMapModel;Ljava/lang/Object;Lorg/mkui/geom/Shape;)Lorg/mkui/geom/Shape;", "paintBackground", "", "g", "Lcom/treemap/crossplatform/TGraphics;", "passes", "b", "(Lcom/treemap/crossplatform/TGraphics;Lcom/treemap/TreeMapView;Ljava/lang/Object;IILorg/mkui/geom/Rectangle;Lorg/mkui/geom/Shape;)V", "paintLabel", "bounds", "paintParent", "(Lcom/treemap/crossplatform/TGraphics;Lcom/treemap/TreeMapView;Ljava/lang/Object;ILorg/mkui/geom/Rectangle;Lorg/mkui/geom/Shape;)V", "paintParentBorder", "(Lcom/treemap/crossplatform/TGraphics;Ljava/lang/Object;Lorg/mkui/geom/Rectangle;Lorg/mkui/geom/Shape;Lcom/treemap/TreeMapModel;)V", "paintParentHighlight", "g2", "Companion", "treemap"})
@StabilityInferred(parameters=0)
public abstract class AbstractRendering
implements Rendering {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    protected static final float COLOR_SIMILARITY_THRESHOLD = 0.5f;

    @Override
    public <N, Row, Column> int getPasses(@NotNull TreeMapModel<N, Row, Column> model) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Column heightColumn = model.getSettings().getHeightColumn();
        return heightColumn != null && (model.isNumericType(heightColumn) || model.isTemporalType(heightColumn)) ? 2 : 1;
    }

    @Override
    @NotNull
    public <N, Row, Column> Iterable<N> getParentOrder(@NotNull TreeMapView<N, Row, Column> view, N root, int pass) {
        Iterable<N> iterable;
        Intrinsics.checkNotNullParameter(view, (String)"view");
        int n = pass;
        if (n == 0) {
            TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
            Intrinsics.checkNotNull(treeMapModel);
            iterable = treeMapModel.parentPreorderEnumeration(root);
        } else {
            iterable = CollectionsKt.emptyList();
        }
        return iterable;
    }

    @Override
    @NotNull
    public <N, Row, Column> Iterable<N> getOrder(@NotNull TreeMapView<N, Row, Column> view, N root, int pass) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter(view, (String)"view");
        TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
        Intrinsics.checkNotNull(treeMapModel);
        TreeMapModel<N, Row, Column> model = treeMapModel;
        int n = pass;
        if (n == 0) {
            iterable = model.preorderEnumeration(root);
        } else {
            List nodes = new ArrayList();
            for (N node : model.preorderEnumeration(root)) {
                if (!model.hasNoChildren(node)) continue;
                nodes.add(node);
            }
            CollectionsKt.sortedWith((Iterable)nodes, (Comparator)new Comparator<N>(view, model){
                final /* synthetic */ TreeMapView<N, Row, Column> $view;
                final /* synthetic */ TreeMapModel<N, Row, Column> $model;
                {
                    this.$view = $view;
                    this.$model = $model;
                }

                public int compare(N o1, N o2) {
                    int n;
                    Shape p1 = this.$view.worldToScreen(o1);
                    Shape p2 = this.$view.worldToScreen(o2);
                    if (p1 != null) {
                        if (p2 != null) {
                            Dimension dimension = this.$model.getSettings().getDimension();
                            if (dimension != null) {
                                double width = dimension.getWidth();
                                double height = dimension.getHeight();
                                double rx1 = p1.getBounds2D().getCenterX() / width;
                                double ry1 = p1.getBounds2D().getCenterY() / height;
                                double rx2 = p2.getBounds2D().getCenterX() / width;
                                double ry2 = p2.getBounds2D().getCenterY() / height;
                                n = MathKt.compare((double)(rx1 + ry1), (double)(rx2 + ry2));
                            } else {
                                n = MathKt.compare((double)(p1.getBounds2D().getCenterX() + p1.getBounds2D().getCenterY()), (double)(p2.getBounds2D().getCenterX() + p2.getBounds2D().getCenterY()));
                            }
                        } else {
                            n = 1;
                        }
                    } else {
                        n = p2 != null ? -1 : 0;
                    }
                    return n;
                }
            });
            iterable = nodes;
        }
        return iterable;
    }

    @Override
    public <N, Row, Column> void paintParent(@NotNull TGraphics g, @NotNull TreeMapView<N, Row, Column> view, N node, int pass, @NotNull Rectangle bounds, @NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
        Intrinsics.checkNotNull(treeMapModel);
        TreeMapModel<N, Row, Column> model = treeMapModel;
        if (pass == 0 && !model.hasNoChildren(node)) {
            int n = model.getLevel(node);
            N n2 = model.getCurrentRoot();
            Intrinsics.checkNotNull(n2);
            int depth = n - model.getLevel(n2);
            Algorithm algorithm = model.getSettings().getColumnSettings(model.getGroupByColumn(node)).getAlgorithm();
            Depth depth2 = model.getSettings().getDepth();
            Intrinsics.checkNotNull((Object)depth2);
            if (depth2.display(depth + 1) && algorithm.isCompatible(model.getShape(node)) && !algorithm.isColorParent()) {
                Color color = this.getNestingBackground(node, model);
                if (color != null) {
                    g.setFill(color);
                } else {
                    g.setFill(view.getBackground());
                }
                g.fill(shape);
            } else if (model.getCurrentRoot() != node) {
                this.paintNode(g, view, node, pass, bounds, shape);
            }
        }
    }

    @Override
    @NotNull
    public <N, Row, Column> Shape getRenderedShape(@NotNull TreeMapView<N, Row, Column> view, @NotNull TreeMapModel<N, Row, Column> model, N node, @NotNull Shape shape) {
        Column heightColumn;
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        if (node != null && model.hasNoChildren(node) && (heightColumn = model.getSettings().getHeightColumn()) != null && (model.isNumericType(heightColumn) || model.isTemporalType(heightColumn))) {
            Double minHeight = model.getNumericMin(heightColumn);
            Double maxHeight = model.getNumericMax(heightColumn);
            Object value = model.getValueAt(node, heightColumn);
            if (value != null && maxHeight != null && minHeight != null) {
                double height = 0.0;
                height = value instanceof Number ? ((Number)value).doubleValue() : 0.0;
                double range = maxHeight - minHeight;
                double d = (height - minHeight) / range;
                boolean bl = false;
                double ratio = Math.abs(d);
                if (shape instanceof Rectangle2D) {
                    Rectangle2D top = (Rectangle2D)shape;
                    double d2 = (double)view.getZoomFactor() * -model.getSettings().getMaximumHeight();
                    Dimension dimension = model.getSettings().getDimension();
                    Intrinsics.checkNotNull((Object)dimension);
                    double d3 = dimension.getWidth();
                    Dimension dimension2 = model.getSettings().getDimension();
                    Intrinsics.checkNotNull((Object)dimension2);
                    double d4 = dimension2.getHeight();
                    boolean bl2 = false;
                    double maxSize = d2 * Math.min(d3, d4);
                    int shift = (int)(maxSize * ratio);
                    RectangularTransform at = new RectangularTransform();
                    at.translate(shift, shift);
                    return (Shape)at.transform(top);
                }
            }
        }
        return shape;
    }

    @Override
    public <N, Row, Column> void paintBackground(@NotNull TGraphics g, @NotNull TreeMapView<N, Row, Column> view, N node, int pass, int passes, @NotNull Rectangle b, @NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Shape shape2 = shape;
        if (pass == passes - 1) {
            TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
            Intrinsics.checkNotNull(treeMapModel);
            TreeMapModel<N, Row, Column> model = treeMapModel;
            shape2 = this.getRenderedShape(view, model, node, shape2);
            Rectangle bounds = this.computeBounds(shape2);
            g.save();
            g.clip(shape2);
            Column column = model.getSettings().getBackgroundColumn();
            if (column != null && bounds.getWidth() > 1.0 && bounds.getHeight() > 1.0) {
                TreeMapColumnSettings columnSettings = model.getSettings().getColumnSettings(column);
                Font font = columnSettings.getLabelingFont();
                if (bounds.getWidth() > 5.0) {
                    double d = bounds.getHeight();
                    Intrinsics.checkNotNull((Object)font);
                    if (d >= MkFontKt.getFontSize((Font)font)) {
                        double d2;
                        TreeMapLabelRenderer<N, Row, Column> treeMapLabelRenderer = view.getLabelRenderer();
                        Intrinsics.checkNotNull(treeMapLabelRenderer);
                        EnhancedLabel enhancedLabel = treeMapLabelRenderer.getTreeMapLabelRendererComponent(view, column, node, new Dimension(bounds.getIwidth(), bounds.getIheight()));
                        Intrinsics.checkNotNull((Object)enhancedLabel);
                        EnhancedLabel elabel = enhancedLabel;
                        PreferredSize pf = g.sizeLabel(elabel, bounds.getIwidth(), bounds.getIheight());
                        int innerWidth = bounds.getIwidth() - elabel.getInsetRight() - elabel.getInsetLeft();
                        int innerHeight = bounds.getIheight() - elabel.getInsetTop() - elabel.getInsetBottom();
                        Color background = model.getSettings().getColumnSettings(column).getLabelingEffectColor();
                        Color foreground = model.getSettings().getColumnSettings(column).getLabelingForeground();
                        Color nodeColor = model.getColor(node);
                        if (foreground != null && background == null && nodeColor != null) {
                            EnhancedLabel.ContrastEnhancement contrastEnhancement = model.getSettings().getColumnSettings(column).getLabelingContrastEnhancement();
                            Intrinsics.checkNotNull((Object)contrastEnhancement);
                            foreground = contrastEnhancement.adjustLabelColor(foreground, nodeColor);
                        }
                        elabel.setFont(font);
                        Intrinsics.checkNotNull((Object)foreground);
                        elabel.setForeground(foreground);
                        elabel.setBackground(background);
                        Dimension preferredSize = pf.getPreferredSize();
                        double fontSize = 0.0;
                        if (columnSettings.getLabelingRendering() != EnhancedLabel.Rendering.WordWrap.INSTANCE) {
                            float scaleX = (float)innerWidth / (float)(preferredSize.getWidth() - (double)elabel.getInsetRight() - (double)elabel.getInsetLeft());
                            float scaleY = (float)innerHeight / (float)(preferredSize.getHeight() - (double)elabel.getInsetTop() - (double)elabel.getInsetBottom());
                            boolean bl = false;
                            float scale = Math.min(scaleX, scaleY);
                            double d3 = MkFontKt.getFontSize((Font)font);
                            double d4 = MkFontKt.getFontSize((Font)font) * (double)scale * (double)1.0f;
                            boolean bl2 = false;
                            d2 = Math.max(d3, d4);
                        } else {
                            double scaleX = MkFontKt.getFontSize((Font)font);
                            double scale = g.fitTextInsideRectangle(elabel, pf, font, (Rectangle2D)new Rectangle(0, 0, innerWidth, innerHeight), 0.9, true);
                            boolean bl = false;
                            d2 = fontSize = Math.max(scaleX, scale);
                        }
                        if (fontSize >= MkFontKt.getFontSize((Font)font) / (double)4) {
                            Integer scale;
                            Font scaledFont = MkFontKt.deriveFontSize((Font)font, (double)fontSize);
                            elabel.setFont(scaledFont);
                            if (columnSettings.getLabelingRendering() != EnhancedLabel.Rendering.WordWrap.INSTANCE) {
                                scaledFont = Companion.scaleFontToFit(bounds, font, elabel, pf, fontSize, false, true);
                                elabel.setFont(scaledFont);
                            }
                            preferredSize = pf.getPreferredSize();
                            int y = 0;
                            Integer n = scale = model.getSettings().getColumnSettings(column).getLabelingVerticalAlignment();
                            int n2 = 1;
                            if (n != null && n == n2) {
                                y = bounds.getIy();
                            } else {
                                Integer n3 = scale;
                                n2 = 0;
                                if (n3 != null && n3 == 0) {
                                    y = (double)bounds.getIheight() > preferredSize.getHeight() ? bounds.getIy() + (bounds.getIheight() - preferredSize.getIheight()) / 2 : bounds.getIy();
                                } else {
                                    Integer n4 = scale;
                                    n2 = 3;
                                    if (n4 != null && n4 == n2) {
                                        y = bounds.getIheight() > preferredSize.getIheight() ? bounds.getIy() + (bounds.getIheight() - preferredSize.getIheight()) : bounds.getIy();
                                    }
                                }
                            }
                            Rectangle drawingArea = AbstractLabeling.Companion.findEnclosedRectangle(shape2, y, preferredSize.getIheight());
                            g.paintLabel(elabel, drawingArea.getIx(), drawingArea.getIy(), drawingArea.getIwidth(), drawingArea.getIheight());
                        }
                    }
                }
            }
            g.restore();
        }
    }

    @Override
    @Nullable
    public <N, Row, Column> Color getNestingBackground(N node, @NotNull TreeMapModel<N, Row, Column> model) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        return model.getSettings().getColumnSettings(model.getGroupByColumn(node)).getNestingBackground();
    }

    private final Rectangle computeBounds(Shape shape) {
        Rectangle rectangle;
        if (shape instanceof Rectangle2D) {
            Rectangle2D bounds = shape.getBounds2D();
            rectangle = new Rectangle((int)bounds.getX(), (int)bounds.getY(), (int)bounds.getWidth(), (int)bounds.getHeight());
        } else {
            Rectangle2D bounds = shape.getBounds2D();
            double d = 2.0;
            boolean bl = false;
            int halfWidth = (int)(bounds.getWidth() / Math.sqrt(d));
            double d2 = 2.0;
            boolean bl2 = false;
            int halfHeight = (int)(bounds.getHeight() / Math.sqrt(d2));
            rectangle = new Rectangle((int)(bounds.getX() + (bounds.getWidth() - (double)halfWidth) / (double)2), (int)(bounds.getY() + (bounds.getHeight() - (double)halfHeight) / (double)2), halfWidth, halfHeight);
        }
        return rectangle;
    }

    @Override
    public <N, Row, Column> void paintLabel(@NotNull TGraphics g, @NotNull TreeMapView<N, Row, Column> view, N node, int pass, int passes, @NotNull Rectangle bounds, @NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Rectangle bounds2 = bounds;
        Shape shape2 = shape;
        if (pass == passes - 1) {
            TreeMapColumnSettings columnSettings;
            TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
            Intrinsics.checkNotNull(treeMapModel);
            TreeMapModel<N, Row, Column> model = treeMapModel;
            Algorithm algorithm = null;
            N n = model.getParent(node);
            Intrinsics.checkNotNull(n);
            N parent = n;
            Column groupByColumn = model.getGroupByColumn(parent);
            Algorithm algorithm2 = groupByColumn != null ? ((columnSettings = model.getSettings().getColumnSettings(groupByColumn)) != null ? columnSettings.getAlgorithm() : (Algorithm)null) : (algorithm = model.getSettings().getDefaultColumnSettings().getAlgorithm());
            if (algorithm == null || algorithm.isRenderingLeafLabelsSupported()) {
                shape2 = this.getRenderedShape(view, model, node, shape2);
                g.save();
                g.clip(shape2);
                bounds2 = this.computeBounds(shape2);
                Labeling labeling = model.getSettings().getColumnSettings(model.getGroupByColumn(node)).getLabeling();
                Intrinsics.checkNotNull((Object)labeling);
                labeling.paintLeaf(g, shape2, bounds2, node, view);
                g.restore();
            }
        }
    }

    @Override
    public <N, Row, Column> void paintParentBorder(@NotNull TGraphics g, N node, @NotNull Rectangle bounds, @NotNull Shape shape, @NotNull TreeMapModel<N, Row, Column> model) {
        float borderThickness;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        if (bounds.getWidth() > 1.0 && bounds.getHeight() > 1.0 && !model.isRoot(node) && !model.hasNoChildren(node) && !model.getFilter().isFiltered(node) && !model.getSearch().isFiltered(node) && (borderThickness = (float)model.getSettings().getColumnSettings(model.getGroupByColumn(node)).getBorderThickness()) > 0.0f && !(shape instanceof TextShape)) {
            g.save();
            g.setLineWidth(borderThickness);
            g.setStroke(model.getSettings().getColumnSettings(model.getGroupByColumn(node)).getBorderColor());
            g.stroke(shape);
            g.restore();
        }
    }

    @Override
    public <N, Row, Column> void paintParentHighlight(@NotNull TGraphics g2, @NotNull TreeMapView<N, Row, Column> view, N node, int pass, @NotNull Rectangle bounds, @Nullable Shape shape) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
        Intrinsics.checkNotNull(treeMapModel);
        TreeMapModel<N, Row, Column> model = treeMapModel;
        if (!model.isRoot(node) && !model.getFilter().isFiltered(node) && !model.getSearch().isFiltered(node) && model.getHighlighting().isActive() && model.getHighlighting().isSelected(node)) {
            g2.save();
            g2.setLineWidth(2.0);
            g2.setStroke(model.getSettings().getProbingColor());
            g2.stroke(shape);
            g2.restore();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/treemap/AbstractRendering$Companion;", "", "()V", "COLOR_SIMILARITY_THRESHOLD", "", "scaleFontToFit", "Ljava/awt/Font;", "Lorg/mkui/font/MkFont;", "bounds", "Lorg/mkui/geom/Rectangle;", "font", "elabel", "Lorg/mkui/labeling/EnhancedLabel;", "pf", "Lcom/macrofocus/common/geom/PreferredSize;", "fontSize", "", "shrink", "", "expand", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Font scaleFontToFit(@NotNull Rectangle bounds, @NotNull Font font, @NotNull EnhancedLabel elabel, @NotNull PreferredSize pf, double fontSize, boolean shrink, boolean expand) {
            Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            Intrinsics.checkNotNullParameter((Object)elabel, (String)"elabel");
            Intrinsics.checkNotNullParameter((Object)pf, (String)"pf");
            elabel.setFont(MkFontKt.deriveFontSize((Font)font, (double)fontSize));
            Dimension preferredSize = pf.getPreferredSize();
            double preferredWidth = preferredSize.getWidth() - (double)elabel.getInsetLeft() - (double)(-elabel.getInsetRight());
            double preferredHeight = preferredSize.getHeight() - (double)elabel.getInsetTop() - (double)(-elabel.getInsetBottom());
            float targetWidth = (float)bounds.getWidth();
            float targetheight = (float)bounds.getHeight();
            double d = (double)targetWidth * fontSize / (double)((float)preferredWidth);
            double d2 = (double)targetheight * fontSize / (double)((float)preferredHeight);
            boolean bl = false;
            double s = Math.min(d, d2) * (double)0.9f;
            if (!shrink) {
                boolean bl2 = false;
                s = Math.max(fontSize, s);
            }
            if (!expand) {
                boolean bl3 = false;
                s = Math.min(fontSize, s);
            }
            return MkFontKt.deriveFontSize((Font)font, (double)s);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

