/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.command.AbstractUICommand;
import com.macrofocus.common.command.UICommand;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.treemap.AbstractLabeling;
import com.treemap.TreeMapController;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapView;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.ContextMenuEvent;
import org.mkui.canvas.ContextMenuListener;
import org.mkui.canvas.KeyEvent;
import org.mkui.canvas.KeyListener;
import org.mkui.canvas.MouseEvent;
import org.mkui.canvas.MouseListener;
import org.mkui.canvas.MouseMotionListener;
import org.mkui.canvas.MouseWheelEvent;
import org.mkui.canvas.MouseWheelListener;
import org.mkui.component.menu.CPPopupMenu;
import org.mkui.geom.Point;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\b'\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004:\u0003./0B\u001f\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J/\u0010\u0013\u001a\u00020\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0018J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001aH\u0002J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001fJ\b\u0010!\u001a\u00020\tH\u0016J \u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001aH\u0002J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020&H\u0002J$\u0010'\u001a\u00020\u00142\u001a\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010\u0006H\u0016J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\tH\u0016J \u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u001aH\u0002J\u0010\u0010-\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u001aH\u0004R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00180\u000fR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\"\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/treemap/AbstractTreeMapController;", "N", "Row", "Column", "Lcom/treemap/TreeMapController;", "view", "Lcom/treemap/TreeMapView;", "(Lcom/treemap/TreeMapView;)V", "improvedBorderZooming", "", "keyListener", "Lorg/mkui/canvas/KeyListener;", "mode", "Lcom/treemap/AbstractTreeMapController$Mode;", "mouseListener", "Lcom/treemap/AbstractTreeMapController$DefaultMouseListener;", "multipleSelectionEnabled", "selectOnPopupTrigger", "zoomingEnabled", "assessQuality", "", "model", "Lcom/treemap/TreeMapModel;", "parent", "(Lcom/treemap/TreeMapModel;Ljava/lang/Object;)V", "denormalize", "", "x", "min", "extent", "getViewport", "Lorg/mkui/geom/Rectangle2D;", "getWorld", "isZoomingEnabled", "normalize", "center", "openPopupMenu", "e", "Lorg/mkui/canvas/ContextMenuEvent;", "setView", "setZoomingEnabled", "zoom", "amount", "xCenter", "yCenter", "zoomingCenterFunction", "DefaultMouseListener", "Mode", "Range", "treemap"})
@StabilityInferred(parameters=0)
public abstract class AbstractTreeMapController<N, Row, Column>
implements TreeMapController<N, Row, Column> {
    @Nullable
    private TreeMapView<N, Row, Column> view;
    @NotNull
    private Mode mode;
    private final boolean multipleSelectionEnabled;
    private final boolean selectOnPopupTrigger;
    private boolean zoomingEnabled;
    private final boolean improvedBorderZooming;
    @NotNull
    private final DefaultMouseListener mouseListener;
    @NotNull
    private final KeyListener keyListener;
    public static final int $stable = 8;

    public AbstractTreeMapController(@NotNull TreeMapView<N, Row, Column> view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        this.mode = Mode.Selection;
        this.multipleSelectionEnabled = true;
        this.zoomingEnabled = true;
        this.mouseListener = new DefaultMouseListener();
        this.keyListener = new KeyListener(this, view){
            @Nullable
            private Mode oldMode;
            final /* synthetic */ AbstractTreeMapController<N, Row, Column> this$0;
            final /* synthetic */ TreeMapView<N, Row, Column> $view;
            {
                this.this$0 = $receiver;
                this.$view = $view;
            }

            @Nullable
            public final Mode getOldMode() {
                return this.oldMode;
            }

            public final void setOldMode(@Nullable Mode mode) {
                this.oldMode = mode;
            }

            public void keyTyped(@NotNull KeyEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            }

            public void keyPressed(@NotNull KeyEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getKeyCode() == 83) {
                    if (this.oldMode == null) {
                        this.oldMode = AbstractTreeMapController.access$getMode$p(this.this$0);
                    }
                    AbstractTreeMapController.access$setMode$p(this.this$0, Mode.Selection);
                }
                if (event.getKeyCode() == 90 || event.getKeyCode() == 16) {
                    if (this.oldMode == null) {
                        this.oldMode = AbstractTreeMapController.access$getMode$p(this.this$0);
                    }
                    AbstractTreeMapController.access$setMode$p(this.this$0, Mode.Zooming);
                }
                if (event.getKeyCode() == 90 || event.getKeyCode() == 32) {
                    if (this.oldMode == null) {
                        this.oldMode = AbstractTreeMapController.access$getMode$p(this.this$0);
                    }
                    AbstractTreeMapController.access$setMode$p(this.this$0, Mode.Panning);
                }
                if (event.getKeyCode() == 40) {
                    this.$view.drillDown();
                }
                if (event.getKeyCode() == 38) {
                    this.$view.drillUp();
                }
                if (event.getKeyCode() == 34) {
                    this.$view.zoomIn();
                }
                if (event.getKeyCode() == 33) {
                    this.$view.zoomOut();
                }
            }

            public void keyReleased(@NotNull KeyEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.oldMode != null) {
                    Mode mode = this.oldMode;
                    Intrinsics.checkNotNull((Object)((Object)mode));
                    AbstractTreeMapController.access$setMode$p(this.this$0, mode);
                    this.oldMode = null;
                }
            }
        };
        this.setView(view);
    }

    private final void zoom(double amount, double xCenter, double yCenter) {
        double xCenter2 = xCenter;
        double yCenter2 = yCenter;
        if (this.zoomingEnabled) {
            TreeMapView<N, Row, Column> treeMapView = this.view;
            Intrinsics.checkNotNull(treeMapView);
            Rectangle2D viewport = treeMapView.getViewport();
            TreeMapView<N, Row, Column> treeMapView2 = this.view;
            Intrinsics.checkNotNull(treeMapView2);
            Rectangle2D world = treeMapView2.getWorld();
            yCenter2 = world.getMaxY() - yCenter2;
            if (this.improvedBorderZooming) {
                double normalizedXCenter = this.normalize(xCenter2, world.getMinX(), world.getMaxX());
                double normalizedYCenter = this.normalize(yCenter2, world.getMinY(), world.getMaxY());
                xCenter2 = this.denormalize(this.zoomingCenterFunction(normalizedXCenter), world.getMinX(), world.getMaxX());
                yCenter2 = this.denormalize(this.zoomingCenterFunction(normalizedYCenter), world.getMinY(), world.getMaxY());
            }
            Double d = xCenter2;
            double d2 = viewport.getMinX();
            double d3 = viewport.getWidth();
            double d4 = world.getMinX();
            double d5 = world.getMaxX();
            TreeMapView<N, Row, Column> treeMapView3 = this.view;
            Intrinsics.checkNotNull(treeMapView3);
            Range xRange = new Range(amount, d, d2, d3, d4, d5, treeMapView3.getSize().getWidth()).invoke();
            double xMin = xRange.getMin();
            double xMax = xRange.getMax();
            Double d6 = yCenter2;
            double d7 = viewport.getMinY();
            double d8 = viewport.getHeight();
            double d9 = world.getMinY();
            double d10 = world.getMaxY();
            TreeMapView<N, Row, Column> treeMapView4 = this.view;
            Intrinsics.checkNotNull(treeMapView4);
            Range yRange = new Range(amount, d6, d7, d8, d9, d10, treeMapView4.getSize().getHeight()).invoke();
            double yMin = yRange.getMin();
            double yMax = yRange.getMax();
            if (xMin < xMax && yMin < yMax) {
                TreeMapView<N, Row, Column> treeMapView5 = this.view;
                Intrinsics.checkNotNull(treeMapView5);
                treeMapView5.zoom(false, xMin, xMax, yMin, yMax);
            }
        }
    }

    protected final double zoomingCenterFunction(double center) {
        double d = center * (double)3;
        boolean bl = false;
        return Math.tanh(d);
    }

    private final double normalize(double center, double min, double extent) {
        return (center - min) / extent * 2.0 - 1.0;
    }

    private final double denormalize(double x, double min, double extent) {
        return min + extent * ((x + 1.0) / 2.0);
    }

    @Override
    public void setView(@Nullable TreeMapView<N, Row, Column> view) {
        this.view = view;
        if (view != null) {
            view.addKeyListener(this.keyListener);
            view.addMouseListener(this.mouseListener);
            view.addMouseMotionListener(this.mouseListener);
            view.addMouseWheelListener(this.mouseListener);
            view.addContextMenuListener(new ContextMenuListener(this){
                final /* synthetic */ AbstractTreeMapController<N, Row, Column> this$0;
                {
                    this.this$0 = $receiver;
                }

                public void contextMenu(@NotNull ContextMenuEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    AbstractTreeMapController.access$openPopupMenu(this.this$0, event);
                }
            });
        }
    }

    private final void openPopupMenu(ContextMenuEvent e) {
        CPPopupMenu popupMenu = new CPPopupMenu();
        int x = e.getX();
        int y = e.getY();
        AbstractUICommand drillDownCommand2 = new AbstractUICommand(this, x, y){
            final /* synthetic */ AbstractTreeMapController<N, Row, Column> this$0;
            final /* synthetic */ int $x;
            final /* synthetic */ int $y;
            {
                this.this$0 = $receiver;
                this.$x = $x;
                this.$y = $y;
                super("Drill down");
            }

            public void execute(@Nullable Object source) {
                TreeMapView treeMapView = AbstractTreeMapController.access$getView$p(this.this$0);
                Intrinsics.checkNotNull((Object)treeMapView);
                treeMapView.drill(this.$x, this.$y);
            }
        };
        AbstractUICommand drillUpCommand2 = new AbstractUICommand(this){
            final /* synthetic */ AbstractTreeMapController<N, Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super("Drill up");
            }

            public void execute(@Nullable Object source) {
                TreeMapView treeMapView = AbstractTreeMapController.access$getView$p(this.this$0);
                Intrinsics.checkNotNull((Object)treeMapView);
                treeMapView.drillUp();
            }
        };
        AbstractUICommand zoomInCommand2 = new AbstractUICommand(this){
            final /* synthetic */ AbstractTreeMapController<N, Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super("Zoom in");
            }

            public void execute(@Nullable Object source) {
                TreeMapView treeMapView = AbstractTreeMapController.access$getView$p(this.this$0);
                Intrinsics.checkNotNull((Object)treeMapView);
                treeMapView.zoomIn();
            }
        };
        AbstractUICommand zoomOutCommand2 = new AbstractUICommand(this){
            final /* synthetic */ AbstractTreeMapController<N, Row, Column> this$0;
            {
                this.this$0 = $receiver;
                super("Zoom out");
            }

            public void execute(@Nullable Object source) {
                TreeMapView treeMapView = AbstractTreeMapController.access$getView$p(this.this$0);
                Intrinsics.checkNotNull((Object)treeMapView);
                treeMapView.zoomOut();
            }
        };
        popupMenu.add((UICommand)drillDownCommand2);
        popupMenu.add((UICommand)drillUpCommand2);
        popupMenu.add((UICommand)zoomInCommand2);
        popupMenu.add((UICommand)zoomOutCommand2);
        TreeMapView<N, Row, Column> treeMapView = this.view;
        Intrinsics.checkNotNull(treeMapView);
        popupMenu.show(treeMapView.getComponent(), x, y);
    }

    private final void assessQuality(TreeMapModel<N, Row, Column> model, N parent) {
        double sumSize = 0.0;
        double sumArea = 0.0;
        for (N child : model.getChildren(parent)) {
            Shape shape = model.getShape(child);
            if (shape == null) continue;
            sumSize += model.getSize(child);
            double d = AbstractLabeling.Companion.getArea(shape);
            boolean bl = false;
            sumArea += Math.abs(d);
        }
        double totalError = 0.0;
        for (N child : model.getChildren(parent)) {
            Shape shape = model.getShape(child);
            if (shape == null) continue;
            double sizeRatio = model.getSize(child) / sumSize;
            double d = AbstractLabeling.Companion.getArea(shape);
            boolean bl = false;
            double area = Math.abs(d);
            double areaRatio = area / sumArea;
            double d2 = sizeRatio - areaRatio;
            boolean bl2 = false;
            double error = Math.abs(d2);
            if (error > 0.03) {
                String string = "Error for " + child + ": desired=" + sizeRatio + ",actual=" + areaRatio + " (" + area + " pixels instead of " + sizeRatio * sumArea + " pixels)";
                boolean bl3 = false;
                System.out.println((Object)string);
            }
            totalError += error;
        }
        Iterator<N> iterator2 = "Total error for " + parent + ": " + totalError;
        boolean child = false;
        System.out.println(iterator2);
        for (N child2 : model.getChildren(parent)) {
            if (model.hasNoChildren(child2)) continue;
            this.assessQuality(model, child2);
        }
    }

    @NotNull
    public final Rectangle2D getViewport() {
        TreeMapView<N, Row, Column> treeMapView = this.view;
        Intrinsics.checkNotNull(treeMapView);
        double d = treeMapView.getXRangeModel().getStart();
        treeMapView = this.view;
        Intrinsics.checkNotNull(treeMapView);
        double d2 = treeMapView.getXRangeModel().getStart();
        treeMapView = this.view;
        Intrinsics.checkNotNull(treeMapView);
        double d3 = treeMapView.getXRangeModel().getExtent();
        treeMapView = this.view;
        Intrinsics.checkNotNull(treeMapView);
        return (Rectangle2D)new Rectangle2D.Double(d, d2, d3, treeMapView.getXRangeModel().getExtent());
    }

    @NotNull
    public final Rectangle2D getWorld() {
        TreeMapView<N, Row, Column> treeMapView = this.view;
        Intrinsics.checkNotNull(treeMapView);
        double d = treeMapView.getYRangeModel().getMinimum();
        treeMapView = this.view;
        Intrinsics.checkNotNull(treeMapView);
        double d2 = treeMapView.getYRangeModel().getMinimum();
        treeMapView = this.view;
        Intrinsics.checkNotNull(treeMapView);
        double d3 = treeMapView.getYRangeModel().getMaximum();
        treeMapView = this.view;
        Intrinsics.checkNotNull(treeMapView);
        double d4 = d3 - treeMapView.getXRangeModel().getMinimum();
        treeMapView = this.view;
        Intrinsics.checkNotNull(treeMapView);
        double d5 = treeMapView.getYRangeModel().getMaximum();
        treeMapView = this.view;
        Intrinsics.checkNotNull(treeMapView);
        return (Rectangle2D)new Rectangle2D.Double(d, d2, d4, d5 - treeMapView.getYRangeModel().getMinimum());
    }

    @Override
    public void setZoomingEnabled(boolean zoomingEnabled) {
        this.zoomingEnabled = zoomingEnabled;
    }

    @Override
    public boolean isZoomingEnabled() {
        return this.zoomingEnabled;
    }

    public static final /* synthetic */ void access$openPopupMenu(AbstractTreeMapController $this, ContextMenuEvent e) {
        $this.openPopupMenu(e);
    }

    public static final /* synthetic */ Mode access$getMode$p(AbstractTreeMapController $this) {
        return $this.mode;
    }

    public static final /* synthetic */ void access$setMode$p(AbstractTreeMapController $this, Mode mode) {
        $this.mode = mode;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/treemap/AbstractTreeMapController$Mode;", "", "(Ljava/lang/String;I)V", "Selection", "Zooming", "Panning", "treemap"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode Selection = new Mode();
        public static final /* enum */ Mode Zooming = new Mode();
        public static final /* enum */ Mode Panning = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;

        public static Mode[] values() {
            Mode[] modeArray = $VALUES;
            return Arrays.copyOf(modeArray, modeArray.length);
        }

        public static Mode valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(Mode.class, value);
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.Selection, Mode.Zooming, Mode.Panning};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000e\u001a\u00020\u0003J\u0006\u0010\u000f\u001a\u00020\u0003J\u001f\u0010\u0010\u001a\u00180\u0000R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0011H\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/treemap/AbstractTreeMapController$Range;", "", "_amount", "", "_center", "_start", "_extent", "_minRange", "_maxRange", "_maxExtent", "(Lcom/treemap/AbstractTreeMapController;DLjava/lang/Double;DDDDD)V", "Ljava/lang/Double;", "_max", "_min", "getMax", "getMin", "invoke", "Lcom/treemap/AbstractTreeMapController;", "treemap"})
    private final class Range {
        private final double _amount;
        @Nullable
        private final Double _center;
        private final double _start;
        private final double _extent;
        private final double _minRange;
        private final double _maxRange;
        private final double _maxExtent;
        private double _min;
        private double _max;

        public Range(@Nullable double _amount, Double _center, double _start, double _extent, double _minRange, double _maxRange, double _maxExtent) {
            Intrinsics.checkNotNullParameter((Object)AbstractTreeMapController.this, (String)"this$0");
            this._amount = _amount;
            this._center = _center;
            this._start = _start;
            this._extent = _extent;
            this._minRange = _minRange;
            this._maxRange = _maxRange;
            this._maxExtent = _maxExtent;
        }

        public final double getMin() {
            return this._min;
        }

        public final double getMax() {
            return this._max;
        }

        @NotNull
        public final Range invoke() {
            double range = this._extent;
            double d = this._maxExtent;
            double d2 = range + range * this._amount;
            boolean bl = false;
            double newRange = Math.min(d, d2);
            if (this._center != null) {
                this._min = this._center - newRange * ((this._center - this._start) / range);
                this._max = this._center + newRange * ((this._start + this._extent - this._center) / range);
            } else {
                this._min = this._start;
                this._max = this._start + newRange;
            }
            if (this._min < this._minRange) {
                this._max += this._minRange - this._min;
                this._min = this._minRange;
            }
            if (this._max > this._maxRange) {
                this._min -= this._max - this._maxRange;
                this._max = this._maxRange;
            }
            d = this._minRange;
            d2 = this._min;
            bl = false;
            this._min = Math.max(d, d2);
            d = this._maxRange;
            d2 = this._max;
            bl = false;
            this._max = Math.min(d, d2);
            return this;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u001cH\u0016J\u0015\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0010J\u0017\u0010\u001e\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010\u0010R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/treemap/AbstractTreeMapController$DefaultMouseListener;", "Lorg/mkui/canvas/MouseListener;", "Lorg/mkui/canvas/MouseMotionListener;", "Lorg/mkui/canvas/MouseWheelListener;", "(Lcom/treemap/AbstractTreeMapController;)V", "last", "Lorg/mkui/canvas/MouseEvent;", "pressedPoint", "Lorg/mkui/geom/Point;", "selectOnRelease", "Ljava/lang/Object;", "zoomOnRelease", "zoomingPoint", "addToSelection", "", "observation", "(Ljava/lang/Object;)V", "newSelection", "", "mouseClicked", "event", "mouseDragged", "mouseEntered", "mouseExited", "mouseMoved", "mousePressed", "mouseReleased", "mouseWheelMoved", "Lorg/mkui/canvas/MouseWheelEvent;", "removeFromSelection", "setSelection", "treemap"})
    public final class DefaultMouseListener
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        @Nullable
        private MouseEvent last;
        @Nullable
        private N selectOnRelease;
        @Nullable
        private Point zoomOnRelease;
        @Nullable
        private final Point zoomingPoint;
        @Nullable
        private Point pressedPoint;

        public DefaultMouseListener() {
            Intrinsics.checkNotNullParameter((Object)AbstractTreeMapController.this, (String)"this$0");
        }

        public void mouseClicked(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        }

        public void mousePressed(@NotNull MouseEvent event) {
            block4: {
                TreeMapModel treeMapModel;
                block6: {
                    Object bestrow;
                    block7: {
                        TreeMapView treeMapView;
                        block8: {
                            block5: {
                                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                                if (AbstractTreeMapController.this.view == null) break block4;
                                this.pressedPoint = new Point(event.getX(), event.getY());
                                if (event.getClickCount() <= 1) break block5;
                                TreeMapView treeMapView2 = AbstractTreeMapController.this.view;
                                Intrinsics.checkNotNull((Object)treeMapView2);
                                TreeMapView treeMapView3 = treeMapView2;
                                treeMapView2 = this.pressedPoint;
                                Intrinsics.checkNotNull((Object)treeMapView2);
                                int n = treeMapView2.getIx();
                                treeMapView2 = this.pressedPoint;
                                Intrinsics.checkNotNull((Object)treeMapView2);
                                treeMapView3.drill(n, treeMapView2.getIy());
                                break block4;
                            }
                            treeMapModel = AbstractTreeMapController.this.view;
                            Intrinsics.checkNotNull((Object)treeMapModel);
                            bestrow = treeMapModel.getNode(new Point(event.getX(), event.getY()));
                            if (bestrow == null) break block6;
                            if (event.isMultipleSelectionKey()) break block7;
                            treeMapView = AbstractTreeMapController.this.view;
                            Intrinsics.checkNotNull((Object)treeMapView);
                            treeMapModel = treeMapView.getModel();
                            Intrinsics.checkNotNull(treeMapModel);
                            if (!treeMapModel.getSelection().isSelected(bestrow)) break block8;
                            treeMapView = AbstractTreeMapController.this.view;
                            Intrinsics.checkNotNull((Object)treeMapView);
                            treeMapModel = treeMapView.getModel();
                            Intrinsics.checkNotNull(treeMapModel);
                            if (treeMapModel.getSelection().getSelectedCount() <= 1) break block4;
                        }
                        treeMapView = AbstractTreeMapController.this.view;
                        Intrinsics.checkNotNull((Object)treeMapView);
                        treeMapModel = treeMapView.getModel();
                        Intrinsics.checkNotNull(treeMapModel);
                        treeMapModel.getSelection().clearSelection();
                        treeMapView = AbstractTreeMapController.this.view;
                        Intrinsics.checkNotNull((Object)treeMapView);
                        treeMapModel = treeMapView.getModel();
                        Intrinsics.checkNotNull(treeMapModel);
                        treeMapModel.getSelection().setSelectedElement(bestrow);
                        treeMapModel = AbstractTreeMapController.this.view;
                        Intrinsics.checkNotNull((Object)treeMapModel);
                        TreeMapModel treeMapModel2 = treeMapModel;
                        treeMapView = AbstractTreeMapController.this.view;
                        Intrinsics.checkNotNull((Object)treeMapView);
                        treeMapModel = treeMapView.getModel();
                        Intrinsics.checkNotNull(treeMapModel);
                        treeMapModel2.setSelectionMode(treeMapModel.getSelection().isSelected(bestrow));
                        break block4;
                    }
                    treeMapModel = AbstractTreeMapController.this.view;
                    Intrinsics.checkNotNull((Object)treeMapModel);
                    TreeMapModel treeMapModel3 = treeMapModel;
                    TreeMapView treeMapView = AbstractTreeMapController.this.view;
                    Intrinsics.checkNotNull((Object)treeMapView);
                    treeMapModel = treeMapView.getModel();
                    Intrinsics.checkNotNull(treeMapModel);
                    treeMapModel3.setSelectionMode(!treeMapModel.getSelection().isSelected(bestrow));
                    treeMapModel = AbstractTreeMapController.this.view;
                    Intrinsics.checkNotNull((Object)treeMapModel);
                    if (treeMapModel.isSelectionMode()) {
                        treeMapView = AbstractTreeMapController.this.view;
                        Intrinsics.checkNotNull((Object)treeMapView);
                        treeMapModel = treeMapView.getModel();
                        Intrinsics.checkNotNull(treeMapModel);
                        treeMapModel.getSelection().setSelectedState(bestrow, true);
                    } else {
                        treeMapView = AbstractTreeMapController.this.view;
                        Intrinsics.checkNotNull((Object)treeMapView);
                        treeMapModel = treeMapView.getModel();
                        Intrinsics.checkNotNull(treeMapModel);
                        treeMapModel.getSelection().setSelectedState(bestrow, false);
                    }
                    break block4;
                }
                TreeMapView treeMapView = AbstractTreeMapController.this.view;
                Intrinsics.checkNotNull((Object)treeMapView);
                treeMapModel = treeMapView.getModel();
                Intrinsics.checkNotNull((Object)treeMapModel);
                treeMapModel.getSelection().clearSelection();
            }
        }

        public void mouseReleased(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (AbstractTreeMapController.this.view != null) {
                if (!event.isPopupTrigger()) {
                    Object object;
                    if (this.selectOnRelease != null && event.isLeftMouseButton()) {
                        TreeMapView treeMapView = AbstractTreeMapController.this.view;
                        Intrinsics.checkNotNull((Object)treeMapView);
                        object = treeMapView.getModel();
                        Intrinsics.checkNotNull((Object)object);
                        object.getSelection().clearSelection();
                        if (AbstractTreeMapController.this.multipleSelectionEnabled) {
                            object = this.selectOnRelease;
                            Intrinsics.checkNotNull((Object)object);
                            this.addToSelection(object);
                        } else {
                            this.setSelection(this.selectOnRelease);
                        }
                        this.selectOnRelease = null;
                    }
                    if (this.zoomOnRelease != null) {
                        if (event.isLeftMouseButton()) {
                            // empty if block
                        }
                        this.zoomOnRelease = null;
                    }
                    object = AbstractTreeMapController.this.view;
                    Intrinsics.checkNotNull((Object)object);
                    object.getRubberBand().stopRubberBand();
                } else if (AbstractTreeMapController.this.selectOnPopupTrigger) {
                    TreeMapView treeMapView = AbstractTreeMapController.this.view;
                    Intrinsics.checkNotNull((Object)treeMapView);
                    Object node = treeMapView.getNode(new Point(event.getX(), event.getY()));
                    this.setSelection(node);
                }
                this.last = null;
            }
        }

        public void mouseEntered(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (AbstractTreeMapController.this.view != null) {
                Object object = AbstractTreeMapController.this.view;
                Intrinsics.checkNotNull((Object)object);
                if (object.getModel() != null) {
                    TreeMapView treeMapView = AbstractTreeMapController.this.view;
                    Intrinsics.checkNotNull((Object)treeMapView);
                    object = treeMapView.getModel();
                    Intrinsics.checkNotNull((Object)object);
                    MutableSingleSelection mutableSingleSelection = object.getProbing();
                    object = AbstractTreeMapController.this.view;
                    Intrinsics.checkNotNull((Object)object);
                    mutableSingleSelection.setSelectedElement(object.getNode(new Point(event.getX(), event.getY())));
                }
            }
        }

        public void mouseExited(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (AbstractTreeMapController.this.view != null) {
                Object object = AbstractTreeMapController.this.view;
                Intrinsics.checkNotNull((Object)object);
                if (object.getModel() != null) {
                    TreeMapView treeMapView = AbstractTreeMapController.this.view;
                    Intrinsics.checkNotNull((Object)treeMapView);
                    object = treeMapView.getModel();
                    Intrinsics.checkNotNull((Object)object);
                    object.getProbing().clearSelection();
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        public void mouseDragged(@NotNull MouseEvent event) {
            block20: {
                block21: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this) == null) break block20;
                    var2_2 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                    Intrinsics.checkNotNull((Object)var2_2);
                    if (var2_2.getModel() == null) break block20;
                    if (this.last == null) break block21;
                    var2_2 = AbstractTreeMapController.access$getMode$p(AbstractTreeMapController.this);
                    var3_3 = WhenMappings.$EnumSwitchMapping$0[var2_2.ordinal()];
                    switch (var3_3) {
                        case 1: {
                            if (!event.isLeftMouseButton()) break;
                            if (event.isAltKeyDown() || event.isShiftKeyDown()) {
                                var5_4 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                                Intrinsics.checkNotNull((Object)var5_4);
                                var4_8 = var5_4.getModel();
                                Intrinsics.checkNotNull(var4_8);
                                var4_8.getProbing().clearSelection();
                                if (!AbstractTreeMapController.access$getMultipleSelectionEnabled$p(AbstractTreeMapController.this)) break;
                                var4_8 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                                Intrinsics.checkNotNull((Object)var4_8);
                                if (!var4_8.getRubberBand().getRubberBand().isActive()) {
                                    var4_8 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                                    Intrinsics.checkNotNull((Object)var4_8);
                                    v0 = var4_8.getRubberBand();
                                    var4_8 = this.pressedPoint;
                                    Intrinsics.checkNotNull((Object)var4_8);
                                    v1 = var4_8.getIx();
                                    var4_8 = this.pressedPoint;
                                    Intrinsics.checkNotNull((Object)var4_8);
                                    v0.startRubberBand(v1, var4_8.getIy());
                                }
                                var4_8 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                                Intrinsics.checkNotNull((Object)var4_8);
                                var4_8.getRubberBand().stretchRubberBand(event.getX(), event.getY());
                                var6_12 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                                Intrinsics.checkNotNull((Object)var6_12);
                                var5_4 = var6_12.getRubberBand().getRubberBandScreen();
                                Intrinsics.checkNotNull((Object)var5_4);
                                r = var5_4;
                                rect = new Rectangle((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
                                var8_15 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                                Intrinsics.checkNotNull((Object)var8_15);
                                var7_18 = var8_15.getNodes(rect);
                                Intrinsics.checkNotNull(var7_18);
                                toSelect = var7_18;
                                if (event.isMultipleSelectionKey()) {
                                    this.addToSelection(toSelect);
                                } else {
                                    var8_15 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                                    Intrinsics.checkNotNull((Object)var8_15);
                                    var7_18 = var8_15.getModel();
                                    Intrinsics.checkNotNull((Object)var7_18);
                                    var7_18.getSelection().setSelectedIterable((Iterable)toSelect);
                                }
                                this.selectOnRelease = null;
                                break;
                            }
                            toSelect = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                            Intrinsics.checkNotNull((Object)toSelect);
                            rect = toSelect.getNode(new Point(event.getX(), event.getY()));
                            Intrinsics.checkNotNull(rect);
                            observation = rect;
                            toSelect = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                            Intrinsics.checkNotNull((Object)toSelect);
                            rect = toSelect.getModel();
                            Intrinsics.checkNotNull(rect);
                            rect.getProbing().setSelectedElement(observation);
                            this.selectOnRelease = null;
                            var7_19 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                            Intrinsics.checkNotNull((Object)var7_19);
                            toSelect = var7_19.getModel();
                            Intrinsics.checkNotNull((Object)toSelect);
                            if (toSelect.getSelection() == null) ** GOTO lbl-1000
                            var7_19 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                            Intrinsics.checkNotNull((Object)var7_19);
                            toSelect = var7_19.getModel();
                            Intrinsics.checkNotNull(toSelect);
                            if (toSelect.getSelection().isSelected(observation)) {
                                v2 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v2 = isAlreadySelected = false;
                            }
                            if (!isAlreadySelected && !event.isMenuShortcutKeyDown()) {
                                var7_19 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                                Intrinsics.checkNotNull((Object)var7_19);
                                toSelect = var7_19.getModel();
                                Intrinsics.checkNotNull(toSelect);
                                toSelect.getSelection().clearSelection();
                            }
                            if (event.isMenuShortcutKeyDown()) {
                                if (AbstractTreeMapController.access$getMultipleSelectionEnabled$p(AbstractTreeMapController.this)) {
                                    this.addToSelection(observation);
                                    break;
                                }
                                this.setSelection(observation);
                                break;
                            }
                            if (isAlreadySelected) {
                                this.selectOnRelease = observation;
                                break;
                            }
                            if (AbstractTreeMapController.access$getMultipleSelectionEnabled$p(AbstractTreeMapController.this)) {
                                this.addToSelection(observation);
                                break;
                            }
                            this.setSelection(observation);
                            break;
                        }
                        case 2: {
                            if (!event.isLeftMouseButton()) break;
                            viewport = AbstractTreeMapController.this.getViewport();
                            world = AbstractTreeMapController.this.getWorld();
                            var8_16 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                            Intrinsics.checkNotNull((Object)var8_16);
                            v3 = var8_16.getScreenTransform().getX();
                            var8_16 = this.last;
                            Intrinsics.checkNotNull((Object)var8_16);
                            x1 = v3.screenToWorld(var8_16.getX());
                            var10_20 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                            Intrinsics.checkNotNull((Object)var10_20);
                            x2 = var10_20.getScreenTransform().getX().screenToWorld(event.getX());
                            worldDiffX = x1 - x2;
                            xMin = viewport.getMinX() + worldDiffX;
                            xMax = viewport.getMaxX() + worldDiffX;
                            var18_24 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                            Intrinsics.checkNotNull((Object)var18_24);
                            v4 = var18_24.getScreenTransform().getY();
                            var18_24 = this.last;
                            Intrinsics.checkNotNull((Object)var18_24);
                            y1 = v4.screenToWorld(var18_24.getY());
                            var20_27 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                            Intrinsics.checkNotNull((Object)var20_27);
                            y2 = var20_27.getScreenTransform().getY().screenToWorld(event.getY());
                            worldDiffY = y1 - y2;
                            yMin = viewport.getMinY() + worldDiffY;
                            yMax = viewport.getMinY() + worldDiffY;
                            if (xMin < world.getMinX()) {
                                xMax += world.getMinX() - xMin;
                                xMin = world.getMinX();
                            }
                            if (xMax > world.getMaxX()) {
                                xMin -= xMax - world.getMaxX();
                                xMax = world.getMaxX();
                            }
                            var26_31 = world.getMinX();
                            var28_33 = false;
                            xMin = Math.max(var26_31, xMin);
                            var26_31 = world.getMaxX();
                            var28_33 = false;
                            xMax = Math.min(var26_31, xMax);
                            if (yMin < world.getMinY()) {
                                yMax += world.getMinY() - yMin;
                                yMin = world.getMinY();
                            }
                            if (yMax > world.getMaxY()) {
                                yMin -= yMax - world.getMaxY();
                                yMax = world.getMaxY();
                            }
                            var26_31 = world.getMinY();
                            var28_33 = false;
                            yMin = Math.max(var26_31, yMin);
                            var26_31 = world.getMaxY();
                            var28_33 = false;
                            yMax = Math.min(var26_31, yMax);
                            if (!(xMin < xMax) || !(yMin < yMax)) break;
                            var26_32 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                            Intrinsics.checkNotNull((Object)var26_32);
                            var26_32.zoom(false, xMin, xMax, yMin, yMax);
                            break;
                        }
                        case 3: {
                            if (!event.isMiddleMouseButton()) break;
                            v5 = event.getY();
                            var4_11 = this.last;
                            Intrinsics.checkNotNull((Object)var4_11);
                            v6 = v5 - (double)var4_11.getY() / 100.0;
                            var4_11 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                            Intrinsics.checkNotNull((Object)var4_11);
                            v7 = var4_11.getScreenTransform().getX().screenToWorld(event.getX());
                            var4_11 = AbstractTreeMapController.access$getView$p(AbstractTreeMapController.this);
                            Intrinsics.checkNotNull((Object)var4_11);
                            AbstractTreeMapController.access$zoom(AbstractTreeMapController.this, v6, v7, var4_11.getScreenTransform().getY().screenToWorld(event.getY()));
                            this.zoomOnRelease = null;
                        }
                    }
                }
                this.last = event;
            }
        }

        public void mouseMoved(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Object object = AbstractTreeMapController.this.view;
            Object closest = object == null ? null : object.getNode(new Point(event.getX(), event.getY()));
            MutableSingleSelection mutableSingleSelection = AbstractTreeMapController.this.view;
            Object object2 = object = mutableSingleSelection == null ? null : mutableSingleSelection.getModel();
            if (object != null && (mutableSingleSelection = object.getProbing()) != null) {
                mutableSingleSelection.setSelectedElement(closest);
            }
        }

        public void mouseWheelMoved(@NotNull MouseWheelEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (AbstractTreeMapController.this.view != null) {
                double amount = event.getWheelRotation();
                double d = amount / 500.0;
                TreeMapView treeMapView = AbstractTreeMapController.this.view;
                Intrinsics.checkNotNull((Object)treeMapView);
                double d2 = treeMapView.getScreenTransform().getX().screenToWorld(event.getX());
                treeMapView = AbstractTreeMapController.this.view;
                Intrinsics.checkNotNull((Object)treeMapView);
                AbstractTreeMapController.this.zoom(d, d2, treeMapView.getScreenTransform().getY().screenToWorld(event.getY()));
            }
        }

        private final void removeFromSelection(N observation) {
            TreeMapView treeMapView = AbstractTreeMapController.this.view;
            Intrinsics.checkNotNull((Object)treeMapView);
            TreeMapModel treeMapModel = treeMapView.getModel();
            Intrinsics.checkNotNull(treeMapModel);
            treeMapModel.getSelection().setSelectedState(observation, false);
        }

        private final void setSelection(N observation) {
            if (observation != null) {
                TreeMapView treeMapView = AbstractTreeMapController.this.view;
                Intrinsics.checkNotNull((Object)treeMapView);
                Object[] objectArray = treeMapView.getModel();
                Intrinsics.checkNotNull(objectArray);
                MutableSelection mutableSelection = objectArray.getSelection();
                objectArray = new Object[]{observation};
                mutableSelection.setSelectedElements(objectArray);
            } else {
                TreeMapView treeMapView = AbstractTreeMapController.this.view;
                Intrinsics.checkNotNull((Object)treeMapView);
                TreeMapModel treeMapModel = treeMapView.getModel();
                Intrinsics.checkNotNull(treeMapModel);
                treeMapModel.getSelection().clearSelection();
            }
        }

        private final void addToSelection(N observation) {
            TreeMapView treeMapView = AbstractTreeMapController.this.view;
            Intrinsics.checkNotNull((Object)treeMapView);
            TreeMapModel treeMapModel = treeMapView.getModel();
            Intrinsics.checkNotNull(treeMapModel);
            treeMapModel.getSelection().setSelectedState(observation, true);
        }

        private final void addToSelection(List<? extends N> newSelection) {
            TreeMapView treeMapView = AbstractTreeMapController.this.view;
            Intrinsics.checkNotNull((Object)treeMapView);
            TreeMapModel treeMapModel = treeMapView.getModel();
            Intrinsics.checkNotNull(treeMapModel);
            treeMapModel.getSelection().setSelectedIterableState((Iterable)newSelection, true);
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Mode.values().length];
                nArray[Mode.Selection.ordinal()] = 1;
                nArray[Mode.Panning.ordinal()] = 2;
                nArray[Mode.Zooming.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

