/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.collection.CollectionFactory;
import com.treemap.TreeMapSettings;
import com.treemap.TreeMapSettingsEvent;
import com.treemap.TreeMapSettingsListener;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b'\u0018\u0000 \u000f*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002\u000f\u0010B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0004J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/treemap/AbstractTreeMapSettings;", "Column", "Lcom/treemap/TreeMapSettings;", "()V", "listeners", "", "Lcom/treemap/TreeMapSettingsListener;", "addTreeMapSettingsListener", "", "listener", "notifySettingsChanged", "event", "Lcom/treemap/TreeMapSettingsEvent;", "removeTreeMapSettingsListener", "removeTreeMapSettingsListeners", "Companion", "PropertyType", "treemap"})
@StabilityInferred(parameters=0)
public abstract class AbstractTreeMapSettings<Column>
implements TreeMapSettings<Column> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<TreeMapSettingsListener> listeners = CollectionFactory.INSTANCE.copyOnWriteArrayList();
    public static final int $stable = 8;
    @NotNull
    public static final String PROPERTY_SIZE_FIELD = "sizeField";
    @NotNull
    public static final String PROPERTY_COLOR_FIELD = "colorField";
    @NotNull
    public static final String PROPERTY_LABELS_FIELD = "labelsField";
    @NotNull
    public static final String PROPERTY_TOOLTIP_FIELD = "toolTipField";
    @NotNull
    public static final String PROPERTY_BACKGROUND_FIELD = "backgroundField";
    @NotNull
    public static final String PROPERTY_HEIGHT_FIELD = "heightField";
    @NotNull
    public static final String PROPERTY_GROUP_BY_FIELD = "groupByField";
    @NotNull
    public static final String PROPERTY_DEPTH = "depth";
    @NotNull
    public static final String PROPERTY_RENDERING = "rendering";
    @NotNull
    public static final String PROPERTY_BACKGROUND = "background";
    @NotNull
    public static final String PROPERTY_TOOLTIP_BACKGROUND = "tooltipBackground";
    @NotNull
    public static final String PROPERTY_PROBING_COLOR = "probingColor";
    @NotNull
    public static final String PROPERTY_SELECTION_COLOR = "selectionColor";
    @NotNull
    public static final String PROPERTY_HIDE_SEARCH_RESULTS = "hideSearchResults";
    @NotNull
    public static final String PROPERTY_HIDE_FILTER_RESULTS = "hideFilterResults";
    @NotNull
    public static final String PROPERTY_DIMENSION = "dimension";
    @NotNull
    public static final String PROPERTY_DIMENSION_FIXED = "dimensionFixed";
    @NotNull
    public static final String PROPERTY_MAXIMUM_HEIGHT = "maximumHeight";
    @NotNull
    public static final String PROPERTY_LIGHT_SOURCE_HEIGHT = "lightSourceHeight";
    @NotNull
    public static final String PROPERTY_LIGHT_SOURCE_AMBIENT = "lightSourceAmbient";
    @NotNull
    public static final String PROPERTY_LIGHT_SOURCE_X = "lightSourceX";
    @NotNull
    public static final String PROPERTY_LIGHT_SOURCE_Y = "lightSourceY";
    @NotNull
    public static final String PROPERTY_LIGHT_SOURCE_Z = "lightSourceZ";

    protected AbstractTreeMapSettings() {
    }

    @Override
    public void addTreeMapSettingsListener(@NotNull TreeMapSettingsListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.add(listener);
    }

    @Override
    public void removeTreeMapSettingsListener(@NotNull TreeMapSettingsListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.remove(listener);
    }

    @Override
    public void removeTreeMapSettingsListeners() {
        this.listeners.clear();
    }

    protected final void notifySettingsChanged(@NotNull TreeMapSettingsEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        for (TreeMapSettingsListener listener : this.listeners) {
            listener.settingsChanged(event);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0019\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Lcom/treemap/AbstractTreeMapSettings$PropertyType;", "", "(Ljava/lang/String;I)V", "sizeField", "colorField", "labelsField", "toolTipField", "backgroundField", "heightField", "groupByField", "depth", "rendering", "background", "tooltipBackground", "probingColor", "selectionColor", "hideSearchResults", "hideFilterResults", "dimension", "dimensionFixed", "maximumHeight", "lightSourceHeight", "lightSourceAmbient", "lightSourceX", "lightSourceY", "lightSourceZ", "treemap"})
    private static final class PropertyType
    extends Enum<PropertyType> {
        public static final /* enum */ PropertyType sizeField = new PropertyType();
        public static final /* enum */ PropertyType colorField = new PropertyType();
        public static final /* enum */ PropertyType labelsField = new PropertyType();
        public static final /* enum */ PropertyType toolTipField = new PropertyType();
        public static final /* enum */ PropertyType backgroundField = new PropertyType();
        public static final /* enum */ PropertyType heightField = new PropertyType();
        public static final /* enum */ PropertyType groupByField = new PropertyType();
        public static final /* enum */ PropertyType depth = new PropertyType();
        public static final /* enum */ PropertyType rendering = new PropertyType();
        public static final /* enum */ PropertyType background = new PropertyType();
        public static final /* enum */ PropertyType tooltipBackground = new PropertyType();
        public static final /* enum */ PropertyType probingColor = new PropertyType();
        public static final /* enum */ PropertyType selectionColor = new PropertyType();
        public static final /* enum */ PropertyType hideSearchResults = new PropertyType();
        public static final /* enum */ PropertyType hideFilterResults = new PropertyType();
        public static final /* enum */ PropertyType dimension = new PropertyType();
        public static final /* enum */ PropertyType dimensionFixed = new PropertyType();
        public static final /* enum */ PropertyType maximumHeight = new PropertyType();
        public static final /* enum */ PropertyType lightSourceHeight = new PropertyType();
        public static final /* enum */ PropertyType lightSourceAmbient = new PropertyType();
        public static final /* enum */ PropertyType lightSourceX = new PropertyType();
        public static final /* enum */ PropertyType lightSourceY = new PropertyType();
        public static final /* enum */ PropertyType lightSourceZ = new PropertyType();
        private static final /* synthetic */ PropertyType[] $VALUES;

        public static PropertyType[] values() {
            PropertyType[] propertyTypeArray = $VALUES;
            return Arrays.copyOf(propertyTypeArray, propertyTypeArray.length);
        }

        public static PropertyType valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(PropertyType.class, value);
        }

        static {
            $VALUES = propertyTypeArray = new PropertyType[]{PropertyType.sizeField, PropertyType.colorField, PropertyType.labelsField, PropertyType.toolTipField, PropertyType.backgroundField, PropertyType.heightField, PropertyType.groupByField, PropertyType.depth, PropertyType.rendering, PropertyType.background, PropertyType.tooltipBackground, PropertyType.probingColor, PropertyType.selectionColor, PropertyType.hideSearchResults, PropertyType.hideFilterResults, PropertyType.dimension, PropertyType.dimensionFixed, PropertyType.maximumHeight, PropertyType.lightSourceHeight, PropertyType.lightSourceAmbient, PropertyType.lightSourceX, PropertyType.lightSourceY, PropertyType.lightSourceZ};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0017\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/treemap/AbstractTreeMapSettings$Companion;", "", "()V", "PROPERTY_BACKGROUND", "", "PROPERTY_BACKGROUND_FIELD", "PROPERTY_COLOR_FIELD", "PROPERTY_DEPTH", "PROPERTY_DIMENSION", "PROPERTY_DIMENSION_FIXED", "PROPERTY_GROUP_BY_FIELD", "PROPERTY_HEIGHT_FIELD", "PROPERTY_HIDE_FILTER_RESULTS", "PROPERTY_HIDE_SEARCH_RESULTS", "PROPERTY_LABELS_FIELD", "PROPERTY_LIGHT_SOURCE_AMBIENT", "PROPERTY_LIGHT_SOURCE_HEIGHT", "PROPERTY_LIGHT_SOURCE_X", "PROPERTY_LIGHT_SOURCE_Y", "PROPERTY_LIGHT_SOURCE_Z", "PROPERTY_MAXIMUM_HEIGHT", "PROPERTY_PROBING_COLOR", "PROPERTY_RENDERING", "PROPERTY_SELECTION_COLOR", "PROPERTY_SIZE_FIELD", "PROPERTY_TOOLTIP_BACKGROUND", "PROPERTY_TOOLTIP_FIELD", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

