/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.treemap.TreeMapModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0010\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u0002\u0013\u0014B'\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\bJ\t\u0010\r\u001a\u00020\u000eH\u0096\u0002J\u000e\u0010\u000f\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\n\u001a$\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\u000bR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/treemap/BreadthFirstIterator;", "T", "Row", "Column", "", "model", "Lcom/treemap/TreeMapModel;", "rootNode", "(Lcom/treemap/TreeMapModel;Ljava/lang/Object;)V", "_hierarchy", "_queue", "Lcom/treemap/BreadthFirstIterator$Queue;", "", "hasNext", "", "next", "()Ljava/lang/Object;", "remove", "", "QNode", "Queue", "treemap"})
public class BreadthFirstIterator<T, Row, Column>
implements Iterator<T>,
KMutableIterator {
    @NotNull
    private final Queue<Iterator<T>> _queue;
    @NotNull
    private final TreeMapModel<T, Row, Column> _hierarchy;

    public BreadthFirstIterator(@NotNull TreeMapModel<T, Row, Column> model, T rootNode) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        this._hierarchy = model;
        List v = new ArrayList(1);
        v.add(rootNode);
        this._queue = new Queue();
        this._queue.enqueue(v.iterator());
    }

    @Override
    public boolean hasNext() {
        return !this._queue.isEmpty() && this._queue.firstObject().hasNext();
    }

    @Override
    public T next() {
        Iterator<T> enumer = this._queue.firstObject();
        T node = enumer.next();
        Iterator<T> children = this._hierarchy.getChildren(node).iterator();
        if (!enumer.hasNext()) {
            this._queue.dequeue();
        }
        if (children.hasNext()) {
            this._queue.enqueue(children);
        }
        return node;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0080\u0004\u0018\u0000*\u0004\b\u0003\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000b\u0010\u000e\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\u0013J\u000b\u0010\u0014\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0015\u001a\u00020\u0016R8\u0010\u0004\u001a \u0012\u0004\u0012\u00028\u0003\u0018\u00010\u0005R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR8\u0010\u000b\u001a \u0012\u0004\u0012\u00028\u0003\u0018\u00010\u0005R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/treemap/BreadthFirstIterator$Queue;", "O", "", "(Lcom/treemap/BreadthFirstIterator;)V", "head", "Lcom/treemap/BreadthFirstIterator$QNode;", "Lcom/treemap/BreadthFirstIterator;", "getHead", "()Lcom/treemap/BreadthFirstIterator$QNode;", "setHead", "(Lcom/treemap/BreadthFirstIterator$QNode;)V", "tail", "getTail", "setTail", "dequeue", "()Ljava/lang/Object;", "enqueue", "", "anObject", "(Ljava/lang/Object;)V", "firstObject", "isEmpty", "", "treemap"})
    public final class Queue<O> {
        @Nullable
        private QNode<O> head;
        @Nullable
        private QNode<O> tail;

        public Queue() {
            Intrinsics.checkNotNullParameter((Object)BreadthFirstIterator.this, (String)"this$0");
        }

        @Nullable
        public final QNode<O> getHead() {
            return this.head;
        }

        public final void setHead(@Nullable QNode<O> qNode) {
            this.head = qNode;
        }

        @Nullable
        public final QNode<O> getTail() {
            return this.tail;
        }

        public final void setTail(@Nullable QNode<O> qNode) {
            this.tail = qNode;
        }

        public final void enqueue(O anObject) {
            if (this.head == null) {
                this.tail = new QNode<O>(anObject, null);
                this.head = this.tail;
            } else {
                QNode<O> qNode = this.tail;
                Intrinsics.checkNotNull(qNode);
                qNode.set_next(new QNode<O>(anObject, null));
                qNode = this.tail;
                Intrinsics.checkNotNull(qNode);
                this.tail = qNode.get_next();
            }
        }

        public final O dequeue() {
            QNode head = this.head;
            if (head != null) {
                O retval = head.get_object();
                QNode oldHead = head;
                this.head = head.get_next();
                oldHead.set_next(null);
                return retval;
            }
            throw new NoSuchElementException("No more elements");
        }

        public final O firstObject() {
            QNode<O> head = this.head;
            if (head != null) {
                return head.get_object();
            }
            throw new NoSuchElementException("No more elements");
        }

        public final boolean isEmpty() {
            return this.head == null;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0080\u0004\u0018\u0000*\u0004\b\u0003\u0010\u00012\u00020\u0002B3\u0012\u0006\u0010\u0003\u001a\u00028\u0003\u0012$\u0010\u0004\u001a \u0012\u0004\u0012\u00028\u0003\u0018\u00010\u0000R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R8\u0010\u0007\u001a \u0012\u0004\u0012\u00028\u0003\u0018\u00010\u0000R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0013\u0010\u0003\u001a\u00028\u0003\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lcom/treemap/BreadthFirstIterator$QNode;", "O", "", "_object", "next", "Lcom/treemap/BreadthFirstIterator;", "(Lcom/treemap/BreadthFirstIterator;Ljava/lang/Object;Lcom/treemap/BreadthFirstIterator$QNode;)V", "_next", "get_next", "()Lcom/treemap/BreadthFirstIterator$QNode;", "set_next", "(Lcom/treemap/BreadthFirstIterator$QNode;)V", "get_object", "()Ljava/lang/Object;", "Ljava/lang/Object;", "treemap"})
    public final class QNode<O> {
        private final O _object;
        @Nullable
        private QNode<O> _next;

        public QNode(@Nullable O _object, QNode<O> next) {
            Intrinsics.checkNotNullParameter((Object)BreadthFirstIterator.this, (String)"this$0");
            this._object = _object;
            this._next = next;
        }

        public final O get_object() {
            return this._object;
        }

        @Nullable
        public final QNode<O> get_next() {
            return this._next;
        }

        public final void set_next(@Nullable QNode<O> qNode) {
            this._next = qNode;
        }
    }
}

