/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.treemap.TreeMapModel;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.MkColorKt;
import org.mkui.graphics.CPImage;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001BK\b\u0016\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bBW\b\u0016\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0000\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\rJR\u0010\u0010\u001a\n\u0018\u00010\u0011j\u0004\u0018\u0001`\u00122\u0012\u0010\u0002\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00032\u000e\u0010\u0013\u001a\n\u0018\u00010\u0011j\u0004\u0018\u0001`\u00122\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005JT\u0010\u0016\u001a\u00020\u00172\u0014\u0010\u0002\u001a\u0010\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00032\u000e\u0010\u0013\u001a\n\u0018\u00010\u0011j\u0004\u0018\u0001`\u00122\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/treemap/Cushion;", "", "model", "Lcom/treemap/TreeMapModel;", "left", "", "right", "width", "top", "bottom", "height", "(Lcom/treemap/TreeMapModel;IIIIII)V", "master", "(Lcom/treemap/Cushion;Lcom/treemap/TreeMapModel;IIIIII)V", "_surface", "", "computeColor", "Ljava/awt/Color;", "Lorg/mkui/color/MkColor;", "color", "x", "y", "fillRaster", "", "raster", "Lorg/mkui/graphics/CPImage;", "treemap"})
@StabilityInferred(parameters=0)
public final class Cushion {
    @NotNull
    private final double[] _surface;
    public static final int $stable = 8;

    public Cushion(@NotNull TreeMapModel<?, ?, ?> model, int left, int right, int width, int top, int bottom, int height) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        this._surface = new double[4];
        double h4 = (double)4 * model.getSettings().getLightSourceHeight();
        double wf = 0.0;
        wf = width <= 0 ? 0.0 : h4 / (double)width;
        this._surface[2] = wf * (double)(right + left);
        this._surface[0] = -wf;
        double hf = 0.0;
        hf = height <= 0 ? 0.0 : h4 / (double)height;
        this._surface[3] = hf * (double)(bottom + top);
        this._surface[1] = -hf;
    }

    public Cushion(@Nullable Cushion master, @Nullable TreeMapModel<?, ?, ?> model, int left, int right, int width, int top, int bottom, int height) {
        this._surface = new double[4];
        if (master != null) {
            double d = 4;
            Intrinsics.checkNotNull(model);
            double h4 = d * model.getSettings().getLightSourceHeight();
            double wf = 0.0;
            wf = width <= 0 ? 0.0 : h4 / (double)width;
            this._surface[2] = master._surface[2] + wf * (double)(right + left);
            this._surface[0] = master._surface[0] - wf;
            double hf = 0.0;
            hf = height <= 0 ? 0.0 : h4 / (double)height;
            this._surface[3] = master._surface[3] + hf * (double)(bottom + top);
            this._surface[1] = master._surface[1] - hf;
        }
    }

    public final void fillRaster(@Nullable TreeMapModel<?, ?, ?> model, @Nullable Color color, int x, int y, int width, int height, @NotNull CPImage raster) {
        Intrinsics.checkNotNullParameter((Object)raster, (String)"raster");
        if (color != null) {
            int bottom = y + height;
            int right = x + width;
            byte by = MkColorKt.getURed((Color)color);
            boolean bl = false;
            byte by2 = by;
            boolean bl2 = false;
            double colR = by2 & 0xFF;
            by2 = MkColorKt.getUGreen((Color)color);
            bl2 = false;
            byte by3 = by2;
            boolean bl3 = false;
            double colG = by3 & 0xFF;
            by3 = MkColorKt.getUBlue((Color)color);
            bl3 = false;
            byte by4 = by3;
            boolean bl4 = false;
            double colB = by4 & 0xFF;
            Intrinsics.checkNotNull(model);
            double ia = model.getSettings().getLightSourceAmbient();
            double is = 1.0 - model.getSettings().getLightSourceAmbient();
            double lx = model.getNormalizedLightSourceX();
            double ly = model.getNormalizedLightSourceY();
            double lz = model.getNormalizedLightSourceZ();
            double s0 = (double)2 * this._surface[0];
            double s1 = (double)2 * this._surface[1];
            double s2 = this._surface[2];
            double s3 = this._surface[3];
            if (!raster.isOneSamplePerArrayElement()) {
                int base = 0;
                int[] data = new int[width * height];
                int n = y;
                if (n < bottom) {
                    do {
                        int iy = n++;
                        double ny = -(s1 * ((double)iy + 0.5) + s3);
                        int n2 = x;
                        if (n2 >= right) continue;
                        do {
                            int ix = n2++;
                            double nx = -(s0 * ((double)ix + 0.5) + s2);
                            double d = 1.0;
                            double d2 = nx * nx + ny * ny + 1.0;
                            boolean bl5 = false;
                            d2 = (nx * lx + ny * ly + lz) / Math.sqrt(d2);
                            bl5 = false;
                            double cosa = Math.min(d, d2);
                            d2 = 1.0;
                            double d3 = 0.0;
                            double d4 = is * cosa + ia;
                            boolean bl6 = false;
                            d3 = Math.max(d3, d4);
                            int n3 = 0;
                            double pixel = Math.min(d2, d3);
                            int red = (int)(colR * pixel);
                            int green = (int)(colG * pixel);
                            int blue32 = (int)(colB * pixel);
                            n3 = MkColorKt.getUAlpha((Color)color);
                            boolean bl7 = false;
                            int alpha = n3 & 0xFF;
                            data[base] = (alpha << 24) + (red << 16) + (green << 8) + blue32;
                            n3 = base;
                            base = n3 + 1;
                        } while (n2 < right);
                    } while (n < bottom);
                }
                raster.setPixels(0, 0, width, height, data);
            } else {
                int base = 0;
                int[] data = new int[width * height << 2];
                int n = y;
                if (n < bottom) {
                    do {
                        int iy = n++;
                        double ny = -(s1 * ((double)iy + 0.5) + s3);
                        int n4 = x;
                        if (n4 >= right) continue;
                        do {
                            int ix = n4++;
                            double nx = -(s0 * ((double)ix + 0.5) + s2);
                            double pixel = 1.0;
                            double red = nx * nx + ny * ny + 1.0;
                            int blue32 = 0;
                            red = (nx * lx + ny * ly + lz) / Math.sqrt(red);
                            blue32 = 0;
                            double cosa = Math.min(pixel, red);
                            red = 1.0;
                            double blue32 = 0.0;
                            double d = is * cosa + ia;
                            boolean bl8 = false;
                            blue32 = Math.max(blue32, d);
                            int n5 = 0;
                            pixel = Math.min(red, blue32);
                            int red2 = (int)(colR * pixel);
                            int green = (int)(colG * pixel);
                            blue32 = (int)(colB * pixel);
                            n5 = MkColorKt.getUAlpha((Color)color);
                            boolean bl9 = false;
                            int alpha = n5 & 0xFF;
                            n5 = base;
                            base = n5 + 1;
                            data[n5] = red2;
                            n5 = base;
                            base = n5 + 1;
                            data[n5] = green;
                            n5 = base;
                            base = n5 + 1;
                            data[n5] = blue32;
                            n5 = base;
                            base = n5 + 1;
                            data[n5] = alpha;
                        } while (n4 < right);
                    } while (n < bottom);
                }
                raster.setPixels(0, 0, width, height, data);
            }
        }
    }

    @Nullable
    public final Color computeColor(@NotNull TreeMapModel<?, ?, ?> model, @Nullable Color color, int x, int y, int width, int height) {
        Color color2;
        Intrinsics.checkNotNullParameter(model, (String)"model");
        if (color != null) {
            int bottom = y + height;
            int right = x + width;
            byte by = MkColorKt.getURed((Color)color);
            boolean bl = false;
            byte by2 = by;
            boolean bl2 = false;
            double colR = by2 & 0xFF;
            by2 = MkColorKt.getUGreen((Color)color);
            bl2 = false;
            byte by3 = by2;
            boolean bl3 = false;
            double colG = by3 & 0xFF;
            by3 = MkColorKt.getUBlue((Color)color);
            bl3 = false;
            byte by4 = by3;
            boolean bl4 = false;
            double colB = by4 & 0xFF;
            double ia = model.getSettings().getLightSourceAmbient();
            double is = 1.0 - model.getSettings().getLightSourceAmbient();
            double lx = model.getNormalizedLightSourceX();
            double ly = model.getNormalizedLightSourceY();
            double lz = model.getNormalizedLightSourceZ();
            double s0 = (double)2 * this._surface[0];
            double s1 = (double)2 * this._surface[1];
            double s2 = this._surface[2];
            double s3 = this._surface[3];
            int iy = (y + bottom) / 2;
            int ix = (x + right) / 2;
            double nx = -(s0 * ((double)ix + 0.5) + s2);
            double ny = -(s1 * ((double)iy + 0.5) + s3);
            double d = 1.0;
            double d2 = nx * nx + ny * ny + 1.0;
            boolean bl5 = false;
            d2 = (nx * lx + ny * ly + lz) / Math.sqrt(d2);
            bl5 = false;
            double cosa = Math.min(d, d2);
            d2 = 1.0;
            double d3 = 0.0;
            double d4 = is * cosa + ia;
            boolean bl6 = false;
            d3 = Math.max(d3, d4);
            boolean bl7 = false;
            double pixel = Math.min(d2, d3);
            int red = (int)(colR * pixel);
            int green = (int)(colG * pixel);
            int blue = (int)(colB * pixel);
            color2 = MkColorKt.colorOf((int)red, (int)green, (int)blue);
        } else {
            color2 = null;
        }
        return color2;
    }
}

