/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.data.type.HtmlString;
import com.macrofocus.common.geom.Dimension;
import com.treemap.TreeMapColumnSettings;
import com.treemap.TreeMapLabelRenderer;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapView;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.mkui.graphics.Insets;
import org.mkui.labeling.EnhancedLabel;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000f*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u00020\u00042\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0005:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0006J?\u0010\u0007\u001a\u00020\u00042\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\t2\u0006\u0010\n\u001a\u00028\u00022\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/treemap/DefaultTreeMapLabelRenderer;", "N", "Row", "Column", "Lorg/mkui/labeling/EnhancedLabel;", "Lcom/treemap/TreeMapLabelRenderer;", "()V", "getTreeMapLabelRendererComponent", "view", "Lcom/treemap/TreeMapView;", "column", "node", "dimension", "Lcom/macrofocus/common/geom/Dimension;", "(Lcom/treemap/TreeMapView;Ljava/lang/Object;Ljava/lang/Object;Lcom/macrofocus/common/geom/Dimension;)Lorg/mkui/labeling/EnhancedLabel;", "Companion", "treemap"})
@StabilityInferred(parameters=0)
public final class DefaultTreeMapLabelRenderer<N, Row, Column>
extends EnhancedLabel
implements TreeMapLabelRenderer<N, Row, Column> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    private static final Insets DEFAULT_BORDER;

    public DefaultTreeMapLabelRenderer() {
        this.setOpaque(false);
        this.setName("TreeMap.labelRenderer");
        this.setEffect((EnhancedLabel.Effect)EnhancedLabel.Effect.Plain.INSTANCE);
        this.setHorizontalAlignment(2);
        this.setRendering((EnhancedLabel.Rendering)EnhancedLabel.Rendering.Clip.INSTANCE);
    }

    @Override
    @NotNull
    public EnhancedLabel getTreeMapLabelRendererComponent(@NotNull TreeMapView<N, Row, Column> view, Column column, N node, @NotNull Dimension dimension) {
        Float effectOpacity;
        boolean bl;
        Integer minimumCharactersToDisplay;
        Integer n;
        Integer verticalAlignment;
        boolean bl2;
        Integer n2;
        Integer horizontalAlignment;
        Integer n3;
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
        Intrinsics.checkNotNull(treeMapModel);
        String value = treeMapModel.getStringValue(node, column);
        this.setInsets(DEFAULT_BORDER.getTop(), DEFAULT_BORDER.getLeft(), DEFAULT_BORDER.getBottom(), DEFAULT_BORDER.getRight());
        this.setText(value);
        treeMapModel = view.getModel();
        Intrinsics.checkNotNull(treeMapModel);
        this.setHTML(treeMapModel.getColumnClass(column) == Reflection.getOrCreateKotlinClass(HtmlString.class));
        TreeMapModel<N, Row, Column> treeMapModel2 = view.getModel();
        Intrinsics.checkNotNull(treeMapModel2);
        TreeMapColumnSettings settings = treeMapModel2.getSettings().getColumnSettings(column);
        EnhancedLabel.Effect effect = settings.getLabelingEffect();
        if (effect != null) {
            this.setEffect(effect);
        }
        if ((n3 = (horizontalAlignment = settings.getLabelingHorizontalAlignment())) != null) {
            n2 = n3;
            boolean bl3 = false;
            bl2 = false;
            int it = ((Number)n2).intValue();
            boolean bl4 = false;
            this.setHorizontalAlignment(it);
        }
        n2 = verticalAlignment = settings.getLabelingVerticalAlignment();
        if (n2 != null) {
            Integer n4 = n2;
            bl2 = false;
            boolean bl5 = false;
            int it = ((Number)n4).intValue();
            boolean bl6 = false;
            this.setVerticalAlignment(it);
        }
        EnhancedLabel.Rendering rendering = settings.getLabelingRendering();
        if (rendering != null) {
            this.setRendering(rendering);
        }
        if ((n = (minimumCharactersToDisplay = settings.getLabelingMinimumCharactersToDisplay())) != null) {
            Integer n5 = n;
            boolean bl7 = false;
            bl = false;
            int it = ((Number)n5).intValue();
            boolean bl8 = false;
            this.setMinimumCharactersToDisplay(it);
        }
        Float f = effectOpacity = settings.getLabelingEffectOpacity();
        if (f != null) {
            Float f2 = f;
            bl = false;
            boolean bl9 = false;
            float it = ((Number)f2).floatValue();
            boolean bl10 = false;
            this.setEffectOpacity(it);
        }
        this.setDesiredWidth(dimension.getIwidth());
        this.setDesiredHeight(dimension.getIheight());
        return this;
    }

    static {
        DEFAULT_BORDER = new Insets(0, 2, 0, 1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/treemap/DefaultTreeMapLabelRenderer$Companion;", "", "()V", "DEFAULT_BORDER", "Lorg/mkui/graphics/Insets;", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

