/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.treemap.AbstractRendering;
import com.treemap.TreeMapColumnSettings;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.TGraphics;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;
import org.mkui.geom.TextShape;
import org.mkui.graphics.IGraphics;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Ja\u0010\t\u001a\u00020\n\"\u0004\b\u0000\u0010\u000b\"\u0004\b\u0001\u0010\f\"\u0004\b\u0002\u0010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r0\u00112\u0006\u0010\u0012\u001a\u0002H\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019Ja\u0010\u001a\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u000b\"\u0004\b\u0001\u0010\f\"\u0004\b\u0002\u0010\r2\u0006\u0010\u001b\u001a\u00020\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r0\u00112\u0006\u0010\u0012\u001a\u0002H\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u001f"}, d2={"Lcom/treemap/FlatRendering;", "Lcom/treemap/AbstractRendering;", "()V", "drawBorder", "", "getDrawBorder", "()Z", "setDrawBorder", "(Z)V", "paintBorder", "", "N", "Row", "Column", "g2", "Lcom/treemap/crossplatform/TGraphics;", "view", "Lcom/treemap/TreeMapView;", "node", "pass", "", "bounds", "Lorg/mkui/geom/Rectangle;", "shape", "Lorg/mkui/geom/Shape;", "(Lcom/treemap/crossplatform/TGraphics;Lcom/treemap/TreeMapView;Ljava/lang/Object;ILorg/mkui/geom/Rectangle;Lorg/mkui/geom/Shape;)V", "paintNode", "g", "(Lcom/treemap/crossplatform/TGraphics;Lcom/treemap/TreeMapView;Ljava/lang/Object;ILorg/mkui/geom/Rectangle;Lorg/mkui/geom/Shape;)Z", "toString", "", "treemap"})
@StabilityInferred(parameters=0)
public class FlatRendering
extends AbstractRendering {
    private boolean drawBorder = true;
    public static final int $stable = 8;

    public final boolean getDrawBorder() {
        return this.drawBorder;
    }

    public final void setDrawBorder(boolean bl) {
        this.drawBorder = bl;
    }

    @Override
    public <N, Row, Column> boolean paintNode(@NotNull TGraphics g, @NotNull TreeMapView<N, Row, Column> view, N node, int pass, @NotNull Rectangle bounds, @NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
        Intrinsics.checkNotNull(treeMapModel);
        TreeMapModel<N, Row, Column> model = treeMapModel;
        int n = pass;
        switch (n) {
            case 0: {
                Color color = null;
                Color color2 = color = !model.getFilter().isFiltered(node) && !model.getSearch().isFiltered(node) ? model.getColor(node) : view.getBackground();
                if (color == null) break;
                g.setFill(color);
                if (shape instanceof TextShape) {
                    TextShape textShape = (TextShape)shape;
                    if (textShape.isTextOutline()) {
                        g.fill(shape);
                        break;
                    }
                    Rectangle2D bounds2D = textShape.getBounds2D();
                    g.fillText(textShape.getText(), (float)bounds2D.getX(), (float)bounds2D.getMaxY());
                    break;
                }
                g.fill(shape);
                break;
            }
            case 1: {
                if (model.getFilter().isFiltered(node) || model.getSearch().isFiltered(node)) break;
                Color textShape = model.getColor(node);
                Intrinsics.checkNotNull((Object)textShape);
                Color color = textShape;
                if (!(shape instanceof Rectangle2D)) break;
                Rectangle2D bottom = (Rectangle2D)shape;
                Rectangle2D top = (Rectangle2D)this.getRenderedShape(view, model, node, shape);
                g.setFill(color);
                g.fillRect(top.getX(), top.getY(), top.getWidth(), top.getHeight());
                if (!(bounds.getWidth() > 1.0) || !(bounds.getHeight() > 1.0)) break;
                IGraphics g2 = g.getIGraphics();
                g2.beginPath();
                g2.moveTo(top.getMinX(), top.getMaxY());
                g2.lineTo(bottom.getX(), bottom.getMaxY());
                g2.lineTo(bottom.getMaxX(), bottom.getMaxY());
                g2.lineTo(top.getMaxX(), top.getMaxY());
                g2.closePath();
                Color color3 = color.darker();
                Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"color.darker()");
                g2.setColor(color3);
                g2.fill();
                g2.beginPath();
                g2.moveTo(top.getMaxX(), top.getMaxY());
                g2.lineTo(bottom.getMaxX(), bottom.getMaxY());
                g2.lineTo(bottom.getMaxX(), bottom.getMinY());
                g2.lineTo(top.getMaxX(), top.getMinY());
                g2.closePath();
                color3 = color.darker();
                Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"color.darker()");
                g2.setColor(color3);
                g2.fill();
                if (!this.drawBorder) break;
                g.setStroke(g.getColorFactory().getDarkGray());
                g.strokeRect(top.getX(), top.getY(), top.getWidth(), top.getHeight());
                g.strokeLine((int)top.getMinX(), (int)top.getMaxY(), (int)bottom.getX(), (int)bottom.getMaxY());
                g.strokeLine((int)top.getMaxX(), (int)top.getMaxY(), (int)bottom.getMaxX(), (int)bottom.getMaxY());
                g.strokeLine((int)top.getMaxX(), (int)top.getMinY(), (int)bottom.getMaxX(), (int)bottom.getMinY());
            }
        }
        return true;
    }

    @Override
    public <N, Row, Column> void paintBorder(@NotNull TGraphics g2, @NotNull TreeMapView<N, Row, Column> view, N node, int pass, @NotNull Rectangle bounds, @NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        if (this.drawBorder && pass == 0 && bounds.getWidth() > 1.0 && bounds.getHeight() > 1.0) {
            TreeMapColumnSettings columnSettings;
            float borderThickness;
            TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
            Intrinsics.checkNotNull(treeMapModel);
            TreeMapModel<N, Row, Column> model = treeMapModel;
            if (model.hasNoChildren(node) && !model.getFilter().isFiltered(node) && !model.getSearch().isFiltered(node) && (borderThickness = (float)(columnSettings = model.getSettings().getColumnSettings(model.getGroupByColumn(node))).getBorderThickness()) > 0.0f && !(shape instanceof TextShape)) {
                g2.save();
                g2.setLineWidth(borderThickness);
                g2.setStroke(columnSettings.getBorderColor());
                g2.stroke(shape);
                g2.restore();
            }
        }
    }

    @NotNull
    public String toString() {
        return "Flat";
    }
}

