/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.treemap.AbstractTreeMapNode;
import com.treemap.LeafTreeMapNode;
import com.treemap.Pair;
import com.treemap.TreeMapModel;
import com.treemap.treeplot.Spoint;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.Ellipse2D;
import org.mkui.geom.GeneralPath;
import org.mkui.geom.Shape;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0007\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003BG\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012$\u0010\u0006\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00018\u0001\u0012\b\u0010\t\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010\nJ\u001c\u0010%\u001a\u00020&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003H\u0016J6\u0010(\u001a\u0004\u0018\u00010)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020)0\f2\b\u0010+\u001a\u0004\u0018\u00010)2\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010-H\u0002J\u0014\u0010/\u001a\u00020&2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020)00J\u001e\u00101\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00030\u0012J \u00102\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\u001d\u00103\u001a\u0004\u0018\u00010\u00142\u0006\u00104\u001a\u00028\u00012\u0006\u00105\u001a\u00028\u0001\u00a2\u0006\u0002\u00106J%\u00107\u001a\b\u0012\u0004\u0012\u00020)002\b\u00104\u001a\u0004\u0018\u00018\u00012\b\u00105\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u00108J\b\u00109\u001a\u00020:H\u0016J\u001a\u0010;\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00030<H\u0016J\u001a\u0010=\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00030<H\u0016J\u001e\u0010>\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00030?J\u001d\u0010@\u001a\u0004\u0018\u00010\u001d2\u0006\u00104\u001a\u00028\u00012\u0006\u00105\u001a\u00028\u0001\u00a2\u0006\u0002\u0010AJ#\u0010B\u001a\b\u0012\u0004\u0012\u00020)002\u0006\u00104\u001a\u00028\u00012\u0006\u00105\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u00108J\b\u0010C\u001a\u00020\u0005H\u0016J\r\u0010D\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000eJ\b\u0010E\u001a\u00020\u001aH\u0016R\"\u0010\u000b\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u0004\u0018\u00018\u00018VX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\"\u0010\u0010\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0011\u001a\u001c\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00010\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\u0004\u0018\u00018\u0001X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u0015\u0010\u000eRR\u0010\u0016\u001aF\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00030\u0012\u0018\u00010\u0017j\"\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00030\u0012\u0018\u0001`\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR*\u0010\u001c\u001a\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00010\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010 \u001a\u0004\u0018\u00010\u001f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f8V@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006F"}, d2={"Lcom/treemap/ParentTreeMapNode;", "Row", "Column", "Lcom/treemap/AbstractTreeMapNode;", "name", "", "model", "Lcom/treemap/TreeMapModel;", "groupByColumn", "childrenGroupByColumn", "(Ljava/lang/Object;Lcom/treemap/TreeMapModel;Ljava/lang/Object;Ljava/lang/Object;)V", "children", "", "getChildrenGroupByColumn", "()Ljava/lang/Object;", "Ljava/lang/Object;", "childrenOfTypeParent", "chs", "", "Lcom/treemap/Pair;", "Lorg/mkui/geom/GeneralPath;", "getGroupByColumn", "indexReference", "Ljava/lang/ref/SoftReference;", "Lcom/macrofocus/common/collection/SoftReference;", "isLeaf", "", "()Z", "mecs", "Lorg/mkui/geom/Ellipse2D;", "value", "Lorg/mkui/geom/Shape;", "nestedShape", "getNestedShape", "()Lorg/mkui/geom/Shape;", "setNestedShape", "(Lorg/mkui/geom/Shape;)V", "add", "", "child", "addPoint", "Lcom/treemap/treeplot/Spoint;", "points", "treeRoot", "xValue", "", "yValue", "computeCHGraph", "", "createIndex", "findChild", "getCH", "xVariable", "yVariable", "(Ljava/lang/Object;Ljava/lang/Object;)Lorg/mkui/geom/GeneralPath;", "getCHPoints", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "getChildCount", "", "getChildren", "", "getChildrenOfTypeParent", "getIndex", "", "getMEC", "(Ljava/lang/Object;Ljava/lang/Object;)Lorg/mkui/geom/Ellipse2D;", "getMECPoints", "getNodeName", "getRow", "hasNoChildren", "treemap"})
@StabilityInferred(parameters=0)
public final class ParentTreeMapNode<Row, Column>
extends AbstractTreeMapNode<Row, Column> {
    @NotNull
    private final Object name;
    @Nullable
    private List<AbstractTreeMapNode<Row, Column>> children;
    @Nullable
    private List<AbstractTreeMapNode<Row, Column>> childrenOfTypeParent;
    @Nullable
    private SoftReference<Map<Object, AbstractTreeMapNode<Row, Column>>> indexReference;
    @Nullable
    private final Column groupByColumn;
    @Nullable
    private final Column childrenGroupByColumn;
    @Nullable
    private Shape nestedShape;
    @Nullable
    private Map<Pair<Column, Column>, Ellipse2D> mecs;
    @Nullable
    private Map<Pair<Column, Column>, GeneralPath> chs;
    public static final int $stable = 8;

    public ParentTreeMapNode(@NotNull Object name, @NotNull TreeMapModel<AbstractTreeMapNode<Row, Column>, Row, Column> model, @Nullable Column groupByColumn, @Nullable Column childrenGroupByColumn) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        super(model);
        this.name = name;
        this.groupByColumn = groupByColumn;
        this.childrenGroupByColumn = childrenGroupByColumn;
    }

    @Override
    @Nullable
    public Column getGroupByColumn() {
        return this.groupByColumn;
    }

    @Override
    @Nullable
    public Column getChildrenGroupByColumn() {
        return this.childrenGroupByColumn != null ? this.childrenGroupByColumn : this.getModel().getSettings().getSizeColumn();
    }

    @Override
    @Nullable
    public Shape getNestedShape() {
        return this.nestedShape != null ? this.nestedShape : this.getShape();
    }

    @Override
    public void setNestedShape(@Nullable Shape value) {
        this.nestedShape = value;
        super.setNestedShape(value);
    }

    @Override
    public Row getRow() {
        throw new IllegalStateException();
    }

    @Override
    public int getChildCount() {
        int n;
        if (this.children != null) {
            List<AbstractTreeMapNode<Row, Column>> list = this.children;
            Intrinsics.checkNotNull(list);
            n = list.size();
        } else {
            n = 0;
        }
        return n;
    }

    @Override
    public boolean hasNoChildren() {
        return this.children == null;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    @NotNull
    public Iterable<AbstractTreeMapNode<Row, Column>> getChildren() {
        List<AbstractTreeMapNode<Row, Column>> list = this.children != null ? this.children : CollectionsKt.emptyList();
        Intrinsics.checkNotNull(list);
        return list;
    }

    @Override
    @NotNull
    public Iterable<AbstractTreeMapNode<Row, Column>> getChildrenOfTypeParent() {
        List<AbstractTreeMapNode<Row, Column>> list = this.childrenOfTypeParent != null ? this.childrenOfTypeParent : CollectionsKt.emptyList();
        Intrinsics.checkNotNull(list);
        return list;
    }

    @Override
    public void add(@NotNull AbstractTreeMapNode<Row, Column> child) {
        List<AbstractTreeMapNode<Row, Column>> list;
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter(child, (String)"child");
                if (this.children == null) {
                    this.children = new ArrayList();
                }
                if (!(child instanceof LeafTreeMapNode)) break block8;
                list = this.children;
                Intrinsics.checkNotNull(list);
                if (list.contains(child)) break block9;
            }
            list = this.children;
            Intrinsics.checkNotNull(list);
            list.add(child);
        }
        child.setParent(this.getSelf());
        if (child instanceof ParentTreeMapNode) {
            if (this.childrenOfTypeParent == null) {
                this.childrenOfTypeParent = new ArrayList();
            }
            list = this.childrenOfTypeParent;
            Intrinsics.checkNotNull(list);
            list.add(child);
            if (this.indexReference != null) {
                Object object = this.indexReference;
                Intrinsics.checkNotNull(object);
                Map<Object, AbstractTreeMapNode<Row, Column>> index = ((SoftReference)object).get();
                if (index != null) {
                    object = index;
                    Object object2 = ((ParentTreeMapNode)child).getNodeName();
                    boolean bl = false;
                    object.put(object2, child);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Object, AbstractTreeMapNode<Row, Column>> getIndex() {
        Map<Object, AbstractTreeMapNode<Row, Column>> map;
        if (this.indexReference == null) {
            Map<Object, AbstractTreeMapNode<Row, Column>> index = this.createIndex();
            this.indexReference = new SoftReference<Map<Object, AbstractTreeMapNode<Row, Column>>>(index);
            map = index;
        } else {
            void var1_2;
            SoftReference<Map<Object, AbstractTreeMapNode<Row, Column>>> softReference = this.indexReference;
            Intrinsics.checkNotNull(softReference);
            Map<Object, AbstractTreeMapNode<Row, Column>> index = softReference.get();
            if (index == null) {
                index = this.createIndex();
                this.indexReference = new SoftReference<Map<Object, AbstractTreeMapNode<Row, Column>>>(index);
            }
            map = var1_2;
        }
        return map;
    }

    @NotNull
    public final Map<Object, AbstractTreeMapNode<Row, Column>> createIndex() {
        Map index = new HashMap();
        List<AbstractTreeMapNode<Row, Column>> list = this.children;
        Intrinsics.checkNotNull(list);
        for (AbstractTreeMapNode<Row, Column> child : list) {
            if (!(child instanceof ParentTreeMapNode)) continue;
            Map map = index;
            Object object = ((ParentTreeMapNode)child).getNodeName();
            boolean bl = false;
            map.put(object, child);
        }
        return index;
    }

    @Override
    @Nullable
    public AbstractTreeMapNode<Row, Column> findChild(@Nullable Object name) {
        Map<Object, AbstractTreeMapNode<Row, Column>> map = this.getIndex();
        boolean bl = false;
        return map.get(name);
    }

    @Override
    @NotNull
    public Object getNodeName() {
        return this.name;
    }

    @Nullable
    public final Ellipse2D getMEC(Column xVariable, Column yVariable) {
        Ellipse2D ellipse2D;
        if (this.mecs == null) {
            this.mecs = new HashMap();
        }
        Column xColumnIndex = xVariable;
        Column yColumnIndex = yVariable;
        Pair<Column, Column> pair = Pair.Companion.create(xColumnIndex, yColumnIndex);
        Map<Pair<Column, Column>, Ellipse2D> map = this.mecs;
        Intrinsics.checkNotNull(map);
        if (map.containsKey(pair)) {
            map = this.mecs;
            Intrinsics.checkNotNull(map);
            ellipse2D = map.get(pair);
        } else {
            Ellipse2D.Double double_;
            Object b;
            Object c;
            double radius = 0.0;
            Spoint center = null;
            List<Spoint> points = this.getMECPoints(xVariable, yVariable);
            this.computeCHGraph(points);
            if (points.size() == 1) {
                center = points.get(0);
            } else if (points.size() > 1) {
                Spoint listHead = points.get(0);
                Object a = listHead;
                Intrinsics.checkNotNull((Object)a);
                c = ((Spoint)a).getChnext();
                b = null;
                if (points.size() == 2) {
                    b = null;
                } else {
                    while (true) {
                        Spoint thetaABC;
                        b = null;
                        double bestTheta = 180.0;
                        Spoint looper = listHead;
                        do {
                            if (looper != a && looper != c && (thetaABC = Spoint.Companion.angleBetweenPoints((Spoint)a, looper, (Spoint)c)) < bestTheta) {
                                bestTheta = thetaABC;
                                b = looper;
                            }
                            thetaABC = looper.getChnext();
                            Intrinsics.checkNotNull((Object)thetaABC);
                        } while ((looper = thetaABC) != listHead);
                        if (bestTheta >= 90.0) {
                            b = null;
                            break;
                        }
                        if (Spoint.Companion.angleBetweenPoints((Spoint)b, (Spoint)c, (Spoint)a) > 90.0) {
                            c = b;
                            continue;
                        }
                        if (Spoint.Companion.angleBetweenPoints((Spoint)c, (Spoint)a, (Spoint)b) <= 90.0) break;
                        a = b;
                    }
                }
                if (b == null) {
                    Intrinsics.checkNotNull((Object)a);
                    Intrinsics.checkNotNull((Object)c);
                    center = ((Spoint)a).add(((Spoint)c).subtract((Spoint)a).scale(0.5));
                    radius = ((Spoint)a).distance(center);
                } else {
                    Spoint ch1 = ((Spoint)b).subtract((Spoint)a).scale(0.5);
                    Intrinsics.checkNotNull((Object)c);
                    Spoint ch2 = ((Spoint)c).subtract((Spoint)a).scale(0.5);
                    Spoint n1 = ch1.normalLeft();
                    Spoint n2 = ch2.normalLeft();
                    Intrinsics.checkNotNull((Object)a);
                    ch1 = ((Spoint)a).add(ch1);
                    ch2 = ((Spoint)a).add(ch2);
                    center = Spoint.Companion.infiniteLineIntersection(ch1, n1, ch2, n2);
                    if (center != null) {
                        radius = center.distance((Spoint)a);
                    }
                }
            }
            Ellipse2D.Double mec = null;
            if (center != null) {
                c = this.normalizedToWorld(center.getX() - radius, xVariable);
                Intrinsics.checkNotNull((Object)c);
                Object x1 = c;
                b = this.normalizedToWorld(center.getY() - radius, yVariable);
                Intrinsics.checkNotNull((Object)b);
                Object y1 = b;
                Number ch1 = this.normalizedToWorld(center.getX() + radius, xVariable);
                Intrinsics.checkNotNull((Object)ch1);
                Number x2 = ch1;
                Number number = this.normalizedToWorld(center.getY() + radius, yVariable);
                Intrinsics.checkNotNull((Object)number);
                Number y2 = number;
                double_ = new Ellipse2D.Double(((Number)x1).doubleValue(), ((Number)y1).doubleValue(), x2.doubleValue() - ((Number)x1).doubleValue(), y2.doubleValue() - ((Number)y1).doubleValue());
            } else {
                double_ = null;
            }
            mec = double_;
            Map<Pair<Column, Column>, Ellipse2D> map2 = this.mecs;
            Intrinsics.checkNotNull(map2);
            boolean bl = false;
            map2.put(pair, (Ellipse2D)mec);
            ellipse2D = (Ellipse2D)mec;
        }
        return ellipse2D;
    }

    @Nullable
    public final GeneralPath getCH(Column xVariable, Column yVariable) {
        GeneralPath generalPath;
        if (this.chs == null) {
            this.chs = new HashMap();
        }
        Column xColumnIndex = xVariable;
        Column yColumnIndex = yVariable;
        Pair<Column, Column> pair = Pair.Companion.create(xColumnIndex, yColumnIndex);
        Map<Pair<Column, Column>, GeneralPath> map = this.chs;
        Intrinsics.checkNotNull(map);
        if (map.containsKey(pair)) {
            map = this.chs;
            Intrinsics.checkNotNull(map);
            generalPath = map.get(pair);
        } else {
            List<Spoint> points = this.getCHPoints(xVariable, yVariable);
            this.computeCHGraph(points);
            GeneralPath path = new GeneralPath();
            if (points.size() > 0) {
                Spoint listHead;
                Spoint current = listHead = points.get(0);
                Number number = this.normalizedToWorld(listHead.getX(), xVariable);
                Intrinsics.checkNotNull((Object)number);
                double d = number.doubleValue();
                number = this.normalizedToWorld(listHead.getY(), yVariable);
                Intrinsics.checkNotNull((Object)number);
                path.moveTo(d, number.doubleValue());
                int c = 1;
                while (current.getChprev() != null && current.getChprev() != listHead) {
                    Object object = current.getChprev();
                    Intrinsics.checkNotNull((Object)object);
                    current = object;
                    object = this.normalizedToWorld(current.getX(), xVariable);
                    Intrinsics.checkNotNull((Object)object);
                    double d2 = ((Number)object).doubleValue();
                    object = this.normalizedToWorld(current.getY(), yVariable);
                    Intrinsics.checkNotNull((Object)object);
                    path.lineTo(d2, ((Number)object).doubleValue());
                    int n = c;
                    c = n + 1;
                }
                path.closePath();
            }
            Map<Pair<Column, Column>, GeneralPath> map2 = this.chs;
            Intrinsics.checkNotNull(map2);
            boolean bl = false;
            map2.put(pair, path);
            generalPath = path;
        }
        return generalPath;
    }

    public final void computeCHGraph(@NotNull List<Spoint> points) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        if (points.size() < 1) {
            return;
        }
        Spoint listHead = points.get(0);
        if (points.size() == 1) {
            listHead.setChprev(listHead);
            listHead.setChnext(listHead.getChprev());
            return;
        }
        if (points.size() == 2) {
            listHead.setChnext(listHead.getNext());
            listHead.setChprev(listHead.getNext());
            listHead.getNext().setChprev(listHead);
            listHead.getNext().setChnext(listHead);
            return;
        }
        int stacksize = 2;
        Spoint stacktop = listHead.getNext();
        Intrinsics.checkNotNull((Object)stacktop);
        stacktop.setChnext(null);
        stacktop.setChprev(listHead);
        listHead.setChnext(stacktop);
        listHead.setChprev(null);
        Spoint looper = null;
        for (looper = listHead.getNext().getNext(); looper != null; looper = looper.getNext()) {
            looper.setChprev(null);
            looper.setChnext(looper.getChprev());
            double turn = 0.0;
            do {
                Spoint spoint = stacktop.getChprev();
                Intrinsics.checkNotNull((Object)spoint);
                double d = spoint.getX() * (stacktop.getY() - looper.getY());
                double d2 = stacktop.getX();
                double d3 = looper.getY();
                spoint = stacktop.getChprev();
                Intrinsics.checkNotNull((Object)spoint);
                double d4 = d + d2 * (d3 - spoint.getY());
                double d5 = looper.getX();
                spoint = stacktop.getChprev();
                Intrinsics.checkNotNull((Object)spoint);
                turn = d4 + d5 * (spoint.getY() - stacktop.getY());
                if (!(turn > 0.0)) continue;
                stacktop = stacktop.getChprev();
                Intrinsics.checkNotNull((Object)stacktop);
                spoint = stacktop.getChnext();
                Intrinsics.checkNotNull((Object)spoint);
                spoint.setChprev(null);
                stacktop.setChnext(null);
                int n = stacksize;
                stacksize = n + -1;
            } while (turn > 0.0 && stacksize > 1);
            looper.setChprev(stacktop);
            stacktop.setChnext(looper);
            stacktop = looper;
            int n = stacksize;
            stacksize = n + 1;
        }
        looper = listHead;
        while (looper.getChnext() != null) {
            looper = looper.getNext();
        }
        Spoint stackbottom = looper;
        stackbottom.setChnext(listHead);
        stackbottom.setChprev(null);
        listHead.setChprev(stackbottom);
        stacksize = 2;
        for (looper = stackbottom.getNext(); looper != null; looper = looper.getNext()) {
            if (looper.getChnext() != null) continue;
            double turn = 0.0;
            do {
                Spoint spoint = stackbottom.getChnext();
                Intrinsics.checkNotNull((Object)spoint);
                double d = spoint.getX() * (stackbottom.getY() - looper.getY());
                double d6 = stackbottom.getX();
                double d7 = looper.getY();
                spoint = stackbottom.getChnext();
                Intrinsics.checkNotNull((Object)spoint);
                double d8 = d + d6 * (d7 - spoint.getY());
                double d9 = looper.getX();
                spoint = stackbottom.getChnext();
                Intrinsics.checkNotNull((Object)spoint);
                turn = d8 + d9 * (spoint.getY() - stackbottom.getY());
                if (!(turn < 0.0)) continue;
                spoint = stackbottom.getChnext();
                Intrinsics.checkNotNull((Object)spoint);
                stackbottom = spoint;
                spoint = stackbottom.getChprev();
                Intrinsics.checkNotNull((Object)spoint);
                spoint.setChnext(null);
                stackbottom.setChprev(null);
                int n = stacksize;
                stacksize = n + -1;
            } while (turn < 0.0 && stacksize > 1);
            looper.setChnext(stackbottom);
            stackbottom.setChprev(looper);
            stackbottom = looper;
            int n = stacksize;
            stacksize = n + 1;
        }
    }

    private final List<Spoint> getMECPoints(Column xVariable, Column yVariable) {
        List points = new ArrayList();
        Spoint treeRoot = null;
        for (AbstractTreeMapNode<Row, Column> pos : this.getChildren()) {
            Object object;
            Object object2;
            if (pos.hasNoChildren()) {
                object2 = this.getModel().getAggregateValue(pos, xVariable);
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                Number number = this.worldToNormalized((Number)object2, xVariable);
                Intrinsics.checkNotNull((Object)number);
                Number xValue = number;
                object = this.getModel().getAggregateValue(pos, yVariable);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                object2 = this.worldToNormalized((Number)object, yVariable);
                Intrinsics.checkNotNull((Object)object2);
                Object yValue = object2;
                treeRoot = this.addPoint(points, treeRoot, xValue, (Number)yValue);
                continue;
            }
            Ellipse2D ellipse = ((ParentTreeMapNode)pos).getMEC(xVariable, yVariable);
            if (ellipse == null) continue;
            object2 = this.worldToNormalized(ellipse.getMinX(), xVariable);
            Intrinsics.checkNotNull((Object)object2);
            Object x1 = object2;
            object = this.worldToNormalized(ellipse.getCenterX(), xVariable);
            Intrinsics.checkNotNull((Object)object);
            Object xc = object;
            Number number = this.worldToNormalized(ellipse.getMaxX(), xVariable);
            Intrinsics.checkNotNull((Object)number);
            Number x2 = number;
            Number number2 = this.worldToNormalized(ellipse.getMinY(), yVariable);
            Intrinsics.checkNotNull((Object)number2);
            Number y1 = number2;
            Number number3 = this.worldToNormalized(ellipse.getCenterY(), yVariable);
            Intrinsics.checkNotNull((Object)number3);
            Number yc = number3;
            Number number4 = this.worldToNormalized(ellipse.getMaxY(), yVariable);
            Intrinsics.checkNotNull((Object)number4);
            Number y2 = number4;
            treeRoot = this.addPoint(points, treeRoot, (Number)x1, yc);
            treeRoot = this.addPoint(points, treeRoot, (Number)xc, y1);
            treeRoot = this.addPoint(points, treeRoot, (Number)xc, y2);
            treeRoot = this.addPoint(points, treeRoot, x2, yc);
        }
        return points;
    }

    @NotNull
    public final List<Spoint> getCHPoints(@Nullable Column xVariable, @Nullable Column yVariable) {
        List points = new ArrayList();
        Spoint treeRoot = null;
        for (AbstractTreeMapNode<Row, Column> pos : this.getChildren()) {
            if (pos.hasNoChildren()) {
                Object object = this.getModel().getAggregateValue(pos, xVariable);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                Number number = this.worldToNormalized((Number)object, xVariable);
                Intrinsics.checkNotNull((Object)number);
                Number xValue = number;
                Object object2 = this.getModel().getAggregateValue(pos, yVariable);
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                object = this.worldToNormalized((Number)object2, yVariable);
                Intrinsics.checkNotNull((Object)object);
                Object yValue = object;
                treeRoot = this.addPoint(points, treeRoot, xValue, (Number)yValue);
                continue;
            }
            List<Spoint> list = ((ParentTreeMapNode)pos).getCHPoints(xVariable, yVariable);
            for (Spoint spoint : list) {
                treeRoot = this.addPoint(points, treeRoot, spoint.getX(), spoint.getY());
            }
        }
        return points;
    }

    private final Spoint addPoint(List<Spoint> points, Spoint treeRoot, Number xValue, Number yValue) {
        if (xValue != null && yValue != null) {
            Spoint where = new Spoint(xValue.doubleValue(), yValue.doubleValue());
            if (treeRoot != null) {
                if (treeRoot.Insert(where)) {
                    if (where.getPrev() == null) {
                        points.add(0, where);
                    } else {
                        points.add(where);
                    }
                    return treeRoot;
                }
            } else {
                points.add(0, where);
                return where;
            }
        }
        return treeRoot;
    }
}

