/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.treemap.AbstractNodeRenderer;
import com.treemap.Algorithm;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapSettings;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.TGraphics;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Shape;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\"\u0010\u0006\u001a\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\tH\u0016J\"\u0010\n\u001a\u00020\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\rH\u0016JW\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\r2\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J/\u0010\u0019\u001a\u00020\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\r2\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/treemap/TextParentNodeRenderer;", "N", "Row", "Column", "Lcom/treemap/AbstractNodeRenderer;", "()V", "getPasses", "", "model", "Lcom/treemap/TreeMapModel;", "isEnabled", "", "view", "Lcom/treemap/TreeMapView;", "paintNode", "g", "Lcom/treemap/crossplatform/TGraphics;", "node", "pass", "passes", "bounds", "Lorg/mkui/geom/Rectangle;", "shape", "Lorg/mkui/geom/Shape;", "(Lcom/treemap/crossplatform/TGraphics;Lcom/treemap/TreeMapView;Ljava/lang/Object;IILorg/mkui/geom/Rectangle;Lorg/mkui/geom/Shape;)Z", "shouldPaint", "(Lcom/treemap/TreeMapView;Ljava/lang/Object;)Z", "treemap"})
public final class TextParentNodeRenderer<N, Row, Column>
extends AbstractNodeRenderer<N, Row, Column> {
    @Override
    public boolean isEnabled(@NotNull TreeMapView<N, Row, Column> view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        return true;
    }

    @Override
    public int getPasses(@NotNull TreeMapModel<N, Row, Column> model) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Column heightColumn = model.getSettings().getHeightColumn();
        return heightColumn != null && (model.isNumericType(heightColumn) || model.isTemporalType(heightColumn)) ? 2 : 1;
    }

    @Override
    public boolean shouldPaint(@NotNull TreeMapView<N, Row, Column> view, N node) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
        Intrinsics.checkNotNull(treeMapModel);
        TreeMapModel<N, Row, Column> model = treeMapModel;
        return !model.isRoot(node) && !model.hasNoChildren(node);
    }

    @Override
    public boolean paintNode(@NotNull TGraphics g, @NotNull TreeMapView<N, Row, Column> view, N node, int pass, int passes, @NotNull Rectangle bounds, @NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        if (bounds.getWidth() > 0.0 && bounds.getHeight() > 0.0) {
            g.save();
            g.clip((Shape)bounds);
            TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
            Intrinsics.checkNotNull(treeMapModel);
            TreeMapModel<N, Row, Column> model = treeMapModel;
            TreeMapSettings<Column> treeMapSettings = model.getSettings();
            Object object = model.getParent(node);
            Intrinsics.checkNotNull(object);
            Algorithm algorithm = treeMapSettings.getColumnSettings(model.getGroupByColumn(object)).getAlgorithm();
            if (algorithm.isRenderingParentLabelSupported()) {
                object = model.getSettings().getColumnSettings(model.getGroupByColumn(node)).getLabeling();
                Intrinsics.checkNotNull(object);
                object.paintParent(g, bounds, node, view, pass, passes);
            }
            g.restore();
        }
        return true;
    }
}

