/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.tagcloud;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.SimpleProperties;
import com.treemap.AbstractAlgorithm;
import com.treemap.DefaultTreeMapColumnSettings;
import com.treemap.TreeMapAccessor;
import com.treemap.TreeMapWorker;
import com.treemap.tagcloud.ArchimedeanSpiral;
import com.treemap.tagcloud.DefaultWord;
import com.treemap.tagcloud.Orientation;
import com.treemap.tagcloud.Point2d;
import com.treemap.tagcloud.PositionIterator;
import com.treemap.tagcloud.TagCloudAlgorithm;
import com.treemap.tagcloud.TextShape;
import com.treemap.tagcloud.TextShapeFactory;
import com.treemap.tagcloud.Word;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.font.CPFontFactory;
import org.mkui.geom.AffineTransform;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 L2\u00020\u00012\u00020\u0002:\u0001LB7\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u000e\u0010\u000b\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\r\u00a2\u0006\u0002\u0010\u000eB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000fJm\u0010+\u001a\u00020\u0014\"\u0004\b\u0000\u0010,\"\u0004\b\u0001\u0010-\"\u0004\b\u0002\u0010.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002H,2\f\u00102\u001a\b\u0012\u0004\u0012\u0002H,032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u001c2\u0006\u00107\u001a\u00020\u001c2\f\u00108\u001a\b\u0012\u0004\u0012\u0002H,092\b\u0010:\u001a\u0004\u0018\u00010;H\u0016\u00a2\u0006\u0002\u0010<J8\u0010=\u001a\u00020>\"\u0004\b\u0000\u0010,2\u0006\u0010/\u001a\u0002002\u0012\u0010?\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H,0\u00190@2\f\u00108\u001a\b\u0012\u0004\u0012\u0002H,09H\u0002J\n\u0010\u0011\u001a\u00060\fj\u0002`\rJ\u0006\u0010\"\u001a\u00020\bJ\u001e\u0010A\u001a\u0002002\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u0002052\u0006\u0010/\u001a\u00020EJ\u0006\u0010(\u001a\u00020\nJ\b\u0010F\u001a\u00020\u001cH\u0016J\u0012\u0010G\u001a\u00020\u00142\b\u0010/\u001a\u0004\u0018\u000100H\u0016J.\u0010H\u001a\u00020\u0014\"\u0004\b\u0000\u0010,2\f\u0010I\u001a\b\u0012\u0004\u0012\u0002H,0\u00192\u0012\u0010?\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H,0\u00190@J\u0010\u0010J\u001a\u00020>2\u0006\u0010!\u001a\u00020\u001cH\u0016J\b\u0010K\u001a\u00020%H\u0016R\"\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0018\u00010\fj\u0004\u0018\u0001`\r0\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0018\u0010\u0018\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u001cX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0012R\u001c\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010%0$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010)\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u00190*X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/treemap/tagcloud/AbstractTagCloudAlgorithm;", "Lcom/treemap/AbstractAlgorithm;", "Lcom/treemap/tagcloud/TagCloudAlgorithm;", "textShapeFactory", "Lcom/treemap/tagcloud/TextShapeFactory;", "fontFactory", "Lorg/mkui/font/CPFontFactory;", "orientationMode", "Lcom/treemap/tagcloud/TagCloudAlgorithm$OrientationMode;", "spiral", "Lcom/treemap/tagcloud/TagCloudAlgorithm$Spiral;", "font", "Ljava/awt/Font;", "Lorg/mkui/font/MkFont;", "(Lcom/treemap/tagcloud/TextShapeFactory;Lorg/mkui/font/CPFontFactory;Lcom/treemap/tagcloud/TagCloudAlgorithm$OrientationMode;Lcom/treemap/tagcloud/TagCloudAlgorithm$Spiral;Ljava/awt/Font;)V", "(Lcom/treemap/tagcloud/TextShapeFactory;Lorg/mkui/font/CPFontFactory;)V", "Lcom/macrofocus/common/properties/MutableProperty;", "getFont", "()Lcom/macrofocus/common/properties/MutableProperty;", "isRenderingLeafLabelsSupported", "", "()Z", "isRenderingParentLabelSupported", "isSpaceFilling", "lastIntersectedWord", "Lcom/treemap/tagcloud/Word;", "", "maxTags", "", "getMaxTags", "()I", "setMaxTags", "(I)V", "nSubdivisions", "getOrientationMode", "properties", "Lcom/macrofocus/common/properties/MutableProperties;", "", "getProperties", "()Lcom/macrofocus/common/properties/MutableProperties;", "getSpiral", "words", "", "breadthFirstLayout", "N", "Row", "Column", "shape", "Lorg/mkui/geom/Shape;", "parent", "children", "", "sumSizes", "", "horizontalVanishingPoint", "verticalVanishingPoint", "accessor", "Lcom/treemap/TreeMapAccessor;", "worker", "Lcom/treemap/TreeMapWorker;", "(Lorg/mkui/geom/Shape;Ljava/lang/Object;[Ljava/lang/Object;DIILcom/treemap/TreeMapAccessor;Lcom/treemap/TreeMapWorker;)Z", "createDiagramShapes", "", "placedWords", "", "getShape", "offsetAbsolute", "Lcom/treemap/tagcloud/Point2d;", "scale", "Lcom/treemap/tagcloud/TextShape;", "getnSubdivisions", "isCompatible", "newWordIntersectsPlacedWords", "word", "setnSubdivisions", "toString", "Companion", "treemap"})
@StabilityInferred(parameters=0)
public final class AbstractTagCloudAlgorithm
extends AbstractAlgorithm
implements TagCloudAlgorithm {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Word<Object>> words;
    @Nullable
    private Word<Object> lastIntersectedWord;
    @NotNull
    private final TextShapeFactory textShapeFactory;
    private int maxTags;
    private int nSubdivisions;
    @NotNull
    private final MutableProperties<String> properties;
    @NotNull
    private final MutableProperty<Font> font;
    @NotNull
    private final MutableProperty<TagCloudAlgorithm.OrientationMode> orientationMode;
    @NotNull
    private final MutableProperty<TagCloudAlgorithm.Spiral> spiral;
    public static final int $stable = 8;
    @NotNull
    public static final String PROPERTY_FONT = "font";
    @NotNull
    public static final String PROPERTY_ORIENTATIONMODE = "orientationMode";
    @NotNull
    public static final String PROPERTY_SPIRAL = "spiral";

    public AbstractTagCloudAlgorithm(@NotNull TextShapeFactory textShapeFactory, @NotNull CPFontFactory fontFactory) {
        Intrinsics.checkNotNullParameter((Object)textShapeFactory, (String)"textShapeFactory");
        Intrinsics.checkNotNullParameter((Object)fontFactory, (String)"fontFactory");
        this.words = new ArrayList();
        this.maxTags = 500;
        this.nSubdivisions = 6;
        this.properties = (MutableProperties)new SimpleProperties();
        this.orientationMode = this.getProperties().createProperty((Object)PROPERTY_ORIENTATIONMODE, (Object)TagCloudAlgorithm.OrientationMode.AllHorizontal);
        this.spiral = this.getProperties().createProperty((Object)PROPERTY_SPIRAL, (Object)TagCloudAlgorithm.Spiral.Rectangular);
        this.textShapeFactory = textShapeFactory;
        this.font = this.getProperties().createProperty((Object)PROPERTY_FONT, (Object)DefaultTreeMapColumnSettings.Companion.getDefaultLabelingFont(fontFactory));
    }

    @Override
    public int getMaxTags() {
        return this.maxTags;
    }

    @Override
    public void setMaxTags(int n) {
        this.maxTags = n;
    }

    @Override
    @NotNull
    public MutableProperties<String> getProperties() {
        return this.properties;
    }

    @Override
    @NotNull
    public MutableProperty<Font> getFont() {
        return this.font;
    }

    @Override
    @NotNull
    public MutableProperty<TagCloudAlgorithm.OrientationMode> getOrientationMode() {
        return this.orientationMode;
    }

    @Override
    @NotNull
    public MutableProperty<TagCloudAlgorithm.Spiral> getSpiral() {
        return this.spiral;
    }

    public AbstractTagCloudAlgorithm(@NotNull TextShapeFactory textShapeFactory, @NotNull CPFontFactory fontFactory, @NotNull TagCloudAlgorithm.OrientationMode orientationMode, @NotNull TagCloudAlgorithm.Spiral spiral, @Nullable Font font) {
        Intrinsics.checkNotNullParameter((Object)textShapeFactory, (String)"textShapeFactory");
        Intrinsics.checkNotNullParameter((Object)fontFactory, (String)"fontFactory");
        Intrinsics.checkNotNullParameter((Object)((Object)orientationMode), (String)PROPERTY_ORIENTATIONMODE);
        Intrinsics.checkNotNullParameter((Object)((Object)spiral), (String)PROPERTY_SPIRAL);
        this(textShapeFactory, fontFactory);
        this.getOrientationMode().setValue((Object)orientationMode);
        this.getSpiral().setValue((Object)spiral);
        this.getFont().setValue((Object)font);
    }

    @Override
    public <N, Row, Column> boolean breadthFirstLayout(@NotNull Shape shape, N parent, @NotNull N[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, @NotNull TreeMapAccessor<? super N> accessor, @Nullable TreeMapWorker worker2) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
        this.words.clear();
        List placedWords = new ArrayList();
        Random random = RandomKt.Random((int)1);
        if (this.getFont().getValue() != null) {
            // empty if block
        }
        int n = this.getMaxTags();
        int n2 = children.length;
        boolean bl = false;
        n = 0;
        int count2 = Math.min(n, n2);
        if (n < count2) {
            do {
                boolean bl2;
                int i = n++;
                if (worker2 != null && worker2.isCancelled()) {
                    return true;
                }
                N child = children[i];
                String text = String.valueOf(child);
                boolean vertical = false;
                TagCloudAlgorithm.OrientationMode orientationMode = (TagCloudAlgorithm.OrientationMode)((Object)this.getOrientationMode().getValue());
                int n3 = WhenMappings.$EnumSwitchMapping$0[orientationMode.ordinal()];
                switch (n3) {
                    case 1: {
                        bl2 = false;
                        break;
                    }
                    case 2: {
                        bl2 = random.nextBoolean();
                        break;
                    }
                    default: {
                        bl2 = false;
                    }
                }
                vertical = bl2;
                Orientation orientation = null;
                orientation = vertical ? Orientation.Vertical : Orientation.Horizontal;
                double p = accessor.getSize(child) / sumSizes;
                Font font = (Font)this.getFont().getValue();
                Intrinsics.checkNotNull((Object)font);
                this.words.add(new DefaultWord<N>(this.textShapeFactory, text, p, child, orientation, this.nSubdivisions, font));
            } while (n < count2);
        }
        if (worker2 != null && worker2.isCancelled()) {
            return true;
        }
        CollectionsKt.sort(this.words);
        CollectionsKt.reverse(this.words);
        ArchimedeanSpiral spiral = null;
        TagCloudAlgorithm.Spiral i = (TagCloudAlgorithm.Spiral)((Object)this.getSpiral().getValue());
        int child = WhenMappings.$EnumSwitchMapping$1[i.ordinal()];
        switch (child) {
            case 1: {
                spiral = new ArchimedeanSpiral(this.words.get(this.words.size() - 1).getShapeForLayout().getBounds2D().getHeight() * 0.05);
                break;
            }
            case 2: {
                spiral = null;
            }
        }
        Point2d position = new Point2d(0.0, 0.0);
        PositionIterator positionIterator = new PositionIterator(shape);
        double totalMaximumSideLength = 0.0;
        this.lastIntersectedWord = null;
        int counter = 0;
        for (Word<Object> word : this.words) {
            int n4;
            if (worker2 != null && worker2.isCancelled()) {
                return true;
            }
            double wordWidth = word.getShapeForLayout().getBounds2D().getWidth();
            double wordHeight = word.getShapeForLayout().getBounds2D().getHeight();
            boolean bl3 = false;
            double minSideLength = Math.min(wordWidth, wordHeight);
            boolean bl4 = false;
            double maxSideLength = Math.max(wordWidth, wordHeight);
            bl4 = false;
            totalMaximumSideLength = Math.max(maxSideLength, totalMaximumSideLength);
            double stepSize = maxSideLength / (double)10;
            double d = totalMaximumSideLength / 20.0;
            boolean bl5 = false;
            stepSize = Math.max(stepSize, d);
            positionIterator.resetIterator(stepSize);
            double theta = Math.PI * 2;
            boolean stepIncreaseCounter = false;
            boolean debug = false;
            while (this.newWordIntersectsPlacedWords(word, placedWords)) {
                if (spiral != null) {
                    spiral.get(theta, position);
                    double d2 = (double)2 * spiral.getRadius(theta);
                    double dTheta = 0.5 / d2 * (double)2;
                    theta += dTheta;
                } else {
                    positionIterator.getNextPosition(position);
                }
                word.setLocation(position);
                n4 = counter;
                counter = n4 + 1;
            }
            placedWords.add(word);
            n4 = counter;
            counter = n4 + 1;
        }
        for (N child2 : children) {
            accessor.setShape(child2, null);
        }
        this.createDiagramShapes(shape, placedWords, accessor);
        return false;
    }

    private final <N> void createDiagramShapes(Shape shape, List<? extends Word<N>> placedWords, TreeMapAccessor<? super N> accessor) {
        Rectangle2D.Double diagramBoundsNormed = null;
        for (Word<N> placedWord : placedWords) {
            Rectangle2D b = placedWord.getShapeForLayout().getBounds2D();
            diagramBoundsNormed = diagramBoundsNormed != null ? diagramBoundsNormed.add(b) : new Rectangle2D.Double(b.getX(), b.getY(), b.getWidth(), b.getHeight());
        }
        Rectangle2D domainBoundsAbsolute = shape.getBounds2D();
        double domainAspect = domainBoundsAbsolute.getWidth() / domainBoundsAbsolute.getHeight();
        Intrinsics.checkNotNull(diagramBoundsNormed);
        double diagramAspect = diagramBoundsNormed.getWidth() / diagramBoundsNormed.getHeight();
        double scale = 0.0;
        scale = diagramAspect > domainAspect ? domainBoundsAbsolute.getWidth() / diagramBoundsNormed.getWidth() : domainBoundsAbsolute.getHeight() / diagramBoundsNormed.getHeight();
        double widthDiff = domainBoundsAbsolute.getWidth() - diagramBoundsNormed.getWidth() * scale;
        double heightDiff = domainBoundsAbsolute.getHeight() - diagramBoundsNormed.getHeight() * scale;
        Point2d offsetAbsolute = new Point2d(domainBoundsAbsolute.getX() - diagramBoundsNormed.getX() * scale + widthDiff / (double)2, domainBoundsAbsolute.getY() - diagramBoundsNormed.getY() * scale + heightDiff / (double)2);
        for (Word<N> word : placedWords) {
            Shape s = this.getShape(offsetAbsolute, scale, word.getShapeForLayout());
            accessor.setShape(word.getTreeMapNode(), s);
        }
    }

    @NotNull
    public final Shape getShape(@NotNull Point2d offsetAbsolute, double scale, @NotNull TextShape shape) {
        Intrinsics.checkNotNullParameter((Object)offsetAbsolute, (String)"offsetAbsolute");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        AffineTransform transform = new AffineTransform(scale, 0.0, 0.0, scale, offsetAbsolute.getX(), offsetAbsolute.getY());
        return shape.createTransformedShape(transform);
    }

    public final <N> boolean newWordIntersectsPlacedWords(@NotNull Word<N> word, @NotNull List<? extends Word<N>> placedWords) {
        Intrinsics.checkNotNullParameter(word, (String)"word");
        Intrinsics.checkNotNullParameter(placedWords, (String)"placedWords");
        if (this.lastIntersectedWord != null) {
            Word<Object> word2 = this.lastIntersectedWord;
            if (word2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.treemap.tagcloud.Word<N of com.treemap.tagcloud.AbstractTagCloudAlgorithm.newWordIntersectsPlacedWords>");
            }
            if (word.intersects(word2)) {
                return true;
            }
        }
        for (Word word2 : placedWords) {
            if (word2 == this.lastIntersectedWord || !word.intersects(word2)) continue;
            this.lastIntersectedWord = word2;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCompatible(@Nullable Shape shape) {
        return shape instanceof Rectangle2D;
    }

    @Override
    public boolean isRenderingLeafLabelsSupported() {
        return false;
    }

    @Override
    public boolean isRenderingParentLabelSupported() {
        return false;
    }

    @Override
    public int getnSubdivisions() {
        return this.nSubdivisions;
    }

    @Override
    public void setnSubdivisions(int nSubdivisions) {
        this.nSubdivisions = nSubdivisions;
    }

    @NotNull
    public final Font getFont() {
        Font font = (Font)this.getFont().getValue();
        Intrinsics.checkNotNull((Object)font);
        return font;
    }

    @NotNull
    public final TagCloudAlgorithm.Spiral getSpiral() {
        return (TagCloudAlgorithm.Spiral)((Object)this.getSpiral().getValue());
    }

    @NotNull
    public final TagCloudAlgorithm.OrientationMode getOrientationMode() {
        return (TagCloudAlgorithm.OrientationMode)((Object)this.getOrientationMode().getValue());
    }

    @Override
    public boolean isSpaceFilling() {
        return false;
    }

    @NotNull
    public String toString() {
        return "Tag Cloud";
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/treemap/tagcloud/AbstractTagCloudAlgorithm$Companion;", "", "()V", "PROPERTY_FONT", "", "PROPERTY_ORIENTATIONMODE", "PROPERTY_SPIRAL", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[TagCloudAlgorithm.OrientationMode.values().length];
            nArray[TagCloudAlgorithm.OrientationMode.AllHorizontal.ordinal()] = 1;
            nArray[TagCloudAlgorithm.OrientationMode.HorizontalAndVertical.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TagCloudAlgorithm.Spiral.values().length];
            nArray[TagCloudAlgorithm.Spiral.Archimedean.ordinal()] = 1;
            nArray[TagCloudAlgorithm.Spiral.Rectangular.ordinal()] = 2;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

